/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.worktable;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hom.business.application.impl.onbrd.OnbrdWorkTableServiceImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdWorkTableService;

public class QuickSearchPlugin
extends HRDynamicFormBasePlugin
implements SearchEnterListener {
    private static final IOnbrdWorkTableService workTableService = new OnbrdWorkTableServiceImpl();
    private static final String SEARCH_AP = "searchap";

    public void registerListener(EventObject e) {
        Search search = (Search)this.getControl(SEARCH_AP);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent event) {
        String str = event.getText();
        List nameList = event.getFieldNames();
        this.showList(str, nameList);
    }

    private void showList(String str, List<String> nameList) {
        QFilter qFilter = workTableService.getAllSearchFilter(nameList, str, true, false);
        this.loadOnbrdPersonList("flexpanelap", qFilter);
        this.setLabelShow(qFilter);
    }

    private void setLabelShow(QFilter qFilter) {
        Object[] dynamicObjects = workTableService.getDynamicObjects(qFilter);
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"labelap"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        List nameList = (List)this.getView().getFormShowParameter().getCustomParam("searchlist");
        String text = (String)this.getView().getFormShowParameter().getCustomParam("searchtext");
        this.showList(text, nameList);
    }

    private void loadOnbrdPersonList(String tabLabelName, QFilter filter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(filter);
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("hom_wbwaitonblist");
        listShowParameter.getOpenStyle().setTargetKey(tabLabelName);
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.setStatus(OperationStatus.EDIT);
        listShowParameter.setListFilterParameter(new ListFilterParameter(filters, (String)null));
        this.getView().showForm((FormShowParameter)listShowParameter);
        IFormView listView = this.getView().getView(listShowParameter.getPageId());
        if (null != listView) {
            this.getView().sendFormAction(listView);
        }
    }
}

