/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.worktable;

import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class WbCalendarCarPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(WbCalendarCarPlugin.class);
    private static final String SERVICE_IHRPIPERSONSERVICE = "IHRPIPersonService";
    private static final String SERVICE_IHRPIEMPLOYEESERVICE = "IHRPIEmployeeService";
    private static final String APPID_HRPI = "hrpi";
    private static final String PERSON = "person";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (!"vectorap".equals(e.getKey())) {
            return;
        }
        this.setParam();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.setParam();
    }

    private void setParam() {
        HRPageCache pageCache = new HRPageCache(this.getView().getParentView());
        List hrbuids = (List)pageCache.get("hrbuids", List.class);
        List adminorgids = (List)pageCache.get("adminorgids", List.class);
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("hrbuids", hrbuids);
        map.put("adminorgids", adminorgids);
        Long personId = this.getPersonId();
        Long wpId = this.getWpIdByPersonId(personId);
        LOGGER.info(MessageFormat.format("WbCalendarCarPlugin.setParam,wpId = {0}", wpId));
        this.getView().getFormShowParameter().setCustomParam("wpId", (Object)wpId);
        this.getView().getFormShowParameter().setCustomParam("app", (Object)"hom");
        this.getView().getFormShowParameter().setCustomParam("params", map);
    }

    private Long getPersonId() {
        Map personMap = (Map)HRMServiceHelper.invokeHRMPService((String)APPID_HRPI, (String)SERVICE_IHRPIPERSONSERVICE, (String)"getPersonModelId", (Object[])new Object[0]);
        Map personInfo = personMap == null ? null : (Map)personMap.get("data");
        Long personId = null;
        if (personInfo != null) {
            personId = personInfo.get(PERSON) != null ? (Long)personInfo.get(PERSON) : null;
        }
        LOGGER.info(MessageFormat.format("WbCalendarCarPlugin.getPersonId,personInfo = {0}", personMap));
        return personId;
    }

    private Long getWpIdByPersonId(Long personId) {
        Map primaryEmpposorgrel = (Map)HRMServiceHelper.invokeHRMPService((String)APPID_HRPI, (String)SERVICE_IHRPIPERSONSERVICE, (String)"getPrimaryEmpposorgrel", (Object[])new Object[]{personId});
        Long employeeId = (Long)primaryEmpposorgrel.get("employee_id");
        List workCalenRelList = (List)HRMServiceHelper.invokeHRMPService((String)APPID_HRPI, (String)SERVICE_IHRPIEMPLOYEESERVICE, (String)"listEmployeeAttachs", (Object[])new Object[]{employeeId, "hrpi_workcalenrel"});
        if (workCalenRelList.size() > 0) {
            return (Long)((Map)workCalenRelList.get(0)).get("workcalendar_id");
        }
        return 0L;
    }
}

