/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hpfs.business.domain.repository.perchg.ChgCategoryRepository;
import kd.hr.hpfs.business.perchg.config.chgaction.ChgConfigQueryService;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;

public class ConfigService {
    private static final ConfigService CONFIG_SERVICE = new ConfigService();
    private static final Log logger = LogFactory.getLog(ConfigService.class);

    public static ConfigService getInstance() {
        return CONFIG_SERVICE;
    }

    public Map<String, Object> getAllConfigByBillConfId(List<Long> chgActionIdList) {
        Map<Long, DynamicObject> chgRuleCache = ChgConfigQueryService.getInstance().getChgRule(chgActionIdList);
        Map<Long, DynamicObject> chgActionCache = ChgConfigQueryService.getInstance().getChgActionByrule(chgRuleCache);
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("hpfs_chgaction", chgActionCache);
        result.put("hpfs_chgrule", chgRuleCache);
        return result;
    }

    public DynamicObject getChgActionByBizInfo(PerChgBizInfo bizInfo, Map<String, Object> config) {
        Map chgActionConfig = (Map)config.get("hpfs_chgaction");
        Long chgActionId = bizInfo.getActionId();
        return (DynamicObject)chgActionConfig.get(chgActionId);
    }

    public DynamicObject getChgRuleByBizInfo(PerChgBizInfo bizInfo, Map<String, Object> config) {
        Map chgRuleConfig = (Map)config.get("hpfs_chgrule");
        Long chgActionId = bizInfo.getActionId();
        bizInfo.setRuleId(Long.valueOf(((DynamicObject)chgRuleConfig.get(chgActionId)).getLong("id")));
        return (DynamicObject)chgRuleConfig.get(chgActionId);
    }

    public void initBizInfo(PerChgBizInfo bizInfo) {
        this.initBizInfoChgEventId(bizInfo);
        this.initDataWithStrategy(bizInfo);
    }

    private void initBizInfoChgEventId(PerChgBizInfo bizInfo) {
        Long categoryId = bizInfo.getChgRule().getLong("chgaction.chgcategory.id");
        DynamicObject dyn = ChgCategoryRepository.queryOneById("id, chgevent", categoryId);
        bizInfo.setChgEventId(Long.valueOf(dyn.getLong("chgevent.id")));
    }

    private void initDataWithStrategy(PerChgBizInfo bizInfo) {
        Long chgStrategyId = bizInfo.getChgRule().getLong("chgstrategy.id");
        DynamicObject[] chgStrategyEntries = new HRBaseServiceHelper("hpfs_affstrategyentry").query("chgstrategy,required,chgtactic,flowtype", new QFilter[]{new QFilter("chgstrategy", "=", (Object)chgStrategyId)});
        if (chgStrategyEntries.length == 0) {
            return;
        }
        this.initBizInfoEntityName2ValidPass(bizInfo, chgStrategyEntries);
        this.initBizInfoFlowType(bizInfo, chgStrategyEntries);
    }

    private void initBizInfoFlowType(PerChgBizInfo bizInfo, DynamicObject[] chgStrategyEntries) {
        HashMap tacticFlowTypeMap = new HashMap(16);
        if (chgStrategyEntries.length == 0) {
            return;
        }
        Map<Long, List<DynamicObject>> tacticMap = Arrays.stream(chgStrategyEntries).collect(Collectors.groupingBy(row -> row.getLong("chgtactic.id")));
        tacticMap.forEach((k, v) -> tacticFlowTypeMap.put(k, ((DynamicObject)v.get(0)).getString("flowtype")));
        bizInfo.setTacticFlowTypeMap(tacticFlowTypeMap);
    }

    private void initBizInfoEntityName2ValidPass(PerChgBizInfo bizInfo, DynamicObject[] chgStrategyEntries) {
        Set entityNames = Arrays.stream(chgStrategyEntries).filter(chgStrategyEntry -> chgStrategyEntry.getBoolean("required")).map(chgStrategyEntry -> chgStrategyEntry.getString("chgtactic.chgobject.id")).collect(Collectors.toSet());
        if (entityNames.contains("hrpi_empentrel")) {
            entityNames.add("hrpi_employee");
        }
        if (entityNames.contains("hrpi_cmpemp")) {
            entityNames.add("hrpi_managingscope");
        }
        if (entityNames.contains("hrpi_empposorgrel")) {
            entityNames.add("hrpi_depemp");
            entityNames.add("hrpi_emporgrelall");
        }
        bizInfo.setEntityName2ErrorIfVerificationFail(entityNames);
    }
}

