/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.executor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.domain.repository.RepositoryUtils;
import kd.hr.hpfs.business.domain.repository.hrpi.PersonEntityConfRepository;
import kd.hr.hpfs.business.domain.repository.perchg.ChgGuideBaseRepository;
import kd.hr.hpfs.business.domain.repository.perchg.ChgRuleRepository;
import kd.hr.hpfs.business.perchg.common.ChgLogHelper;
import kd.hr.hpfs.business.perchg.config.ConfigService;
import kd.hr.hpfs.business.perchg.executor.ExecutorService;
import kd.hr.hpfs.business.perchg.executor.model.ChgActionExecuteParamDto;
import kd.hr.hpfs.business.perchg.executor.model.enums.ChgPerEntityClassifyEnum;
import kd.hr.hpfs.business.perchg.executor.service.InitDataQueryService;
import kd.hr.hpfs.business.utils.ChgApiDataReturnUtils;
import kd.hr.hpfs.common.enums.ChgCarrierEnum;
import kd.hr.hpfs.common.perchg.PerChgBizOperateType;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizResult;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ChgActionExecuteService {
    private static final Log LOGGER = LogFactory.getLog(ChgActionExecuteService.class);
    private static final ChgActionExecuteService CHG_ACTION_EXECUTE_SERVICE = new ChgActionExecuteService();

    public static ChgActionExecuteService getInstance() {
        return CHG_ACTION_EXECUTE_SERVICE;
    }

    public Map<String, Object> execute(Map<String, Object> params) {
        ChgLogHelper.writeLogAfterReceive(SerializationUtils.toJsonString(params));
        PerChgBizResult data = null;
        try {
            ChgActionExecuteParamDto chgActionExecuteParam = ChgActionExecuteParamDto.format(params);
            DynamicObject chgGuideBase = ChgGuideBaseRepository.getInstance().queryGuideBaseByAction(chgActionExecuteParam.getChgActionId(), ChgCarrierEnum.CARRIER_ACTION.getCode());
            String errorMsg = this.validateActionId(chgGuideBase);
            if (HRStringUtils.isNotEmpty((String)errorMsg)) {
                return ChgApiDataReturnUtils.formatDataReturned(Boolean.FALSE, errorMsg, data);
            }
            data = this.executeAction(chgActionExecuteParam, chgGuideBase);
            if (data.getSuccess().booleanValue()) {
                return ChgApiDataReturnUtils.formatDataReturned(Boolean.TRUE, "", data);
            }
            return ChgApiDataReturnUtils.formatDataReturned(Boolean.FALSE, data.getErrMsg(), data);
        }
        catch (Exception e) {
            String traceId = RequestContext.get().getTraceId();
            String errorInfo = String.format(Locale.ROOT, "CHG_HPFS_ERROR.ChgActionExecuteService.execute.error param:%s", SerializationUtils.toJsonString(params));
            LOGGER.error(errorInfo, (Throwable)e);
            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e8b\u52a1\u53d8\u52a8\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u5185\u5bb9\u3002", (String)"ChgCrossValidateService_3", (String)"hr-hpfs-business", (Object[])new Object[0]), ExceptionUtils.getStackTrace((Throwable)e) + traceId);
            return ChgApiDataReturnUtils.formatDataReturned(false, errorMsg, data);
        }
    }

    private DynamicObject queryGuideBase(long chgActionId) {
        String selectFields = "chgrule, chgevent, carrier,entryentity";
        QFilter chgActionQFilter = new QFilter("chgaction", "=", (Object)chgActionId);
        QFilter actionCarrier = new QFilter("carrier", "=", (Object)ChgCarrierEnum.CARRIER_ACTION.getCode());
        return ChgGuideBaseRepository.getInstance().queryOne(selectFields, new QFilter[]{chgActionQFilter, RepositoryUtils.isEnable(), actionCarrier});
    }

    private String validateActionId(DynamicObject chgGuideBase) {
        return chgGuideBase == null ? "need enabled action-carrier chgActionId" : "";
    }

    private PerChgBizResult executeAction(ChgActionExecuteParamDto chgActionExecuteParam, DynamicObject chgGuideBase) {
        long ruleId = chgGuideBase.getLong("chgrule.id");
        DynamicObject chgRule = ChgRuleRepository.queryOne(ruleId);
        DynamicObject chgAction = chgRule.getDynamicObject("chgaction");
        PerChgBizInfo perChgBizInfo = this.getBizInfo(chgActionExecuteParam, chgAction, chgRule);
        DynamicObjectCollection ruleConfigs = chgRule.getDynamicObjectCollection("customentryentity");
        Map<DynamicObject, List<DynamicObject>> ruleConfigMap = ruleConfigs.stream().collect(Collectors.groupingBy(row -> row.getDynamicObject("chgtactic")));
        ArrayList<DynamicObject> tactics = new ArrayList<DynamicObject>(ruleConfigMap.keySet());
        tactics.sort(Comparator.comparingInt(tactic -> tactic.getInt("index")));
        Set targetTables = tactics.stream().filter(row -> row.getDynamicObject("chgobject") != null).map(row -> row.getString("chgobject.number")).collect(Collectors.toSet());
        QFilter entityQFilter = new QFilter("entity", "in", targetTables);
        DynamicObject[] personConfig = PersonEntityConfRepository.queryOriginalArray(new QFilter[]{entityQFilter});
        Map<String, String> tableClassifyMap = Arrays.stream(personConfig).collect(Collectors.toMap(row -> row.getString("entity"), row -> row.getString("classify")));
        Map<String, Long> personIds = chgActionExecuteParam.getPersonModel();
        HashMap<String, List<DynamicObject>> sourceData = new HashMap<String, List<DynamicObject>>();
        tableClassifyMap.entrySet().stream().filter(entrySet -> !HRStringUtils.equals((String)((String)entrySet.getValue()), (String)ChgPerEntityClassifyEnum.PERSON_MODEL.getClassify())).forEach(entrySet -> {
            HRBaseServiceHelper helper = new HRBaseServiceHelper((String)entrySet.getKey());
            ChgPerEntityClassifyEnum chgPerEntityClassify = ChgPerEntityClassifyEnum.getQueryFieldByClassify((String)entrySet.getValue());
            QFilter qFilter = new QFilter(chgPerEntityClassify.getForeign(), "=", personIds.get(chgPerEntityClassify.getIdField()));
            DynamicObject[] dyns = helper.loadDynamicObjectArray(new QFilter[]{qFilter, RepositoryUtils.isBusinessStatusEffect(), RepositoryUtils.isCurrentVersion()});
            if (dyns.length == 0) {
                return;
            }
            sourceData.put((String)entrySet.getKey(), Arrays.asList(dyns));
        });
        Map<String, Map<String, Set<Long>>> querySourceEntity = new InitDataQueryService().formatQuery(perChgBizInfo);
        Map<String, List<DynamicObject>> allData = new InitDataQueryService().queryData(querySourceEntity);
        querySourceEntity.forEach((entityName, query) -> {
            List entityData = sourceData.computeIfAbsent((String)entityName, list -> new ArrayList());
            entityData.addAll(((List)allData.get(entityName)).stream().filter(this.formatPredicate((Map<String, Set<Long>>)query)).collect(Collectors.toList()));
        });
        PerChgBizOperateType operateType = PerChgBizOperateType.CHGOPERATION_ADDNEWANDEFFECT;
        perChgBizInfo.setOldPersonId(chgActionExecuteParam.getPersonId());
        PerChgBizResult result = ExecutorService.getInstance().executeSingle(perChgBizInfo, operateType, sourceData, chgAction, chgRule, chgGuideBase);
        return result;
    }

    private Predicate<DynamicObject> formatPredicate(Map<String, Set<Long>> query) {
        return row -> {
            for (Map.Entry entry : query.entrySet()) {
                if (!((Set)entry.getValue()).contains(row.getLong((String)entry.getKey()))) continue;
                return true;
            }
            return false;
        };
    }

    private PerChgBizInfo getBizInfo(ChgActionExecuteParamDto chgActionExecuteParam, DynamicObject chgAction, DynamicObject chgRule) {
        PerChgBizInfo perChgBizInfo = new PerChgBizInfo();
        perChgBizInfo.setOldPersonId(chgActionExecuteParam.getPersonId());
        perChgBizInfo.setOldEmployeeId(chgActionExecuteParam.getEmployeeId());
        perChgBizInfo.setOldComempId(chgActionExecuteParam.getCmpEmpId());
        perChgBizInfo.setOldDepempId(chgActionExecuteParam.getDepEmpId());
        perChgBizInfo.setOldErfileId(Long.valueOf(chgActionExecuteParam.getErManFileId()));
        perChgBizInfo.setValueMap(chgActionExecuteParam.getValueMap());
        perChgBizInfo.setBsed(new Date(chgActionExecuteParam.getEffectTime()));
        perChgBizInfo.setActionId(Long.valueOf(chgAction.getLong("id")));
        perChgBizInfo.setRuleId(Long.valueOf(chgRule.getLong("id")));
        perChgBizInfo.setChgRule(chgRule);
        ConfigService.getInstance().initBizInfo(perChgBizInfo);
        if (chgActionExecuteParam.getScheduleIdsMap() == null) {
            perChgBizInfo.setDataRow(new HashMap());
        } else {
            perChgBizInfo.setDataRow(chgActionExecuteParam.getScheduleIdsMap());
        }
        return perChgBizInfo;
    }

    public Map<String, Object> getActionPersonalChange(Map<String, Object> params) {
        HashMap data = new HashMap();
        try {
            Long actionId = Long.parseLong(params.get("chgActionId") + "");
            return ChgApiDataReturnUtils.formatDataReturned(true, "", this.get(actionId));
        }
        catch (Exception e) {
            String traceId = RequestContext.get().getTraceId();
            String errorInfo = String.format(Locale.ROOT, "CHG_HPFS_ERROR.ChgActionExecuteService.execute.error param:%s", SerializationUtils.toJsonString(params));
            LOGGER.error(errorInfo, (Throwable)e);
            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e8b\u52a1\u53d8\u52a8\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u5185\u5bb9\u3002", (String)"ChgCrossValidateService_3", (String)"hr-hpfs-business", (Object[])new Object[0]), errorInfo + traceId);
            return ChgApiDataReturnUtils.formatDataReturned(false, errorMsg, data);
        }
    }

    private Map<String, Map<String, Map<String, Object>>> get(Long chgActionId) {
        if (chgActionId == null || chgActionId == 0L) {
            return Collections.emptyMap();
        }
        DynamicObject chgGuideBase = ChgGuideBaseRepository.getInstance().queryGuideBaseByAction(chgActionId, ChgCarrierEnum.CARRIER_ACTION.getCode());
        if (Objects.isNull(chgGuideBase)) {
            return Collections.emptyMap();
        }
        long ruleId = chgGuideBase.getLong("chgrule.id");
        DynamicObject chgRule = ChgRuleRepository.queryOne(ruleId);
        DynamicObjectCollection ruleConfigs = chgRule.getDynamicObjectCollection("customentryentity");
        Map<DynamicObject, List<DynamicObject>> ruleConfigMap = ruleConfigs.stream().filter(row -> row.getDynamicObject("chgtactic").getDynamicObject("chgobject") != null).collect(Collectors.groupingBy(row -> row.getDynamicObject("chgtactic")));
        HashMap<String, Map<String, Map<String, Object>>> res = new HashMap<String, Map<String, Map<String, Object>>>();
        for (Map.Entry<DynamicObject, List<DynamicObject>> entry : ruleConfigMap.entrySet()) {
            DynamicObject tactic = entry.getKey();
            List<DynamicObject> configs = entry.getValue();
            String changeObject = tactic.getString("chgobject.number");
            configs.forEach(config -> {
                String field = config.getString("chgfile");
                Map configMap = (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)config), Map.class);
                configMap.remove("chgtactic");
                configMap.remove("id");
                configMap.remove("seq");
                res.computeIfAbsent(changeObject, map -> new HashMap()).putIfAbsent(field, configMap);
            });
        }
        return res;
    }
}

