/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.executor.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.executor.service.ExecutorDataFormatService;
import kd.hrmp.hrpi.business.domian.service.HRPIServiceFactory;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgLogEntryStatusEnum;

public class HRPIValidateFormattedDataService {
    private static final Log LOGGER = LogFactory.getLog(HRPIValidateFormattedDataService.class);
    private static final HRPIValidateFormattedDataService HRPI_VALIDATE_FORMATTED_DATA_SERVICE = new HRPIValidateFormattedDataService();

    public static HRPIValidateFormattedDataService getInstance() {
        return HRPI_VALIDATE_FORMATTED_DATA_SERVICE;
    }

    public String validateByHRPI(Map<String, DynamicObjectCollection> dynMap, PerChgBizInfo bizInfo) {
        List<Map<String, DynamicObjectCollection>> list = ExecutorDataFormatService.formatDataByApiFormat(dynMap);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("caller", "hpfs");
        map.put("data", list);
        try {
            Map res = HRPIServiceFactory.personGenericService.validate(map);
            if (res == null) {
                LOGGER.warn("CHG_HPFS_WARN IHRPIPersonGenericService.validate api res is null");
                return "IHRPIPersonGenericService.validate api res is null";
            }
            if (((Boolean)res.get("success")).booleanValue()) {
                this.writeBackAllSuccessValidStatus(bizInfo);
                LOGGER.info("CHG_HPFS_WARN IHRPIPersonGenericService.validate success");
                return "";
            }
            List errorInfos = (List)res.get("errInfos");
            if (CollectionUtils.isEmpty((Collection)errorInfos)) {
                return "IHRPIPersonGenericService.validate api.result is false ,errorInfo is empty";
            }
            return this.parserErrorInfo(errorInfos, dynMap, bizInfo);
        }
        catch (Exception e) {
            String errorInfo = String.format(Locale.ROOT, "IHRPIPersonGenericService.validate api error:%s chgActionId:%s", ExceptionUtils.getExceptionStackTraceMessage((Exception)e), bizInfo.getActionId());
            LOGGER.error(errorInfo, (Throwable)e);
            throw new KDException((Throwable)e, new ErrorCode("validateByHRPI", errorInfo), new Object[0]);
        }
    }

    private String parserErrorInfo(List<Map<String, Object>> errorInfos, Map<String, DynamicObjectCollection> dynMap, PerChgBizInfo bizInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean isFail = false;
        HashMap<String, Map<Long, String>> entityErrMap = new HashMap<String, Map<Long, String>>(16);
        for (Map<String, Object> errorMap : errorInfos) {
            String entityNumber = (String)errorMap.get("entityNumber");
            if (!isFail && bizInfo.getEntityName2ErrorIfVerificationFail().contains(entityNumber)) {
                isFail = true;
            }
            stringBuilder.append(entityNumber).append(":");
            List error = (List)errorMap.get("errorDatas");
            if (error == null) {
                String errorInfo = String.format("parserErrorInfo entityNumber : %s, error is null : %s", entityNumber, errorMap.get("exceptionMessage"));
                throw new KDException((Throwable)new RuntimeException(), new ErrorCode("parserErrorInfo", errorInfo), new Object[0]);
            }
            error.forEach(row -> {
                Long id = (Long)row.get("id");
                String errorMsg = (String)row.get("errMsg");
                ((DynamicObjectCollection)dynMap.get(entityNumber)).removeIf(dyn -> dyn.getLong("id") == id.longValue());
                stringBuilder.append(errorMsg).append(";");
                entityErrMap.computeIfAbsent(entityNumber, map -> new HashMap(16)).put(id, errorMsg);
            });
        }
        this.writeBackValidStatus(bizInfo, entityErrMap);
        if (isFail) {
            String errorInfo = String.format(Locale.ROOT, "HRPIValidateFormattedDataService.parserErrorInfo EntityName2ErrorIfVerificationFail errorInfo:%s, chgActionId:%s", stringBuilder, bizInfo.getActionId());
            throw new KDException((Throwable)new RuntimeException(), new ErrorCode("parserErrorInfo", errorInfo), new Object[0]);
        }
        return stringBuilder.toString();
    }

    private void writeBackValidStatus(PerChgBizInfo bizInfo, Map<String, Map<Long, String>> entityErrMap) {
        Map logEntryMap = bizInfo.getLogEntryMap();
        logEntryMap.forEach((entityName, idMap) -> idMap.forEach((id, dto) -> {
            Map idErrMap = (Map)entityErrMap.get(entityName);
            if (CollectionUtils.isEmpty((Map)idErrMap) || HRStringUtils.isEmpty((String)((String)idErrMap.get(id)))) {
                dto.setValidStatus(ChgLogEntryStatusEnum.SUCCESS.getCode());
            } else {
                dto.setValidStatus(ChgLogEntryStatusEnum.FAIL.getCode());
                dto.setErrorMsg((String)idErrMap.get(id));
            }
        }));
    }

    private void writeBackAllSuccessValidStatus(PerChgBizInfo bizInfo) {
        Map logEntryMap = bizInfo.getLogEntryMap();
        logEntryMap.forEach((entityName, idMap) -> idMap.forEach((id, dto) -> dto.setValidStatus(ChgLogEntryStatusEnum.SUCCESS.getCode())));
    }
}

