/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.executor.util;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.service.cert.HRCertServiceHelper;
import kd.hr.hpfs.business.service.config.IDevParamConfigService;
import kd.hrmp.hrpi.business.tools.PersonModelConfigUtil;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgParam;
import kd.sdk.hr.hpfs.common.perchg.PerChgConstants;

public class PerChgUtils {
    private static final Log LOGGER = LogFactory.getLog(PerChgUtils.class);
    public static final String BUSINESS_KEY_USE_OLD_BOS_USER = "hpfs_use_old_bos_user";

    public static boolean isReemployment(PerChgBizInfo perChgBizInfo) {
        Long chgEventId = perChgBizInfo.getChgEventId();
        Long oldEmployeeId = perChgBizInfo.getOldEmployeeId();
        return Objects.nonNull(chgEventId) && 1010L == chgEventId && Objects.nonNull(oldEmployeeId) && oldEmployeeId > 0L;
    }

    public static boolean isQuit(PerChgBizInfo perChgBizInfo) {
        Long chgEventId = perChgBizInfo.getChgEventId();
        return HRCertServiceHelper.LICENSE_OUT.contains(chgEventId);
    }

    public static boolean skipCreateNewPerson(PerChgBizInfo perChgBizInfo) {
        Long chgEventId = perChgBizInfo.getChgEventId();
        Long oldEmployeeId = perChgBizInfo.getOldEmployeeId();
        return PersonModelConfigUtil.configOn() && Objects.nonNull(chgEventId) && HRCertServiceHelper.LICENSE_IN.contains(chgEventId) && Objects.nonNull(oldEmployeeId) && oldEmployeeId > 0L;
    }

    public static boolean skipCreateNewPerson(Long chgEventId, Long oldEmployeeId) {
        return PersonModelConfigUtil.configOn() && Objects.nonNull(chgEventId) && HRCertServiceHelper.LICENSE_IN.contains(chgEventId) && Objects.nonNull(oldEmployeeId) && oldEmployeeId > 0L;
    }

    public static boolean useOldBosUser() {
        String userOldBosUser = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey(BUSINESS_KEY_USE_OLD_BOS_USER);
        return Objects.isNull(userOldBosUser) ? Boolean.FALSE : HRStringUtils.equals((String)"true", (String)userOldBosUser);
    }

    public static String getProperty(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        value = System.getenv(key);
        return value != null ? value : defaultValue;
    }

    public static String getPerChgRetryMaxCountCacheKey(String uniqueKey) {
        return String.join((CharSequence)"_", "perchg_retry_maxcount", uniqueKey);
    }

    public static long getDLockTimeout() {
        try {
            String dLockTimeoutStr = PerChgUtils.getProperty("perchg.dlock.timeout", PerChgConstants.PERCHG_DLOCK_TIMEOUT_DEFAULT.toString());
            return Long.parseLong(dLockTimeoutStr);
        }
        catch (Exception ex) {
            LOGGER.error("MserviceService#getDLockTimeout error", (Throwable)ex);
            return PerChgConstants.PERCHG_DLOCK_TIMEOUT_DEFAULT;
        }
    }

    public static int getPerChgRetryMaxCount() {
        try {
            String retryCountStr = PerChgUtils.getProperty("perchg.retry.maxcount", String.valueOf(5));
            return Integer.parseInt(retryCountStr);
        }
        catch (Exception ex) {
            LOGGER.error("PerChgUtils#getPerChgRetryMaxCount error:", (Throwable)ex);
            return 5;
        }
    }

    public static String parseUniqueKeyFromChgMessage(String chgMessage) {
        String cacheKey = null;
        Map mqParam = (Map)SerializationUtils.fromJsonString((String)chgMessage, Map.class);
        try {
            PerChgParam perChgParam = (PerChgParam)SerializationUtils.fromJsonString((String)HRJSONUtils.toString(mqParam.get("billdata")), PerChgParam.class);
            List bizInfoList = perChgParam.getBizInfoList();
            if (bizInfoList.size() > 0) {
                PerChgBizInfo bizInfo = (PerChgBizInfo)bizInfoList.get(0);
                cacheKey = String.join((CharSequence)"_", bizInfo.getBillSource(), String.valueOf(bizInfo.getBillId()));
            }
        }
        catch (IOException ex) {
            LOGGER.error("PerChgUtils#parseUniqueKeyFromChgMessage exception", (Throwable)ex);
        }
        return cacheKey;
    }
}

