/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.parser.parserentity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.parser.AbstractParser;
import kd.hr.hpfs.business.perchg.parser.enums.AttachmentEnum;
import kd.hr.hpfs.business.perchg.parser.util.ParserUtil;
import kd.hr.hpfs.common.constants.PerModelConstants;
import kd.hr.hpfs.common.perchg.PerChgBoType;
import kd.sdk.hr.hpfs.business.perchg.executor.model.ChgRecordEntryDto;
import kd.sdk.hr.hpfs.common.constants.ChgConstants;
import kd.sdk.hr.hpfs.common.perchg.PerChgConstants;

public class DefaultEntityParser
extends AbstractParser
implements PerModelConstants,
ChgConstants,
PerChgConstants {
    private static final Log LOGGER = LogFactory.getLog(DefaultEntityParser.class);

    @Override
    protected EnumMap<PerChgBoType, List<DynamicObject>> doAddNewParser() {
        EnumMap<PerChgBoType, List<DynamicObject>> enumMap = new EnumMap<PerChgBoType, List<DynamicObject>>(PerChgBoType.class);
        ArrayList newList = new ArrayList();
        ArrayList modifyList = new ArrayList();
        this.sourceBillTrueData.forEach(row -> this.formatNewDynByChgMode((DynamicObject)row, newList, modifyList));
        enumMap.put(PerChgBoType.NEW, newList);
        enumMap.put(PerChgBoType.MODIFY, modifyList);
        return enumMap;
    }

    private void formatNewDynByChgMode(DynamicObject mappingSource, List<DynamicObject> newList, List<DynamicObject> modifyList) {
        switch (this.chgMode) {
            case "0": {
                DynamicObject newDyn = this.addHis(mappingSource);
                this.performAttachment(newList, mappingSource, newDyn);
                newList.add(newDyn);
                break;
            }
            case "1": {
                if (CollectionUtils.isEmpty((Collection)this.originData)) break;
                this.originData.stream().filter(ParserUtil::filterCurrentAndDataEffectFromOrigin).forEach(row -> modifyList.add(this.updateHis(mappingSource, (DynamicObject)row)));
                break;
            }
            case "2": {
                if (CollectionUtils.isEmpty((Collection)this.originData)) break;
                this.originData.stream().filter(ParserUtil::filterCurrentAndDataEffectFromOrigin).forEach(row -> modifyList.add(this.invalidHis((DynamicObject)row, mappingSource)));
                break;
            }
        }
    }

    private DynamicObject addHis(DynamicObject mappingSource) {
        DynamicObject newHis = this.formatAddHis();
        this.specialAddPerform(newHis, mappingSource);
        try {
            ParserUtil.generateHisByFieldMapping(this.getFieldEntry(), mappingSource, newHis, this.bizInfo);
        }
        catch (Exception e) {
            String errorInfo = String.format(Locale.ROOT, "DefaultEntityParser:entityname:%s", this.hisEntityName);
            LOGGER.error(errorInfo);
            throw new KDException((Throwable)e, new ErrorCode("AbstractCollTemplateViewPlugin", e.getMessage()), new Object[0]);
        }
        return newHis;
    }

    private void specialAddPerform(DynamicObject newHis, DynamicObject mappingSource) {
        if (this.hisEntityName.equals("hrpi_pertsprop")) {
            newHis.set("childrennumber", (Object)0);
        }
        if (this.hisEntityName.equals("hrpi_pereduexp")) {
            this.bizInfo.setPerEduExpIds(Long.valueOf(mappingSource.getLong("id")), Long.valueOf(newHis.getLong("id")));
        }
        if (this.hisEntityName.equals("hrpi_pereduexpcert")) {
            this.setModelVal(newHis, "pereduexp", (Long)this.bizInfo.getPerEduExpIds().get(mappingSource.getLong("edu.id")));
        }
    }

    private DynamicObject formatAddHis() {
        DynamicObject newHis = this.hisHelper.generateEmptyDynamicObject();
        Long newId = ORM.create().genLongId(this.hisEntityName);
        newHis.set("id", (Object)newId);
        this.setValueByGeneralBusinessRule(newHis, newId);
        return newHis;
    }

    private void setValueByGeneralBusinessRule(DynamicObject newHis, Long newId) {
        newHis.set("datastatus", (Object)"0");
        this.cacheNewPersonModel(newId);
        this.specialForm(newHis, newId);
        this.bizInfo.setIdsRecord(this.hisEntityName, ChgRecordEntryDto.formatNewRecord((Long)newId, (String)this.flowType));
        ParserUtil.fixDate(newHis, this.bizInfo.getBsed());
        ParserUtil.setInit(newHis);
        if (Objects.nonNull(newHis.getDataEntityType().getProperties().get((Object)"businessstatus"))) {
            newHis.set("businessstatus", (Object)"1");
        }
    }

    private void specialForm(DynamicObject newHis, Long newId) {
        this.setEmpNonEntRel(newHis, newId);
        this.setErManFile(newHis, newId);
        this.setIdFromCache(newHis);
    }

    private DynamicObject updateHis(DynamicObject mappingSource, DynamicObject origin) {
        DynamicObject newHis = this.formatUpdateHis(origin);
        ParserUtil.generateHisByFieldMapping(this.getFieldEntry(), mappingSource, newHis, this.bizInfo);
        return newHis;
    }

    private DynamicObject formatUpdateHis(DynamicObject source) {
        DynamicObject newHis = this.hisHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)source, (DynamicObject)newHis);
        newHis.set("createtime", (Object)new Date());
        long idBefore = source.getLong("id");
        Long vidBefore = source.getDataEntityType().getProperties().get((Object)"sourcevid") != null ? source.getLong("sourcevid") : idBefore;
        Long idNew = ORM.create().genLongId(this.hisEntityName);
        newHis.set("id", (Object)idNew);
        this.bizInfo.setIdsRecord(this.hisEntityName, ChgRecordEntryDto.formatRecord((Long)idBefore, (Long)vidBefore, (Long)idBefore, (Long)idNew, (String)this.chgMode, (String)this.flowType));
        if (newHis.getDataEntityType().getProperties().containsKey((Object)"bsed")) {
            newHis.set("bsed", (Object)this.bizInfo.getBsed());
        }
        return newHis;
    }

    private DynamicObject invalidHis(DynamicObject origin, DynamicObject mappingSource) {
        DynamicObject newHis = this.formatInvalidHis(origin);
        DataEntityPropertyCollection properties = newHis.getDataEntityType().getProperties();
        ParserUtil.generateHisByFieldMapping(this.getFieldEntry(), mappingSource, newHis, this.bizInfo);
        if (properties.containsKey((Object)"sysenddate") && properties.containsKey((Object)"enddate") && Objects.nonNull(newHis.get("sysenddate"))) {
            newHis.set("enddate", (Object)HRDateTimeUtils.addDay((Date)newHis.getDate("sysenddate"), (long)-1L));
        }
        return newHis;
    }

    private DynamicObject formatInvalidHis(DynamicObject source) {
        DynamicObject newHis = this.formatUpdateHis(source);
        DataEntityPropertyCollection properties = newHis.getDataEntityType().getProperties();
        boolean isErManFile = HRStringUtils.equals((String)this.hisEntityName, (String)"hspm_ermanfile");
        if (properties.containsKey((Object)"businessstatus")) {
            newHis.set("businessstatus", (Object)(isErManFile ? "-1" : "2"));
        }
        if (properties.containsKey((Object)"sysenddate")) {
            newHis.set("sysenddate", (Object)this.bizInfo.getBsed());
        }
        if (properties.containsKey((Object)"enddate")) {
            newHis.set("enddate", (Object)HRDateTimeUtils.addDay((Date)this.bizInfo.getBsed(), (long)-1L));
        }
        return newHis;
    }

    private void cacheNewPersonModel(Long newId) {
        switch (this.hisEntityName) {
            case "hrpi_person": {
                this.bizInfo.setNewPersonId(newId);
                break;
            }
            case "hrpi_employee": {
                this.bizInfo.setNewEmployeeId(newId);
                break;
            }
            case "hrpi_depemp": {
                this.bizInfo.setNewDepempId(newId);
                break;
            }
            case "hrpi_cmpemp": {
                this.bizInfo.setNewComempId(newId);
                break;
            }
            case "hspm_ermanfile": {
                this.bizInfo.setNewErfileId(newId);
                break;
            }
            case "hrpi_empentrel": {
                this.bizInfo.setNewEmpEntRel(newId);
                break;
            }
            case "hrpi_empposorgrel": {
                this.bizInfo.setNewEmpPosOrgRel(newId);
                break;
            }
            case "hrpi_pernontsprop": {
                this.bizInfo.setNewPerNonTSProp(newId);
                break;
            }
            case "hrpi_appointremoverel": {
                this.bizInfo.setNewAppointremoverel(newId);
            }
        }
    }

    private void setIdFromCache(DynamicObject hisDy) {
        this.setPersonModelVal(hisDy);
        this.setModelVal(hisDy, "empentrel", this.bizInfo.getNewEmpEntRel());
        this.setModelVal(hisDy, "empposrel", this.bizInfo.getNewEmpPosOrgRel());
        this.setModelVal(hisDy, "pernontsprop", this.bizInfo.getNewPerNonTSProp());
        this.setModelVal(hisDy, "appremoverel", this.bizInfo.getNewAppointremoverel());
    }

    private void setEmpNonEntRel(DynamicObject newHis, Long newId) {
        boolean oldEmployeeIdExist;
        boolean bl = oldEmployeeIdExist = this.bizInfo.getOldEmployeeId() != null && this.bizInfo.getOldEmployeeId() != 0L;
        if (this.hisEntityName.equals("hrpi_empnonentrel") && oldEmployeeIdExist) {
            DynamicObject empEntRel = ((List)this.source.get("hrpi_empentrel")).stream().filter(ParserUtil::filterCurrentAndDataEffectFromOrigin).findAny().orElse(null);
            if (empEntRel == null) {
                return;
            }
            HRDynamicObjectUtils.copy((DynamicObject)empEntRel, (DynamicObject)newHis);
            newHis.set("boid", null);
            newHis.set("id", (Object)newId);
        }
    }

    private void setErManFile(DynamicObject newHis, Long newId) {
        boolean oldEmployeeIdExist;
        boolean bl = oldEmployeeIdExist = this.bizInfo.getOldEmployeeId() != null && this.bizInfo.getOldEmployeeId() != 0L;
        if (this.hisEntityName.equals("hspm_ermanfile") && oldEmployeeIdExist) {
            if (this.originData == null) {
                return;
            }
            DynamicObject erManFile = this.findMainFile();
            if (erManFile == null) {
                LOGGER.warn("CHG_HPFS_WARN setErManFile erManFIle is null");
                newHis.set("empentrel", (Object)this.bizInfo.getNewEmpEntRel());
                newHis.set("pernontsprop", (Object)this.bizInfo.getNewPerNonTSProp());
                return;
            }
            HRDynamicObjectUtils.copy((DynamicObject)erManFile, (DynamicObject)newHis);
            newHis.set("boid", null);
            newHis.set("id", (Object)newId);
            newHis.set("empentrel", this.bizInfo.getNewEmpEntRel() == null ? erManFile.get("empentrel") : this.bizInfo.getNewEmpEntRel());
            newHis.set("empentrel_id", this.bizInfo.getNewEmpEntRel() == null ? erManFile.get("empentrel") : this.bizInfo.getNewEmpEntRel());
            newHis.set("pernontsprop", this.bizInfo.getNewPerNonTSProp() == null ? erManFile.get("pernontsprop") : this.bizInfo.getNewPerNonTSProp());
        }
    }

    private DynamicObject findMainFile() {
        DynamicObject mainErManFile;
        List erManFiles = this.originData.stream().filter(ParserUtil::filterCurrentAndDataEffectFromOrigin).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(erManFiles)) {
            LOGGER.warn("CHG_HPFS_WARN findMainFile erManFiles is empty");
            return null;
        }
        Long mainOrgId = this.bizInfo.getOldDepempId();
        if (mainOrgId != null && (mainErManFile = (DynamicObject)erManFiles.stream().filter(row -> mainOrgId.equals(row.getLong("depemp.id"))).findAny().orElse(null)) != null) {
            return mainErManFile;
        }
        LOGGER.warn("CHG_HPFS_WARN findMainFile mainErManFile is null");
        return (DynamicObject)erManFiles.get(0);
    }

    @Override
    protected EnumMap<PerChgBoType, List<DynamicObject>> doAddNewAndEffectParser() {
        return this.doAddNewParser();
    }

    @Override
    protected EnumMap<PerChgBoType, Long> doEffectParser() {
        EnumMap<PerChgBoType, Long> enumMap = new EnumMap<PerChgBoType, Long>(PerChgBoType.class);
        enumMap.put(PerChgBoType.MODIFY, this.bizInfo.getEventId());
        return enumMap;
    }

    @Override
    protected EnumMap<PerChgBoType, Long> doDiscardScheduleParser() {
        EnumMap<PerChgBoType, Long> enumMap = new EnumMap<PerChgBoType, Long>(PerChgBoType.class);
        enumMap.put(PerChgBoType.MODIFY, this.bizInfo.getEventId());
        return enumMap;
    }

    @Override
    protected List<DynamicObject> doUpdateScheduleParser() {
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        HashMap sourseMap = new HashMap(this.sourceBillTrueData.size());
        this.sourceBillTrueData.parallelStream().forEach(dy -> sourseMap.put(this.getSourceIdVal((DynamicObject)dy), dy));
        QFilter q2 = new QFilter("datastatus", "=", (Object)"0");
        QFilter q1 = new QFilter("bo", "in", sourseMap.keySet());
        DynamicObject[] dys = this.hisHelper.loadDynamicObjectArray(new QFilter[]{q1, q2});
        Arrays.stream(dys).forEach(dy -> resultList.add(ParserUtil.generateHisByFieldMapping(this.getFieldEntry(), (DynamicObject)sourseMap.get(dy.getLong("bo")), dy, this.bizInfo)));
        return resultList;
    }

    public DynamicObject formatNewDy(DynamicObject source) {
        switch (this.chgMode) {
            case "0": {
                return this.formatAddHis();
            }
            case "1": {
                return this.formatUpdateHis(source);
            }
            case "2": {
                return this.formatInvalidHis(source);
            }
        }
        return null;
    }

    private void performAttachment(List<DynamicObject> newList, DynamicObject mappingSource, DynamicObject newDyn) {
        String hrpiEntity = AttachmentEnum.getHrpiByBusiness(this.hisEntityName);
        if (HRStringUtils.isEmpty((String)hrpiEntity)) {
            LOGGER.warn("CHG_HPFS_WARN performAttachment hrpiEntity is null");
            return;
        }
        List attachmentData = (List)this.source.get("bos_attachment");
        if (CollectionUtils.isEmpty((Collection)attachmentData)) {
            LOGGER.warn("CHG_HPFS_WARN performAttachment attachmentData is null");
            return;
        }
        Long newId = newDyn.getLong("id");
        String sourceEntityName = AttachmentEnum.getHcfByHrpi(this.hisEntityName);
        List<DynamicObject> attachmentDataRelated = this.getOriginAttachmentData(attachmentData, sourceEntityName, mappingSource);
        if (attachmentDataRelated == null) {
            LOGGER.warn("CHG_HPFS_WARN performAttachment attachmentDataRelated is null");
            return;
        }
        attachmentDataRelated.forEach(row -> newList.add(this.formatAttachment((DynamicObject)row, newId, hrpiEntity)));
    }

    private List<DynamicObject> getOriginAttachmentData(List<DynamicObject> attachmentData, String sourceEntityName, DynamicObject mappingSource) {
        return this.performDefaultAttachment(attachmentData, sourceEntityName, mappingSource);
    }

    private List<DynamicObject> performDefaultAttachment(List<DynamicObject> attachmentData, String sourceEntityName, DynamicObject mappingSource) {
        String interIdOrigin = mappingSource.getString("id");
        return attachmentData.stream().filter(row -> HRStringUtils.equals((String)sourceEntityName, (String)row.getString("fbilltype")) && HRStringUtils.equals((String)row.getString("finterid"), (String)interIdOrigin)).collect(Collectors.toList());
    }

    private DynamicObject formatAttachment(DynamicObject attach, Long newId, String hrpiEntity) {
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_attachment"));
        HRDynamicObjectUtils.copy((DynamicObject)attach, (DynamicObject)dynamicObject);
        dynamicObject.set("id", (Object)ORM.create().genLongId("bos_attachment"));
        dynamicObject.set("finterid", (Object)newId);
        dynamicObject.set("fbilltype", (Object)hrpiEntity);
        dynamicObject.set("fattachmentpanel", (Object)"attachmentpanelap_std");
        dynamicObject.set("fcreatetime", (Object)new Date());
        dynamicObject.set("fmodifytime", (Object)new Date());
        return dynamicObject;
    }
}

