/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.repository;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class TaskLogRepository {
    private static final Log LOGGER = LogFactory.getLog(TaskLogRepository.class);
    private static final HRBaseServiceHelper TASK_LOG_HELPER = new HRBaseServiceHelper("sch_tasklog_details");

    public static boolean isSchduled(DynamicObject schedule) {
        if (null == schedule) {
            return false;
        }
        DynamicObject scheduleJob = schedule.getDynamicObject("job");
        if (null != scheduleJob) {
            return TaskLogRepository.isJobScheduled(scheduleJob);
        }
        DynamicObjectCollection jobEntry = schedule.getDynamicObjectCollection("entryentity");
        if (jobEntry == null) {
            return false;
        }
        int jobAmount = jobEntry.size();
        if (jobAmount == 1) {
            return TaskLogRepository.isJobScheduled((DynamicObject)jobEntry.get(0));
        }
        if (jobAmount > 1) {
            ArrayList<Long> jobIds = new ArrayList<Long>(jobAmount);
            for (DynamicObject dynamicObject : jobEntry) {
                long jobId = dynamicObject.getLong("jobnumber.id");
                if (jobId == 0L) continue;
                jobIds.add(jobId);
            }
            QFilter jobFilter = new QFilter("job", "in", jobIds);
            QFilter statusFilter = new QFilter("status", "=", (Object)"BEGIN");
            statusFilter.or(new QFilter("status", "=", (Object)"SCHEDULED"));
            DynamicObject[] taskJobs = TASK_LOG_HELPER.query("id,job,job.id", new QFilter[]{jobFilter, statusFilter});
            return TaskLogRepository.isAllTaskScheduled(jobAmount, taskJobs);
        }
        return false;
    }

    public static boolean isAllTaskScheduled(int jobAmount, DynamicObject[] taskJobs) {
        if (taskJobs.length < jobAmount) {
            return false;
        }
        HashSet scheduledJobIds = Sets.newHashSetWithExpectedSize((int)jobAmount);
        for (DynamicObject job : taskJobs) {
            scheduledJobIds.add(job.getLong("job.ids"));
        }
        return scheduledJobIds.size() == jobAmount;
    }

    private static boolean isJobScheduled(DynamicObject scheduleJob) {
        QFilter jobFilter = new QFilter("job", "=", scheduleJob.getPkValue());
        QFilter statusFilter = new QFilter("status", "=", (Object)"SCHEDULED");
        return TASK_LOG_HELPER.isExists(new QFilter[]{jobFilter, statusFilter});
    }
}

