/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.schedule;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hpfs.business.perchg.common.ChgLogHelper;
import kd.hr.hpfs.business.perchg.executor.MserviceService;

public class ScheduleOnbrdPerchgTask
extends AbstractTask {
    private final Log LOGGER = LogFactory.getLog(ScheduleOnbrdPerchgTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean isSkipOnbrd = false;
        try {
            isSkipOnbrd = Boolean.parseBoolean(System.getProperty("hpfs_skip_onbrd_perchg"));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            this.LOGGER.warn("", (Throwable)e);
        }
        if (isSkipOnbrd) {
            this.LOGGER.info("hpfs_skip_onbrd_perchg is true");
            return;
        }
        this.LOGGER.info("ScheduleOnbrdPerchgTask-execute");
        DynamicObject[] chgLogs = ChgLogHelper.queryChgLog("HPFSPersonChgOnbrdConsumer", "0");
        while (null != chgLogs && chgLogs.length > 0) {
            this.LOGGER.info("ScheduleOnbrdPerchgTask-execute,size:{}", (Object)chgLogs.length);
            for (DynamicObject chgLog : chgLogs) {
                ChgLogHelper.LOG_ID_THREAD_LOCAL.set(chgLog.getLong("id"));
                try {
                    MserviceService.getInstance().execute(chgLog.getString("params"));
                }
                catch (Exception ex) {
                    this.LOGGER.error("ScheduleOnbrdPerchgTask#execute error", (Throwable)ex);
                    ChgLogHelper.updateErrorLog(chgLog, ex);
                }
            }
            chgLogs = ChgLogHelper.queryChgLog("HPFSPersonChgOnbrdConsumer", "0");
        }
    }
}

