/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.schedule;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hpfs.business.perchg.executor.service.ExecutorDataFormatService;
import kd.hr.hpfs.business.utils.PersonGenericUtil;
import kd.hrmp.hrpi.business.domian.service.HRPIServiceFactory;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgParam;

public class ScheduleRepairProbationrst
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(ScheduleRepairProbationrst.class);
    HRBaseServiceHelper recordHelper = new HRBaseServiceHelper("hpfs_chgrecord");
    HRBaseServiceHelper logHelper = new HRBaseServiceHelper("hpfs_chglog");
    HRBaseServiceHelper trialperiodrstHelper = new HRBaseServiceHelper("hrpi_trialperiodrst");
    private static final Integer MAX_SEND = 1000;
    private static List<Long> REG_ACTION_IDS = Arrays.asList(1090L, 1260L);
    private static String ENTITY_HDM_REGPROCESS = "hdm_regprocess";
    private static String ENTITY_HDM_REGBBASEBILL = "hdm_regbasebill";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("ScheduleRepairProbationrst-execute begin");
        try {
            List<Long> eventIds = this.getRegChangeEventId();
            if (CollectionUtils.isEmpty(eventIds)) {
                LOGGER.info("ScheduleRepairProbationrst-execute eventIds is empty, task end");
                return;
            }
            List<RegChangeRecord> regChangeRecords = this.getRegChangeRecordByEventId(eventIds);
            Stream.iterate(0, n -> n + 1).limit(this.countStep(regChangeRecords.size()).intValue()).forEach(i -> this.executeRepairProbationrst(regChangeRecords.stream().skip(i * MAX_SEND).limit(MAX_SEND.intValue()).collect(Collectors.toList())));
        }
        catch (Exception ex) {
            LOGGER.error("ScheduleRepairProbationrst-execute error", (Throwable)ex);
        }
        LOGGER.info("ScheduleRepairProbationrst-execute end");
    }

    private Integer countStep(int size) {
        return (size + MAX_SEND - 1) / MAX_SEND;
    }

    private void executeRepairProbationrst(List<RegChangeRecord> regChangeRecords) {
        try {
            HashMap entityRecordMap = new HashMap(16);
            ArrayList<Long> employeeIds = new ArrayList<Long>();
            regChangeRecords.forEach(regRecord -> {
                PerChgBizInfo bizInfo = regRecord.getBizInfo();
                Map dataRow = bizInfo.getDataRow();
                dataRow.forEach((key, value) -> {
                    if (!CollectionUtils.isEmpty((Collection)value)) {
                        Map recordBillMap = entityRecordMap.computeIfAbsent(key, map -> new HashMap());
                        recordBillMap.put(regRecord.getRecordId(), value.get(0));
                    }
                });
                employeeIds.add(regRecord.getBizInfo().getOldEmployeeId());
            });
            DynamicObject[] trialperiodrstArr = this.listTrialperiodrstByEmployeeIds(employeeIds);
            if (null == trialperiodrstArr || trialperiodrstArr.length == 0) {
                LOGGER.warn("trialperiodrstArr is empty");
                return;
            }
            Map<Long, List<DynamicObject>> trialperMap = Arrays.stream(trialperiodrstArr).collect(Collectors.groupingBy(trialperiodrst -> trialperiodrst.getLong("employee_id")));
            Map<Object, DynamicObject> regbasebillMap = this.getDynamicObjectMapByFields(ENTITY_HDM_REGBBASEBILL, "id", ((Map)entityRecordMap.getOrDefault(ENTITY_HDM_REGBBASEBILL, new HashMap())).values().stream().collect(Collectors.toList()));
            Map<Object, DynamicObject> regprocessMap = this.getDynamicObjectMapByFields(ENTITY_HDM_REGPROCESS, "id", ((Map)entityRecordMap.getOrDefault(ENTITY_HDM_REGPROCESS, new HashMap())).values().stream().collect(Collectors.toList()));
            regChangeRecords.forEach(record -> this.setTrialperiodrst((RegChangeRecord)record, trialperMap, entityRecordMap, regbasebillMap, regprocessMap));
            List<DynamicObject> collect = regChangeRecords.stream().filter(record -> null != record.getTrialperiodrst()).flatMap(record -> record.getTrialperiodrst().stream()).collect(Collectors.toList());
            collect.forEach(this::saveData);
        }
        catch (Exception ex) {
            LOGGER.error("executeRepairProbationrst error", (Throwable)ex);
        }
    }

    private List<Long> getRegChangeEventId() {
        QFilter chgActionFilter = new QFilter("chgaction", "in", REG_ACTION_IDS);
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        DynamicObject[] regRecordArr = this.recordHelper.loadDynamicObjectArray(new QFilter[]{chgActionFilter, statusFilter});
        Map<Long, List<DynamicObject>> bill = Arrays.stream(regRecordArr).collect(Collectors.groupingBy(dy -> dy.getLong("bill")));
        List<Long> eventIds = bill.values().stream().map(list -> list.stream().filter(dy -> null != dy.getDate("createtime") && dy.getLong("event") > 0L).sorted((record1, record2) -> HRDateTimeUtils.dayBefore((Date)record1.getDate("createtime"), (Date)record2.getDate("createtime")) ? 1 : -1).findFirst().get().getLong("event")).collect(Collectors.toList());
        return eventIds;
    }

    private List<RegChangeRecord> getRegChangeRecordByEventId(List<Long> eventIds) {
        QFilter eventFilter = new QFilter("event", "in", eventIds);
        DynamicObject[] chgLogs = this.logHelper.query("id, event, appid, chgaction, params, chgrecord, consumeexetime", new QFilter[]{eventFilter});
        List<RegChangeRecord> regChangeRecords = Arrays.stream(chgLogs).map(RegChangeRecord::logConvert2RegChangeRecord).filter(record -> !Objects.isNull(record.getBizInfo()) && !Objects.isNull(record.getEmployeeId()) && record.getEmployeeId() > 0L).sorted(Comparator.comparing(RegChangeRecord::getConsumeexetime).reversed()).distinct().collect(Collectors.toList());
        return regChangeRecords;
    }

    private void saveData(DynamicObject trialperiodrstDy) {
        DynamicObjectCollection trialperiodrstDys = new DynamicObjectCollection();
        trialperiodrstDys.add((Object)trialperiodrstDy);
        HashMap dynMap = Maps.newHashMapWithExpectedSize((int)trialperiodrstDys.size());
        dynMap.put("hrpi_trialperiodrst", trialperiodrstDys);
        List<Map<String, DynamicObjectCollection>> dynList = ExecutorDataFormatService.formatDataByApiFormat(dynMap);
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("caller", "hpfs");
        map.put("mustAllSuccess", Boolean.TRUE);
        map.put("data", dynList);
        Map res = HRPIServiceFactory.personGenericService.saveBatch(map);
    }

    private void setTrialperiodrst(RegChangeRecord record, Map<Long, List<DynamicObject>> trialperMap, Map<String, Map<Long, Long>> entityRecordMap, Map<Object, DynamicObject> regbasebillMap, Map<Object, DynamicObject> regprocessMap) {
        List<DynamicObject> oldtrialperiodrsts = trialperMap.get(record.getBizInfo().getOldEmployeeId());
        if (CollectionUtils.isEmpty(oldtrialperiodrsts)) {
            return;
        }
        ArrayList<DynamicObject> trialperiodrsts = new ArrayList<DynamicObject>(oldtrialperiodrsts.size());
        oldtrialperiodrsts.forEach(oldtrialperiodrst -> {
            Long regProcessId;
            DynamicObject trialperiodrst = this.trialperiodrstHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)oldtrialperiodrst, (DynamicObject)trialperiodrst);
            trialperiodrst.set("id", (Object)ORM.create().genLongId("hrpi_trialperiodrst"));
            Long trialperiod = (Long)((Map)entityRecordMap.getOrDefault("hrpi_trialperiod", new HashMap())).get(record.getRecordId());
            if (null != trialperiod) {
                trialperiodrst.set("probationid_id", (Object)trialperiod);
            }
            if (null != (regProcessId = (Long)((Map)entityRecordMap.getOrDefault(ENTITY_HDM_REGPROCESS, new HashMap())).get(record.getRecordId())) && null != regprocessMap.get(regProcessId)) {
                trialperiodrst.set("probationrst", ((DynamicObject)regprocessMap.get(regProcessId)).get("trialperiodrst"));
            }
            Long regbasebillId = (Long)((Map)entityRecordMap.getOrDefault(ENTITY_HDM_REGBBASEBILL, new HashMap())).get(record.getRecordId());
            long datadiff = -1L;
            if (null != regbasebillId && null != regbasebillMap.get(regbasebillId) && null != ((DynamicObject)regbasebillMap.get(regbasebillId)).get("effectdate")) {
                Date startdate = trialperiodrst.getDate("startdate");
                Date effectdate = (Date)((DynamicObject)regbasebillMap.get(regbasebillId)).get("effectdate");
                datadiff = PersonGenericUtil.dateDiff(effectdate, startdate);
                if (datadiff >= 0L) {
                    trialperiodrst.set("sysenddate", ((DynamicObject)regbasebillMap.get(regbasebillId)).get("effectdate"));
                }
            }
            Date sysenddate = trialperiodrst.getDate("sysenddate");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            if (null == sysenddate) {
                try {
                    trialperiodrst.set("sysenddate", (Object)df.parse("2999-12-31"));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (datadiff == 0L) {
                trialperiodrst.set("enddate", (Object)trialperiodrst.getDate("sysenddate"));
            } else if (datadiff > 0L) {
                trialperiodrst.set("enddate", (Object)HRDateTimeUtils.addDay((Date)trialperiodrst.getDate("sysenddate"), (long)-1L));
            }
            trialperiodrsts.add(trialperiodrst);
        });
        record.setTrialperiodrst(trialperiodrsts);
    }

    private DynamicObject[] listTrialperiodrstByEmployeeIds(List<Long> employeeIds) {
        QFilter employeeFilter = new QFilter("employee", "in", employeeIds);
        QFilter probationrstFilter = new QFilter("probationrst", "=", (Object)0L);
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return this.trialperiodrstHelper.loadDynamicObjectArray(new QFilter[]{employeeFilter, currentFilter, probationrstFilter});
    }

    private Map<Object, DynamicObject> getDynamicObjectMapByFields(String entityNumber, String field, List<Long> ids) {
        QFilter queryFilter = new QFilter(field, "in", ids);
        DynamicObject[] dynamicObjects = new HRBaseServiceHelper(entityNumber).loadDynamicObjectArray(new QFilter[]{queryFilter});
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.get(field), Function.identity()));
    }

    static class RegChangeRecord {
        private Long logId;
        private Long eventId;
        private Long recordId;
        private String appId;
        private PerChgBizInfo bizInfo;
        private Long employeeId;
        private Long consumeexetime;
        private List<DynamicObject> trialperiodrst;

        RegChangeRecord() {
        }

        public Long getLogId() {
            return this.logId;
        }

        public void setLogId(Long logId) {
            this.logId = logId;
        }

        public Long getEventId() {
            return this.eventId;
        }

        public void setEventId(Long eventId) {
            this.eventId = eventId;
        }

        public Long getRecordId() {
            return this.recordId;
        }

        public void setRecordId(Long recordId) {
            this.recordId = recordId;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public PerChgBizInfo getBizInfo() {
            return this.bizInfo;
        }

        public void setBizInfo(PerChgBizInfo bizInfo) {
            this.bizInfo = bizInfo;
        }

        public List<DynamicObject> getTrialperiodrst() {
            return this.trialperiodrst;
        }

        public void setTrialperiodrst(List<DynamicObject> trialperiodrst) {
            this.trialperiodrst = trialperiodrst;
        }

        public Long getEmployeeId() {
            return this.employeeId;
        }

        public void setEmployeeId(Long employeeId) {
            this.employeeId = employeeId;
        }

        public Long getConsumeexetime() {
            return this.consumeexetime;
        }

        public void setConsumeexetime(Long consumeexetime) {
            this.consumeexetime = consumeexetime;
        }

        public static RegChangeRecord logConvert2RegChangeRecord(DynamicObject log) {
            RegChangeRecord regChangeRecord = new RegChangeRecord();
            regChangeRecord.setAppId(log.getString("appid"));
            regChangeRecord.setLogId(log.getLong("id"));
            regChangeRecord.setEventId(log.getLong("event"));
            regChangeRecord.setRecordId(log.getLong("chgrecord"));
            regChangeRecord.setConsumeexetime(log.getDate("consumeexetime").getTime());
            Map mqParam = (Map)SerializationUtils.fromJsonString((String)log.getString("params"), Map.class);
            PerChgParam perChgParam = null;
            try {
                perChgParam = (PerChgParam)SerializationUtils.fromJsonString((String)HRJSONUtils.toString(mqParam.get("billdata")), PerChgParam.class);
            }
            catch (IOException ex) {
                LOGGER.error("serialization error, the exception is ", (Throwable)ex);
            }
            if (!Objects.isNull(perChgParam)) {
                regChangeRecord.setBizInfo((PerChgBizInfo)perChgParam.getBizInfoList().get(0));
            }
            if (!Objects.isNull(regChangeRecord.getBizInfo())) {
                regChangeRecord.setEmployeeId(regChangeRecord.getBizInfo().getOldEmployeeId());
            }
            return regChangeRecord;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegChangeRecord that = (RegChangeRecord)o;
            return Objects.equals(this.employeeId, that.employeeId);
        }

        public int hashCode() {
            return Objects.hash(this.employeeId);
        }
    }
}

