/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.parser.ParserResult;
import kd.hr.hpfs.business.perchg.service.IAfterDataFormatPluginService;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;

public class HdmAfterDataFormatPluginServiceImpl
implements IAfterDataFormatPluginService {
    private static final Log LOGGER = LogFactory.getLog(HdmAfterDataFormatPluginServiceImpl.class);

    @Override
    public void performParserResult(List<ParserResult> parserResults, PerChgBizInfo bizInfo, Map<String, List<DynamicObject>> sourceData, DynamicObject chgActionInfo, DynamicObject chgRuleInfo, Map<String, String> paramMap) {
        HashMap<String, List<String>> coreFields = new HashMap<String, List<String>>();
        List<String> empJobRelCore = Arrays.asList("job", "employee", "joblevel", "jobgrade", "person", "jobseq", "jobscm", "jobclass", "jobfamily");
        List<String> baseLocationCore = Collections.singletonList("location");
        coreFields.put("hrpi_baselocation", baseLocationCore);
        coreFields.put("hrpi_empjobrel", empJobRelCore);
        Set tableSet = coreFields.keySet();
        HashMap<String, List> map = new HashMap<String, List>(16);
        parserResults.forEach(row -> {
            String entityName = (String)row.getParserParam().get("entityName");
            if (tableSet.contains(entityName)) {
                DynamicObject dyn = (DynamicObject)row.getParserParam().get("hisDy");
                map.computeIfAbsent(entityName, list -> new ArrayList()).add(dyn);
            }
        });
        map.forEach((entityName, dyns) -> {
            DynamicObject addDyn = dyns.stream().filter(row -> row.getLong("boid") == 0L && HRStringUtils.equals((String)row.getString("businessstatus"), (String)"1")).findAny().orElse(null);
            if (addDyn == null) {
                String warnInfo = "HdmAfterDataFormatPluginServiceImpl.coreProcess addDyn is null, entityname:" + entityName;
                LOGGER.warn(warnInfo);
                return;
            }
            DynamicObject invalidDyn = dyns.stream().filter(row -> row.getLong("boid") != 0L && HRStringUtils.equals((String)row.getString("businessstatus"), (String)"2")).findAny().orElse(null);
            if (invalidDyn == null) {
                String warnInfo = "HdmAfterDataFormatPluginServiceImpl.coreProcess invalidDyn is null, entityname:" + entityName;
                LOGGER.warn(warnInfo);
                return;
            }
            List core = (List)coreFields.get(entityName);
            if (CollectionUtils.isEmpty((Collection)core)) {
                String warnInfo = "HdmAfterDataFormatPluginServiceImpl.coreProcess core is null, entityname:" + entityName;
                LOGGER.warn(warnInfo);
                return;
            }
            boolean unchanged = true;
            for (String field : core) {
                Object add = addDyn.get(field);
                Object invalid = invalidDyn.get(field);
                if (add == null && invalid == null) continue;
                if (add != null && invalid != null) {
                    unchanged = HRObjectUtils.equals((Object)add, (Object)invalid);
                    if (unchanged) continue;
                    break;
                }
                unchanged = false;
                break;
            }
            if (!unchanged) {
                return;
            }
            invalidDyn.set("businessstatus", (Object)"1");
            invalidDyn.set("sysenddate", (Object)HRDateTimeUtils.getSysMaxDate());
            invalidDyn.set("enddate", (Object)HRDateTimeUtils.getSysMaxDate());
            invalidDyn.set("description", addDyn.get("description"));
            parserResults.removeIf(row -> HRStringUtils.equals((String)((String)row.getParserParam().get("entityName")), (String)entityName) && ((DynamicObject)row.getParserParam().get("hisDy")).getLong("id") == addDyn.getLong("id"));
            ((List)bizInfo.getIdsRecord().get(entityName)).removeIf(row -> row.getVidAfter() != null && row.getVidAfter().longValue() == addDyn.getLong("id"));
            ((List)bizInfo.getIdsRecord().get(entityName)).stream().filter(row -> row.getIdAfter().longValue() == invalidDyn.getLong("id")).forEach(row -> row.setChgMode(ChgModeEnum.MODIFY.getChgMode()));
        });
    }
}

