/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.service.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.parser.ParserResult;
import kd.hr.hpfs.business.perchg.service.IAfterDataFormatPluginService;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.executor.model.ChgRecordEntryDto;

public class HdmCadreInfoAppRemOveRelServiceImpl
implements IAfterDataFormatPluginService {
    private static final String PAGE_APPREMOVEREL = "hrpi_appointremoverel";
    private static final HRBaseServiceHelper REPOSITORY_APP_REM_OVE_REL = HRBaseServiceHelper.create((String)"hrpi_appointremoverel");
    private static final Log LOG = LogFactory.getLog(HdmCadreInfoAppRemOveRelServiceImpl.class);

    public Boolean enableSihc() {
        Boolean enableSihc = (Boolean)HRMServiceHelper.invokeHRMPService((String)"soecs", (String)"SystemConfigMService", (String)"enableSihc", (Object[])new Object[0]);
        return enableSihc;
    }

    @Override
    public void performParserResult(List<ParserResult> parserResults, PerChgBizInfo bizInfo, Map<String, List<DynamicObject>> sourceData, DynamicObject chgActionInfo, DynamicObject chgRuleInfo, Map<String, String> paramMap) {
        if (!this.enableSihc().booleanValue()) {
            return;
        }
        LOG.info("HdmCadreInfoAppRemOveRelServiceImpl.performParserResult.start:{}", parserResults.stream().filter(parserResult -> !CollectionUtils.isEmpty(parserResult.getParserParam())).map(parserResult -> parserResult.getParserParam().get("entityName")).collect(Collectors.toList()));
        Long billId = bizInfo.getBillId();
        DynamicObject dynamicObject = HRBaseServiceHelper.create((String)bizInfo.getBillSource()).queryOne((Object)billId);
        if (dynamicObject == null) {
            return;
        }
        Optional<DynamicObject> empPosOrgRelOp = parserResults.stream().filter(parserResult -> HRStringUtils.equals((String)String.valueOf(parserResult.getParserParam().get("entityName")), (String)"hrpi_empposorgrel")).map(parserResult -> (DynamicObject)parserResult.getParserParam().get("hisDy")).findFirst();
        if (!empPosOrgRelOp.isPresent()) {
            return;
        }
        long appRemOveRelId = dynamicObject.getLong("appremoverel.id");
        if (appRemOveRelId != 0L) {
            parserResults.add(this.updateAppRemOveRel(appRemOveRelId, dynamicObject, empPosOrgRelOp.get()));
            this.createOrUpdateIdsRecord(bizInfo, "1", appRemOveRelId);
        }
        LOG.info("HdmCadreInfoAppRemOveRelServiceImpl.performParserResult.end: {}", parserResults.stream().filter(parserResult -> !CollectionUtils.isEmpty(parserResult.getParserParam())).map(parserResult -> parserResult.getParserParam().get("entityName")).collect(Collectors.toList()));
    }

    private ParserResult updateAppRemOveRel(long appRemOveRelId, DynamicObject billDO, DynamicObject empPosOrgRelDO) {
        DynamicObject dynamicObject = REPOSITORY_APP_REM_OVE_REL.loadSingle((Object)appRemOveRelId);
        dynamicObject.set("empposrel", (Object)empPosOrgRelDO);
        dynamicObject.set("person", empPosOrgRelDO.get("person"));
        dynamicObject.set("employee", empPosOrgRelDO.get("employee"));
        Object effectdate = billDO.get("effectdate");
        if (effectdate == null && billDO.getDynamicObjectType().getProperty("realitydate") != null) {
            effectdate = billDO.get("realitydate");
        }
        dynamicObject.set("bsed", effectdate);
        DynamicObject clone = REPOSITORY_APP_REM_OVE_REL.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)clone, (boolean)true);
        clone.set("id", (Object)ORM.create().genLongId(REPOSITORY_APP_REM_OVE_REL.getEntityName()));
        LOG.info("HdmCadreInfoAppRemOveRelServiceImpl.performParserResult updateAppRemOveRelBoId:{}", (Object)appRemOveRelId);
        return this.genParserResult(clone);
    }

    private void createOrUpdateIdsRecord(PerChgBizInfo bizInfo, String type, Long id) {
        bizInfo.getIdsRecord().remove(REPOSITORY_APP_REM_OVE_REL.getEntityName());
        ChgRecordEntryDto chgRecordEntryDto = new ChgRecordEntryDto();
        chgRecordEntryDto.setChgMode(type);
        if (HRStringUtils.equals((String)type, (String)"0")) {
            chgRecordEntryDto.setIdAfter(id);
        }
        if (HRStringUtils.equals((String)type, (String)"1")) {
            chgRecordEntryDto.setIdBefore(id);
        }
        bizInfo.getIdsRecord().put(REPOSITORY_APP_REM_OVE_REL.getEntityName(), Collections.singletonList(chgRecordEntryDto));
    }

    private ParserResult genParserResult(DynamicObject dynamicObject) {
        ParserResult parserResult = new ParserResult();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("entityName", dynamicObject.getDynamicObjectType().getName());
        map.put("hisDy", dynamicObject);
        parserResult.setParserParam(map);
        return parserResult;
    }
}

