/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.executor.chgtype.ChgTypeIndividuation;
import kd.hr.hpfs.business.perchg.executor.util.PerChgUtils;
import kd.hr.hpfs.business.perchg.parser.ParserResult;
import kd.hr.hpfs.business.perchg.service.IAfterDataFormatPluginService;
import kd.hr.hpfs.business.service.repeatnumber.GenerateReplaceNumberHelper;
import kd.hr.hpfs.common.model.PreEmployeeModel;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.common.constants.PerModelConstants;

public class NumberRepeatAfterDataFormatServiceImpl
implements IAfterDataFormatPluginService,
PerModelConstants {
    private static final Log LOGGER = LogFactory.getLog(NumberRepeatAfterDataFormatServiceImpl.class);

    @Override
    public void performParserResult(List<ParserResult> parserResults, PerChgBizInfo bizInfo, Map<String, List<DynamicObject>> sourceData, DynamicObject chgActionInfo, DynamicObject chgRuleInfo, Map<String, String> paramMap) {
        if (PerChgUtils.skipCreateNewPerson(bizInfo)) {
            LOGGER.info("ReplacePreNumberAfterDataFormatServiceImpl#performParserResult skipCreateNewPerson, the plugin execute end");
            return;
        }
        GenerateReplaceNumberHelper instance = GenerateReplaceNumberHelper.getInstance();
        PreEmployeeModel preEmployeeModel = null;
        if (!paramMap.containsKey("repeatednumber")) {
            preEmployeeModel = instance.getPreEmployeeMsg(parserResults, sourceData, bizInfo, chgActionInfo, chgRuleInfo, paramMap);
        } else {
            String repeatedNumber = paramMap.get("repeatednumber");
            List<DynamicObject> onBrdBillDys = sourceData.get(bizInfo.getBillSource());
            if (CollectionUtils.isEmpty(onBrdBillDys)) {
                throw new KDException(new ErrorCode("NumberRepeatAfterDataFormatServiceImpl error", "has repatednumber config,but bill is empty"), new Object[0]);
            }
            if (HRStringUtils.isEmpty((String)repeatedNumber)) {
                repeatedNumber = "employeenoscheme";
            }
            if (!onBrdBillDys.get(0).containsProperty(repeatedNumber)) {
                throw new KDException(new ErrorCode("NumberRepeatAfterDataFormatServiceImpl error", "has repatednumber config,but bill not find config field"), new Object[0]);
            }
            String repeatedNumberValue = onBrdBillDys.get(0).getString(repeatedNumber);
            if ("1".equals(repeatedNumberValue)) {
                throw new KDException(new ErrorCode("NumberRepeatAfterDataFormatServiceImpl error", "config repatednumber,but bill do not repeatednumber"), new Object[0]);
            }
            preEmployeeModel = instance.getPreEmployeeMsg(parserResults, sourceData, bizInfo, chgActionInfo, chgRuleInfo, paramMap);
        }
        if (preEmployeeModel == null) {
            LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#GetPreInfoEmpty");
            return;
        }
        this.assembleNumberUpdateData(parserResults, bizInfo, sourceData, chgActionInfo, chgRuleInfo, paramMap, preEmployeeModel);
    }

    private void assembleNumberUpdateData(List<ParserResult> parserResults, PerChgBizInfo bizInfo, Map<String, List<DynamicObject>> sourceData, DynamicObject chgActionInfo, DynamicObject chgRuleInfo, Map<String, String> paramMap, PreEmployeeModel preEmployeeModel) {
        LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#start->{}", (Object)preEmployeeModel);
        ChgTypeIndividuation.THREAD_LOCAL_PREEMPLOYEEMODEL.set(preEmployeeModel);
        bizInfo.setOldPersonId(preEmployeeModel.getOldPersonId());
        DynamicObject entityInfo = GenerateReplaceNumberHelper.getInstance().getEntityInfo(parserResults, "hrpi_empentrel");
        if (entityInfo == null) {
            LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#isEmptyNumber");
            return;
        }
        String onBrdNumber = entityInfo.getString("empnumber");
        GenerateReplaceNumberHelper instance = GenerateReplaceNumberHelper.getInstance();
        instance.replaceOldNumber("hrpi_employee", parserResults, preEmployeeModel, onBrdNumber, bizInfo, "1", chgActionInfo, chgRuleInfo, paramMap, sourceData);
        instance.replaceOldNumber("hrpi_empentrel", parserResults, preEmployeeModel, onBrdNumber, bizInfo, "1", chgActionInfo, chgRuleInfo, paramMap, sourceData);
        Set<String> entityNameSet = instance.numberEntity();
        for (String entityName : entityNameSet) {
            instance.replaceOldNumber(entityName, parserResults, preEmployeeModel, onBrdNumber, bizInfo, "1", chgActionInfo, chgRuleInfo, paramMap, sourceData);
        }
    }
}

