/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.service.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hpfs.business.perchg.parser.ParserResult;
import kd.hr.hpfs.business.perchg.service.IAfterDataSavedPluginService;
import kd.hr.hpfs.common.perchg.PerChgBizOperateType;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizResult;

public class SendCoordinateMsg
implements IAfterDataSavedPluginService {
    @Override
    public void afterDataSaved(PerChgBizResult bizResult, PerChgBizInfo bizInfo, PerChgBizOperateType operateType, DynamicObject chgActionInfo, List<ParserResult> parserResults, Map<String, String> paramsMap) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String msgNumber = Objects.isNull(bizInfo.getBillNo()) ? String.join((CharSequence)"_", chgActionInfo.getString("number"), timestamp) : String.join((CharSequence)"_", bizInfo.getBillNo(), timestamp);
        String msgPubNo = paramsMap.get("msgPubNo");
        HashMap<String, Object> messageParams = new HashMap<String, Object>(8);
        messageParams.put("msgNumber", msgNumber);
        messageParams.put("msgPubNo", msgPubNo);
        messageParams.put("msgTitle", this.getMsgTitle(bizResult, bizInfo, operateType, chgActionInfo));
        messageParams.put("actionId", bizResult.getMsgSynActionId());
        messageParams.put("senderId", RequestContext.get().getCurrUserId());
        messageParams.put("sendTime", new Date());
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("affactionId", bizInfo.getActionId());
        params.put("recordId", bizInfo.getChgrecordId());
        params.put("chgcategoryId", bizInfo.getChgRule().getLong("chgaction.chgcategory_id"));
        messageParams.put("params", SerializationUtils.serializeToBase64(params));
        HRProducerServiceHelper.publishAction(messageParams);
    }

    private String getMsgTitle(PerChgBizResult bizResult, PerChgBizInfo bizInfo, PerChgBizOperateType operateType, DynamicObject chgActionInfo) {
        Long personId = bizResult.getNewPersonId() == null ? bizInfo.getOldPersonId() : bizResult.getNewPersonId();
        QFilter idQFilter = new QFilter("id", "=", (Object)personId);
        DynamicObject personDy = new HRBaseServiceHelper("hrpi_person").loadDynamicObject(idQFilter);
        if (null == personDy) {
            return String.join((CharSequence)"_", chgActionInfo.getString("name"), operateType.getOperateName().loadKDString(), bizInfo.getBillNo());
        }
        return String.join((CharSequence)"_", chgActionInfo.getString("name"), personDy.getString("name"), personDy.getString("number"), operateType.getOperateName().loadKDString());
    }
}

