/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.parser.ParserResult;
import kd.hr.hpfs.business.perchg.service.IAfterDataFormatPluginService;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgFlowTypeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.model.ChgRecordEntryDto;

public class UpdateEffectDepempId4ChgRecordPlugin
implements IAfterDataFormatPluginService {
    private static final Log LOGGER = LogFactory.getLog(UpdateEffectDepempId4ChgRecordPlugin.class);

    @Override
    public void performParserResult(List<ParserResult> parserResults, PerChgBizInfo bizInfo, Map<String, List<DynamicObject>> sourceData, DynamicObject chgActionInfo, DynamicObject chgRuleInfo, Map<String, String> paramMap) {
        Long oldDepempId = bizInfo.getOldDepempId();
        LOGGER.info("UpdateEffectDepempId4ChgRecordPlugin#performParserResult ===> begin, the oldDepempId us {}", (Object)oldDepempId);
        if (Objects.isNull(oldDepempId) || oldDepempId == 0L) {
            LOGGER.info("UpdateEffectDepempId4ChgRecordPlugin#performParserResult ===> end, the oldDepempId illegal, the data is empty or zero", (Object)oldDepempId);
            return;
        }
        DynamicObject oldDepempDy = sourceData.get("hrpi_depemp").stream().filter(dy -> dy.getLong("id") == oldDepempId.longValue()).findFirst().orElse(null);
        if (Objects.isNull(oldDepempDy)) {
            LOGGER.warn("UpdateEffectDepempId4ChgRecordPlugin#performParserResult ===> the oldDepempDys in the sourceData is empty");
            return;
        }
        String depempBusinessStatus = oldDepempDy.getString("businessstatus");
        if (HRStringUtils.equals((String)depempBusinessStatus, (String)"1") || HRStringUtils.equals((String)depempBusinessStatus, (String)"true")) {
            LOGGER.info("UpdateEffectDepempId4ChgRecordPlugin#performParserResult ===> current oldDepempDy is effect, the plugin execute end");
            return;
        }
        DynamicObject effectPrimaryDepemp = this.queryEffectPrimaryDepemp(bizInfo.getOldPersonId());
        if (Objects.isNull(effectPrimaryDepemp)) {
            LOGGER.info("UpdateEffectDepempId4ChgRecordPlugin#performParserResult ===> effectPrimaryDepemp is empty, the plugin execute end");
            return;
        }
        Map idsRecord = bizInfo.getIdsRecord();
        List depempRecords = (List)idsRecord.get("hrpi_depemp");
        if (Objects.nonNull(depempRecords)) {
            depempRecords.removeIf(dy -> Objects.nonNull(dy.getIdBefore()) && dy.getIdBefore().equals(bizInfo.getOldDepempId()));
            ChgRecordEntryDto depempRecord = depempRecords.stream().filter(dy -> Objects.nonNull(dy.getIdBefore()) && dy.getIdBefore().equals(effectPrimaryDepemp.getLong("boid"))).findFirst().orElse(null);
            if (Objects.isNull(depempRecord)) {
                depempRecords.add(this.createDepempRecord(effectPrimaryDepemp));
            }
            LOGGER.info("UpdateEffectDepempId4ChgRecordPlugin#performParserResult ===> update depempRecord success");
            return;
        }
        LOGGER.info("UpdateEffectDepempId4ChgRecordPlugin#performParserResult ===> depempRecords is empty");
        bizInfo.setIdsRecord("hrpi_depemp", this.createDepempRecord(effectPrimaryDepemp));
        LOGGER.info("UpdateEffectDepempId4ChgRecordPlugin#performParserResult ===> createNewDepempRecord success");
    }

    private DynamicObject queryEffectPrimaryDepemp(Long personId) {
        if (Objects.isNull(personId) || personId == 0L) {
            LOGGER.warn("UpdateEffectDepempId4ChgRecordPlugin#queryEffectPrimaryDepemp ===> queryEffectPrimaryDepemp result is null");
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_depemp");
        QFilter personQFilter = new QFilter("person_id", "=", (Object)personId);
        personQFilter.and(new QFilter("isprimary", "=", (Object)"1"));
        personQFilter.and(QFilterUtil.getCurrentQf());
        personQFilter.and(QFilterUtil.getDataStatusFilter());
        personQFilter.and(QFilterUtil.getStatusFilters());
        personQFilter.and(QFilterUtil.getInitStatusFinish());
        return serviceHelper.loadDynamicObject(personQFilter);
    }

    private ChgRecordEntryDto createDepempRecord(DynamicObject effectPrimaryDepemp) {
        return ChgRecordEntryDto.formatRecord((Long)effectPrimaryDepemp.getLong("boid"), (Long)effectPrimaryDepemp.getLong("sourcevid"), (Long)effectPrimaryDepemp.getLong("boid"), null, (String)ChgModeEnum.UNCHANGED.getChgMode(), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType());
    }
}

