/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.domain.repository.perchg.ChgActionRepository;
import kd.hr.hpfs.business.perchg.executor.enums.ChgRecordStatusEnum;
import kd.hr.hpfs.business.utils.ChgApiDataReturnUtils;
import kd.hr.hpfs.business.utils.PersonGenericUtil;

public class ChgActionService {
    private static final ChgActionService CHG_ACTION_SERVICE = new ChgActionService();
    private static final Log LOGGER = LogFactory.getLog(ChgActionService.class);
    private static String PARAM_KEY_SIGN = "sign";
    private static String PARAM_KEY_VALUES = "values";
    private static String PARAM_KEY_ISNEWCHGACTION = "isNewChgAction";
    private static List<String> PARAM_KEY_LIST = Arrays.asList(PARAM_KEY_SIGN, PARAM_KEY_VALUES, PARAM_KEY_ISNEWCHGACTION);

    public static ChgActionService getInstance() {
        return CHG_ACTION_SERVICE;
    }

    public Map<String, Object> getActionResByBill(String entityName) {
        try {
            List<Long> actionIds = this.getActionIdByBill(entityName);
            return ChgApiDataReturnUtils.formatDataReturned(Boolean.TRUE, null, actionIds);
        }
        catch (Exception e) {
            String errorInfo = String.format("ChgActionService getActionResByBill entityName : %s, error : %s", entityName, e.getMessage());
            LOGGER.error(errorInfo, (Throwable)e);
            return ChgApiDataReturnUtils.formatDataReturned(Boolean.FALSE, errorInfo, Collections.emptyList());
        }
    }

    public Map<String, Object> getActionResByBillNew(String entityName) {
        try {
            String errorInfo = String.format("ChgActionService getActionResByBillNew is empty entityName : %s", entityName);
            List<String> formIds = this.getFormIds(entityName);
            if (CollectionUtils.isEmpty(formIds)) {
                return ChgApiDataReturnUtils.formatDataReturned(Boolean.FALSE, errorInfo, Collections.emptyList());
            }
            DynamicObject[] dyns = new HRBaseServiceHelper("hpfs_chgguidebase").query("id, chgaction, billsource", new QFilter[]{new QFilter("billsource", "in", formIds), new QFilter("enable", "=", (Object)"1")});
            if (dyns == null || dyns.length == 0) {
                return ChgApiDataReturnUtils.formatDataReturned(Boolean.FALSE, errorInfo, Collections.emptyList());
            }
            List<Map<String, Object>> chgList = this.formatAction(dyns, formIds);
            return ChgApiDataReturnUtils.formatDataReturned(Boolean.TRUE, null, chgList);
        }
        catch (Exception e) {
            String errorInfo = String.format("ChgActionService getActionResByBillNew entityName : %s, error : %s", entityName, e.getMessage());
            LOGGER.error(errorInfo, (Throwable)e);
            return ChgApiDataReturnUtils.formatDataReturned(Boolean.FALSE, errorInfo, Collections.emptyList());
        }
    }

    private List<Map<String, Object>> formatAction(DynamicObject[] dyns, List<String> formIds) {
        Map<String, List<DynamicObject>> map = Arrays.stream(dyns).collect(Collectors.groupingBy(row -> row.getString("billsource.id")));
        ArrayList<Map<String, Object>> chgList = new ArrayList<Map<String, Object>>(dyns.length);
        for (String formId : formIds) {
            if (map.get(formId) == null) continue;
            List<DynamicObject> chgguideBases = map.get(formId);
            for (DynamicObject dy : chgguideBases) {
                DynamicObject chgDy = dy.getDynamicObject("chgaction");
                HashMap<String, Object> chgMap = new HashMap<String, Object>(4);
                chgMap.put("id", chgDy.getLong("id"));
                chgMap.put("number", chgDy.getString("number"));
                ILocaleString nameLocal = chgDy.getLocaleString("name");
                chgMap.put("name", nameLocal);
                chgList.add(chgMap);
            }
            return chgList;
        }
        return Collections.emptyList();
    }

    public Map<String, Object> getActionResByBillSourceExt(String entityName) {
        String fields = PersonGenericUtil.getAllProps("hpfs_chgaction", new HashSet<String>());
        return this.getActionResByBillSourceInfo(entityName, fields);
    }

    public Map<String, Object> getActionResByBillSource(String entityName) {
        String fields = "id,name,number";
        return this.getActionResByBillSourceInfo(entityName, fields);
    }

    public Map<String, Object> getActionResByBillSourceInfo(String entityName, String fields) {
        try {
            if (HRStringUtils.isEmpty((String)entityName)) {
                return ChgApiDataReturnUtils.formatDataReturned(Boolean.TRUE, null, Collections.emptyList());
            }
            DynamicObject[] dynamicObjects = ChgActionRepository.getInstance().queryActionByBill(fields, entityName);
            ArrayList<Map> retList = new ArrayList<Map>(10);
            for (DynamicObject dy : dynamicObjects) {
                Map map = HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)dy);
                retList.add(map);
            }
            return ChgApiDataReturnUtils.formatDataReturned(Boolean.TRUE, null, retList);
        }
        catch (Exception e) {
            String errorInfo = String.format("ChgActionService getActionResByBillSourceInfo entityName : %s, error : %s", entityName, e.getMessage());
            LOGGER.error(errorInfo, (Throwable)e);
            return ChgApiDataReturnUtils.formatDataReturned(Boolean.FALSE, errorInfo, Collections.emptyList());
        }
    }

    public Map<String, Object> getActionByName(String entityName, String name) {
        try {
            List<Long> actionIds = this.getActionIdByBill(entityName);
            DynamicObject dy = new HRBaseServiceHelper("hpfs_chgaction").queryOriginalOne("id", new QFilter[]{new QFilter("id", "in", actionIds), new QFilter("name", "=", (Object)name), new QFilter("enable", "=", (Object)"1")});
            return ChgApiDataReturnUtils.formatDataReturned(Boolean.TRUE, null, dy == null ? null : dy.get("id"));
        }
        catch (Exception e) {
            String errorInfo = String.format("ChgActionService getActionByName entityName : %s,name : %s, error : %s", entityName, name, e.getMessage());
            LOGGER.error(errorInfo, (Throwable)e);
            return ChgApiDataReturnUtils.formatDataReturned(Boolean.FALSE, errorInfo, Collections.emptyList());
        }
    }

    public List<Long> getActionIdByBill(String entityName) {
        List<String> formIds = this.getFormIds(entityName);
        DynamicObject[] dyns = new HRBaseServiceHelper("hpfs_chgguidebase").queryOriginalArray("id, chgaction, billsource", new QFilter[]{new QFilter("billsource", "in", formIds), new QFilter("enable", "=", (Object)"1")});
        List<Long> actionIds = new ArrayList<Long>(dyns == null ? 0 : dyns.length);
        if (dyns != null) {
            actionIds = this.formatActionId(dyns, formIds);
        }
        return actionIds;
    }

    private List<String> getFormIds(String entityName) {
        DynamicObject dyn = new HRBaseServiceHelper("bos_formmeta").queryOne("inheritpath", new QFilter[]{new QFilter("number", "=", (Object)entityName)});
        String inheritPath = dyn.getString("inheritpath");
        if (HRStringUtils.isEmpty((String)inheritPath)) {
            return Collections.singletonList(entityName);
        }
        String[] inheritPathArr = inheritPath.split(",");
        DynamicObject[] dyns = new HRBaseServiceHelper("bos_formmeta").query("number,id", new QFilter[]{new QFilter("id", "in", Arrays.asList(inheritPathArr))});
        Map<String, String> map = Arrays.stream(dyns).collect(Collectors.toMap(row -> row.getString("id"), row -> row.getString("number")));
        return Arrays.stream(inheritPathArr).map(map::get).sorted((pre, next) -> HRStringUtils.equals((String)pre, (String)next) ? 0 : -1).collect(Collectors.toCollection(() -> Stream.of(entityName).collect(Collectors.toList())));
    }

    public Map<String, Object> isSuccessBill(Map<String, Object> params) {
        try {
            LOGGER.info("ChgActionService#isSuccessBill,{}", params);
            Long billId = HRJSONUtils.getLongValOfCustomParam((Object)params.get("billId"));
            Long actionId = HRJSONUtils.getLongValOfCustomParam((Object)params.get("actionId"));
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hpfs_chgrecord");
            QFilter billIdFilter = new QFilter("bill", "=", (Object)billId);
            QFilter actionFilter = new QFilter("chgaction", "=", (Object)actionId);
            QFilter transactionStatusFilter = new QFilter("datastatus", "=", (Object)ChgRecordStatusEnum.CHANGED.getCode());
            DynamicObject dy = helper.queryOne("id,bill,billsource,event", new QFilter[]{billIdFilter, transactionStatusFilter, actionFilter});
            boolean isSuccessBill = !Objects.isNull(dy);
            return ChgApiDataReturnUtils.formatDataReturned(Boolean.TRUE, null, isSuccessBill);
        }
        catch (Exception e) {
            LOGGER.error("ChgActionService#isSuccessBill fail,", (Throwable)e);
            return ChgApiDataReturnUtils.formatDataReturned(Boolean.FALSE, "query fail", null);
        }
    }

    private List<Long> formatActionId(DynamicObject[] dyns, List<String> formIds) {
        Map<String, List<DynamicObject>> map = Arrays.stream(dyns).collect(Collectors.groupingBy(row -> row.getString("billsource")));
        for (String formId : formIds) {
            if (map.get(formId) == null) continue;
            return map.get(formId).stream().map(row -> row.getLong("chgaction")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Map<String, Object> getChgActionByNumberOrName(Map<String, Object> requestMap) {
        try {
            HashMap<String, DynamicObject> data = new HashMap<String, DynamicObject>();
            String errorMsg = this.validateRequestMap(requestMap);
            if (!HRStringUtils.equals((String)"", (String)errorMsg)) {
                return ChgApiDataReturnUtils.formatDataReturned(Boolean.FALSE, errorMsg, null);
            }
            String sign = (String)requestMap.get(PARAM_KEY_SIGN);
            HashSet values = (HashSet)requestMap.get(PARAM_KEY_VALUES);
            boolean isNewChgAction = (Boolean)requestMap.get(PARAM_KEY_ISNEWCHGACTION);
            QFilter signQFilter = new QFilter(sign, "in", (Object)values);
            QFilter isnewchgactionQFilter = new QFilter("isnewchgaction", "=", (Object)isNewChgAction);
            QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
            Object[] dyns = new HRBaseServiceHelper("hpfs_chgaction").loadDynamicObjectArray(new QFilter[]{signQFilter, isnewchgactionQFilter, enableQFilter});
            if (HRArrayUtils.isNotEmpty((Object[])dyns)) {
                data.putAll(Arrays.asList(dyns).stream().collect(Collectors.toMap(dy -> dy.getString(sign), dy -> dy, (dy1, dy2) -> dy1)));
            }
            return ChgApiDataReturnUtils.formatDataReturned(Boolean.TRUE, null, data);
        }
        catch (Exception ex) {
            LOGGER.error("ChgActionService#getChgActionByNumberOrName error {}");
            return ChgApiDataReturnUtils.formatDataReturned(Boolean.FALSE, "request exception", null);
        }
    }

    private String validateRequestMap(Map<String, Object> requestMap) {
        for (String paramKey : PARAM_KEY_LIST) {
            Object param = requestMap.get(paramKey);
            if (!Objects.isNull(param)) continue;
            return String.format("request parameter %s cannot be empty", paramKey);
        }
        String sign = (String)requestMap.get(PARAM_KEY_SIGN);
        if (!HRStringUtils.equals((String)"number", (String)sign) && !HRStringUtils.equals((String)"name", (String)sign)) {
            return "request param sign only be 'number' or 'name'";
        }
        if (!(requestMap.get(PARAM_KEY_VALUES) instanceof HashSet)) {
            return "request param values only be HashSet class type";
        }
        if (CollectionUtils.isEmpty((Collection)((HashSet)requestMap.get(PARAM_KEY_VALUES)))) {
            return "request param values is empty";
        }
        if (!(requestMap.get(PARAM_KEY_ISNEWCHGACTION) instanceof Boolean)) {
            return "request param isNewChgAction only be Boolean class type";
        }
        return "";
    }

    public Map<String, Object> getNewChgRuleByActionIds(List<Long> actionIds) {
        if (actionIds == null || actionIds.isEmpty()) {
            String errorMsg = ResManager.loadKDString((String)"\u53d8\u52a8\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChgRuleService_0", (String)"hr-hpfs-business", (Object[])new Object[0]);
            return ChgApiDataReturnUtils.formatDataReturned(Boolean.FALSE, errorMsg, null);
        }
        DynamicObject[] chgActionDyArr = new HRBaseServiceHelper("hpfs_chgaction").query("id,mulbillsource,mulpersonlaborreltype,mulpersonlaborrelstatus,mulemplaborreltype,mulemplaborrelstatus", new QFilter[]{new QFilter("id", "in", actionIds), new QFilter("isnewchgaction", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1")});
        if (chgActionDyArr == null || chgActionDyArr.length == 0) {
            return ChgApiDataReturnUtils.formatDataReturned(Boolean.TRUE, "", null);
        }
        Map<Long, Map> chgActionDyMap = Arrays.stream(chgActionDyArr).collect(Collectors.toMap(chgActionDy -> chgActionDy.getLong("id"), chgActionDy -> {
            HashMap<String, DynamicObjectCollection> valueMap = new HashMap<String, DynamicObjectCollection>(16);
            valueMap.put("billsource", this.getCollect((DynamicObject)chgActionDy, "mulbillsource", false));
            valueMap.put("personlaborreltype", this.getCollect((DynamicObject)chgActionDy, "mulpersonlaborreltype", true));
            valueMap.put("personlaborrelstatus", this.getCollect((DynamicObject)chgActionDy, "mulpersonlaborrelstatus", true));
            valueMap.put("laborreltype", this.getCollect((DynamicObject)chgActionDy, "mulemplaborreltype", true));
            valueMap.put("laborrelstatus", this.getCollect((DynamicObject)chgActionDy, "mulemplaborrelstatus", true));
            return valueMap;
        }));
        return ChgApiDataReturnUtils.formatDataReturned(Boolean.TRUE, "", chgActionDyMap);
    }

    private DynamicObjectCollection getCollect(DynamicObject chgActionDy, String mulDyField, boolean checkEnable) {
        DynamicObjectCollection mulDyCollection = chgActionDy.getDynamicObjectCollection(mulDyField);
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        if (HRCollUtil.isEmpty((Collection)mulDyCollection)) {
            return dynamicObjectCollection;
        }
        LOGGER.info("mulDyField: {}, size: {}", (Object)mulDyField, (Object)mulDyCollection.size());
        for (DynamicObject mulDy : mulDyCollection) {
            DynamicObject basedataDy = mulDy.getDynamicObject("fbasedataid");
            if (Objects.nonNull(basedataDy)) {
                if (checkEnable) {
                    DataEntityPropertyCollection properties;
                    IDataEntityType dataEntityType = basedataDy.getDataEntityType();
                    DataEntityPropertyCollection dataEntityPropertyCollection = properties = dataEntityType == null ? null : dataEntityType.getProperties();
                    if (null != properties) {
                        if (properties.containsKey((Object)"status") && !HRStringUtils.equalsIgnoreCase((String)"C", (String)basedataDy.getString("status"))) {
                            LOGGER.info("data is invalid {}", (Object)basedataDy);
                            continue;
                        }
                        if (properties.containsKey((Object)"enable") && !HRStringUtils.equals((String)"1", (String)basedataDy.getString("enable"))) {
                            LOGGER.info("data is disable {}", (Object)basedataDy);
                            continue;
                        }
                    }
                }
                dynamicObjectCollection.add((Object)basedataDy);
                continue;
            }
            Object basedataid = mulDy.get("fbasedataid_id");
            LOGGER.info("mulDyField: {}, basedataDy is null, basedataid:{}", (Object)mulDyField, basedataid);
        }
        return dynamicObjectCollection;
    }
}

