/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.config.chgaction.ChgConfigQueryService;
import kd.hrmp.hrpi.business.domian.service.reentry.impl.ReEntryServiceImpl;

public class ChgDataProviderService {
    private static final ChgDataProviderService CHG_DATA_PROVIDER_SERVICE = new ChgDataProviderService();
    private static final Log LOGGER = LogFactory.getLog(ChgDataProviderService.class);

    public static ChgDataProviderService getInstance() {
        return CHG_DATA_PROVIDER_SERVICE;
    }

    public Map<String, List<DynamicObject>> getHCFInfoForReOnboardByRequestMap(Map<String, Object> requestMap) {
        LOGGER.info("ChgDataProviderService#getHCFInfoForReOnboard reuqestMap is {}", (Object)JSONObject.toJSONString(requestMap));
        Long employeeId = (Long)requestMap.get("employeeId");
        Long chgActionId = (Long)requestMap.get("chgActionId");
        return this.getHCFInfoForReOnboardByEmployeeIdAndChgactionId(employeeId, chgActionId);
    }

    public Map<String, List<DynamicObject>> getHCFInfoForReOnboard(Long employeeId) {
        LOGGER.info("ChgDataProviderService#getHCFInfoForReOnboard employeeId is {}", (Object)employeeId);
        Long chgActionId = this.getLatestOnBoardChgActionIdByEmployeeId(employeeId);
        return this.getHCFInfoForReOnboardByEmployeeIdAndChgactionId(employeeId, chgActionId);
    }

    private Map<String, List<DynamicObject>> getHCFInfoForReOnboardByEmployeeIdAndChgactionId(Long employeeId, Long chgActionId) {
        if (null == chgActionId || chgActionId == 0L || null == employeeId || employeeId == 0L) {
            return new HashMap<String, List<DynamicObject>>();
        }
        Map<Long, DynamicObject> chgRuleMap = ChgConfigQueryService.getInstance().getChgRule(Collections.singletonList(chgActionId));
        DynamicObject chgRuleInfo = chgRuleMap.get(chgActionId);
        if (chgRuleInfo == null) {
            return new HashMap<String, List<DynamicObject>>();
        }
        HashSet<String> targetNumberSet = new HashSet<String>();
        HashMap<String, Set<String>> entityNumberMap = new HashMap<String, Set<String>>();
        HashMap<String, Map<String, Map<String, String>>> entityNumberFieldMap = new HashMap<String, Map<String, Map<String, String>>>();
        this.mappingHandle(chgRuleInfo, targetNumberSet, entityNumberMap, entityNumberFieldMap);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("employeeid:" + employeeId + ",targetNumberSet:" + targetNumberSet);
        }
        Map hrpiMap = new ReEntryServiceImpl().queryPersonDataByEmployeeId(employeeId, new ArrayList<String>(targetNumberSet));
        Map<String, List<DynamicObject>> result = this.assembleTargetDateByMappingAndHRPIMap(hrpiMap, entityNumberMap, entityNumberFieldMap);
        return result;
    }

    private Long getLatestOnBoardChgActionIdByEmployeeId(Long employeeId) {
        HRBaseServiceHelper chgRecordHelper = new HRBaseServiceHelper("hpfs_chgrecord");
        QFilter filter = new QFilter("entryentity.chgentity", "=", (Object)"hrpi_employee");
        QFilter filter2 = new QFilter("entryentity.idafter", "=", (Object)employeeId);
        QFilter filter4 = new QFilter("chgcategory.chgevent", "=", (Object)1010L);
        DynamicObject chgRecord = chgRecordHelper.queryOne("chgaction", new QFilter[]{filter, filter2, filter4}, "effecttime desc");
        if (chgRecord == null) {
            return null;
        }
        Long chgActionId = chgRecord.getDynamicObject("chgaction").getLong("id");
        return chgActionId;
    }

    private void mappingHandle(DynamicObject chgRuleInfo, Set<String> targetNumberSet, Map<String, Set<String>> entityNumberMap, Map<String, Map<String, Map<String, String>>> entityNumberFieldMap) {
        DynamicObjectCollection ruleConfigs = chgRuleInfo.getDynamicObjectCollection("customentryentity");
        Map<DynamicObject, List<DynamicObject>> ruleConfigMap = ruleConfigs.stream().collect(Collectors.groupingBy(row -> row.getDynamicObject("chgtactic")));
        ArrayList<DynamicObject> tactics = new ArrayList<DynamicObject>(ruleConfigMap.keySet());
        tactics.forEach(tactic -> {
            DynamicObject chgObject;
            HashSet<String> targetEntityNumberSet;
            List configList = (List)ruleConfigMap.get(tactic);
            DynamicObject mappingPlan = null;
            Optional<DynamicObject> mappingConfig = configList.stream().filter(dy -> !Objects.isNull(dy.getDynamicObject("filemapping"))).findFirst();
            if (mappingConfig.isPresent()) {
                mappingPlan = mappingConfig.get().getDynamicObject("filemapping");
                DynamicObjectCollection mappingTable = mappingPlan.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : mappingTable) {
                    HashMap<String, String> fieldMap;
                    String sourceEntityNumber = dynamicObject.getDynamicObject("sourceentity").getString("number");
                    String targetEntityNumber = dynamicObject.getDynamicObject("targetentity").getString("number");
                    targetNumberSet.add(targetEntityNumber);
                    targetEntityNumberSet = (Set)entityNumberMap.get(sourceEntityNumber);
                    if (targetEntityNumberSet == null) {
                        targetEntityNumberSet = new HashSet();
                    }
                    targetEntityNumberSet.add(targetEntityNumber);
                    entityNumberMap.put(sourceEntityNumber, targetEntityNumberSet);
                    DynamicObjectCollection fieldmapping = dynamicObject.getDynamicObjectCollection("subentryentity");
                    HashMap targetEntityNumberMap = (HashMap)entityNumberFieldMap.get(sourceEntityNumber);
                    if (targetEntityNumberMap == null) {
                        targetEntityNumberMap = new HashMap();
                    }
                    if ((fieldMap = (HashMap<String, String>)targetEntityNumberMap.get(targetEntityNumber)) == null) {
                        fieldMap = new HashMap<String, String>();
                    }
                    for (DynamicObject field : fieldmapping) {
                        String sourceField = field.getString("sourcefield");
                        String targetField = field.getString("targetfield");
                        fieldMap.put(sourceField, targetField);
                    }
                    entityNumberFieldMap.put(sourceEntityNumber, targetEntityNumberMap);
                    targetEntityNumberMap.put(targetEntityNumber, fieldMap);
                }
            }
            if ((chgObject = tactic.getDynamicObject("chgobject")) != null) {
                String targetEntityNumber = chgObject.getString("number");
                targetNumberSet.add(targetEntityNumber);
                for (DynamicObject dynamicObject : configList) {
                    HashMap<String, String> fieldMap;
                    String sourceEntityNumber = dynamicObject.getString("entitysource");
                    if (!HRStringUtils.isNotEmpty((String)sourceEntityNumber)) continue;
                    targetEntityNumberSet = (HashSet<String>)entityNumberMap.get(sourceEntityNumber);
                    if (targetEntityNumberSet == null) {
                        targetEntityNumberSet = new HashSet<String>();
                    }
                    targetEntityNumberSet.add(targetEntityNumber);
                    entityNumberMap.put(sourceEntityNumber, targetEntityNumberSet);
                    HashMap<String, HashMap<String, String>> targetEntityNumberMap = (HashMap<String, HashMap<String, String>>)entityNumberFieldMap.get(sourceEntityNumber);
                    if (targetEntityNumberMap == null) {
                        targetEntityNumberMap = new HashMap<String, HashMap<String, String>>();
                    }
                    if ((fieldMap = (HashMap<String, String>)targetEntityNumberMap.get(targetEntityNumber)) == null) {
                        fieldMap = new HashMap<String, String>();
                    }
                    fieldMap.put(dynamicObject.getString("fieldsource"), dynamicObject.getString("chgfile"));
                    entityNumberFieldMap.put(sourceEntityNumber, targetEntityNumberMap);
                    targetEntityNumberMap.put(targetEntityNumber, fieldMap);
                }
            }
        });
    }

    private Map<String, List<DynamicObject>> assembleTargetDateByMappingAndHRPIMap(Map<String, List<DynamicObject>> hrpiMap, Map<String, Set<String>> entityNumberMap, Map<String, Map<String, Map<String, String>>> entityNumberFieldMap) {
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>(32);
        for (Map.Entry<String, Set<String>> entityNumberEntry : entityNumberMap.entrySet()) {
            String hcfEntityNumber = entityNumberEntry.getKey();
            Set<String> hrpiEntityNumbers = entityNumberEntry.getValue();
            ArrayList<DynamicObject> hcfDyns = new ArrayList<DynamicObject>();
            DynamicObject hcfDynFirst = HRBaseServiceHelper.create((String)hcfEntityNumber).generateEmptyDynamicObject();
            hcfDyns.add(hcfDynFirst);
            boolean flag = true;
            for (String hrpiEntityNumber : hrpiEntityNumbers) {
                List<DynamicObject> hrpiDyns = hrpiMap.get(hrpiEntityNumber);
                if (hrpiDyns != null && hrpiDyns.size() == 1) {
                    DynamicObject hrpiDyn = hrpiDyns.get(0);
                    Map<String, Map<String, String>> hrpiEntityNumberMap = entityNumberFieldMap.get(hcfEntityNumber);
                    Map<String, String> fieldMap = hrpiEntityNumberMap.get(hrpiEntityNumber);
                    for (Map.Entry<String, String> fieldEntry : fieldMap.entrySet()) {
                        String hcfField = fieldEntry.getKey();
                        String hrpiField = fieldEntry.getValue();
                        for (DynamicObject hcfDyn : hcfDyns) {
                            this.setProp(hcfDyn, hcfField, hrpiDyn, hrpiField, hcfEntityNumber, hrpiEntityNumber);
                        }
                    }
                    flag = false;
                    continue;
                }
                if (hrpiDyns != null && hrpiDyns.size() > 1 && hcfDyns.size() == 1) {
                    for (int i = 0; i < hrpiDyns.size(); ++i) {
                        if (i > 0) {
                            DynamicObject hcfDyn = HRBaseServiceHelper.create((String)hcfEntityNumber).generateEmptyDynamicObject();
                            HRDynamicObjectUtils.copy((DynamicObject)((DynamicObject)hcfDyns.get(0)), (DynamicObject)hcfDyn);
                            hcfDyns.add(hcfDyn);
                        }
                        DynamicObject hrpiDyn = hrpiDyns.get(i);
                        DynamicObject hcfDyn = (DynamicObject)hcfDyns.get(i);
                        Map<String, Map<String, String>> hrpiEntityNumberMap = entityNumberFieldMap.get(hcfEntityNumber);
                        Map<String, String> fieldMap = hrpiEntityNumberMap.get(hrpiEntityNumber);
                        for (Map.Entry<String, String> fieldEntry : fieldMap.entrySet()) {
                            String hcfField = fieldEntry.getKey();
                            String hrpiField = fieldEntry.getValue();
                            this.setProp(hcfDyn, hcfField, hrpiDyn, hrpiField, hcfEntityNumber, hrpiEntityNumber);
                        }
                    }
                    flag = false;
                    continue;
                }
                if (hrpiDyns != null && hrpiDyns.size() > 1 && hcfDyns.size() > 1) {
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.warn("not handle, hcfEntityNumber:" + hcfEntityNumber + ", hrpiEntityNumber" + hrpiEntityNumber);
                    continue;
                }
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("not handle, hcfEntityNumber:" + hcfEntityNumber + ", hrpiEntityNumber" + hrpiEntityNumber);
            }
            if (flag) {
                hcfDyns = new ArrayList();
            }
            result.put(hcfEntityNumber, hcfDyns);
        }
        return result;
    }

    private void setProp(DynamicObject hcfDyn, String hcfField, DynamicObject hrpiDyn, String hrpiField, String hcfEntityNumber, String hrpiEntityNumber) {
        try {
            hcfDyn.set(hcfField, hrpiDyn.get(hrpiField));
        }
        catch (Exception e) {
            LOGGER.error("hcfDyn,hcfField --> hrpiDyn,hrpiField  error:" + hcfEntityNumber + "," + hcfField + "-->" + hrpiEntityNumber + "," + hrpiField);
            LOGGER.error((Throwable)e);
        }
    }
}

