/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.domain.repository.RepositoryUtils;
import kd.hr.hpfs.business.domain.repository.hrpi.CmpEmpRepository;
import kd.hr.hpfs.business.domain.repository.hrpi.DepEmpRepository;
import kd.hr.hpfs.business.perchg.executor.enums.ChgRecordStatusEnum;
import kd.hr.hpfs.business.perchg.parser.util.ParserUtil;
import kd.hr.hpfs.business.utils.ChgApiDataReturnUtils;
import kd.hr.hpfs.common.constants.PerModelConstants;
import kd.hr.hpfs.common.enums.ChgSign2EntityNumberEnum;
import kd.hr.hpfs.common.enums.FlowTypeEnum;
import kd.hr.hpfs.common.model.ChgRecordQueryModel;
import kd.hr.hpfs.common.model.ResponseResult;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgFlowTypeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.model.ChgRecordEntryDto;

public class ChgRecordService {
    private static final ChgRecordService CHG_RECORD_SERVICE = new ChgRecordService();
    private static final HRBaseServiceHelper CHG_RECORD_HELPER = new HRBaseServiceHelper("hpfs_chgrecord");
    private static final HRBaseServiceHelper CHG_RECORD_ENTRY_HELPER = new HRBaseServiceHelper("hpfs_chgrecordentry");
    private static final HRBaseServiceHelper HRPI_EMPPOSORGREL_HELPER = new HRBaseServiceHelper("hrpi_empposorgrel");
    private static final HRBaseServiceHelper HRPI_DEPEMP_HELPER = new HRBaseServiceHelper("hrpi_depemp");
    private static final Log LOGGER = LogFactory.getLog(ChgRecordService.class);

    public static ChgRecordService getInstance() {
        return CHG_RECORD_SERVICE;
    }

    public Map<String, Object> getChgInfoByRecordId(Long recordId) {
        try {
            DynamicObject chgRecord = CHG_RECORD_HELPER.loadDynamicObject(new QFilter("id", "=", (Object)recordId));
            String errorMsg = this.validate(chgRecord);
            if (!StringUtils.isEmpty((Object)errorMsg)) {
                return ChgApiDataReturnUtils.formatDataReturned(false, errorMsg, new HashMap(0));
            }
            Map<String, Object> res = this.formatResult(chgRecord, false);
            return ChgApiDataReturnUtils.formatDataReturned(true, null, res);
        }
        catch (Exception e) {
            LOGGER.error("CHG_HPFS_ERROR getChgInfoByRecordId recordId:{}", (Object)recordId, (Object)e);
            String errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e8b\u52a1\u53d8\u52a8\u5185\u90e8\u9519\u8bef\u3002%s", (String)"ChgRecordService_0", (String)"hr-hpfs-business", (Object[])new Object[0]), e.getMessage());
            return ChgApiDataReturnUtils.formatDataReturned(false, errMsg, new HashMap(0));
        }
    }

    public Map<String, Object> getChgInfoDetailByRecordId(Long recordId) {
        try {
            DynamicObject chgRecord = CHG_RECORD_HELPER.loadDynamicObject(new QFilter("id", "=", (Object)recordId));
            String errorMsg = this.validate(chgRecord);
            if (!StringUtils.isEmpty((Object)errorMsg)) {
                return ChgApiDataReturnUtils.formatDataReturned(false, errorMsg, new HashMap(0));
            }
            Map<String, Object> res = this.formatResult(chgRecord, true);
            return ChgApiDataReturnUtils.formatDataReturned(true, null, res);
        }
        catch (Exception e) {
            LOGGER.error("CHG_HPFS_ERROR getChgInfoDetailByRecordId recordId:{}", (Object)recordId, (Object)e);
            String errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e8b\u52a1\u53d8\u52a8\u5185\u90e8\u9519\u8bef\u3002%s", (String)"ChgRecordService_0", (String)"hr-hpfs-business", (Object[])new Object[0]), e.getMessage());
            return ChgApiDataReturnUtils.formatDataReturned(false, errMsg, new HashMap(0));
        }
    }

    private String validate(DynamicObject chgRecord) {
        String errorMsg = "";
        if (chgRecord == null) {
            errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u53d8\u52a8\u8bb0\u5f55\u4e0d\u5b58\u5728\u3002", (String)"ChgRecordService_1", (String)"hr-hpfs-business", (Object[])new Object[0]), errorMsg);
        }
        return errorMsg;
    }

    private Map<String, Object> formatResult(DynamicObject chgRecord, boolean isDetail) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        this.formatRecordAndBillInfo(map, chgRecord);
        DynamicObjectCollection collection = chgRecord.getDynamicObjectCollection("entryentity");
        map.put("data", isDetail ? this.formatDetail(collection) : this.formatId(collection));
        if (!isDetail) {
            this.completePersonAndEmployee(collection, map);
        }
        return map;
    }

    private void completePersonAndEmployee(DynamicObjectCollection collection, Map<String, Object> map) {
        List list = (List)map.get("data");
        if (list != null && list.size() == 1) {
            this.formatUniqueMap(collection, "hrpi_person", list);
            this.formatUniqueMap(collection, "hrpi_employee", list);
        } else if (list != null && list.size() > 1) {
            this.addPersonAndEmployee(collection, list);
        }
        map.put("data", list);
    }

    private void formatUniqueMap(DynamicObjectCollection collection, String entityName, List<Map<String, Map<String, Object>>> list) {
        long vid;
        long boid;
        List collect = collection.stream().filter(row -> HRStringUtils.equals((String)entityName, (String)row.getString("chgentity.number"))).collect(Collectors.toList());
        if (null == collect || collect.size() == 0) {
            return;
        }
        DynamicObject personDyn = collect.size() == 1 ? (DynamicObject)collect.get(0) : collect.stream().filter(row -> HRStringUtils.isNotEmpty((String)row.getString("chgmode"))).sorted((row1, row2) -> row1.getString("chgmode").compareTo(row2.getString("chgmode"))).findFirst().get();
        String chgMode = personDyn.getString("chgmode");
        if (HRStringUtils.equals((String)chgMode, (String)ChgModeEnum.ADD_NEW.getChgMode())) {
            boid = personDyn.getLong("idafter");
            vid = personDyn.getLong("vidafter");
        } else {
            boid = personDyn.getLong("idbefore");
            vid = personDyn.getLong("vidbefore");
        }
        Map<String, Object> res = this.formatBoidVid(boid, vid, chgMode, "");
        list.forEach(row -> row.put(entityName, res));
    }

    private void addPersonAndEmployee(DynamicObjectCollection collection, List<Map<String, Map<String, Object>>> list) {
        HashMap<Long, DynamicObject> personEmployeeIdEntryMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject chgRecordEntry : collection) {
            if (!HRStringUtils.equals((String)"hrpi_employee", (String)chgRecordEntry.getString("chgentity.number")) && !HRStringUtils.equals((String)"hrpi_person", (String)chgRecordEntry.getString("chgentity.number"))) continue;
            personEmployeeIdEntryMap.put(chgRecordEntry.getLong("idafter"), chgRecordEntry);
        }
        list.forEach(row -> {
            DynamicObject depemp;
            Long boid;
            Map depEmpMap = (Map)row.get("hrpi_depemp");
            if (depEmpMap != null && depEmpMap.size() > 0 && (boid = (Long)depEmpMap.get("boid")) != null && boid != 0L && (depemp = HRPI_DEPEMP_HELPER.queryOne("person,employee", (Object)boid)) != null) {
                long personId = depemp.getLong("person.id");
                long employeeId = depemp.getLong("employee.id");
                this.buildResData(personId, (Map<Long, DynamicObject>)personEmployeeIdEntryMap, (Map<String, Map<String, Object>>)row, collection, "hrpi_person");
                this.buildResData(employeeId, (Map<Long, DynamicObject>)personEmployeeIdEntryMap, (Map<String, Map<String, Object>>)row, collection, "hrpi_employee");
            }
        });
    }

    private void buildResData(Long id, Map<Long, DynamicObject> personEmployeeIdEntryMap, Map<String, Map<String, Object>> row, DynamicObjectCollection collection, String entityName) {
        DynamicObject chgRecordEntry = personEmployeeIdEntryMap.get(id);
        if (chgRecordEntry != null) {
            Map<String, Object> res = this.buildEntryData(chgRecordEntry);
            row.put(entityName, res);
        } else {
            DynamicObject personDyn = collection.stream().filter(row1 -> HRStringUtils.equals((String)entityName, (String)row1.getString("chgentity.number"))).findAny().orElse(null);
            if (personDyn != null) {
                Map<String, Object> res = this.buildEntryData(personDyn);
                row.put(entityName, res);
            }
        }
    }

    private Map<String, Object> buildEntryData(DynamicObject chgRecordEntry) {
        long vid;
        long boid;
        String chgMode = chgRecordEntry.getString("chgmode");
        if (HRStringUtils.equals((String)chgMode, (String)ChgModeEnum.ADD_NEW.getChgMode())) {
            boid = chgRecordEntry.getLong("idafter");
            vid = chgRecordEntry.getLong("vidafter");
        } else {
            boid = chgRecordEntry.getLong("idbefore");
            vid = chgRecordEntry.getLong("vidbefore");
        }
        Map<String, Object> res = this.formatBoidVid(boid, vid, chgMode, "");
        return res;
    }

    private void formatRecordAndBillInfo(Map<String, Object> map, DynamicObject chgRecord) {
        map.put("chgCategoryId", chgRecord.getLong("chgcategory.id"));
        map.put("chgActionId", chgRecord.getLong("chgaction.id"));
        map.put("chgRuleId", chgRecord.getLong("chgrule.id"));
        map.put("effectTime", chgRecord.getDate("effecttime").getTime());
        map.put("datastatus", chgRecord.getString("datastatus"));
        map.put("eventEntity", chgRecord.getString("evententity.number"));
        map.put("eventId", chgRecord.getLong("event"));
        map.put("billId", chgRecord.getLong("bill"));
        map.put("billNo", chgRecord.getString("billno"));
        map.put("billSource", chgRecord.getString("billsource.number"));
    }

    private List<Map<String, Object>> formatDetail(DynamicObjectCollection collection) {
        List<String> entryFields = Arrays.asList("chgmode", "idbefore", "idafter", "vidbefore", "vidafter", "flowtype");
        return collection.stream().map(dyn -> {
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("entity", dyn.getString("chgentity.number"));
            entryFields.forEach(entryField -> map.put((String)entryField, (String)dyn.get(entryField)));
            return map;
        }).collect(Collectors.toList());
    }

    private List<Map<String, Map<String, Object>>> formatId(DynamicObjectCollection collection) {
        ArrayList<Map<String, Map<String, Object>>> idList = new ArrayList<Map<String, Map<String, Object>>>(10);
        List<String> entityList = Arrays.asList("hrpi_cmpemp", "hrpi_depemp");
        Map<String, List<DynamicObject>> mapOrigin = collection.stream().filter(row -> HRStringUtils.equals((String)row.getString("chgmode"), (String)ChgModeEnum.UNCHANGED.getChgMode()) && entityList.contains(row.getString("chgentity.number"))).collect(Collectors.groupingBy(row -> row.getString("chgentity.number")));
        Arrays.stream(ChgModeEnum.values()).forEach(chgModeEnum -> this.formatChangeMap(collection, entityList, mapOrigin, chgModeEnum.getChgMode(), idList));
        return idList;
    }

    private Map<String, Map<String, Object>> formatUnchangedList(Map<String, List<DynamicObject>> mapOrigin) {
        HashMap<String, Map<String, Object>> res = new HashMap<String, Map<String, Object>>(8);
        Arrays.stream(PerModelConstants.PERSON_MODEL_PAGES).forEach(row -> {
            if (mapOrigin.get(row) != null) {
                DynamicObject dyn = (DynamicObject)((List)mapOrigin.get(row)).get(0);
                String flowType = this.getFlowType(dyn, (String)row);
                res.put((String)row, this.formatBoidVid(dyn.getLong("idbefore"), dyn.getLong("vidbefore"), ChgModeEnum.UNCHANGED.getChgMode(), flowType));
            }
        });
        return res;
    }

    private void formatChangeMap(DynamicObjectCollection collection, List<String> entityList, Map<String, List<DynamicObject>> mapOrigin, String chgMode, List<Map<String, Map<String, Object>>> idList) {
        Map<String, List<DynamicObject>> map2change = collection.stream().filter(row -> HRStringUtils.equals((String)row.getString("chgmode"), (String)chgMode) && entityList.contains(row.getString("chgentity.number"))).collect(Collectors.groupingBy(row -> row.getString("chgentity.number")));
        if (map2change.isEmpty() || map2change.get("hrpi_depemp") == null) {
            return;
        }
        idList.addAll(this.formatChangeList(map2change, mapOrigin, chgMode));
    }

    private List<Map<String, Map<String, Object>>> formatChangeList(Map<String, List<DynamicObject>> map2Change, Map<String, List<DynamicObject>> mapUnchanged, String chgMode) {
        List<DynamicObject> orgPersons = map2Change.get("hrpi_depemp");
        ArrayList<Map<String, Map<String, Object>>> idList = new ArrayList<Map<String, Map<String, Object>>>(10);
        if (orgPersons == null || orgPersons.size() == 1) {
            idList.add(this.formatSingleOrg(map2Change, mapUnchanged, chgMode));
        } else {
            this.formatMultipleOrg(orgPersons, map2Change, mapUnchanged, idList, chgMode);
        }
        return idList;
    }

    private Map<String, Map<String, Object>> formatSingleOrg(Map<String, List<DynamicObject>> map2Change, Map<String, List<DynamicObject>> mapUnchanged, String chgMode) {
        HashMap<String, Map<String, Object>> res = new HashMap<String, Map<String, Object>>(8);
        Arrays.stream(PerModelConstants.PERSON_MODEL_PAGES).forEach(row -> {
            if (map2Change.get(row) != null) {
                DynamicObject dyn = (DynamicObject)((List)map2Change.get(row)).get(0);
                String flowType = this.getFlowType(dyn, (String)row);
                long boid = dyn.getLong("idafter") == 0L ? dyn.getLong("idbefore") : dyn.getLong("idafter");
                long vid = dyn.getLong("vidafter") == 0L ? dyn.getLong("vidbefore") : dyn.getLong("vidafter");
                res.put((String)row, this.formatBoidVid(boid, vid, chgMode, flowType));
            } else {
                if (mapUnchanged.get(row) == null) {
                    LOGGER.warn(String.format("CHG_HPFS_WARN formatSingleOrg , both change & unChange are null, chgMode:%s,  entityName:%s", chgMode, row));
                    return;
                }
                DynamicObject dyn = (DynamicObject)((List)mapUnchanged.get(row)).get(0);
                String flowType = this.getFlowType(dyn, (String)row);
                res.put((String)row, this.formatBoidVid(dyn.getLong("idbefore"), dyn.getLong("vidbefore"), ChgModeEnum.UNCHANGED.getChgMode(), flowType));
            }
        });
        if (res.get("hrpi_cmpemp") != null) {
            return res;
        }
        this.completeCmpEmp(res);
        return res;
    }

    private void completeCmpEmp(Map<String, Map<String, Object>> res) {
        String selectField = "id, boid, cmpemp";
        long depEmpId = res.get("hrpi_depemp") == null ? 0L : (Long)res.get("hrpi_depemp").get("boid");
        QFilter boIdFilter = new QFilter("boid", "=", (Object)depEmpId);
        DynamicObject depEmpDyn = DepEmpRepository.getInstance().queryOne(selectField, new QFilter[]{boIdFilter, RepositoryUtils.isCurrentVersion()});
        if (depEmpDyn == null) {
            return;
        }
        long cmpEmpId = depEmpDyn.getLong("cmpemp.id");
        QFilter cmpBoIdFilter = new QFilter("boid", "=", (Object)cmpEmpId);
        String selectField1 = "id, boid, sourcevid";
        DynamicObject cmpEmpDyn = CmpEmpRepository.getInstance().queryOne(selectField1, new QFilter[]{cmpBoIdFilter, RepositoryUtils.isCurrentVersion()});
        if (cmpEmpDyn == null) {
            return;
        }
        res.put("hrpi_cmpemp", this.formatBoidVid(cmpEmpDyn.getLong("boid"), cmpEmpDyn.getLong("sourcevid"), ChgModeEnum.UNCHANGED.getChgMode(), ""));
    }

    private void formatMultipleOrg(List<DynamicObject> orgPersons, Map<String, List<DynamicObject>> map2Change, Map<String, List<DynamicObject>> mapUnchanged, List<Map<String, Map<String, Object>>> ans, String chgMode) {
        String selectFields = "id, cmpemp,boid, employee,person";
        List boids = orgPersons.stream().map(row -> row.getLong("idbefore")).collect(Collectors.toList());
        QFilter idFilter = new QFilter("boid", "in", boids);
        DynamicObject[] dyns = DepEmpRepository.getInstance().query(selectFields, new QFilter[]{idFilter, RepositoryUtils.isCurrentVersion()});
        Arrays.stream(dyns).forEach(dyn -> {
            HashMap<String, Map<String, Object>> res = new HashMap<String, Map<String, Object>>(8);
            long personId = dyn.getLong("person.id");
            this.putPersonModel(map2Change, mapUnchanged, "hrpi_person", personId, res, chgMode);
            long employeeId = dyn.getLong("employee.id");
            this.putPersonModel(map2Change, mapUnchanged, "hrpi_employee", employeeId, res, chgMode);
            long cmpEmpId = dyn.getLong("cmpemp.id");
            this.putPersonModel(map2Change, mapUnchanged, "hrpi_cmpemp", cmpEmpId, res, chgMode);
            long depEmpId = dyn.getLong("boid");
            this.putPersonModel(map2Change, mapUnchanged, "hrpi_depemp", depEmpId, res, chgMode);
            ans.add(res);
        });
    }

    private void putPersonModel(Map<String, List<DynamicObject>> map2Change, Map<String, List<DynamicObject>> mapUnchanged, String entityName, long boid, Map<String, Map<String, Object>> res, String chgMode) {
        DynamicObject changeDyn2;
        List<DynamicObject> changeList = map2Change.get(entityName);
        if (changeList != null && (changeDyn2 = (DynamicObject)changeList.stream().filter(row -> row.getLong("idafter") == boid).findFirst().orElse(null)) != null) {
            String flowType = this.getFlowType(changeDyn2, entityName);
            res.put(entityName, this.formatBoidVid(changeDyn2.getLong("idafter"), changeDyn2.getLong("vidafter"), chgMode, flowType));
            return;
        }
        List<DynamicObject> unChangeList = mapUnchanged.get(entityName);
        if (unChangeList != null) {
            unChangeList.stream().filter(row -> row.getLong("idafter") == boid).findFirst().ifPresent(changeDyn -> {
                String flowType = this.getFlowType((DynamicObject)changeDyn, entityName);
                res.put(entityName, this.formatBoidVid(changeDyn.getLong("idafter"), changeDyn.getLong("idbefore"), ChgModeEnum.UNCHANGED.getChgMode(), flowType));
            });
        }
    }

    private String getFlowType(DynamicObject dyn, String entityName) {
        if (HRStringUtils.equals((String)entityName, (String)"hrpi_depemp")) {
            String flowType = dyn.getString("flowtype");
            return HRStringUtils.isEmpty((String)flowType) ? ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType() : flowType;
        }
        return "";
    }

    private Map<String, Object> formatBoidVid(Long boid, Long vid, String chgMode, String flowType) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("boid", boid);
        map.put("vid", vid);
        map.put("chgmode", chgMode);
        if (HRStringUtils.isNotEmpty((String)flowType)) {
            map.put("flowtype", flowType);
        }
        return map;
    }

    public static void addFileChangeRecord(PerChgBizInfo bizInfo) {
        HRBaseServiceHelper fileChgRedHelper = new HRBaseServiceHelper("hpfs_chgrecord");
        QFilter billQFilter = new QFilter("bill", "=", (Object)bizInfo.getBillId());
        QFilter sourceQFilter = new QFilter("billsource", "=", (Object)bizInfo.getBillSource());
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList("0", "2"));
        DynamicObject fileChgRedDy = fileChgRedHelper.loadDynamicObject(new QFilter[]{billQFilter, sourceQFilter, statusFilter});
        if (fileChgRedDy == null) {
            fileChgRedDy = fileChgRedHelper.generateEmptyDynamicObject();
        }
        fileChgRedDy.set("event", (Object)bizInfo.getEventId());
        fileChgRedDy.set("chgrule", (Object)bizInfo.getRuleId());
        fileChgRedDy.set("chgaction", (Object)bizInfo.getActionId());
        fileChgRedDy.set("datastatus", (Object)"1");
        fileChgRedDy.set("bill", (Object)bizInfo.getBillId());
        fileChgRedDy.set("billsource", (Object)bizInfo.getBillSource());
        fileChgRedDy.set("effecttime", (Object)bizInfo.getBsed());
        fileChgRedDy.set("evententity", (Object)bizInfo.getEventEntity());
        fileChgRedDy.set("billno", (Object)bizInfo.getBillNo());
        fileChgRedDy.set("chgcategory", bizInfo.getChgRule().getDynamicObject("chgaction").get("chgcategory"));
        DynamicObjectCollection collection = fileChgRedDy.getDynamicObjectCollection("entryentity");
        ChgRecordService.formatCollection(bizInfo, collection);
        ParserUtil.setSysField(fileChgRedDy);
        fileChgRedHelper.saveOne(fileChgRedDy);
        bizInfo.setChgrecordId(Long.valueOf(fileChgRedDy.getLong("id")));
    }

    private static void formatCollection(PerChgBizInfo bizInfo, DynamicObjectCollection collection) {
        collection.clear();
        Map idsRecord = bizInfo.getIdsRecord();
        idsRecord.forEach((entityName, ids) -> ids.forEach(row -> {
            DynamicObject dynNew = collection.addNew();
            ChgRecordEntryDto.recordEntrySetValue((DynamicObject)dynNew, (String)entityName, (ChgRecordEntryDto)row);
        }));
    }

    public Map<String, Object> getFlowOutPersonCount(Map<String, Object> params) {
        LOGGER.info("ChgRecordService-->getFlowOutPersonCount,param:{}", params);
        Date startTime = (Date)params.get("startTime");
        Date endTime = (Date)params.get("endTime");
        List positionIdList = (List)params.get("positionId");
        List chgEventAndCategoryList = (List)params.get("chgEventAndCategory");
        QFilter positionIdListFilter = new QFilter("position", "in", (Object)positionIdList);
        QFilter businessStatusFilter = new QFilter("businessstatus", "=", (Object)"2");
        QFilter dataStatusFilter = new QFilter("datastatus", "!=", (Object)"-2");
        QFilter createTimeFilter = new QFilter("createtime", ">=", (Object)startTime).and(new QFilter("createtime", "<=", (Object)endTime));
        DynamicObject[] empPosOrgRelDyArr = HRPI_EMPPOSORGREL_HELPER.query("id", new QFilter[]{positionIdListFilter, businessStatusFilter, dataStatusFilter, createTimeFilter});
        if (empPosOrgRelDyArr == null || empPosOrgRelDyArr.length == 0) {
            return ChgApiDataReturnUtils.formatDataReturned(true, null, 0);
        }
        List empPosOrgRelIdList = Arrays.stream(empPosOrgRelDyArr).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        LOGGER.info("ChgRecordService-->getFlowOutPersonCount,empPosOrgRelIdList:{}", empPosOrgRelIdList);
        QFilter idBeforeFilter = new QFilter("idbefore", "in", empPosOrgRelIdList);
        QFilter chgEntityFilter = new QFilter("chgentity", "=", (Object)"hrpi_empposorgrel");
        QFilter flowTypeFilter = new QFilter("flowtype", "=", (Object)FlowTypeEnum.OUT.getValue());
        DynamicObject[] recordEntryArr = CHG_RECORD_ENTRY_HELPER.query("chgrecord", new QFilter[]{idBeforeFilter, chgEntityFilter, flowTypeFilter});
        if (recordEntryArr == null || recordEntryArr.length == 0) {
            return ChgApiDataReturnUtils.formatDataReturned(true, null, 0);
        }
        List recordIdList = Arrays.stream(recordEntryArr).map(dynamicObject -> dynamicObject.getLong("chgrecord.id")).collect(Collectors.toList());
        LOGGER.info("ChgRecordService-->getFlowOutPersonCount,recordIdList:{}", recordIdList);
        QFilter recordIdListFilter = new QFilter("id", "in", recordIdList);
        QFilter transactionStatusFilter = new QFilter("datastatus", "=", (Object)ChgRecordStatusEnum.CHANGED.getCode());
        QFilter dateFilter = new QFilter("effecttime", ">=", (Object)startTime).and(new QFilter("effecttime", "<=", (Object)endTime));
        QFilter eventAndCategoryQFilter = new QFilter("chgcategory.chgevent", "=", ((Map)chgEventAndCategoryList.get(0)).get("chgevent"));
        if (((Map)chgEventAndCategoryList.get(0)).get("chgcategory") != null) {
            eventAndCategoryQFilter.and(new QFilter("chgcategory", "in", ((Map)chgEventAndCategoryList.get(0)).get("chgcategory")));
        }
        for (int i = 1; i < chgEventAndCategoryList.size(); ++i) {
            QFilter qFilter = new QFilter("chgcategory.chgevent", "=", ((Map)chgEventAndCategoryList.get(i)).get("chgevent"));
            if (((Map)chgEventAndCategoryList.get(i)).get("chgcategory") != null) {
                qFilter.and(new QFilter("chgcategory", "in", ((Map)chgEventAndCategoryList.get(i)).get("chgcategory")));
            }
            eventAndCategoryQFilter.or(qFilter);
        }
        LOGGER.info("ChgRecordService-->getFlowOutPersonCount,eventAndCategoryQFilter:{}", (Object)eventAndCategoryQFilter);
        QFilter[] qFilterArr = new QFilter[]{recordIdListFilter, transactionStatusFilter, dateFilter, eventAndCategoryQFilter};
        return ChgApiDataReturnUtils.formatDataReturned(true, null, CHG_RECORD_HELPER.count("hpfs_chgrecord", qFilterArr));
    }

    public Map<String, Object> getChgRecord(Map<String, Object> params) {
        LOGGER.info("ChgRecordService-->getChgRecord,param:{}", params);
        ResponseResult result = new ResponseResult();
        try {
            ChgRecordQueryModel chgRecordQueryModel = this.parseParams2ChgRecordQueryModel(params, result);
            QFilter filter = new QFilter("chgentity", "=", (Object)chgRecordQueryModel.getEntityNumber()).and(new QFilter("idbefore", "in", (Object)chgRecordQueryModel.getSignList()));
            HRBaseServiceHelper recordEntryHelper = new HRBaseServiceHelper("hpfs_chgrecordentry");
            DynamicObject[] recordEntry = recordEntryHelper.queryOriginalArray("chgrecord, idbefore", new QFilter[]{filter});
            if (recordEntry == null || recordEntry.length == 0) {
                LOGGER.info("ChgRecordService-->getChgRecord recordEntry is empty");
                return (Map)JSON.parseObject((String)JSON.toJSONString((Object)result.success(new HashMap())), Map.class);
            }
            HRBaseServiceHelper recordHelper = new HRBaseServiceHelper("hpfs_chgrecord");
            Map<Long, List<Long>> idRecordMap = Arrays.stream(recordEntry).collect(Collectors.groupingBy(row -> row.getLong("idbefore"))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, row -> ((List)row.getValue()).stream().map(entry -> entry.getLong("chgrecord")).collect(Collectors.toList())));
            List<Long> recordIds = idRecordMap.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
            QFilter recordQFilter = this.buildQueryChgRecordQFilter(recordIds, chgRecordQueryModel);
            DynamicObject[] records = recordHelper.loadDynamicObjectArray(new QFilter[]{recordQFilter});
            if (records == null || records.length == 0) {
                LOGGER.info("ChgRecordService-->getChgRecord record is empty");
                return (Map)JSON.parseObject((String)JSON.toJSONString((Object)result.success(new HashMap())), Map.class);
            }
            List chgcategoryIds = Arrays.stream(records).map(record -> record.getLong("chgcategory.id")).distinct().collect(Collectors.toList());
            QFilter chgcategoryQFilter = new QFilter("id", "in", chgcategoryIds);
            HRBaseServiceHelper categoryHelper = new HRBaseServiceHelper("hpfs_chgcategory");
            DynamicObject[] categoryArr = categoryHelper.loadDynamicObjectArray(new QFilter[]{chgcategoryQFilter});
            Map<Long, DynamicObject> categoryEventMap = Arrays.stream(categoryArr).collect(Collectors.toMap(category -> category.getLong("id"), category -> category.getDynamicObject("chgevent")));
            QFilter recordFilter = new QFilter("chgrecord", "in", recordIds);
            DynamicObject[] recordEntryDetail = recordEntryHelper.queryOriginalArray("chgrecord, idbefore,chgentity", new QFilter[]{recordFilter});
            Map<Long, List<Map<String, Object>>> data = this.buildResult(chgRecordQueryModel.getSignList(), idRecordMap, records, recordEntryDetail, categoryEventMap);
            result.success(data);
        }
        catch (KDBizException bizException) {
            result.bizError(bizException.getMessage());
            LOGGER.error("ChgRecordService-->getChgRecord bizError, the result is {}", (Object)bizException.getMessage(), (Object)bizException);
        }
        catch (Exception exception) {
            result.serverError(exception.getMessage());
            LOGGER.error("ChgRecordService-->getChgRecord error, the result is", (Throwable)exception);
        }
        return (Map)JSON.parseObject((String)JSON.toJSONString((Object)result), Map.class);
    }

    private ChgRecordQueryModel parseParams2ChgRecordQueryModel(Map<String, Object> params, ResponseResult result) throws KDBizException {
        ChgRecordQueryModel chgRecordQueryModel = new ChgRecordQueryModel();
        try {
            chgRecordQueryModel = (ChgRecordQueryModel)SerializationUtils.fromJsonString((String)JSON.toJSONString(params), ChgRecordQueryModel.class);
        }
        catch (Exception ex) {
            LOGGER.error("parse params error", (Throwable)ex);
            throw new KDBizException("parse params error, please check param");
        }
        if (null == chgRecordQueryModel.getSign()) {
            throw new KDBizException("params sign is empty");
        }
        if (null == chgRecordQueryModel.getSignList()) {
            throw new KDBizException("params signList is empty");
        }
        chgRecordQueryModel.setEntityNumber(ChgSign2EntityNumberEnum.getEntityNumberBySign((String)chgRecordQueryModel.getSign()));
        if (HRObjectUtils.isEmpty((Object)chgRecordQueryModel.getEntityNumber())) {
            LOGGER.error("sign convert to entityNumber exception, the sign is {}", (Object)chgRecordQueryModel.getSign());
            throw new KDBizException("param sign convert to entityNumber exception");
        }
        return chgRecordQueryModel;
    }

    private QFilter buildQueryChgRecordQFilter(List<Long> recordIds, ChgRecordQueryModel chgRecordQueryModel) {
        QFilter recordQFilter = new QFilter("id", "in", recordIds);
        if (!HRObjectUtils.isEmpty((Object)chgRecordQueryModel.getStatus())) {
            recordQFilter.and(new QFilter("datastatus", "in", (Object)chgRecordQueryModel.getStatus()));
        }
        if (null != chgRecordQueryModel.getChgcategory()) {
            recordQFilter.and(new QFilter("chgcategory", "=", (Object)chgRecordQueryModel.getChgcategory()));
        } else {
            recordQFilter.and(new QFilter("chgcategory", "!=", (Object)0));
        }
        if (null != chgRecordQueryModel.getChgevent()) {
            recordQFilter.and(new QFilter("chgcategory.chgevent", "=", (Object)chgRecordQueryModel.getChgevent()));
        }
        return recordQFilter;
    }

    private Map<Long, List<Map<String, Object>>> buildResult(List<Long> signList, Map<Long, List<Long>> idRecordMap, DynamicObject[] records, DynamicObject[] recordEntry, Map<Long, DynamicObject> categoryEventMap) {
        Map recordMap = Arrays.stream(records).collect(Collectors.toMap(record -> record.getLong("id"), Function.identity()));
        Map<Long, List<DynamicObject>> recordEntryMap = Arrays.stream(recordEntry).collect(Collectors.groupingBy(entry -> entry.getLong("chgrecord")));
        Map<Long, List<Map<String, Object>>> result = signList.stream().collect(Collectors.toMap(sign -> sign, sign -> {
            List recordIds = (List)idRecordMap.get(sign);
            if (null == recordIds) {
                return new ArrayList();
            }
            return recordIds.stream().filter(id -> null != recordMap.get(id)).map(id -> {
                HashMap<String, Object> record = new HashMap<String, Object>();
                DynamicObject recordDy = (DynamicObject)recordMap.get(id);
                List recordEntryDy = (List)recordEntryMap.get(id);
                DynamicObject chgCategory = recordDy.getDynamicObject("chgcategory");
                DynamicObject chgEvent = (DynamicObject)categoryEventMap.get(chgCategory.getLong("id"));
                record.put("id", id);
                record.put("billNo", recordDy.getString("billno"));
                record.put("billId", recordDy.getLong("bill"));
                record.put("chgaction", recordDy.getLong("chgaction.id"));
                record.put("chgactionName", recordDy.getString("chgaction.name"));
                record.put("chgcategory", chgCategory.getLong("id"));
                record.put("chgcategoryName", chgCategory.getString("name"));
                record.put("chgevent", chgEvent.getLong("id"));
                record.put("chgeventName", chgEvent.getString("name"));
                record.put("status", recordDy.getString("datastatus"));
                recordEntryDy.stream().forEach(entry -> {
                    String signStr = ChgSign2EntityNumberEnum.getSignByEntityNumber((String)entry.getString("chgentity"));
                    if (!HRStringUtils.isEmpty((String)signStr)) {
                        record.put(signStr, entry.getLong("idbefore"));
                    }
                });
                return record;
            }).collect(Collectors.toList());
        }));
        return result;
    }
}

