/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service.cert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.bussiness.cert.HRBizCertSignHelper;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;

public class HPLicenseCertUpgradeServiceHelper
implements IUpgradeService {
    private static final String APPID = "0QO140ANVBBZ";
    private static final int PAGECOUNT = 1000;
    private static final String ENTITYNAME = "hrpi_empposorgrel";
    private static final Log logger = LogFactory.getLog(HPLicenseCertUpgradeServiceHelper.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        result.setLog("begin init license detail");
        int count = ORM.create().count("BusinessDataServiceHelper_empcert_count", ENTITYNAME, this.getFilters());
        logger.info("license cert count {}", (Object)count);
        Map verifyCertMap = HRCertCommonHelper.verifyCertCount((String)APPID, (String)ENTITYNAME, (int)count);
        logger.info("license verifyCertMap {}", (Object)verifyCertMap);
        this.saveLicenseDetails(count);
        result.setLog("end init license detail");
        return result;
    }

    void saveLicenseDetails(int count) {
        int pageSize = count / 1000 + 1;
        try {
            for (int i = 0; i < pageSize; ++i) {
                logger.info("begin license detail page {}", (Object)i);
                Object[] data = this.getData(i, 1000);
                if (HRArrayUtils.isEmpty((Object[])data)) continue;
                SaveServiceHelper.save((DynamicObject[])data);
                logger.info("end license detail page {}", (Object)i);
            }
        }
        catch (Exception ex) {
            logger.error(" license cert error ", (Throwable)ex);
        }
    }

    DynamicObject[] getData(int start, int limit) {
        Object[] primaryPersonArray = BusinessDataServiceHelper.load((String)ENTITYNAME, (String)"person", (QFilter[])this.getFilters(), (String)"number", (int)start, (int)limit);
        if (!HRArrayUtils.isEmpty((Object[])primaryPersonArray)) {
            ArrayList dys = new ArrayList(primaryPersonArray.length);
            Arrays.stream(primaryPersonArray).map(t -> t.getDynamicObject("person")).filter(person -> !HRObjectUtils.isEmpty((Object)person)).forEach(person -> {
                DynamicObject tmpPerson = BusinessDataServiceHelper.newDynamicObject((String)"hpfs_licensedetail");
                tmpPerson.set("person", (Object)person.getLong("id"));
                tmpPerson.set("sign", (Object)HRBizCertSignHelper.getSignData((String)person.getString("id"), (String)person.getString("number")));
                dys.add(tmpPerson);
            });
            return dys.toArray(new DynamicObject[0]);
        }
        return null;
    }

    QFilter[] getFilters() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        filters.add(new QFilter("businessstatus", "=", (Object)"1"));
        filters.add(new QFilter("isprimary", "=", (Object)"1"));
        filters.add(new QFilter("postype", "=", (Object)1010L));
        filters.add(new QFilter("employee.laborrelstatus.labrelstatusprd", "in", (Object)1010L));
        filters.add(new QFilter("employee.laborrelstatus.laborreltypecls", "in", Arrays.asList(1010L, 1020L)));
        return filters.toArray(new QFilter[0]);
    }
}

