/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service.cert;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hpfs.business.service.cert.HRLicenseRecordManager;

public final class HRCertValidateServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HRCertValidateServiceHelper.class);

    private HRCertValidateServiceHelper() {
    }

    public static Map<Long, Map<String, Object>> checkPersonLicenses(List<Long> personIds) {
        return HRLicenseRecordManager.checkPersonLicense(personIds);
    }

    public static String getValidataMsg(Long personId, String bussinessMsg) {
        String message = null;
        try {
            Map<Long, Map<String, Object>> license = HRLicenseRecordManager.checkPersonLicense(Collections.singletonList(personId));
            if (license.isEmpty()) {
                message = ResManager.loadKDString((String)"\u672a\u68c0\u67e5\u5230\u8bb8\u53ef\u4eba\u5458\u3002", (String)"HRCertValidataServiceHelper_0", (String)"hr-hpfs-business", (Object[])new Object[0]);
            } else {
                Map<String, Object> personInfo = license.get(personId);
                if (personInfo != null && !personInfo.isEmpty() && !((Boolean)personInfo.get("status")).booleanValue()) {
                    String name = (String)personInfo.get("name");
                    String number = (String)personInfo.get("number");
                    message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u53d1\u8d77%3$s\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"HRCertValidataServiceHelper_1", (String)"hr-hpfs-business", (Object[])new Object[0]), name, number, bussinessMsg);
                }
            }
        }
        catch (Exception ex) {
            message = ResManager.loadKDString((String)"\u6821\u9a8c\u8bb8\u53ef\u5f02\u5e38", (String)"HRCertValidataServiceHelper_2", (String)"hr-hpfs-business", (Object[])new Object[0]);
        }
        LOGGER.info(String.format("getValidataMsg msg:%s, personId:%s", message, personId));
        return message;
    }
}

