/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service.cert;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;

final class PersonLicenseHelper {
    private static final String SELECTS = "id,number";
    static final HRBaseServiceHelper PERSONHELPER = new HRBaseServiceHelper("hrpi_person");
    static final HRBaseServiceHelper SERVICEHELPER = new HRBaseServiceHelper("hpfs_licensedetail");

    PersonLicenseHelper() {
    }

    public static DynamicObject[] listPersons(List<Long> personIds) {
        QFilter idFilter = new QFilter("id", "in", personIds);
        return PERSONHELPER.query("id,number,name", new QFilter[]{idFilter});
    }

    public static DynamicObject getPerson(Long personId) {
        QFilter idFilter = new QFilter("id", "=", (Object)personId);
        return PERSONHELPER.queryOriginalOne("id,number,name", new QFilter[]{idFilter});
    }

    public static DynamicObject getPersonLincese(Long personId) {
        return PersonLicenseHelper.getPersonLicenseByPersonId(personId);
    }

    static boolean savePersonLicense(DynamicObject license) {
        return !HRObjectUtils.isEmpty((Object)SERVICEHELPER.saveOne(license));
    }

    static int delPersonLicense(Long signData, String sign) {
        QFilter signDataFilter = new QFilter("person", "=", (Object)signData);
        QFilter signFilter = new QFilter("sign", "=", (Object)sign);
        return SERVICEHELPER.deleteByFilter(new QFilter[]{signDataFilter, signFilter});
    }

    static DynamicObject[] listPersonLicense(Set<Long> signData, List<String> signList) {
        QFilter signDataFilter = new QFilter("person", "in", signData);
        QFilter signFilter = new QFilter("sign", "in", signList);
        return SERVICEHELPER.queryOriginalArray("person,sign", new QFilter[]{signDataFilter, signFilter});
    }

    static DynamicObject getPersonLicenseByPersonId(Long personId) {
        QFilter personFilter = new QFilter("person", "=", (Object)personId);
        return SERVICEHELPER.queryOne("person,sign", new QFilter[]{personFilter});
    }
}

