/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service.hpfsrollback;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransRevocationListBo;
import kd.hr.hbp.business.domain.model.newhismodel.event.HisSearchLaterEventParam;
import kd.hr.hbp.business.domain.model.newhismodel.event.HisSearchLaterEventResult;
import kd.hr.hbp.business.domain.model.newhismodel.event.result.LaterEventBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.HRPerserlenHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.domain.repository.RepositoryUtils;
import kd.hr.hpfs.business.domain.repository.hrpi.EmployeeAttachRepository;
import kd.hr.hpfs.business.domain.repository.hrpi.PersonEntityConfRepository;
import kd.hr.hpfs.business.domain.repository.hrpi.PersonRepository;
import kd.hr.hpfs.business.perchg.executor.enums.ChgLogStatusEnum;
import kd.hr.hpfs.business.service.cert.HRCertServiceHelper;
import kd.hrmp.hrpi.business.helper.revise.CalServiceLengthHandler;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;

public class HpfsRollbackServiceHelper {
    private static final Log LOG = LogFactory.getLog(HpfsRollbackServiceHelper.class);
    private static final String PROPERTIES = "id, person,adminorg, startdate, position, depemp, apositiontype";
    private static final String PROPERTIES_EVENT = "id, event, boid, sourceentity";
    private static final HRBaseServiceHelper logHelper = new HRBaseServiceHelper("hpfs_chglog");
    private static final String UPDPLUGINPATH = "kd.hr.hpfs.business.perchg.service.impl.UpdateUserAfterDataFormatServiceImpl";

    public static DynamicObject[] queryChgRecordByBillAction(Map<String, Object> param) {
        QFilter filter = new QFilter("bill", "in", param.get("billId")).and("chgaction", "in", param.get("chgaction")).and("datastatus", "!=", (Object)"4").and("billno", "=", param.get("billNo"));
        return RepositoryUtils.queryDynamicObjects("hpfs_chgrecord", "", filter);
    }

    public static void defaultRollback(Map<String, Object> param) {
        DynamicObject[] chgRecords = HpfsRollbackServiceHelper.queryChgRecordByBillAction(param);
        if (chgRecords != null && chgRecords.length > 0) {
            HpfsRollbackServiceHelper.rollbackDiscardData(param);
            HpfsRollbackServiceHelper.rollbackByEventId(chgRecords);
            HpfsRollbackServiceHelper.rollbackInvalidPersonAttach(chgRecords);
            HpfsRollbackServiceHelper.reCalculateBusinessData4QuitRollback(chgRecords);
            HpfsRollbackServiceHelper.rollbackOrgLeader(chgRecords);
            HpfsRollbackServiceHelper.rollbackPosition(chgRecords);
            HpfsRollbackServiceHelper.rollbackHRLicense(chgRecords);
            HpfsRollbackServiceHelper.rollbackFlow(chgRecords);
            HpfsRollbackServiceHelper.rollbackSynBosUser(chgRecords);
            HpfsRollbackServiceHelper.rollbackChgRecord(chgRecords);
            HpfsRollbackServiceHelper.rollbackAddLog(chgRecords, ChgLogStatusEnum.ROLLBACK_SUCCESS.getFlag());
        }
    }

    private static void reCalculateBusinessData4QuitRollback(DynamicObject[] chgRecords) {
        List<DynamicObject> quitRecords = Arrays.asList(chgRecords).stream().filter(record -> null != record.get("chgcategory")).filter(record -> {
            DynamicObject chgcategory = record.getDynamicObject("chgcategory");
            return 1070L == chgcategory.getLong("chgevent_id");
        }).collect(Collectors.toList());
        if (null == quitRecords || quitRecords.size() == 0) {
            LOG.info("HpfsRollbackServiceHelper#reCalculateSerlen4QuitRollback quitRecord is empty");
            return;
        }
        ArrayList<Long> quitEmployeeIds = new ArrayList<Long>();
        quitRecords.forEach(quitRecord -> {
            DynamicObjectCollection coll = quitRecord.getDynamicObjectCollection("entryentity");
            quitEmployeeIds.addAll(coll.stream().filter(entry -> HRStringUtils.equals((String)entry.getString("chgentity.number"), (String)"hrpi_employee")).map(entry -> entry.getLong("idbefore")).collect(Collectors.toList()));
        });
        if (quitEmployeeIds.size() > 0) {
            try (TXHandle tx = TX.required();){
                try {
                    HpfsRollbackServiceHelper.reCalculateComSerCount4QuitRollback(quitEmployeeIds);
                    HpfsRollbackServiceHelper.reCalculateCompanyWorkAge4QuitRollback(quitEmployeeIds);
                }
                catch (Exception ex) {
                    LOG.error("HpfsRollbackServiceHelper#reCalculateBusinessData4QuitRollback error");
                    tx.markRollback();
                }
            }
        }
    }

    private static void reCalculateCompanyWorkAge4QuitRollback(List<Long> quitEmployeeIds) {
        DynamicObject[] empentrelDys = EmployeeAttachRepository.queryEmployeeAttchByEmployeeIds(quitEmployeeIds, EmployeeAttachRepository.getHrpiEmpentrelHelper());
        if (null == empentrelDys || empentrelDys.length == 0) {
            LOG.warn("HpfsRollbackServiceHelper#reCalculateCompanyWorkAge4QuitRollback queryEmpentrel result is empty");
            return;
        }
        Set<Long> personIds = Arrays.stream(empentrelDys).map(empentrel -> empentrel.getLong("person.id")).collect(Collectors.toSet());
        DynamicObject[] personontSpropDys = PersonRepository.queryPernontspropByPersonId(personIds);
        Map<Long, List<DynamicObject>> empentrelDyMap = HpfsRollbackServiceHelper.groupByDataByBoid(empentrelDys);
        for (Map.Entry<Long, List<DynamicObject>> empentrelDy : empentrelDyMap.entrySet()) {
            BigDecimal serviceLength;
            Long empentrelBoid = empentrelDy.getKey();
            List<DynamicObject> empentrelList = empentrelDy.getValue();
            Optional<DynamicObject> first = empentrelList.stream().filter(dy -> dy.getLong("id") == empentrelBoid.longValue()).findFirst();
            if (!first.isPresent()) continue;
            DynamicObject currentEmpentrel = first.get();
            BigDecimal adjustlength = HpfsRollbackServiceHelper.getBigDecimalDefaultZero(currentEmpentrel, "adjustlength");
            Date startdate = currentEmpentrel.getDate("startdate");
            if (startdate == null) continue;
            String serviceAgeScheme = currentEmpentrel.getString("serviceagescheme");
            long personId = currentEmpentrel.getLong("person.id");
            if ("2".equals(serviceAgeScheme)) {
                Map companyAgeMap = CalServiceLengthHandler.calcEmpentrelContinuation(Collections.singletonList(currentEmpentrel), (String)"1", (String)"0");
                serviceLength = companyAgeMap.getOrDefault(currentEmpentrel.getLong("employee.mid"), BigDecimal.ZERO);
            } else {
                serviceLength = CalServiceLengthHandler.calcServiceLength((Date)startdate, (Date)new Date(), (BigDecimal)adjustlength, (DynamicObject)currentEmpentrel);
            }
            empentrelList.forEach(dynamicObject -> dynamicObject.set("servicelength", (Object)serviceLength));
            Arrays.stream(personontSpropDys).filter(personontSpropDy -> personontSpropDy.getLong("person.id") == personId).forEach(personontSpropDy -> personontSpropDy.set("entservicelen", (Object)serviceLength));
        }
        EmployeeAttachRepository.getHrpiEmpentrelHelper().update(empentrelDys);
        PersonRepository.getPernontspropHelper().update(personontSpropDys);
    }

    private static void reCalculateComSerCount4QuitRollback(List<Long> quitEmployeeIds) {
        DynamicObject[] perserDys = EmployeeAttachRepository.queryEmployeeAttchByEmployeeIds(quitEmployeeIds, EmployeeAttachRepository.getHrpiPerserlenHelper());
        if (null == perserDys || perserDys.length == 0) {
            LOG.warn("HpfsRollbackServiceHelper#reCalculateComSerCount4QuitRollback perserDys result is empty");
            return;
        }
        Map<Long, List<DynamicObject>> perserDyMap = HpfsRollbackServiceHelper.groupByDataByBoid(perserDys);
        for (Map.Entry<Long, List<DynamicObject>> perseEntry : perserDyMap.entrySet()) {
            Long perseBoid = perseEntry.getKey();
            List<DynamicObject> perseList = perseEntry.getValue();
            Optional<DynamicObject> first = perseList.stream().filter(dy -> dy.getLong("id") == perseBoid.longValue()).findFirst();
            if (!first.isPresent()) {
                LOG.warn("HpfsRollbackServiceHelper#reCalculateComSerCount4QuitRollback currentPerserlen is empty");
                continue;
            }
            DynamicObject perserDy = first.get();
            Date joinDate = perserDy.getDate("joincomdate");
            Date joinworktime = perserDy.getDate("joinworktime");
            BigDecimal adjustcomtime = HpfsRollbackServiceHelper.getBigDecimalDefaultZero(perserDy, "adjustcomtime");
            BigDecimal adjustworkage = HpfsRollbackServiceHelper.getBigDecimalDefaultZero(perserDy, "adjustworkage");
            BigDecimal socialworkage = adjustworkage.add(BusinessUtils.calcYearsDiff((Date)new Date(), (Date)joinworktime));
            BigDecimal comserCount = HRPerserlenHelper.calcComsercountByEmployeeId((Date)joinDate, (BigDecimal)adjustcomtime, (Long)perserDy.getLong("employee_id"));
            perseList.forEach(perserlen -> {
                perserlen.set("comsercount", (Object)comserCount);
                perserlen.set("socialworkage", (Object)socialworkage);
            });
        }
        EmployeeAttachRepository.getHrpiPerserlenHelper().update(perserDys);
    }

    private static BigDecimal getBigDecimalDefaultZero(DynamicObject dynamicObject, String propertyKey) {
        if (null == dynamicObject || null == dynamicObject.getBigDecimal(propertyKey)) {
            return BigDecimal.ZERO;
        }
        return dynamicObject.getBigDecimal(propertyKey);
    }

    private static Map<Long, List<DynamicObject>> groupByDataByBoid(DynamicObject[] data) {
        Map<Long, List<DynamicObject>> dynamicObjectMap = Arrays.stream(data).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("boid"), dynamicObject -> {
            ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>();
            newList.add((DynamicObject)dynamicObject);
            return newList;
        }, (oldList, newList) -> {
            oldList.addAll(newList);
            return oldList;
        }));
        return dynamicObjectMap;
    }

    private static void rollbackDiscardData(Map<String, Object> param) {
        LOG.info("==rollbackDiscardData begin==");
        if (null != param.get("eventId")) {
            try {
                LOG.info("==rollbackDiscardData eventId=={}", param.get("eventId"));
                Long eventId = Long.valueOf(param.get("eventId").toString());
                if (eventId > 0L) {
                    HpfsRollbackServiceHelper.forceRollbackDataByEventId(eventId);
                }
            }
            catch (Exception ex) {
                LOG.error("==rollbackDiscardData exception eventId=={}, exception is {}", param.get("eventId"), (Object)ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e8b\u52a1\u53d8\u52a8\u4ea4\u53c9\u914d\u7f6e\u3002", (String)"HpfsRollbackServiceHelper_9", (String)"hr-hpfs-business", (Object[])new Object[0]));
            }
        }
        LOG.info("==rollbackDiscardData end==");
    }

    public static void rollbackSynBosUser(DynamicObject[] chgRecords) {
        for (DynamicObject chgRec : chgRecords) {
            DynamicObjectCollection coll = chgRec.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)coll)) {
                LOG.info("==CHG_RECORD COLL is empty==");
                return;
            }
            long chgEventId = chgRec.getLong("chgcategory.chgevent.id");
            if (HRCertServiceHelper.LICENSE_OUT.contains(chgEventId)) {
                HpfsRollbackServiceHelper.backQuit(coll);
                continue;
            }
            Set<Long> personSet = coll.stream().filter(row -> HRStringUtils.equals((String)row.getString("chgentity.number"), (String)"hrpi_person") && HRStringUtils.equals((String)row.getString("chgmode"), (String)"4")).map(row -> row.getLong("idafter")).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(personSet) && !HRCertServiceHelper.LICENSE_IN.contains(chgEventId)) {
                HpfsRollbackServiceHelper.synBosUser(personSet, null, "back_update");
                continue;
            }
            if (!CollectionUtils.isEmpty(personSet) && HRCertServiceHelper.LICENSE_IN.contains(chgEventId)) {
                HpfsRollbackServiceHelper.backAgainJoin(personSet, personSet);
                return;
            }
            Set<Long> oldpersonSet = coll.stream().filter(row -> HRStringUtils.equals((String)row.getString("chgentity.number"), (String)"hrpi_person") && HRStringUtils.equals((String)row.getString("chgmode"), (String)"1")).map(row -> row.getLong("idafter")).collect(Collectors.toSet());
            Set<Long> newpersonSet = coll.stream().filter(row -> HRStringUtils.equals((String)row.getString("chgentity.number"), (String)"hrpi_person") && HRStringUtils.equals((String)row.getString("chgmode"), (String)"0")).map(row -> row.getLong("idafter")).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(oldpersonSet) && !CollectionUtils.isEmpty(newpersonSet)) {
                HpfsRollbackServiceHelper.backAgainJoin(oldpersonSet, newpersonSet);
                return;
            }
            if (CollectionUtils.isEmpty(newpersonSet)) continue;
            HpfsRollbackServiceHelper.synBosUser(newpersonSet, "back_join");
            return;
        }
    }

    private static void backAgainJoin(Set<Long> oldpersonSet, Set<Long> newpersonSet) {
        HpfsRollbackServiceHelper.synBosUser(newpersonSet, "back_join");
        HpfsRollbackServiceHelper.synBosUser(oldpersonSet, "enble_bos_user");
        HpfsRollbackServiceHelper.synBosUser(oldpersonSet, "disableupdate");
        HpfsRollbackServiceHelper.synBosUser(oldpersonSet, "disble_bos_user");
    }

    private static void backQuit(DynamicObjectCollection coll) {
        Long personId = coll.stream().filter(row -> HRStringUtils.equals((String)row.getString("chgentity.number"), (String)"hrpi_person")).map(row -> row.getLong("idafter")).findFirst().orElse(0L);
        Long employeeId = coll.stream().filter(row -> HRStringUtils.equals((String)row.getString("chgentity.number"), (String)"hrpi_employee")).map(row -> row.getLong("idafter")).findFirst().orElse(0L);
        if (null == personId || null == employeeId || personId == 0L || employeeId == 0L) {
            LOG.warn("HpfsRollbackServiceHelper#backQuit record personId or employeeId is empty");
        }
        HashMap<Long, Long> personEmpMap = new HashMap<Long, Long>();
        personEmpMap.put(personId, employeeId);
        HashSet<Long> personSet = new HashSet<Long>();
        personSet.add(personId);
        HpfsRollbackServiceHelper.synBosUser(personSet, personEmpMap, "back_quit");
    }

    private static void synBosUser(Set<Long> personSet, String synType) {
        HpfsRollbackServiceHelper.synBosUser(personSet, null, synType);
    }

    private static void synBosUser(Set<Long> personSet, Map<Long, Long> personEmpMap, String synType) {
        DynamicObject[] personDys;
        if (!CollectionUtils.isEmpty(personSet) && (personDys = RepositoryUtils.queryByIds("hrpi_person", "", personSet)) != null && personDys.length > 0) {
            ArrayList<Map<String, Object>> userList = new ArrayList<Map<String, Object>>(personDys.length);
            for (DynamicObject personDy : personDys) {
                userList.add(HpfsRollbackServiceHelper.buildSynPersonParam(personDy, personEmpMap, synType));
            }
            if (!CollectionUtils.isEmpty(userList)) {
                LOG.info("===userList:{}==", userList);
                Map res = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"syncPersonToSysUer", (Object[])new Object[]{userList});
                LOG.info("===SYNC_PERSON_SERVICE res:{}==", (Object)res);
                if (((Boolean)res.get("success")).booleanValue()) {
                    LOG.info("==CHG_HPFS ROLLBACK syncPersonToSysUer success");
                } else if (res.get("message") != null) {
                    LOG.error("==CHG_HPFS ROLLBACK syncPersonToSysUer fail, the error message is{}", (Object)res.get("message").toString());
                }
            }
        }
    }

    public static Map<String, Object> buildSynPersonParam(DynamicObject personDy, Map<Long, Long> personEmpMap, String synType) {
        HashMap<String, Object> synPersonParam = new HashMap<String, Object>(16);
        String number = personDy.getString("number");
        String name = personDy.getString("name");
        Long personid = personDy.getLong("id");
        synPersonParam.put("personid", personid);
        synPersonParam.put("number", number);
        synPersonParam.put("name", name);
        synPersonParam.put("synctype", synType);
        if (null != personEmpMap && null != personEmpMap.get(personid) && personEmpMap.get(personid) > 0L) {
            synPersonParam.put("employeeid", personEmpMap.get(personid));
        }
        return synPersonParam;
    }

    public static Map<String, Object> buildSynPersonParam(DynamicObject personDy, String synType) {
        HashMap<String, Object> synPersonParam = new HashMap<String, Object>(16);
        String number = personDy.getString("number");
        String name = personDy.getString("name");
        Long personid = personDy.getLong("id");
        synPersonParam.put("personid", personid);
        synPersonParam.put("number", number);
        synPersonParam.put("name", name);
        synPersonParam.put("synctype", synType);
        return synPersonParam;
    }

    private static void rollbackHRLicense(DynamicObject[] chgRecords) {
        HashMap<Long, DynamicObject> licenseInMap = new HashMap<Long, DynamicObject>(chgRecords.length);
        HashMap<Long, DynamicObject> licenseOutMap = new HashMap<Long, DynamicObject>(chgRecords.length);
        long chgEventId = chgRecords[0].getLong("chgcategory.chgevent.id");
        for (DynamicObject chgRecord : chgRecords) {
            DynamicObjectCollection coll = chgRecord.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)coll)) continue;
            for (DynamicObject dy : coll) {
                String chgentityNum = dy.getString("chgentity.number");
                if (HRCertServiceHelper.LICENSE_IN.contains(chgEventId) && HRStringUtils.equals((String)"hrpi_person", (String)chgentityNum)) {
                    licenseInMap.put(dy.getLong("idafter"), chgRecord);
                }
                if (!HRCertServiceHelper.LICENSE_OUT.contains(chgEventId) || !HRStringUtils.equals((String)"hspm_ermanfile", (String)chgentityNum) || !ChgModeEnum.INVALID.getChgMode().equals(dy.getString("chgmode")) && !ChgModeEnum.DELETE.getChgMode().equals(dy.getString("chgmode"))) continue;
                licenseOutMap.put(dy.getLong("idafter"), chgRecord);
            }
        }
        HRCertServiceHelper.rollbackLicenseExcute(licenseInMap, chgEventId);
        HRCertServiceHelper.rollbackLicenseExcute(licenseOutMap, chgEventId);
    }

    private static void rollbackAddLog(DynamicObject[] chgRecords, String logStatus) {
        HashSet<Long> recordIds = new HashSet<Long>(chgRecords.length);
        HashSet<Long> eventIds = new HashSet<Long>(chgRecords.length);
        for (DynamicObject chgDy : chgRecords) {
            long eventId = chgDy.getLong("event");
            if (eventId == 0L) continue;
            recordIds.add(chgDy.getLong("id"));
            eventIds.add(eventId);
        }
        DynamicObject[] chgLogs = HpfsRollbackServiceHelper.queryLogByRecIdAndEventId(recordIds, eventIds);
        if (chgLogs != null && chgLogs.length > 0) {
            ArrayList<DynamicObject> copyChgLogs = new ArrayList<DynamicObject>(chgLogs.length);
            for (DynamicObject dy : chgLogs) {
                DynamicObject logDy = logHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)logDy, (Set)Sets.newHashSet((Object[])new String[]{"id"}));
                logDy.set("consumeexetime", (Object)new Date());
                logDy.set("transactionstatus", (Object)logStatus);
                copyChgLogs.add(logDy);
            }
            RepositoryUtils.saveDynamicObjects("hpfs_chglog", copyChgLogs.toArray(new DynamicObject[0]));
        }
    }

    private static void rollbackChgRecord(DynamicObject[] chgRecords) {
        for (DynamicObject chgDy : chgRecords) {
            chgDy.set("datastatus", (Object)"4");
        }
        RepositoryUtils.updDynamicObjects("hpfs_chgrecord", chgRecords);
    }

    private static void rollbackPosition(DynamicObject[] chgRecords) {
        ArrayList<Map<String, Object>> paramsList;
        HashMap<Long, DynamicObject> enablePositionMap = new HashMap<Long, DynamicObject>(chgRecords.length);
        HashMap<Long, DynamicObject> diablePositionMap = new HashMap<Long, DynamicObject>(chgRecords.length);
        for (DynamicObject chgRecord : chgRecords) {
            DynamicObjectCollection coll = chgRecord.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)coll)) continue;
            for (DynamicObject dy : coll) {
                String chgentityNum = dy.getString("chgentity.number");
                if (!HRStringUtils.equals((String)"hrpi_empposorgrel", (String)chgentityNum)) continue;
                if (ChgModeEnum.ADD_NEW.getChgMode().equals(dy.getString("chgmode"))) {
                    diablePositionMap.put(dy.getLong("idafter"), chgRecord);
                }
                if (!ChgModeEnum.INVALID.getChgMode().equals(dy.getString("chgmode")) && !ChgModeEnum.DELETE.getChgMode().equals(dy.getString("chgmode"))) continue;
                enablePositionMap.put(dy.getLong("idafter"), chgRecord);
            }
        }
        if (!CollectionUtils.isEmpty(diablePositionMap)) {
            paramsList = new ArrayList<Map<String, Object>>(16);
            Map<Long, DynamicObject> disableMap = HpfsRollbackServiceHelper.getHasDarkPosition(diablePositionMap);
            HpfsRollbackServiceHelper.enOrdisableDarkPosition(disableMap, paramsList);
            Map<String, Object> result = HpfsRollbackServiceHelper.invokeHbpmService("hbpm", "IStandardPositionService", "disableDarkPosition", paramsList);
            LOG.info("==disableDarkPosition result:{}==", result);
        }
        if (!CollectionUtils.isEmpty(enablePositionMap)) {
            paramsList = new ArrayList(16);
            Map<Long, DynamicObject> enableMap = HpfsRollbackServiceHelper.getHasDarkPosition(enablePositionMap);
            HpfsRollbackServiceHelper.enOrdisableDarkPosition(enableMap, paramsList);
            Map<String, Object> result = HpfsRollbackServiceHelper.invokeHbpmService("hbpm", "IStandardPositionService", "enableDarkPosition", paramsList);
            LOG.info("==enableDarkPosition result:{}==", result);
        }
    }

    private static Map<Long, DynamicObject> getHasDarkPosition(Map<Long, DynamicObject> diablePositionMap) {
        QFilter disFilter = new QFilter("id", "in", diablePositionMap.keySet());
        DynamicObject[] enOrdisableEmps = RepositoryUtils.queryDynamicObjects("hrpi_empposorgrel", PROPERTIES, disFilter);
        return Arrays.stream(enOrdisableEmps).filter(dy -> "0".equals(dy.getString("apositiontype")) || "2".equals(dy.getString("apositiontype"))).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (oldVal, newVal) -> newVal));
    }

    private static void rollbackFlow(DynamicObject[] chgRecords) {
        Set<Long> recordIds = Arrays.stream(chgRecords).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        RepositoryUtils.delFlowInfoByRecordId("hpfs_personflow", recordIds);
        LOG.info("==DEL recordIds :{}==", recordIds);
    }

    private static void rollbackByEventId(DynamicObject[] chgRecords) {
        HisTransRevocationListBo listHisBo = new HisTransRevocationListBo();
        for (DynamicObject chgRecordTmp : chgRecords) {
            Long eventId = chgRecordTmp.getLong("event");
            if (eventId == null || eventId == 0L) {
                LOG.info("==rollbackByEventId eventId is empty, the recordId is {}", chgRecordTmp.get("id"));
                continue;
            }
            HpfsRollbackServiceHelper.forceRollbackDataByEventId(eventId);
        }
    }

    private static void forceRollbackDataByEventId(Long eventId) {
        HpfsRollbackServiceHelper.rollbackLaterEvent(eventId);
        HpfsRollbackServiceHelper.rollbackData(eventId);
    }

    private static void rollbackLaterEvent(Long eventId) {
        LaterEventBo[] laterEventBoArr;
        LOG.info("==rollbackLaterEvent eventId:{}==", (Object)eventId);
        HisSearchLaterEventParam searchLaterEventParam = new HisSearchLaterEventParam();
        searchLaterEventParam.setEventId(eventId);
        searchLaterEventParam.setResisterEventGroupAppId("0QO140ANVBBZ");
        HrApiResponse response = HisModelController.getInstance().searchLaterEvent(searchLaterEventParam);
        LOG.info("==rollbackLaterEvent searchLaterEvent response:{}==", (Object)SerializationUtils.toJsonString((Object)response));
        if (!response.isSuccess()) {
            LOG.info("==rollbackLaterEvent searchLaterEvent exception:{}==", (Object)response.getErrorMessage());
            throw new KDBizException(response.getErrorMessage());
        }
        if (null == response.getData() || null == ((HisSearchLaterEventResult)response.getData()).getLaterEventBoList() || ((HisSearchLaterEventResult)response.getData()).getLaterEventBoList().length == 0) {
            LOG.info("==rollbackLaterEvent searchLaterEvent response data is empty");
            return;
        }
        for (LaterEventBo laterEventBo : laterEventBoArr = ((HisSearchLaterEventResult)response.getData()).getLaterEventBoList()) {
            HpfsRollbackServiceHelper.rollbackData(laterEventBo.getEventId());
        }
    }

    private static void rollbackData(Long eventId) {
        LOG.info("==rollbackData eventId:{}==", (Object)eventId);
        HisTransRevocationListBo listHisBo = new HisTransRevocationListBo();
        listHisBo.setEventId(eventId);
        listHisBo.setResisterEventGroupAppId("0QO140ANVBBZ");
        LOG.info("==rollbackData listHisBo:{}==", (Object)listHisBo.getEventId());
        HisModelController.getInstance().revocationEvent(listHisBo);
        LOG.info("==rollbackData success ==");
    }

    private static Map<String, Object> rollbackOrgLeader(DynamicObject[] chgRecords) {
        HashMap<Long, DynamicObject> enableLeaderMap = new HashMap<Long, DynamicObject>(chgRecords.length);
        HashMap<Long, DynamicObject> diableLeaderMap = new HashMap<Long, DynamicObject>(chgRecords.length);
        for (DynamicObject chgRecord : chgRecords) {
            DynamicObjectCollection coll = chgRecord.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)coll)) continue;
            for (DynamicObject dy : coll) {
                String chgentityNum = dy.getString("chgentity.number");
                if (!HRStringUtils.equals((String)"hrpi_empposorgrel", (String)chgentityNum)) continue;
                if (ChgModeEnum.ADD_NEW.getChgMode().equals(dy.getString("chgmode"))) {
                    diableLeaderMap.put(dy.getLong("idafter"), chgRecord);
                }
                if (!ChgModeEnum.INVALID.getChgMode().equals(dy.getString("chgmode")) && !ChgModeEnum.DELETE.getChgMode().equals(dy.getString("chgmode"))) continue;
                enableLeaderMap.put(dy.getLong("idafter"), chgRecord);
            }
        }
        ArrayList<Map<String, Object>> chargePersonParam = new ArrayList<Map<String, Object>>(16);
        if (!CollectionUtils.isEmpty(diableLeaderMap)) {
            Map<Long, DynamicObject> disableMap = HpfsRollbackServiceHelper.getHasLeaderPositon(diableLeaderMap);
            HpfsRollbackServiceHelper.enOrdisableLeader(disableMap, chargePersonParam, "1");
        }
        if (!CollectionUtils.isEmpty(enableLeaderMap)) {
            Map<Long, DynamicObject> enableMap = HpfsRollbackServiceHelper.getHasLeaderPositon(enableLeaderMap);
            HpfsRollbackServiceHelper.enOrdisableLeader(enableMap, chargePersonParam, "0");
        }
        if (!CollectionUtils.isEmpty(chargePersonParam)) {
            LOG.info("==setChargePerson chargePersonParam:{}==", chargePersonParam);
            Map responMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIChargeService", (String)"setChargePerson", (Object[])new Object[]{chargePersonParam});
            LOG.info("==chargePersonParam.responMap:{}==", (Object)responMap);
        }
        return new HashMap<String, Object>();
    }

    public static void rollbackInvalidPersonAttach(DynamicObject[] chgRecords) {
        LOG.info("HpfsRollbackServiceHelper#rollbackInvalidPersonAttach begin");
        List<String> personAttachEntityNumber = PersonEntityConfRepository.getPersonAttachEntityNumber();
        for (DynamicObject chgRecord : chgRecords) {
            DynamicObjectCollection coll = chgRecord.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)coll)) continue;
            for (DynamicObject record : coll) {
                String entityName = record.getString("chgentity.number");
                if (!personAttachEntityNumber.contains(entityName) || !ChgModeEnum.INVALID.getChgMode().equals(record.getString("chgmode"))) continue;
                String boid = record.getString("idbefore");
                LOG.info("HpfsRollbackServiceHelper#rollbackInvalidPersonAttach, entityNumber is {}, boid is {}", (Object)entityName, (Object)boid);
                QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(boid));
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
                DynamicObject invalidPersonAttachDy = serviceHelper.loadDynamicObject(new QFilter[]{idFilter});
                if (Objects.nonNull(invalidPersonAttachDy)) {
                    invalidPersonAttachDy.set("datastatus", (Object)"1");
                    serviceHelper.updateDataOne(invalidPersonAttachDy);
                    continue;
                }
                LOG.warn("HpfsRollbackServiceHelper#rollbackInvalidPersonAttach queryData empty, entityNumber is {}, boid is {}", (Object)entityName, (Object)boid);
            }
        }
    }

    public static Map<Long, DynamicObject> getHasLeaderPositon(Map<Long, DynamicObject> enOrdiableLeaderMap) {
        QFilter disFilter = new QFilter("id", "in", enOrdiableLeaderMap.keySet());
        DynamicObject[] disableEmps = RepositoryUtils.queryDynamicObjects("hrpi_empposorgrel", PROPERTIES, disFilter);
        return Arrays.stream(disableEmps).filter(dy -> "1".equals(dy.getString("position.isleader"))).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (oldVal, newVal) -> newVal));
    }

    public static void enOrdisableLeader(Map<Long, DynamicObject> enOrdisableMap, List<Map<String, Object>> chargePersonParam, String operatetype) {
        if (!CollectionUtils.isEmpty(enOrdisableMap)) {
            for (Map.Entry<Long, DynamicObject> entry : enOrdisableMap.entrySet()) {
                DynamicObject dy = entry.getValue();
                HashMap<String, Object> parm = new HashMap<String, Object>(8);
                parm.put("operatetype", operatetype);
                parm.put("person", dy.getLong("person.id"));
                parm.put("changesource", 1030L);
                parm.put("effdt", dy.getDate("startdate"));
                parm.put("adminorg", dy.getLong("adminorg.id"));
                parm.put("depemp", dy.getLong("depemp.id"));
                chargePersonParam.add(parm);
            }
        }
    }

    public static void enOrdisableDarkPosition(Map<Long, DynamicObject> enOrdisableMap, List<Map<String, Object>> chargePersonParam) {
        if (!CollectionUtils.isEmpty(enOrdisableMap)) {
            for (Map.Entry<Long, DynamicObject> entry : enOrdisableMap.entrySet()) {
                DynamicObject dy = entry.getValue();
                HashMap<String, Long> parm = new HashMap<String, Long>(8);
                parm.put("position", dy.getLong("position.id"));
                chargePersonParam.add(parm);
            }
        }
    }

    public static String checkParams(Map<String, Object> param) {
        String msg;
        if (CollectionUtils.isEmpty(param)) {
            return ResManager.loadKDString((String)"\u5165\u53c2\u4e3a\u7a7a", (String)"HpfsRollbackServiceHelper_4", (String)"hr-hpfs-business", (Object[])new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        if (HRObjectUtils.isEmpty((Object)param.get("billId")) || (Long)param.get("billId") == 0L) {
            msg = ResManager.loadKDString((String)"\u201cbillID\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"HpfsRollbackServiceHelper_2", (String)"hr-hpfs-business", (Object[])new Object[0]);
            sb.append(msg);
        }
        if (HRObjectUtils.isEmpty((Object)param.get("chgaction")) || (Long)param.get("chgaction") == 0L) {
            msg = ResManager.loadKDString((String)"\u201cchgaction\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"HpfsRollbackServiceHelper_3", (String)"hr-hpfs-business", (Object[])new Object[0]);
            sb.append(msg);
        }
        if (HRStringUtils.isEmpty((String)((String)param.get("billNo")))) {
            msg = ResManager.loadKDString((String)"\u201cbillNo\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"HpfsRollbackServiceHelper_5", (String)"hr-hpfs-business", (Object[])new Object[0]);
            sb.append(msg);
        }
        return sb.toString();
    }

    public static Map<String, Object> buildRespon(Map<String, Object> respon, String checkParamMsg, String code) {
        respon.put("code", code);
        respon.put("msg", checkParamMsg);
        return respon;
    }

    public static Map<String, Object> invokeHbpmService(String appId, String serviceName, String methodName, List<Map<String, Object>> paramsList) {
        LOG.info("==invokeHbpmService paramsList:{}==", paramsList);
        if (!CollectionUtils.isEmpty(paramsList)) {
            return (Map)HRMServiceHelper.invokeHRMPService((String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{paramsList});
        }
        return new HashMap<String, Object>(1);
    }

    public static DynamicObject[] queryLogByRecIdAndEventId(Set<Long> recIds, Set<Long> eventIds) {
        HashSet chgStatus = Sets.newHashSet((Object[])new String[]{ChgLogStatusEnum.MAIN_SUCCESS.getFlag(), ChgLogStatusEnum.FAIL.getFlag()});
        QFilter filter = new QFilter("chgrecord", "in", recIds).and("event", "in", eventIds).and("transactionstatus", "in", (Object)chgStatus);
        return RepositoryUtils.queryDynamicObjects("hpfs_chglog", "", filter);
    }

    public static void publishAction(DynamicObject[] chgRecords) {
        if (chgRecords != null && chgRecords.length > 0) {
            LOG.info("==start send message : params{}==", (Object)Arrays.toString(chgRecords));
            for (DynamicObject dy : chgRecords) {
                long chgActionId = dy.getLong("chgaction.id");
                QFilter filter = new QFilter("chgaction", "=", (Object)chgActionId).and("msgtype", "=", (Object)"2").and(RepositoryUtils.isEnable());
                DynamicObject msgDy = RepositoryUtils.loadDynamicObject("hpfs_actionrelate", filter);
                if (msgDy == null) continue;
                String pubNo = msgDy.getString("msgpublish.number");
                Long actionId = msgDy.getLong("msgpublish.action.id");
                HashMap<String, Object> messageParams = new HashMap<String, Object>(16);
                messageParams.put("msgNumber", String.valueOf(HpfsRollbackServiceHelper.generateMessageId()));
                messageParams.put("msgPubNo", pubNo);
                messageParams.put("msgTitle", HpfsRollbackServiceHelper.getMsgTitle(dy));
                messageParams.put("msgDesc", HpfsRollbackServiceHelper.getMsgTitle(dy));
                messageParams.put("actionId", actionId);
                messageParams.put("senderId", RequestContext.get().getCurrUserId());
                messageParams.put("sendTime", new Date());
                HashMap<String, Long> params = new HashMap<String, Long>();
                params.put("affactionId", chgActionId);
                params.put("recordId", dy.getLong("id"));
                params.put("chgcategoryId", dy.getLong("chgcategory.id"));
                LOG.info("==publish params :{}", params);
                messageParams.put("params", SerializationUtils.serializeToBase64(params));
                LOG.info("==start send message : messageParams {} ==", messageParams);
                HRProducerServiceHelper.publishAction(messageParams);
            }
        }
    }

    private static long generateMessageId() {
        return ORM.create().genLongId("hrcs_msgcenter");
    }

    public static String getMsgTitle(DynamicObject record) {
        Optional<DynamicObject> first;
        if (record == null) {
            return "";
        }
        DynamicObjectCollection coll = record.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)coll) && (first = coll.stream().filter(row -> HRStringUtils.equals((String)"hrpi_person", (String)row.getString("chgentity.number"))).findFirst()).isPresent()) {
            Long personId = first.get().getLong("idafter");
            QFilter idQFilter = new QFilter("id", "=", (Object)personId);
            DynamicObject personDy = new HRBaseServiceHelper("hrpi_person").loadDynamicObject(idQFilter);
            String chgName = record.getString("chgaction.name");
            if (null == personDy) {
                return String.join((CharSequence)"_", chgName, ResManager.loadKDString((String)"\u64a4\u56de", (String)"HpfsRollbackServiceHelper_8", (String)"hr-hpfs-business", (Object[])new Object[0]), record.getString("billno"));
            }
            return personDy.getString("name") + chgName + '_' + ResManager.loadKDString((String)"\u64a4\u56de", (String)"HpfsRollbackServiceHelper_8", (String)"hr-hpfs-business", (Object[])new Object[0]);
        }
        return "";
    }
}

