/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service.relatiolservice.inst;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.service.relatiolservice.repository.HelperRepository;
import kd.hr.hpfs.common.model.ChangeModel;

public class AbstractChangeService {
    private static final Log logger = LogFactory.getLog(AbstractChangeService.class);
    protected String entityName;
    protected HRBaseServiceHelper serviceHelper;

    public AbstractChangeService setEntityName(String entityName) {
        this.entityName = entityName;
        return this;
    }

    public Map<String, DynamicObjectCollection> chgLoseOrEffect(ChangeModel changeModel) {
        String operationType = changeModel.getOperationType();
        DynamicObject empDy = changeModel.getEmpDy();
        HashMap<String, DynamicObjectCollection> logMap = new HashMap(16);
        HashMap<String, DynamicObjectCollection> retMap = new HashMap<String, DynamicObjectCollection>(16);
        String type = null;
        if ("1".equals(operationType)) {
            logMap = this.structureEffectInfo(changeModel);
            type = "1";
        } else if ("0".equals(operationType)) {
            logMap = this.structureLoseEffectInfo(changeModel);
            type = "2";
        }
        if (empDy != null) {
            logger.info(MessageFormat.format("doChangePersonRelationLogEffectId->{0}", empDy.getLong("id")));
        }
        this.printRetLog(retMap, logMap, type);
        return retMap;
    }

    private void printRetLog(Map<String, DynamicObjectCollection> retMap, Map<String, DynamicObjectCollection> logMap, String type) {
        try {
            for (Map.Entry<String, DynamicObjectCollection> tMap : logMap.entrySet()) {
                String key = tMap.getKey();
                DynamicObjectCollection dys = tMap.getValue();
                if (dys == null || dys.size() <= 0) continue;
                retMap.put(key, dys);
                Map<String, String> tempMap = dys.stream().collect(Collectors.toMap(dy -> dy.getDataEntityType().getName(), dy -> dy.getLong("id") + "--" + dy.getLong("boid") + "--" + dy.getLong("businessstatus"), (val1, val2) -> val1));
                logger.info(MessageFormat.format("chgLoseOrEffect->{0}->{1}->{2}", type, key, tempMap));
            }
        }
        catch (Exception esc) {
            logger.error("printRetLogError", (Throwable)esc);
        }
    }

    protected Map<String, DynamicObjectCollection> structureEffectInfo(ChangeModel changeModel) {
        this.serviceHelper = new HRBaseServiceHelper(this.entityName);
        HashMap<String, DynamicObjectCollection> retMap = new HashMap<String, DynamicObjectCollection>(16);
        retMap.put(this.entityName, new DynamicObjectCollection());
        return retMap;
    }

    protected Map<String, DynamicObjectCollection> structureLoseEffectInfo(ChangeModel changeModel) {
        this.serviceHelper = new HRBaseServiceHelper(this.entityName);
        HashMap<String, DynamicObjectCollection> retMap = new HashMap<String, DynamicObjectCollection>(16);
        retMap.put(this.entityName, new DynamicObjectCollection());
        return retMap;
    }

    protected Map<String, DynamicObjectCollection> abstractEffect(ChangeModel changeModel, HRBaseServiceHelper service, String entity) {
        HashMap<String, DynamicObjectCollection> retMap = new HashMap<String, DynamicObjectCollection>(16);
        logger.info(MessageFormat.format("startAbstractEffectInfoWorkRole->{0}->{1}->{2}", changeModel, entity, this.entityName));
        DynamicObjectCollection rtDys = new DynamicObjectCollection();
        DynamicObject empDy = changeModel.getEmpDy();
        DynamicObject roleDy = changeModel.getRoleDy();
        String relEntityName = entity != null ? entity : this.entityName;
        DynamicObject dy = service != null ? service.generateEmptyDynamicObject() : this.serviceHelper.generateEmptyDynamicObject();
        this.buildEffectCommon(dy, empDy, relEntityName);
        if (roleDy != null) {
            HRBaseServiceHelper postHelper = new HRBaseServiceHelper("hbpm_workroleshr");
            long roleId = roleDy.getLong("id");
            DynamicObject dbRoleDy = postHelper.queryOne("id,adminorg,mainpeoincharge", (Object)roleId);
            if (dbRoleDy != null) {
                dy.set("role", (Object)dbRoleDy);
                dy.set("adminorg", dbRoleDy.get("adminorg"));
                dy.set("mainpeoincharge", dbRoleDy.get("mainpeoincharge"));
            }
        } else {
            logger.info("structureEffectInfoRoleEmpty", (Object)changeModel);
        }
        rtDys.add((Object)dy);
        if (rtDys.size() > 0) {
            retMap.put(relEntityName, rtDys);
        }
        if (dy.containsProperty("boid")) {
            logger.info(MessageFormat.format("abstractEffectBoId->{0}", dy.get("boid")));
        }
        logger.info(MessageFormat.format("abstractEffectRtMap->{0}", retMap.keySet()));
        return retMap;
    }

    protected Map<String, DynamicObjectCollection> abstractLoseEffect(ChangeModel changeModel, String entity) {
        Long chgType = changeModel.getChgType();
        boolean quitType = false;
        if (1070L == chgType) {
            quitType = true;
        }
        HashMap<String, DynamicObjectCollection> retMap = new HashMap<String, DynamicObjectCollection>(16);
        logger.info(MessageFormat.format("abstractLoseEffect->{0}->{1}->{2}", changeModel, this.entityName, entity));
        DynamicObjectCollection rtDys = new DynamicObjectCollection();
        DynamicObject empDy = changeModel.getEmpDy();
        long depId = empDy.getLong("depemp.id");
        if (depId == 0L) {
            logger.info("structureLoseEffectInfoDepEmpEmpty", (Object)changeModel);
            return retMap;
        }
        DynamicObject[] dbDys = null;
        if (HRStringUtils.isNotEmpty((String)entity)) {
            HRBaseServiceHelper service = new HRBaseServiceHelper(entity);
            dbDys = HelperRepository.getEffectDys(service, depId);
            this.copyLoseDy(dbDys, rtDys, empDy, service, quitType);
        } else {
            dbDys = HelperRepository.getEffectDys(this.serviceHelper, depId);
            this.copyLoseDy(dbDys, rtDys, empDy, this.serviceHelper, quitType);
        }
        if (rtDys.size() <= 0) {
            logger.info("structureLoseEffectInfoRoleEmpty", (Object)changeModel);
            return retMap;
        }
        if (HRStringUtils.isEmpty((String)entity)) {
            retMap.put(this.entityName, rtDys);
        } else {
            retMap.put(entity, rtDys);
        }
        logger.info(MessageFormat.format("abstractLoseEffectRtMap->{0}", retMap.keySet()));
        return retMap;
    }

    private void copyLoseDy(DynamicObject[] dbDys, DynamicObjectCollection rtDys, DynamicObject empDy, HRBaseServiceHelper serviceHelper, boolean quitType) {
        if (dbDys != null && dbDys.length > 0) {
            for (DynamicObject dbDy : dbDys) {
                DynamicObject newHis = serviceHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)dbDy, (DynamicObject)newHis);
                this.buildLoseEffectCommon(empDy, newHis, quitType);
                rtDys.add((Object)newHis);
            }
        } else {
            logger.info("structureCopyLoseDyEmpty");
        }
    }

    protected void buildLoseEffectCommon(DynamicObject empDy, DynamicObject dbDy, boolean quitType) {
        dbDy.set("bsed", empDy.get("bsed"));
        dbDy.set("bsled", empDy.get("bsled"));
        dbDy.set("id", (Object)0L);
        if (!quitType) {
            dbDy.set("businessstatus", (Object)"2");
        }
        dbDy.set("enddate", empDy.get("enddate"));
        dbDy.set("sysenddate", empDy.get("sysenddate"));
        dbDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dbDy.set("modifytime", (Object)new Date());
        dbDy.set("initstatus", (Object)"2");
    }

    protected void buildEffectCommon(DynamicObject dy, DynamicObject empDy, String entityName) {
        dy.set("id", (Object)ORM.create().genLongId(dy.getDynamicObjectType().getName()));
        dy.set("person", empDy.get("person"));
        dy.set("employee", empDy.get("employee"));
        if ("hrpi_personrolerel".equals(entityName)) {
            dy.set("cmpemp", empDy.get("cmpemp"));
        }
        dy.set("depemp", empDy.get("depemp"));
        this.buildMinEffectCommon(dy, empDy);
    }

    protected void buildMinEffectCommon(DynamicObject dy, DynamicObject empDy) {
        dy.set("bsled", empDy.get("bsled"));
        dy.set("bsed", empDy.get("bsed"));
        dy.set("businessstatus", (Object)"1");
        dy.set("iscurrentversion", (Object)"1");
        dy.set("startdate", empDy.get("startdate"));
        try {
            dy.set("enddate", (Object)HRDateTimeUtils.parseDate((String)"2999-12-31"));
            dy.set("sysenddate", (Object)HRDateTimeUtils.parseDate((String)"2999-12-31"));
        }
        catch (Exception exc) {
            logger.error("buildEffectCommonError", (Throwable)exc);
        }
        dy.set("creator", (Object)RequestContext.get().getCurrUserId());
        dy.set("createtime", (Object)new Date());
        dy.set("initstatus", (Object)"2");
    }
}

