/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service.relatiolservice.inst;

import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hpfs.business.service.relatiolservice.inst.AbstractChangeService;
import kd.hr.hpfs.business.service.relatiolservice.repository.HelperRepository;
import kd.hr.hpfs.common.model.ChangeModel;

public class ReportRelationChangeService
extends AbstractChangeService {
    private static final Log logger = LogFactory.getLog(ReportRelationChangeService.class);
    private static final Set<Long> INVALID_EMPSUPREL_CHGEVENT = Sets.newHashSet((Object[])new Long[]{1020L, 1070L, 1080L});

    @Override
    protected Map<String, DynamicObjectCollection> structureEffectInfo(ChangeModel changeModel) {
        HRBaseServiceHelper serviceHelper;
        Map<String, DynamicObjectCollection> tempMap;
        super.structureLoseEffectInfo(changeModel);
        logger.info("reportStructureEffectInfo->", (Object)changeModel);
        Map<String, DynamicObjectCollection> rtMap = super.structureEffectInfo(changeModel);
        DynamicObject empDy = changeModel.getEmpDy();
        List personIds = changeModel.getPersonId();
        DynamicObject[] mainFiles = HelperRepository.getMainFile(personIds);
        if (mainFiles == null || mainFiles.length == 0) {
            logger.info("structureEffectInfoErMainFileEmpty->", (Object)changeModel);
            return rtMap;
        }
        DynamicObjectCollection rtDys = this.handleSuperiorEffect(changeModel, empDy, personIds, mainFiles);
        if (rtDys.size() > 0) {
            rtMap.put(this.entityName, rtDys);
        }
        if ((tempMap = this.abstractEffect(changeModel, serviceHelper = new HRBaseServiceHelper("hrpi_personrolerel"), "hrpi_personrolerel")) != null && tempMap.size() > 0) {
            rtMap.putAll(tempMap);
        }
        return rtMap;
    }

    private DynamicObjectCollection handleSuperiorEffect(ChangeModel changeModel, DynamicObject empDy, List<Long> personIds, DynamicObject[] mainFiles) {
        Map<Long, DynamicObject> personModelMap = Arrays.stream(mainFiles).collect(Collectors.toMap(appDy -> appDy.getLong("person.id"), appDy -> appDy, (v1, v2) -> v1));
        List<Long> postIds = Arrays.stream(mainFiles).filter(dy -> dy.getLong("position.id") != 0L).map(dy -> dy.getLong("position.id")).collect(Collectors.toList());
        List stfPostIds = Arrays.stream(mainFiles).filter(dy -> dy.getLong("darkposition.id") != 0L).map(dy -> dy.getLong("darkposition.id")).collect(Collectors.toList());
        if (stfPostIds.size() > 0) {
            postIds.addAll(stfPostIds);
        }
        DynamicObjectCollection rtDys = new DynamicObjectCollection();
        Map<Long, DynamicObject> postMap = HelperRepository.getBaseDataMap(postIds, "hbpm_positionhr");
        for (Long personId : personIds) {
            DynamicObject roleDy;
            DynamicObject dy2 = this.serviceHelper.generateEmptyDynamicObject();
            this.buildEffectCommon(dy2, empDy, this.entityName);
            dy2.set("reporttype", (Object)1010L);
            DynamicObject fileDy = personModelMap.get(personId);
            if (fileDy == null) {
                logger.info(MessageFormat.format("structureEffectInfoSuperEmpty->{0}->{1}", personId, changeModel));
                continue;
            }
            dy2.set("superior", fileDy.get("person.id"));
            dy2.set("superioremployee", fileDy.get("employee.id"));
            dy2.set("superiordepemp", fileDy.get("depemp.id"));
            dy2.set("superioradminorg", fileDy.get("adminorg.id"));
            long postId = fileDy.getLong("position.id");
            if (postId == 0L) {
                postId = fileDy.getLong("darkposition.id");
            }
            if ((roleDy = postMap.get(postId)) == null) {
                logger.info(MessageFormat.format("structureEffectInfoSuperEmpty->{0}->{1}", personId, changeModel));
            } else {
                dy2.set("superiorrole", (Object)roleDy.getLong("id"));
            }
            rtDys.add((Object)dy2);
        }
        return rtDys;
    }

    @Override
    protected Map<String, DynamicObjectCollection> structureLoseEffectInfo(ChangeModel changeModel) {
        super.structureLoseEffectInfo(changeModel);
        logger.info("reportStructureLoseEffectInfo", (Object)changeModel);
        Map<String, DynamicObjectCollection> rtMap = super.structureLoseEffectInfo(changeModel);
        DynamicObjectCollection rtDys = new DynamicObjectCollection();
        DynamicObject empDy = changeModel.getEmpDy();
        Map<String, DynamicObjectCollection> roleMap = this.abstractLoseEffect(changeModel, "hrpi_personrolerel");
        Map<String, DynamicObjectCollection> supMap = this.abstractLoseEffect(changeModel, null);
        if (roleMap != null && roleMap.size() > 0) {
            rtMap.putAll(roleMap);
        }
        if (supMap != null && supMap.size() > 0) {
            rtMap.putAll(supMap);
        }
        Long chgType = changeModel.getChgType();
        logger.info(MessageFormat.format("reportStructureLoseEffect->{0}->{1}", changeModel, chgType));
        if (INVALID_EMPSUPREL_CHGEVENT.contains(chgType)) {
            String queryField = chgType == 1020L ? "superiordepemp" : "superioremployee";
            long queryId = chgType == 1020L ? empDy.getLong("depemp.id") : empDy.getLong("employee.id");
            QFilter customerQFilter = new QFilter(queryField, "=", (Object)queryId);
            DynamicObject[] effectSuperiorDys = HelperRepository.getEffectSuperiorByCustomerQFilter(customerQFilter);
            this.handleSuperiorLose(effectSuperiorDys, changeModel, rtDys);
            if (rtDys.size() > 0) {
                DynamicObjectCollection supTempMap = rtMap.get("hrpi_empsuprel");
                if (supTempMap != null && supTempMap.size() > 0) {
                    rtDys.addAll((Collection)supTempMap);
                }
                rtMap.put("hrpi_empsuprel", rtDys);
            }
        }
        return rtMap;
    }

    private void handleSuperiorLose(DynamicObject[] superiorDys, ChangeModel changeModel, DynamicObjectCollection rtDys) {
        DynamicObject empDy = changeModel.getEmpDy();
        for (DynamicObject superDy : superiorDys) {
            DynamicObject newHis = this.serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)superDy, (DynamicObject)newHis);
            this.buildLoseEffectCommon(empDy, newHis, false);
            rtDys.add((Object)newHis);
        }
    }

    private void creatNewSuperior(DynamicObject empDy, DynamicObject[] personByRole, DynamicObjectCollection newDys, DynamicObject oldDy, Map<Long, DynamicObject> personModelMap, long supPersonId) {
        List newSuperPersonIds = Arrays.stream(personByRole).filter(dy -> dy.getLong("person.id") != 0L).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        logger.info(MessageFormat.format("creatNewSuperior->{0}", newSuperPersonIds));
        for (Long newSuperId : newSuperPersonIds) {
            if (supPersonId == newSuperId) continue;
            DynamicObject newDy = this.serviceHelper.generateEmptyDynamicObject();
            this.buildMinEffectCommon(newDy, empDy);
            newDy.set("reporttype", (Object)1010L);
            newDy.set("superior", (Object)newSuperId);
            newDy.set("superiorrole", oldDy.get("superiorrole"));
            newDy.set("person", oldDy.get("person"));
            newDy.set("employee", oldDy.get("employee"));
            newDy.set("depemp", oldDy.get("depemp"));
            DynamicObject fileDy = personModelMap.get(newSuperId);
            if (fileDy == null) {
                logger.info(MessageFormat.format("structureEffectInfoSuperEmpty->{0}", newSuperId));
                continue;
            }
            newDy.set("superiordepemp", fileDy.get("depemp.id"));
            newDy.set("superior", fileDy.get("person.id"));
            newDy.set("superioremployee", fileDy.get("employee.id"));
            newDy.set("superioradminorg", fileDy.get("adminorg.id"));
            newDys.add((Object)newDy);
        }
    }
}

