/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service.relatiolservice.repository;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.hr.hspm.common.utils.QFilterUtil;

public class HelperRepository {
    private static final HRBaseServiceHelper HSPM_ERMANFILE = new HRBaseServiceHelper("hrpi_empposorgrel");
    private static final HRBaseServiceHelper HRPI_PERSONROLEREL = new HRBaseServiceHelper("hrpi_personrolerel");
    private static final HRBaseServiceHelper HRPI_EMPSUPREL = new HRBaseServiceHelper("hrpi_empsuprel");

    public static DynamicObject[] getPersonByRole(List<Long> roleIds) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hrpi_personrolerel");
        QFilter roleFilter = new QFilter("role.id", "in", roleIds);
        return baseServiceHelper.queryOriginalArray("person.id,role.id,id", new QFilter[]{roleFilter, HelperRepository.effectFilter(), HelperRepository.currentFilter(), QFilterUtil.getDataStatusFilter()});
    }

    public static DynamicObject[] getSuperiorByPersonIds(List<Long> personId) {
        QFilter perFilter = new QFilter("person", "in", personId);
        return HRPI_EMPSUPREL.loadDynamicObjectArray(new QFilter[]{perFilter, HelperRepository.effectFilter(), HelperRepository.currentFilter(), QFilterUtil.getDataStatusFilter()});
    }

    public static DynamicObject[] getEffectSuperiorByCustomerQFilter(QFilter customerQFilter) {
        return HRPI_EMPSUPREL.loadDynamicObjectArray(new QFilter[]{customerQFilter, HelperRepository.effectFilter(), HelperRepository.currentFilter(), QFilterUtil.getDataStatusFilter()});
    }

    public static DynamicObject[] getSuperiorByPersonId(String field, Long personId) {
        QFilter supFilter = new QFilter(field, "=", (Object)personId);
        return HRPI_EMPSUPREL.queryOriginalArray("id,person.id,superior.id,superiorrole.id", new QFilter[]{supFilter, HelperRepository.effectFilter(), HelperRepository.currentFilter(), QFilterUtil.getDataStatusFilter()});
    }

    public static DynamicObject[] getMainFile(List<Long> personIds) {
        QFilter primaryStatusQf = new QFilter("isprimary", "=", (Object)"1");
        QFilter empQf = new QFilter("person.id", "in", personIds);
        return HSPM_ERMANFILE.queryOriginalArray("person.id,employee.id,cmpemp.id,depemp.id,adminorg.id,position.id,stdposition.id,darkposition.id", new QFilter[]{empQf, primaryStatusQf, HelperRepository.effectFilter(), HelperRepository.currentFilter(), QFilterUtil.getDataStatusFilter()});
    }

    public static Map<Long, DynamicObject> getBaseDataMap(List<Long> postIds, String entityName) {
        HRBaseServiceHelper postHelper = new HRBaseServiceHelper(entityName);
        QFilter qFilter = new QFilter("id", "in", postIds);
        DynamicObject[] dynamicObjects = postHelper.queryOriginalArray("id,workrole", new QFilter[]{qFilter});
        return HelperRepository.buildDataMap(dynamicObjects);
    }

    private static Map<Long, DynamicObject> buildDataMap(DynamicObject[] employeeDys) {
        if (employeeDys != null && employeeDys.length > 0) {
            return Arrays.stream(employeeDys).collect(Collectors.toMap(appDy -> appDy.getLong("id"), appDy -> appDy, (v1, v2) -> v1));
        }
        return new HashMap<Long, DynamicObject>(16);
    }

    public static DynamicObject[] getEffectDys(HRBaseServiceHelper service, long depId) {
        QFilter depFilter = new QFilter("depemp", "=", (Object)depId);
        return service.loadDynamicObjectArray(new QFilter[]{depFilter, HelperRepository.effectFilter(), HelperRepository.currentFilter()});
    }

    private static QFilter effectFilter() {
        return new QFilter("businessstatus", "=", (Object)"1");
    }

    private static QFilter currentFilter() {
        return new QFilter("iscurrentversion", "=", (Object)"1");
    }
}

