/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service.repeatnumber;

import com.alibaba.druid.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.parser.ParserResult;
import kd.hr.hpfs.common.constants.ChgStrategyConstants;
import kd.hr.hpfs.common.model.PreEmployeeModel;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.executor.model.ChgRecordEntryDto;

public class GenerateReplaceNumberHelper {
    private static final Log LOGGER = LogFactory.getLog(GenerateReplaceNumberHelper.class);
    private static final GenerateReplaceNumberHelper GENERATE_REPLACE_NUMBER = new GenerateReplaceNumberHelper();
    private static final HRBaseServiceHelper EMPLOYEE_HELPER = new HRBaseServiceHelper("hrpi_employee");

    public static GenerateReplaceNumberHelper getInstance() {
        return GENERATE_REPLACE_NUMBER;
    }

    public PreEmployeeModel getPreEmployeeMsg(List<ParserResult> parserResults, PerChgBizInfo bizInfo) {
        DynamicObject entityInfo = this.getEntityInfo(parserResults, "hrpi_empentrel");
        if (entityInfo == null) {
            LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#findEmptyNumber");
            return null;
        }
        Long oldEmployeeId = bizInfo.getOldEmployeeId();
        Long oldPersonId = bizInfo.getOldPersonId();
        return this.getPreEmployeeModel(entityInfo.getString("empnumber"), oldEmployeeId, oldPersonId);
    }

    public PreEmployeeModel getPreEmployeeMsg(List<ParserResult> parserResults, Map<String, List<DynamicObject>> sourceData, PerChgBizInfo bizInfo, DynamicObject chgActionInfo, DynamicObject chgRuleInfo, Map<String, String> paramMap) {
        DynamicObject entityInfo = this.getEntityInfo(parserResults, "hrpi_empentrel");
        if (entityInfo == null) {
            LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#findEmptyNumber");
            return null;
        }
        Long oldEmployeeId = bizInfo.getOldEmployeeId();
        Long oldPersonId = bizInfo.getOldPersonId();
        return this.getPreEmployeeByDbOrContext(entityInfo.getString("empnumber"), oldEmployeeId, oldPersonId, parserResults, sourceData, bizInfo, chgActionInfo, chgRuleInfo, paramMap);
    }

    private PreEmployeeModel getPreEmployeeByDbOrContext(String onBrdNumber, Long oldEmployeeId, Long oldPersonId, List<ParserResult> parserResults, Map<String, List<DynamicObject>> sourceData, PerChgBizInfo bizInfo, DynamicObject chgActionInfo, DynamicObject chgRuleInfo, Map<String, String> paramMap) {
        if (HRStringUtils.isEmpty((String)onBrdNumber)) {
            LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#emptyNumber");
            return null;
        }
        Object[] quitEmployeeArr = this.queryPersonByNumber(onBrdNumber, "=", "quit");
        if (HRArrayUtils.isEmpty((Object[])quitEmployeeArr)) {
            DynamicObject updateDy = this.getEntityInfoSingle(parserResults, "hrpi_empentrel", false);
            if (updateDy != null) {
                DynamicObject addDy = this.getEntityInfoSingle(parserResults, "hrpi_empentrel", true);
                if (addDy == null) {
                    LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#findContextAddEmptyNumber");
                    return null;
                }
                return this.toReplaceNumber(parserResults, sourceData, bizInfo, chgActionInfo, chgRuleInfo, paramMap, addDy);
            }
        } else if (quitEmployeeArr.length > 2) {
            LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#number not only one");
            return null;
        }
        return this.generateOldEmployeeInfo(onBrdNumber, oldEmployeeId, oldPersonId);
    }

    private PreEmployeeModel toReplaceNumber(List<ParserResult> parserResults, Map<String, List<DynamicObject>> sourceData, PerChgBizInfo bizInfo, DynamicObject chgActionInfo, DynamicObject chgRuleInfo, Map<String, String> paramMap, DynamicObject addDy) {
        String addNumber = addDy.getString("empnumber");
        PreEmployeeModel preEmployeeModelByContext = this.getPreEmployeeModelByContextOrDb(parserResults, addNumber, 0L, 0L);
        if (preEmployeeModelByContext == null) {
            LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#findContextEmptyNumber");
            return null;
        }
        this.replaceOldNumber("hrpi_employee", parserResults, preEmployeeModelByContext, addNumber, bizInfo, "0", chgActionInfo, chgRuleInfo, paramMap, sourceData);
        this.replaceOldNumber("hrpi_empentrel", parserResults, preEmployeeModelByContext, addNumber, bizInfo, "0", chgActionInfo, chgRuleInfo, paramMap, sourceData);
        Set<String> entityNameSet = this.numberEntity();
        for (String entityName : entityNameSet) {
            this.replaceOldNumber(entityName, parserResults, preEmployeeModelByContext, addNumber, bizInfo, "0", chgActionInfo, chgRuleInfo, paramMap, sourceData);
        }
        LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#queryQuitPersonEmpty");
        return null;
    }

    public Set<String> allNumberEntity() {
        Set<String> entityNameSet = this.numberEntity();
        entityNameSet.add("hrpi_employee");
        entityNameSet.add("hrpi_empentrel");
        return entityNameSet;
    }

    public Set<String> numberEntity() {
        HashSet<String> entityNameSet = new HashSet<String>(4);
        entityNameSet.add("hrpi_person");
        entityNameSet.add("hrpi_depemp");
        entityNameSet.add("hrpi_empposorgrel");
        entityNameSet.add("hspm_ermanfile");
        return entityNameSet;
    }

    public DynamicObject getEntityInfo(List<ParserResult> parserResults, String queryEntityName) {
        for (ParserResult parserResult : parserResults) {
            DynamicObject entrDy;
            Object hisObj;
            String entityName;
            Map<String, Object> parserParam = parserResult.getParserParam();
            Object entObj = parserParam.get("entityName");
            if (entObj instanceof String && !queryEntityName.equals(entityName = (String)parserParam.get("entityName")) || !((hisObj = parserParam.get("hisDy")) instanceof DynamicObject) || (entrDy = (DynamicObject)hisObj).getLong("boid") != 0L) continue;
            return entrDy;
        }
        return null;
    }

    private DynamicObject getEntityInfoSingle(List<ParserResult> parserResults, String queryEntityName, boolean findAdd) {
        List<DynamicObject> entityInfo = this.getEntityInfo(parserResults, queryEntityName, findAdd);
        for (DynamicObject entity : entityInfo) {
            if (!HRStringUtils.isNotEmpty((String)entity.getString("empnumber"))) continue;
            return entity;
        }
        return null;
    }

    private Map<Long, DynamicObject> getEntityInfoMap(List<ParserResult> parserResults, String queryEntityName, boolean findAdd) {
        List<DynamicObject> entityInfo = this.getEntityInfo(parserResults, queryEntityName, findAdd);
        return entityInfo.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy, (k1, k2) -> k1));
    }

    private List<DynamicObject> getEntityInfo(List<ParserResult> parserResults, String queryEntityName, boolean findAdd) {
        ArrayList<DynamicObject> addEntityList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> updateEntityList = new ArrayList<DynamicObject>(10);
        for (ParserResult parserResult : parserResults) {
            Object hisObj;
            String entityName;
            Map<String, Object> parserParam = parserResult.getParserParam();
            Object entObj = parserParam.get("entityName");
            if (entObj instanceof String && !queryEntityName.equals(entityName = (String)parserParam.get("entityName")) || !((hisObj = parserParam.get("hisDy")) instanceof DynamicObject)) continue;
            DynamicObject entrDy = (DynamicObject)hisObj;
            if (findAdd) {
                if (entrDy.getLong("boid") != 0L) continue;
                addEntityList.add(entrDy);
                continue;
            }
            if (entrDy.getLong("boid") == 0L) continue;
            updateEntityList.add(entrDy);
        }
        if (findAdd) {
            return addEntityList;
        }
        return updateEntityList;
    }

    public PreEmployeeModel getPreEmployeeInfo(List<ParserResult> parserResults, PerChgBizInfo bizInfo, Map<String, List<DynamicObject>> sourceData, DynamicObject chgActionInfo, DynamicObject chgRuleInfo, Map<String, String> paramMap) {
        String viewTypeProp = paramMap.get("viewtype");
        if (HRStringUtils.isEmpty((String)viewTypeProp)) {
            viewTypeProp = "viewtype";
        }
        List<DynamicObject> onBrdBillDys = sourceData.get(bizInfo.getBillSource());
        DynamicObject onBrdBillDy = onBrdBillDys.get(0);
        String viewType = onBrdBillDy.getString(viewTypeProp);
        DynamicObject entityInfo = this.getEntityInfo(parserResults, "hrpi_empentrel");
        if (entityInfo == null) {
            LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#isEmptyNumber");
            return null;
        }
        String onBrdNumber = entityInfo.getString("empnumber");
        Long oldEmployeeId = 0L;
        Long oldPersonId = 0L;
        if ("2".equals(viewType)) {
            oldEmployeeId = bizInfo.getOldEmployeeId() == null ? oldEmployeeId : bizInfo.getOldEmployeeId();
            oldPersonId = bizInfo.getOldPersonId();
        }
        return this.getPreEmployeeModelByContextOrDb(parserResults, onBrdNumber, oldEmployeeId, oldPersonId);
    }

    public PreEmployeeModel getPreEmployeeInfo(Map<String, List<DynamicObject>> sourceData, PerChgBizInfo bizInfo) {
        List<DynamicObject> onBrdBillDys = sourceData.get(bizInfo.getBillSource());
        DynamicObject onBrdBillDy = onBrdBillDys.get(0);
        String onBrdNumber = onBrdBillDy.getString("employeeno");
        String viewType = onBrdBillDy.getString("viewtype");
        Long oldEmployeeId = 0L;
        Long oldPersonId = 0L;
        if ("2".equals(viewType)) {
            oldEmployeeId = bizInfo.getOldEmployeeId() == null ? oldEmployeeId : bizInfo.getOldEmployeeId();
            oldPersonId = bizInfo.getOldPersonId();
        }
        return this.getPreEmployeeModel(onBrdNumber, oldEmployeeId, oldPersonId);
    }

    public Map<String, Object> getOldNumber(String newNumber) {
        HashMap<String, Object> retMap = new HashMap<String, Object>(10);
        PreEmployeeModel preEmployeeModel = this.getPreEmployeeModel(newNumber, 0L, 0L);
        if (preEmployeeModel != null) {
            retMap.put("oldempnumber", preEmployeeModel.getOldNumber());
            return retMap;
        }
        return retMap;
    }

    private PreEmployeeModel getPreEmployeeModelByContextOrDb(List<ParserResult> parserResults, String onBrdNumber, Long oldEmployeeId, Long oldPersonId) {
        if (HRStringUtils.isEmpty((String)onBrdNumber)) {
            LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#emptyNumber");
            return null;
        }
        Object[] quitEmployeeArr = this.queryPersonByNumber(onBrdNumber, "=", "quit");
        if (HRArrayUtils.isEmpty((Object[])quitEmployeeArr)) {
            DynamicObject addDy;
            DynamicObject entityInfo = this.getEntityInfoSingle(parserResults, "hrpi_empentrel", false);
            LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#queryQuitPersonEmpty");
            if (entityInfo != null && (addDy = this.getEntityInfoSingle(parserResults, "hrpi_empentrel", true)) != null) {
                LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#findcontextdata");
                return this.generateOldEmployeeInfo(addDy.getString("empnumber"), 0L, 0L);
            }
            return null;
        }
        if (quitEmployeeArr.length > 2) {
            LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#number not only one");
            return null;
        }
        return this.generateOldEmployeeInfo(onBrdNumber, oldEmployeeId, oldPersonId);
    }

    private PreEmployeeModel getPreEmployeeModel(String onBrdNumber, Long oldEmployeeId, Long oldPersonId) {
        if (HRStringUtils.isEmpty((String)onBrdNumber)) {
            LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#emptyNumber");
            return null;
        }
        Object[] quitEmployeeArr = this.queryPersonByNumber(onBrdNumber, "=", "quit");
        if (HRArrayUtils.isEmpty((Object[])quitEmployeeArr)) {
            LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#queryQuitPersonEmpty");
            return null;
        }
        if (quitEmployeeArr.length > 2) {
            LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#number not only one");
            return null;
        }
        return this.generateOldEmployeeInfo(onBrdNumber, oldEmployeeId, oldPersonId);
    }

    private PreEmployeeModel generateOldEmployeeInfo(String onBrdNumber, Long oldEmployeeId, Long oldPersonId) {
        int maxRSuffix = 0;
        DynamicObject[] vagueEmployeeArr = this.queryPersonByNumber(onBrdNumber + "%", "like", "onboarding");
        List idAndNumberList = Arrays.stream(vagueEmployeeArr).map(dy -> dy.getString("empnumber") + "-" + dy.getLong("id")).collect(Collectors.toList());
        LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#oldNumberList->{}-->{}-->{}", new Object[]{idAndNumberList, oldEmployeeId, oldPersonId});
        for (DynamicObject quitEmployeeDy : vagueEmployeeArr) {
            String tmpMaxRIndex;
            String number = quitEmployeeDy.getString("empnumber");
            boolean suffixR = GenerateReplaceNumberHelper.isSuffixR(onBrdNumber, number);
            if ((oldEmployeeId == null || oldEmployeeId == 0L) && onBrdNumber.equals(number)) {
                oldEmployeeId = quitEmployeeDy.getLong("id");
                oldPersonId = quitEmployeeDy.getLong("person.id");
            }
            if (!suffixR || !HRStringUtils.isNotEmpty((String)(tmpMaxRIndex = number.substring(number.lastIndexOf("-R") + 2))) || !StringUtils.isNumber((String)tmpMaxRIndex)) continue;
            maxRSuffix = Math.max(maxRSuffix, Integer.parseInt(tmpMaxRIndex));
        }
        if (oldEmployeeId == null || oldEmployeeId == 0L || oldPersonId == null || oldPersonId == 0L) {
            LOGGER.warn("NumberRepeatAfterDataFormatServiceImpl#employeeIdError->{}", idAndNumberList);
            return null;
        }
        String newNumber = onBrdNumber + "-R" + (maxRSuffix + 1);
        LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#employeeId->{}->{}->{}", new Object[]{oldEmployeeId, newNumber, oldPersonId});
        return new PreEmployeeModel(oldEmployeeId, oldPersonId, newNumber);
    }

    private DynamicObject[] queryPersonByNumber(String number, String term, String status) {
        QFilter[] qFilters = null;
        QFilter qFilter = new QFilter("empnumber", term, (Object)number);
        QFilter sFilter = this.getInitStatusFilter();
        QFilter cFilter = this.getCurrentVersionFilter();
        QFilter dFilter = this.getDataStatusFilter();
        if ("quit".equals(status)) {
            QFilter filter = new QFilter("laborrelstatus.labrelstatusprd", "=", (Object)ChgStrategyConstants.LABREL_STATUSPRD_ID);
            qFilters = new QFilter[]{filter, qFilter, cFilter, sFilter, dFilter};
        } else {
            qFilters = new QFilter[]{qFilter, cFilter, sFilter, dFilter};
        }
        return EMPLOYEE_HELPER.query("person,id,empnumber", qFilters);
    }

    private static boolean isSuffixR(String matchNumber, String oldNumber) {
        String MAIL_REG = "^" + matchNumber + "-R" + "[0-9]{1,60}";
        Pattern PATTERN = Pattern.compile(MAIL_REG);
        Matcher matcher = PATTERN.matcher(oldNumber);
        return matcher.matches();
    }

    public QFilter getDataStatusFilter() {
        return new QFilter("datastatus", "in", (Object)"1");
    }

    public QFilter getCurrentVersionFilter() {
        return new QFilter("iscurrentversion", "=", (Object)"1");
    }

    public QFilter getInitStatusFilter() {
        return new QFilter("initstatus", "=", (Object)"2");
    }

    public void replaceOldNumber(String entityName, List<ParserResult> parserResults, PreEmployeeModel preEmployeeModel, String onBrdNumber, PerChgBizInfo bizInfo, String replaceFormDb, DynamicObject chgActionInfo, DynamicObject chgRuleInfo, Map<String, String> paramMap, Map<String, List<DynamicObject>> sourceData) {
        Set<String> entityNameSet = this.numberEntity();
        Long oldEmployeeId = preEmployeeModel.getOldEmployeeId();
        Long oldPersonId = preEmployeeModel.getOldPersonId();
        String oldNumber = preEmployeeModel.getOldNumber();
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper(entityName);
        Object[] entityDys = this.queryEntityData(entityName, oldEmployeeId, oldPersonId, entityHelper);
        if (HRArrayUtils.isEmpty((Object[])entityDys)) {
            LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#getAndResetUpdateEntityEmpty");
            return;
        }
        long[] tmpIds = ORM.create().genLongIds(entityName, entityDys.length);
        ArrayList<String> numberList = new ArrayList<String>(10);
        HashMap<String, Map<Long, DynamicObject>> entityDataMap = new HashMap<String, Map<Long, DynamicObject>>(16);
        if (!"1".equals(replaceFormDb)) {
            Map<Long, DynamicObject> entityInfoMap = this.getEntityInfoMap(parserResults, entityName, false);
            entityDataMap.put(entityName, entityInfoMap);
        }
        for (int idx = 0; idx < entityDys.length; ++idx) {
            boolean needAdd = true;
            Object dbDy = entityDys[idx];
            if ("1".equals(replaceFormDb)) {
                this.replaceNumber(entityName, onBrdNumber, entityNameSet, oldNumber, numberList, (DynamicObject)dbDy, false, parserResults);
            } else {
                Map entityData = (Map)entityDataMap.get(entityName);
                DynamicObject contextDy = (DynamicObject)entityData.get(dbDy.getLong("boid"));
                if (contextDy != null) {
                    needAdd = false;
                    this.replaceNumber(entityName, onBrdNumber, entityNameSet, oldNumber, numberList, contextDy, true, parserResults);
                }
            }
            if (!needAdd) continue;
            this.addParserResultData(entityName, parserResults, bizInfo, entityHelper, tmpIds[idx], (DynamicObject)dbDy);
        }
        LOGGER.info("NumberRepeatAfterDataFormatServiceImpl#setFinish-->{}-->{}", (Object)entityName, numberList);
    }

    private void replaceNumber(String entityName, String onBrdNumber, Set<String> entityNameSet, String oldNumber, List<String> numberList, DynamicObject dbDy, boolean updateContext, List<ParserResult> parserResults) {
        if (entityNameSet.contains(entityName)) {
            this.replaceOldNumberByBrdNumber(entityName, oldNumber, dbDy, "number", numberList, onBrdNumber, updateContext, parserResults);
        } else if ("hrpi_employee".equals(entityName)) {
            this.replaceOldNumberByBrdNumber(entityName, oldNumber, dbDy, "empnumber", numberList, onBrdNumber, updateContext, parserResults);
        } else if ("hrpi_empentrel".equals(entityName)) {
            this.replaceOldNumberByBrdNumber(entityName, oldNumber, dbDy, "number", numberList, onBrdNumber, updateContext, parserResults);
            if (HRStringUtils.isNotEmpty((String)oldNumber)) {
                dbDy.set("empnumber", (Object)oldNumber);
            }
        }
    }

    private void addParserResultData(String entityName, List<ParserResult> parserResults, PerChgBizInfo bizInfo, HRBaseServiceHelper entityHelper, long tmpId, DynamicObject dbDy) {
        DynamicObject newHis = entityHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)dbDy, (DynamicObject)newHis);
        newHis.set("modifier", (Object)RequestContext.get().getCurrUserId());
        newHis.set("modifytime", (Object)new Date());
        newHis.set("id", (Object)tmpId);
        this.setIdsRecord(entityName, dbDy, newHis, bizInfo);
        ParserResult parserResult = new ParserResult();
        ConcurrentHashMap<String, Object> parserParam = new ConcurrentHashMap<String, Object>(4);
        parserParam.put("entityName", entityName);
        parserParam.put("hisDy", newHis);
        parserResult.setParserParam(parserParam);
        parserResults.add(parserResult);
    }

    private DynamicObject[] queryEntityData(String entityName, Long oldEmployeeId, Long oldPersonId, HRBaseServiceHelper entityHelper) {
        QFilter eFilter = null;
        eFilter = "hrpi_employee".equals(entityName) ? new QFilter("id", "=", (Object)oldEmployeeId) : ("hrpi_person".equals(entityName) ? new QFilter("id", "=", (Object)oldPersonId) : new QFilter("person", "=", (Object)oldPersonId));
        QFilter sFilter = this.getInitStatusFilter();
        QFilter cFilter = this.getCurrentVersionFilter();
        QFilter dFilter = this.getDataStatusFilter();
        return entityHelper.loadDynamicObjectArray(new QFilter[]{cFilter, sFilter, eFilter, dFilter});
    }

    private void setIdsRecord(String entityNumber, DynamicObject source, DynamicObject newHis, PerChgBizInfo bizInfo) {
        long idBefore = source.getLong("id");
        Long vidBefore = source.getDataEntityType().getProperties().get((Object)"sourcevid") != null ? source.getLong("sourcevid") : idBefore;
        Long idNew = newHis.getLong("id");
        bizInfo.setIdsRecord(entityNumber, ChgRecordEntryDto.formatRecord((Long)idBefore, (Long)vidBefore, (Long)idBefore, (Long)idNew, (String)"1", (String)"0"));
    }

    private void replaceOldNumberByBrdNumber(String entityName, String oldNumber, DynamicObject dbDy, String field, List<String> numberList, String onBrdNumber, boolean updateContext, List<ParserResult> parserResults) {
        String numberField = dbDy.getString(field);
        String newNumber = numberField.replaceFirst(onBrdNumber, oldNumber);
        if (HRStringUtils.isNotEmpty((String)newNumber)) {
            dbDy.set(field, (Object)newNumber);
        }
        if (!updateContext) {
            numberList.add(dbDy.getLong("id") + "_" + dbDy.getDataEntityType().getName() + "_" + field + "_" + newNumber);
            return;
        }
        for (ParserResult parserResult : parserResults) {
            DynamicObject entrDy;
            long contextBoId;
            Object hisObj;
            String conEntityName;
            Map<String, Object> parserParam = parserResult.getParserParam();
            Object entObj = parserParam.get("entityName");
            if (!(entObj instanceof String) || !entityName.equals(conEntityName = (String)parserParam.get("entityName")) || !((hisObj = parserParam.get("hisDy")) instanceof DynamicObject) || (contextBoId = (entrDy = (DynamicObject)hisObj).getLong("boid")) == 0L) continue;
            if (entrDy.getLong("boid") == dbDy.getLong("boid")) {
                entrDy.set(field, (Object)newNumber);
            }
            if (!"hrpi_empentrel".equals(entityName) || !HRStringUtils.isNotEmpty((String)oldNumber)) continue;
            dbDy.set("empnumber", (Object)oldNumber);
        }
        numberList.add(dbDy.getDataEntityType().getName() + "-" + field + "-" + newNumber);
    }
}

