/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.task;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.web.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hpfs.business.domain.repository.RepositoryUtils;

public class FixChgTemplateExtMetaTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(FixChgTemplateExtMetaTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_formmeta");
            DynamicObject[] formsNeedToFix = serviceHelper.query("id,number", new QFilter[]{new QFilter("inheritpath", "like", (Object)"%20S9N+XAVPH7%"), new QFilter("isv", "!=", (Object)"kingdee").or(new QFilter("number", "like", (Object)"%\\_ext"))});
            LOGGER.info("Form Meta Need To Fix:{}", (Object)formsNeedToFix.toString());
            for (DynamicObject form : formsNeedToFix) {
                String id = form.getString("id");
                List deployFiles = MetadataDao.getFormDeployFile((String)id);
                this.findOriginParentAndFix(deployFiles);
            }
            String schScheduleId = "4/SWC2Z581B0";
            RepositoryUtils.disableTask("sch_schedule", schScheduleId);
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
    }

    private void findOriginParentAndFix(List<DeployFile> deployFiles) {
        String deployFileString = deployFiles.get(0).getFileContent();
        List<AbstractDesignMeta> designMetas = this.getAbstractDesignMetas(deployFileString);
        DesignFormMeta designFormMeta = this.getDesignFormMeta(designMetas);
        List parentDeployFiles = MetadataDao.getFormDeployFile((String)designFormMeta.getParentId());
        String parentDeployFileString = ((DeployFile)parentDeployFiles.get(0)).getFileContent();
        List<AbstractDesignMeta> parentDesignMetas = this.getAbstractDesignMetas(parentDeployFileString);
        DesignFormMeta parentDesignFormMeta = this.getDesignFormMeta(parentDesignMetas);
        if (this.isExtMeta(parentDesignFormMeta)) {
            parentDeployFiles = MetadataDao.getFormDeployFile((String)parentDesignFormMeta.getParentId());
            this.findOriginParentAndFix(parentDeployFiles);
        }
        this.fixInhertPath(deployFileString, designFormMeta, parentDesignFormMeta);
    }

    private void fixInhertPath(String deployFileString, DesignFormMeta designFormMeta, DesignFormMeta parentDesignFormMeta) {
        String childInheritPath = designFormMeta.getInheritPath();
        String childId = designFormMeta.getId();
        String parentInheritPath = parentDesignFormMeta.getInheritPath();
        String parentId = parentDesignFormMeta.getId();
        LOGGER.info("designFormMeta:{}", (Object)designFormMeta.getNumber());
        LOGGER.info("childInheritPath:{}", (Object)childInheritPath);
        LOGGER.info("parentInheritPath:{}", (Object)parentInheritPath);
        if (!parentInheritPath.endsWith(parentId)) {
            parentInheritPath = parentInheritPath + "," + parentId;
        }
        if (!childInheritPath.contains(parentInheritPath)) {
            String childInhertPathWithoutSelf = childInheritPath;
            if (childInheritPath.endsWith(childId)) {
                childInhertPathWithoutSelf = childInheritPath.subSequence(0, childInheritPath.lastIndexOf("," + childId)).toString();
            }
            LOGGER.info("parentInheritPathAfter:{}", (Object)parentInheritPath);
            LOGGER.info("childInhertPathWithoutSelf:{}", (Object)childInhertPathWithoutSelf);
            deployFileString = deployFileString.replaceAll(childInhertPathWithoutSelf.replaceAll("\\+", "\\\\+").replaceAll("\\/", "\\\\/"), parentInheritPath);
            MetadataDao.deployMetadata((String)deployFileString, (String)MetadataDao.getUnitIdFromUnitrel((String)designFormMeta.getId()), (String)designFormMeta.getBizappId());
            DynamicObject bizapp = BusinessDataServiceHelper.loadSingleFromCache((Object)designFormMeta.getBizappId(), (String)"bos_devportal_bizapp", (String)"id, number");
            try {
                DispatchServiceHelper.invokeBOSServiceByAppId((String)"bos", (String)"MetadataService", (String)"rebuildFormRuntimeMeta", (Object[])new Object[]{designFormMeta.getNumber()});
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    private boolean isExtMeta(DesignFormMeta designFormMeta) {
        if (null == designFormMeta) {
            return false;
        }
        return designFormMeta.getNumber().endsWith("_ext") || !designFormMeta.getIsv().equals("kingdee");
    }

    private List<AbstractDesignMeta> getAbstractDesignMetas(String deployFileString) {
        DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(deployFileString, null);
        return deployNew.getDesignMetas();
    }

    private DesignFormMeta getDesignFormMeta(List<AbstractDesignMeta> designMetas) {
        for (AbstractDesignMeta designMeta : designMetas) {
            if (!(designMeta instanceof DesignFormMeta)) continue;
            return (DesignFormMeta)designMeta;
        }
        throw new KDBizException("No DesignFormMeta:" + designMetas.toString());
    }
}

