/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.validator;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hr.impt.core.validate.AbstractValidateHandler;
import kd.hrmp.hrpi.business.domian.repository.HRPIBlackListRepository;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;

public class BlackListImportValidatorHelper
extends AbstractValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(BlackListImportValidatorHelper.class);

    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.AFTER;
    }

    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        QFilter idFilter = new QFilter("id", ">", (Object)0L);
        DynamicObject[] dynamicObjects = HRPIBlackListRepository.getInstance().queryByFilter("", new QFilter[]{idFilter});
        HashMap<String, DynamicObject> namePhoneMap = new HashMap<String, DynamicObject>(dynamicObjects.length);
        Arrays.stream(dynamicObjects).forEach(dy -> {
            String name = dy.getString("name");
            String phone = dy.getString("phone");
            namePhoneMap.put(name + "-" + phone, (DynamicObject)dy);
        });
        for (ImportBillData importBillData : billDataList) {
            try {
                this.cardAboutValidate(importBillData, importLog);
                this.phoneFormatValidate(importBillData, importLog);
                this.adminorOrgPermissionValidate(importBillData, importLog);
                this.dataDuplicateValidate(importBillData, importLog, namePhoneMap);
            }
            catch (Exception exe) {
                LOGGER.error("BlackListImportValidatorHelper.validate.exception", (Throwable)exe);
                importLog.writeRowLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), exe.getMessage());
            }
        }
    }

    private void cardAboutValidate(ImportBillData importBillData, ImportLog importLog) {
        JSONObject billData = this.getBillData(importBillData);
        Boolean mainCardInfoIsFull = this.checkCardInfoIsFull(importBillData, importLog, "maincardtype", "maincardnumber");
        Boolean cardInfoIsFull = this.checkCardInfoIsFull(importBillData, importLog, "cardtypeimport", "cardnumberimport");
        Object mainCardTypeObj = billData.get((Object)"maincardtype");
        Object cardTypeObj = billData.get((Object)"cardtypeimport");
        if (mainCardInfoIsFull.booleanValue() && cardInfoIsFull.booleanValue() && !HRObjectUtils.isEmpty((Object)cardTypeObj) && HRObjectUtils.isEmpty((Object)mainCardTypeObj)) {
            String errorMsg = ResManager.loadKDString((String)"\u5fc5\u987b\u5b58\u5728\u4e00\u6761\u4e3b\u8bc1\u4ef6\u4fe1\u606f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BlackListImportValidatorHelper_2", (String)"hr-hpfs-business", (Object[])new Object[0]);
            importLog.writeRowLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), errorMsg);
        }
        Object maincardnumber = billData.get((Object)"maincardnumber");
        Object cardnumber = billData.get((Object)"cardnumberimport");
        String checkResultMain = this.checkIdFormat(mainCardTypeObj, maincardnumber);
        String checkResult = this.checkIdFormat(cardTypeObj, cardnumber);
        if (HRStringUtils.isNotEmpty((String)checkResultMain) || HRStringUtils.isNotEmpty((String)checkResult)) {
            importLog.writeRowLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), HRStringUtils.isNotEmpty((String)checkResultMain) ? checkResultMain : checkResult);
        }
    }

    private void phoneFormatValidate(ImportBillData importBillData, ImportLog importLog) {
        boolean phoneCheckResult;
        String errMsg;
        JSONObject billData = this.getBillData(importBillData);
        String phone = this.assemblePhoneWithLocationCode(billData);
        if (String.valueOf(billData.get((Object)"email")).toCharArray().length > 50) {
            errMsg = ResManager.loadKDString((String)"\u90ae\u7bb1\u5730\u5740\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u8bd5\u3002", (String)"BlackListImportValidatorHelper_8", (String)"hr-hpfs-business", (Object[])new Object[0]);
            importLog.writeRowLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), errMsg);
        }
        if (phone.toCharArray().length > 30) {
            errMsg = ResManager.loadKDString((String)"\u7535\u8bdd\u53f7\u7801\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730\u4f4d\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u8bd5\u3002", (String)"BlackListImportValidatorHelper_7", (String)"hr-hpfs-business", (Object[])new Object[0]);
            importLog.writeRowLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), errMsg);
        }
        if (!(phoneCheckResult = CommonServiceUtil.validatePhone((String)phone))) {
            String errMsg2 = ResManager.loadKDString((String)"\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BlackListImportValidatorHelper_3", (String)"hr-hpfs-business", (Object[])new Object[0]);
            importLog.writeRowLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), errMsg2);
        }
    }

    private void adminorOrgPermissionValidate(ImportBillData importBillData, ImportLog importLog) {
        JSONObject adminororg;
        Long adminId;
        List hasPermOrgs;
        JSONObject billData = this.getBillData(importBillData);
        long userId = RequestContext.get().getCurrUserId();
        AuthorizedOrgResult result = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserAdminOrgsF7", (Object[])new Object[]{userId, "hpfs", "hpfs_blacklist", "47150e89000000ac", "adminororg", new HashMap()});
        if (!result.isHasAllOrgPerm() && !(hasPermOrgs = result.getHasPermOrgs()).contains(adminId = (Long)(adminororg = (JSONObject)billData.get((Object)"adminororg")).get((Object)"id"))) {
            String errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709%1$s\u7684\u6570\u636e\u8bbf\u95ee\u6743\u9650\uff0c\u65e0\u6cd5\u521b\u5efa\u8be5\u7ec4\u7ec7\u4e0b\u7684\u9ed1\u540d\u5355\u4eba\u5458\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u4fee\u6539\u6743\u9650\u8303\u56f4\u540e\u518d\u8bd5\u3002", (String)"BlackListImportValidatorHelper_4", (String)"hr-hpfs-business", (Object[])new Object[0]), adminororg.getString("name"));
            importLog.writeRowLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), errMsg);
        }
    }

    private void dataDuplicateValidate(ImportBillData importBillData, ImportLog importLog, Map<String, DynamicObject> namePhoneMap) {
        JSONObject billData = this.getBillData(importBillData);
        String name = String.valueOf(billData.get((Object)"name"));
        String phone = this.assemblePhoneWithLocationCode(billData);
        if (!HRObjectUtils.isEmpty((Object)namePhoneMap.get(name + "-" + phone))) {
            DynamicObject dyObj = namePhoneMap.get(name + "-" + phone);
            String errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u5df2\u7ecf\u88ab\u52a0\u5165\u9ed1\u540d\u5355\uff0c\u65e0\u9700\u91cd\u590d\u6dfb\u52a0\u3002\uff08\u6dfb\u52a0\u539f\u56e0\uff1a%3$s\uff1b\u5907\u6ce8\uff1a%4$s\uff1b\u9ed1\u540d\u5355\u7ba1\u7406\u7ec4\u7ec7\uff1a%5$s\uff0c\u6dfb\u52a0\u4eba\uff1a%6$s\uff1b\u6dfb\u52a0\u65f6\u95f4\uff1a%7$s\uff09\u3002", (String)"BlackListImportValidatorHelper_5", (String)"hr-hpfs-business", (Object[])new Object[0]), dyObj.getString("name"), dyObj.getString("phone"), dyObj.getString("toreason.name"), dyObj.getString("reasondetail"), dyObj.getString("adminororg.name"), dyObj.getString("creator.name"), HRDateTimeUtils.formatDate((Date)dyObj.getDate("createtime")));
            importLog.writeRowLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), errMsg);
        }
    }

    private Boolean checkCardInfoIsFull(ImportBillData importBillData, ImportLog importLog, String typeKey, String numKey) {
        JSONObject billData = this.getBillData(importBillData);
        Object cardtype = billData.get((Object)typeKey);
        Object cardnumber = billData.get((Object)numKey);
        if (!HRObjectUtils.isEmpty((Object)cardtype) && HRObjectUtils.isEmpty((Object)cardnumber) || HRObjectUtils.isEmpty((Object)cardtype) && !HRObjectUtils.isEmpty((Object)cardnumber)) {
            String errorMsg = ResManager.loadKDString((String)"\u5b58\u5728\u8bc1\u4ef6\u4fe1\u606f\u586b\u5199\u4e0d\u5b8c\u6574\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BlackListImportValidatorHelper_1", (String)"hr-hpfs-business", (Object[])new Object[0]);
            importLog.writeRowLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), errorMsg);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private String checkIdFormat(Object cardType, Object cardNumber) {
        if (!HRObjectUtils.isEmpty((Object)cardType) && cardType instanceof JSONObject && "1010".equals(String.valueOf(((JSONObject)cardType).get((Object)"id"))) && !HRObjectUtils.isEmpty((Object)cardNumber) && !CommonServiceUtil.validIdentityCardNo(null, (String)"CN01", (String)String.valueOf(cardNumber))) {
            return ResManager.loadKDString((String)"\u8eab\u4efd\u8bc1\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"BlackListImportValidatorHelper_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
        }
        return "";
    }

    private JSONObject getBillData(ImportBillData importBillData) {
        JSONObject jsonObject = importBillData.getData();
        return jsonObject.getJSONObject("hpfs_blacklist");
    }

    private String assemblePhoneWithLocationCode(JSONObject billData) {
        String locationCode = String.valueOf(billData.get((Object)"locationcode"));
        String phoneCode = String.valueOf(billData.get((Object)"phonecode"));
        return locationCode.startsWith("+") ? locationCode + "-" + phoneCode : "+" + locationCode + "-" + phoneCode;
    }
}

