/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hpfs.business.validator.ValidatorBase;

public class ValidatorFactory {
    private boolean validateAll;
    private List<ValidatorBase> validators;
    private Map<String, Object> params;

    public ValidatorFactory(Map<String, Object> params) {
        this.params = params;
        this.validateAll = false;
        this.validators = new ArrayList<ValidatorBase>();
    }

    public ValidatorFactory(Map<String, Object> params, boolean validateAll) {
        this.params = params;
        this.validateAll = validateAll;
        this.validators = new ArrayList<ValidatorBase>();
    }

    public List<ValidatorBase> getValidators() {
        return this.validators;
    }

    public void setValidators(List<ValidatorBase> validators) {
        this.validators = validators;
    }

    public boolean isValidateAll() {
        return this.validateAll;
    }

    public void setValidateAll(boolean validateAll) {
        this.validateAll = validateAll;
    }

    public ValidatorFactory addValidator(ValidatorBase validator) {
        this.validators.add(validator);
        return this;
    }

    public void removeValidator(ValidatorBase validator) {
        this.validators.remove(validator);
    }

    public Object startValidate() {
        return this.validateAll ? this.validateAll() : this.validateFirst();
    }

    public boolean validatorIsEmpty() {
        return CollectionUtils.isEmpty(this.validators);
    }

    private Object validateFirst() {
        for (ValidatorBase validator : this.validators) {
            Object validateResult = validator.validate(this.params);
            if (validator.continueValidate()) continue;
            return validateResult;
        }
        return null;
    }

    private String validateAll() {
        List<Object> allValidateError = this.getAllValidateError();
        String errMsg = allValidateError.stream().filter(validateResult -> !HRObjectUtils.isEmpty((Object)validateResult)).map(Object::toString).collect(Collectors.joining(";"));
        return HRObjectUtils.isEmpty((Object)errMsg) ? null : errMsg;
    }

    private List<Object> getAllValidateError() {
        ArrayList<Object> errorList = new ArrayList<Object>(10);
        for (ValidatorBase validator : this.validators) {
            Object validateResult = validator.validate(this.params);
            if (Objects.isNull(validateResult)) continue;
            errorList.add(validateResult);
        }
        return errorList;
    }
}

