/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.common.enums;

import java.util.Arrays;
import java.util.Optional;

public enum ChgSign2EntityNumberEnum {
    PERSON("personId", "hrpi_person"),
    EMPLOYEE("employeeId", "hrpi_employee"),
    CMPEMP("cmpempId", "hrpi_cmpemp"),
    DEPEMP("depempId", "hrpi_depemp");

    private String sign;
    private String entityNumber;

    private ChgSign2EntityNumberEnum(String sign, String entityNumber) {
        this.sign = sign;
        this.entityNumber = entityNumber;
    }

    public String getSign() {
        return this.sign;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public static String getEntityNumberBySign(String sign) {
        Optional<ChgSign2EntityNumberEnum> first = Arrays.stream(ChgSign2EntityNumberEnum.values()).filter(chgSign2EntityNumberEnum -> sign.equals(chgSign2EntityNumberEnum.getSign())).findFirst();
        return first.isPresent() ? first.get().getEntityNumber() : "";
    }

    public static String getSignByEntityNumber(String entityNumber) {
        Optional<ChgSign2EntityNumberEnum> first = Arrays.stream(ChgSign2EntityNumberEnum.values()).filter(chgSign2EntityNumberEnum -> entityNumber.equals(chgSign2EntityNumberEnum.getEntityNumber())).findFirst();
        return first.isPresent() ? first.get().getSign() : "";
    }
}

