/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.service.fileMap.FileMapManagerService;
import kd.hr.hpfs.business.service.fileMap.vo.FileMapManagerVO;
import kd.hr.hpfs.business.service.fileMap.vo.FileMapVO;
import kd.hr.hpfs.mservice.api.IHPFSFileMapManagerService;

public class HPFSFileMapManagerService
implements IHPFSFileMapManagerService {
    private static final Log LOG = LogFactory.getLog(HPFSFileMapManagerService.class);

    public void updateFileMapManager(Map<String, Object> paramMap) {
        LOG.info("updateFileMapManager param={}", (Object)SerializationUtils.toJsonString(paramMap));
        FileMapManagerService service = new FileMapManagerService();
        try {
            List<String> sourceEntitys = this.getSourceEntity(paramMap);
            List<FileMapManagerVO> list = this.buildFileMapParam(paramMap);
            service.saveFileMapManager(sourceEntitys, list, this.isHcf(paramMap));
        }
        catch (Exception exception) {
            LOG.error("updateFileMapManager error:", (Throwable)exception);
        }
    }

    private List<FileMapManagerVO> buildFileMapParam(Map<String, Object> paramMap) {
        List fileMapList = (List)paramMap.get("fileMapList");
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        if (!CollectionUtils.isEmpty((Collection)fileMapList)) {
            String entityNumber = null;
            if (this.isHcf(paramMap)) {
                entityNumber = (String)paramMap.get("entityNumber");
            }
            String finalEntityNumber = entityNumber;
            fileMapList.forEach(fileMap -> {
                List list = map.computeIfAbsent(new FileMapManagerVO(finalEntityNumber != null ? finalEntityNumber : (String)fileMap.get("sourceEntry"), (String)fileMap.get("targetEntity")), v -> Lists.newArrayListWithCapacity((int)10));
                list.add(new FileMapVO((String)fileMap.get("sourceField"), (String)fileMap.get("targetField"), (String)fileMap.get("operateType")));
            });
        }
        ArrayList fileMapManagerVOList = Lists.newArrayListWithCapacity((int)map.size());
        map.forEach((key, value) -> {
            fileMapManagerVOList.add(key);
            key.setFileMapVOList(value);
        });
        map.clear();
        return fileMapManagerVOList;
    }

    private List<String> getSourceEntity(Map<String, Object> paramMap) {
        ArrayList<String> sourceEntitys = new ArrayList<String>(2);
        String extMetaNum = (String)paramMap.get("extMetaNum");
        if (!HRStringUtils.isEmpty((String)extMetaNum)) {
            sourceEntitys.add(extMetaNum);
        }
        sourceEntitys.add((String)paramMap.get("l4Number"));
        return sourceEntitys;
    }

    private boolean isHcf(Map<String, Object> paramMap) {
        return "1".equals(paramMap.get("isHcf"));
    }
}

