/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.rollback.model.RollbackValidDto;
import kd.hr.hpfs.business.service.hpfsrollback.HpfsRollbackServiceHelper;
import kd.hr.hpfs.business.service.hpfsrollback.HpfsRollbackValidHelper;
import kd.hr.hpfs.business.utils.ProxyUtils;
import kd.hr.hpfs.mservice.api.IHPFSRollbackService;

public class HPFSRollbackService
implements IHPFSRollbackService {
    private static final Log LOG = LogFactory.getLog(HPFSRollbackService.class);

    public Map<String, Object> dataRollback(Map<String, Object> param) {
        HashMap<String, Object> respon = new HashMap<String, Object>(16);
        if (CollectionUtils.isEmpty(param)) {
            String msg = ResManager.loadKDString((String)"\u5165\u53c2\u4e3a\u7a7a", (String)"HPFSRollback_4", (String)"hr-hpfs-mservice", (Object[])new Object[0]);
            return HpfsRollbackServiceHelper.buildRespon(respon, (String)msg, (String)"500");
        }
        LOG.info("==start datarollback param:{}==", param);
        respon.putAll(param);
        String checkParamMsg = HpfsRollbackServiceHelper.checkParams(param);
        if (!HRStringUtils.isEmpty((String)checkParamMsg)) {
            return HpfsRollbackServiceHelper.buildRespon(respon, (String)checkParamMsg, (String)"500");
        }
        HpfsRollbackServiceHelper.buildRespon(respon, (String)"success", (String)"200");
        respon.put("failContinue", Boolean.TRUE);
        DynamicObject[] chgRecords = HpfsRollbackServiceHelper.queryChgRecordByBillAction(param);
        if (chgRecords == null || chgRecords.length == 0) {
            String msg = ResManager.loadKDString((String)"\u64a4\u56de\u5931\u8d25\uff1a\u67e5\u8be2\u4e0d\u5230\u4e8b\u52a1\u53d8\u66f4\u8bb0\u5f55\u6216\u5df2\u7ecf\u64a4\u56de\u3002", (String)"HPFSRollback_5", (String)"hr-hpfs-mservice", (Object[])new Object[0]);
            return HpfsRollbackServiceHelper.buildRespon(respon, (String)msg, (String)"500");
        }
        for (DynamicObject dy : chgRecords) {
            respon.put("affactionId", dy.getLong("chgaction.id"));
            respon.put("recordId", dy.getLong("id"));
            respon.put("chgcategoryId", dy.getLong("chgcategory.id"));
        }
        Map customValidMap = ProxyUtils.replaceValid(iCustomService -> iCustomService.replaceValid(respon));
        if (this.buryingPointCheck(respon, customValidMap)) {
            return respon;
        }
        try {
            Map aRollbackMap;
            Map bRollbackMap = ProxyUtils.rollBack(iCustomService -> iCustomService.beforeRollBack(respon));
            if (this.buryingPointCheck(respon, bRollbackMap)) {
                return respon;
            }
            Map rRollbackMap = ProxyUtils.rollBack(iCustomService -> iCustomService.replaceRollBack(respon));
            if (this.buryingPointCheck(respon, rRollbackMap)) {
                return respon;
            }
            if (rRollbackMap.get("is_default") != null && ((Boolean)rRollbackMap.get("is_default")).booleanValue()) {
                LOG.info("==HpfsRollbackServiceHelper.defaultRollback=");
                HpfsRollbackServiceHelper.defaultRollback(respon);
            }
            if (this.buryingPointCheck(respon, aRollbackMap = ProxyUtils.rollBack(iCustomService -> iCustomService.afterRollBack(respon)))) {
                return respon;
            }
            HpfsRollbackServiceHelper.publishAction((DynamicObject[])chgRecords);
            Map respMsg = HpfsRollbackServiceHelper.buildRespon(respon, (String)"success", (String)"200");
            LOG.info("==dataRollback success:{}==", (Object)respMsg);
            return respMsg;
        }
        catch (Exception exp) {
            LOG.error("==dataRollback.service==", (Throwable)exp);
            return HpfsRollbackServiceHelper.buildRespon(respon, (String)exp.toString(), (String)"500");
        }
    }

    public Map<String, Object> dataRollbackValid(List<Map<String, Object>> paramList) {
        if (CollectionUtils.isEmpty(paramList)) {
            return HpfsRollbackValidHelper.buildRespon((String)"200", new ArrayList(1));
        }
        LOG.info("===dataRollbackValidBatch params:{}", (Object)SerializationUtils.toJsonString(paramList));
        List allDtoList = paramList.stream().map(RollbackValidDto::format).collect(Collectors.toList());
        HpfsRollbackValidHelper.validParams(allDtoList);
        ArrayList<Object> failDtoList = new ArrayList<Object>(allDtoList.size());
        List<RollbackValidDto> successDtoList = new ArrayList(allDtoList.size());
        for (RollbackValidDto rollbackValidDto : allDtoList) {
            String code = rollbackValidDto.getCode();
            if (!HRStringUtils.equals((String)"200", (String)code)) continue;
            successDtoList.add(rollbackValidDto);
        }
        if (!CollectionUtils.isEmpty(successDtoList = HpfsRollbackValidHelper.rollbackValid(successDtoList))) {
            for (RollbackValidDto rollbackValidDto : allDtoList) {
                boolean flag = false;
                for (RollbackValidDto succeDto : successDtoList) {
                    if (!rollbackValidDto.getBillId().equals(succeDto.getBillId())) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                failDtoList.add(rollbackValidDto);
            }
        } else {
            failDtoList.addAll(allDtoList);
        }
        if (!CollectionUtils.isEmpty(failDtoList)) {
            for (RollbackValidDto rollbackValidDto : failDtoList) {
                rollbackValidDto.setCode("500");
                if (!HRStringUtils.isEmpty((String)rollbackValidDto.getMsg()) && !"success".equals(rollbackValidDto.getMsg())) continue;
                rollbackValidDto.setMsg(ResManager.loadKDString((String)"\u67e5\u4e0d\u5230\u8be5\u6570\u636e\u76f8\u5173\u7684\u53d8\u66f4\u8bb0\u5f55\u3002", (String)"HPFSRollback_6", (String)"hr-hpfs-mservice", (Object[])new Object[0]));
            }
        }
        HashMap<String, Object> resMap = new HashMap<String, Object>(2);
        if (!CollectionUtils.isEmpty(failDtoList)) {
            resMap.put("code", "500");
        } else {
            resMap.put("code", "200");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(failDtoList.size() + successDtoList.size());
        arrayList.addAll(successDtoList);
        arrayList.addAll(failDtoList);
        resMap.put("data", SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(arrayList), List.class));
        return resMap;
    }

    private boolean buryingPointCheck(Map<String, Object> respon, Map<String, Object> resultMap) {
        boolean failContinue = (Boolean)resultMap.get("failContinue");
        String code = (String)resultMap.get("code");
        if (!failContinue && !"200".equals(code)) {
            String msg = (String)resultMap.get("msg");
            respon.put("code", "500");
            respon.put("msg", msg);
            return true;
        }
        return false;
    }
}

