/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.mservice.upgrade;

import java.util.Locale;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;

public class HPFSSwitchHpfsMenuConfigUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(HPFSSwitchHpfsMenuConfigUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            LOGGER.info("==HPFSSwitchHpfsMenuConfigUpgradeService hpfs basedata begin==");
            int row = this.doUpgrade(ver, iteration, dbKey, sqlFileName);
            result.setLog(String.format("HPFSSwitchHpfsMenuConfigUpgradeService hpfs basedata oristatus upgrade success: %s", row));
            result.setSuccess(true);
            result.setEl("warning");
            LOGGER.info("==HPFSSwitchHpfsMenuConfigUpgradeService hpfs basedata success==");
            return result;
        }
        catch (Exception exception) {
            LOGGER.error("==HPFSSwitchHpfsMenuConfigUpgradeService hpfs basedata success==", (Throwable)exception);
            result.setErrorInfo(exception.getMessage());
            result.setSuccess(false);
            throw new KDException((Throwable)exception, BosErrorCode.sQL, new Object[]{String.format(Locale.ROOT, "Error:%s", exception.getMessage())});
        }
    }

    private int doUpgrade(String ver, String iteration, String dbKey, String sqlFileName) {
        boolean exists = this.isExists(dbKey);
        return this.updateDevConfigByBusinessKey(dbKey, exists ? "0" : "1");
    }

    private int updateDevConfigByBusinessKey(String dbKey, String newBusinessValue) {
        String sql = "update t_hpfs_devconfig set fbusinessvalue = ? where fbusinesskey =?";
        int update = DB.update((DBRoute)new DBRoute(dbKey), (String)sql, (Object[])new Object[]{String.valueOf(newBusinessValue), "hpfs_switch_menu_config"});
        IHRAppCache ihrAppCache = HRAppCache.get((String)"hpfs:DevelopParamConfig");
        ihrAppCache.remove("hpfs_switch_menu_config");
        return update;
    }

    private boolean isExists(String dbKey) {
        String sql = "select count(1) from t_hpfs_licensedetail";
        long num = (Long)DB.query((DBRoute)new DBRoute(dbKey), (String)sql, null, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
        return num > 0L;
    }
}

