/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.mservice.upgrade;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hpfs.common.enums.ChgTemplateUpgradeEnum;

public class HPFSTemplateUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(HPFSTemplateUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            LOGGER.info("HPFSTemplateUpgradeService start");
            Iterator iterator = Arrays.stream(ChgTemplateUpgradeEnum.values()).iterator();
            while (iterator.hasNext()) {
                ChgTemplateUpgradeEnum upgradeEnum = (ChgTemplateUpgradeEnum)iterator.next();
                boolean exists = this.isExists(upgradeEnum.getTableName(), upgradeEnum.getBDRoute());
                this.updateDevConfigByBusinessKey(upgradeEnum.getDevConfigKey(), String.valueOf(!exists));
            }
            result.setLog("HPFSTemplateUpgradeService hpfs upgrade success: \ntrue");
            result.setSuccess(true);
            result.setEl("warning");
            LOGGER.info("HPFSTemplateUpgradeService hpfs  success");
            return result;
        }
        catch (Exception exception) {
            LOGGER.error("==HPFSTemplateUpgradeService hpfs success==", (Throwable)exception);
            result.setErrorInfo(exception.getMessage());
            result.setSuccess(false);
            throw new KDBizException((Throwable)exception, BosErrorCode.sQL, new Object[]{String.format(Locale.ROOT, "Error:%s", exception.getMessage())});
        }
    }

    private boolean isExists(String tableName, String dbRouteKey) {
        String sql = String.format("select count(1) from %s ;", tableName);
        long num = (Long)DB.query((DBRoute)new DBRoute(dbRouteKey), (String)sql, null, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getLong(1);
                }
                return 0L;
            }
        });
        return num > 0L;
    }

    private void updateDevConfigByBusinessKey(String businessKey, String newBusinessValue) {
        String sql = "update t_hpfs_devconfig set fbusinessvalue = ? where fbusinesskey =?";
        DB.update((DBRoute)new DBRoute("hr"), (String)sql, (Object[])new Object[]{String.valueOf(newBusinessValue), businessKey});
    }
}

