/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hpfs.formplugin.service.ChgNameValidateService;
import kd.sdk.hr.hpfs.common.constants.ChgConstants;

public class ChgActionEditPlugin
extends HRDataBaseEdit
implements ChgConstants {
    private static final Log LOGGER = LogFactory.getLog(ChgActionEditPlugin.class);
    private static final HRBaseServiceHelper ACTION_HELPER = new HRBaseServiceHelper("hbss_action");

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if (HRStringUtils.equals((String)key, (String)"save")) {
            this.saveAction(args);
        }
    }

    private void saveAction(BeforeDoOperationEventArgs args) {
        DynamicObject chgCategory = (DynamicObject)this.getModel().getValue("chgcategory");
        long actionTypeId = chgCategory.getLong("actiontype_id");
        String number = (String)this.getModel().getValue("number");
        String name = ((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue();
        Long hbssActionId = ChgNameValidateService.getInstance().getHBSSActionId(name, actionTypeId, number);
        if (this.validateRepeatHbssActionId(args, hbssActionId)) {
            return;
        }
        String backMsg = ResManager.loadKDString((String)"\u64a4\u56de", (String)"ChgActionEditPlugin_4", (String)"hr-hpfs-formplugin", (Object[])new Object[0]);
        String backNum = number + "_BACK";
        String backName = name + "_" + backMsg;
        Long hbssBackActionId = ChgNameValidateService.getInstance().getHBSSActionId(backName, actionTypeId, backNum);
        if (this.validateRepeatHbssActionId(args, hbssBackActionId)) {
            return;
        }
        String desc = ((OrmLocaleValue)this.getModel().getValue("description")).getLocaleValue();
        Long actionId = this.syncHBSSAction(number, name, hbssActionId, actionTypeId, desc);
        this.getModel().setValue("action", (Object)actionId);
        Long backActionId = this.syncHBSSAction(backNum, backName, hbssBackActionId, actionTypeId, HRStringUtils.isEmpty((String)desc) ? "" : desc + "_" + backMsg);
        this.getModel().setValue("backaction", (Object)backActionId);
    }

    private boolean validateRepeatHbssActionId(BeforeDoOperationEventArgs args, Long hbssActionId) {
        if (hbssActionId == -1L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u5728\u6d88\u606f\u534f\u540c\u4e2d\u6709\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ChgActionEditPlugin_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return true;
        }
        return false;
    }

    private Long syncHBSSAction(String number, String name, Long id, Long actionTypeId, String desc) {
        DynamicObject actionDy;
        if (id != 0L) {
            actionDy = ACTION_HELPER.loadSingle((Object)id);
        } else {
            actionDy = ACTION_HELPER.generateEmptyDynamicObject();
            Long newId = ORM.create().genLongId("hbss_action");
            actionDy.set("id", (Object)newId);
            actionDy.set("masterid", (Object)newId);
        }
        actionDy.set("name", (Object)name);
        actionDy.set("number", (Object)number);
        if (HRStringUtils.isNotEmpty((String)desc)) {
            actionDy.set("description", (Object)desc);
        }
        actionDy.set("actiontype", (Object)actionTypeId);
        actionDy.set("status", (Object)"C");
        actionDy.set("enable", (Object)"1");
        return (Long)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSMsgService", (String)"saveActionDy", (Object[])new Object[]{actionDy});
    }
}

