/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sdk.hr.hpfs.common.constants.ChgConstants;

public class ChgCategoryEditPlugin
extends HRDataBaseEdit
implements ChgConstants {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if (HRStringUtils.equals((String)key, (String)"save")) {
            HRBaseServiceHelper actionTypeHelper = new HRBaseServiceHelper("hbss_actiontype");
            long id = this.getModel().getDataEntity().getLong("id");
            String number = (String)this.getModel().getValue("number");
            String name = ((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue();
            number = this.strTrim(number);
            name = this.strTrim(name);
            if (id != 0L) {
                HRBaseServiceHelper chgHelper = new HRBaseServiceHelper("hpfs_chgcategory");
                QFilter notIdFilter = new QFilter("id", "!=", (Object)id);
                QFilter numFilter = new QFilter("number", "=", (Object)number);
                QFilter nameFilter = new QFilter("name", "=", (Object)name);
                DynamicObject chgByNum = chgHelper.loadDynamicObject(new QFilter[]{numFilter, notIdFilter});
                DynamicObject chgByName = chgHelper.loadDynamicObject(new QFilter[]{nameFilter, notIdFilter});
                if (chgByNum != null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ChgCategoryEditPlugin_3", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (chgByName != null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ChgCategoryEditPlugin_4", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                long actionId = this.getModel().getDataEntity().getLong("actiontype.id");
                QFilter actionNotIdFilter = new QFilter("id", "!=", (Object)actionId);
                QFilter actionNumFilter = new QFilter("number", "=", (Object)number);
                QFilter actionNameFilter = new QFilter("name", "=", (Object)name);
                DynamicObject actionNumDy = actionTypeHelper.loadDynamicObject(new QFilter[]{actionNumFilter, actionNotIdFilter});
                DynamicObject actionNameDy = actionTypeHelper.loadDynamicObject(new QFilter[]{actionNameFilter, actionNotIdFilter});
                if (actionNumDy != null || actionNameDy != null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u5728\u6d88\u606f\u534f\u540c\u4e2d\u6709\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ChgCategoryEditPlugin_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObject actionType = actionTypeHelper.queryOne((Object)actionId);
                this.updateAction(actionType);
            } else {
                DynamicObject actionTypeByNumber = actionTypeHelper.loadDynamicObject(new QFilter[]{new QFilter("number", "=", (Object)number)});
                DynamicObject actionTypeByName = actionTypeHelper.loadDynamicObject(new QFilter[]{new QFilter("name", "=", (Object)name)});
                if (actionTypeByNumber == null && actionTypeByName == null) {
                    this.syncHBSSActionType(actionTypeHelper);
                    return;
                }
                if (actionTypeByName != null && actionTypeByNumber != null && actionTypeByName.getLong("id") == actionTypeByNumber.getLong("id") && actionTypeByName.getLong("businessdomain.id") == actionTypeByNumber.getLong("businessdomain.id") && HRStringUtils.equals((String)String.valueOf(actionTypeByName.getLong("businessdomain.id")), (String)"103010")) {
                    this.getModel().setValue("actiontype", (Object)actionTypeByName.getLong("id"));
                    return;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u5728\u6d88\u606f\u534f\u540c\u4e2d\u6709\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ChgCategoryEditPlugin_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private String strTrim(String val) {
        if (HRStringUtils.isNotEmpty((String)val)) {
            val = val.trim();
        }
        return val;
    }

    private void updateAction(DynamicObject actionType) {
        actionType.set("businessdomain", (Object)"103010");
        actionType.set("name", this.getModel().getValue("name"));
        actionType.set("number", this.getModel().getValue("number"));
        actionType.set("status", (Object)"C");
        actionType.set("enable", (Object)"1");
        actionType.set("description", this.getModel().getValue("description"));
        Long newId = (Long)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSMsgService", (String)"saveActionTypeDy", (Object[])new Object[]{actionType});
        this.getModel().setValue("actiontype", (Object)newId);
    }

    private void syncHBSSActionType(HRBaseServiceHelper actionTypeHelper) {
        DynamicObject newDy = actionTypeHelper.generateEmptyDynamicObject();
        newDy.set("businessdomain", (Object)"103010");
        newDy.set("name", this.getModel().getValue("name"));
        newDy.set("number", this.getModel().getValue("number"));
        newDy.set("status", (Object)"C");
        newDy.set("enable", (Object)"1");
        newDy.set("description", this.getModel().getValue("description"));
        Long newId = (Long)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSMsgService", (String)"saveActionTypeDy", (Object[])new Object[]{newDy});
        this.getModel().setValue("actiontype", (Object)newId);
    }
}

