/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hpfs.formplugin.HPFSRPCTestEditPlugin;

public class HPFSRPCTestRollbackEditPlugin
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(HPFSRPCTestEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"invoke", "getchginfobyrecordidquery", "detailquery", "send", "getactionidsbybillquery"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "invoke": {
                this.invokeRPC();
                break;
            }
            case "getchginfobyrecordidquery": {
                this.getChgInfoByRecordIdQuery();
                break;
            }
            case "detailquery": {
                this.detailQuery();
                break;
            }
            case "send": {
                this.send();
                break;
            }
            case "getactionidsbybillquery": {
                this.getActionIdsByBill();
                break;
            }
        }
    }

    private void invokeRPC() {
        String cloud = (String)this.getModel().getValue("cloud");
        String appid = (String)this.getModel().getValue("appid");
        String serviceName = (String)this.getModel().getValue("servicename");
        String methodName = (String)this.getModel().getValue("methodname");
        String params = (String)this.getModel().getValue("params");
        Object res = null;
        if ("dataRollback".equals(methodName)) {
            Map paramsMap = (Map)JSON.parseObject((String)params, Map.class);
            LOG.info("==paramsMap:{}==", (Object)paramsMap);
            res = HRMServiceHelper.invokeBizService((String)cloud, (String)appid, (String)serviceName, (String)methodName, (Object[])new Object[]{paramsMap});
        } else if ("dataRollbackValid".equals(methodName)) {
            List paramsMap = (List)JSON.parseObject((String)params, List.class);
            LOG.info("==paramsMap:{}==", (Object)paramsMap);
            res = HRMServiceHelper.invokeBizService((String)cloud, (String)appid, (String)serviceName, (String)methodName, (Object[])new Object[]{paramsMap});
        } else {
            res = HRMServiceHelper.invokeBizService((String)cloud, (String)appid, (String)serviceName, (String)methodName, (Object[])new Object[]{params});
            LOG.info("==paramsMap:{}res==", res);
        }
        this.getModel().setValue("rpctestres", res);
    }

    private void getChgInfoByRecordIdQuery() {
        long recordId = Long.parseLong((String)this.getModel().getValue("recordid"));
        Object res = HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgInfoByRecordId", (Object[])new Object[]{recordId});
        this.getModel().setValue("getchginfobyrecordidres", res);
    }

    private void detailQuery() {
        long recordId = Long.parseLong((String)this.getModel().getValue("recordid1"));
        Object res = HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgInfoDetailByRecordId", (Object[])new Object[]{recordId});
        this.getModel().setValue("detailres", res);
    }

    private void send() {
        String msgNumber = (String)this.getModel().getValue("msgnumber");
        String msgPubNo = (String)this.getModel().getValue("msgpubno");
        long actionId = Long.parseLong((String)this.getModel().getValue("actionid"));
        String params = (String)this.getModel().getValue("coordinateparam");
        HashMap<String, Object> messageParams = new HashMap<String, Object>(8);
        messageParams.put("msgNumber", msgNumber);
        messageParams.put("msgPubNo", msgPubNo);
        messageParams.put("msgTitle", "hpfs test coordinate msg send");
        messageParams.put("actionId", actionId);
        messageParams.put("senderId", RequestContext.get().getCurrUserId());
        messageParams.put("sendTime", new Date());
        messageParams.put("params", params);
        HRProducerServiceHelper.publishAction(messageParams);
    }

    private void getActionIdsByBill() {
        String entityName = (String)this.getModel().getValue("entityname");
        Object res = HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getActionResByBill", (Object[])new Object[]{entityName});
        this.getModel().setValue("getactionidsbybillres", res);
    }
}

