/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.service.ChgActionService;
import kd.hr.hpfs.business.service.ChgStrategyService;

public class PerChgBillTplEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(PerChgBillTplEdit.class);
    protected static final String BUSINESS_VALUE = "businessvalue";
    private static final String FIELD_LABORREL_TYPE = "laborreltype";
    private static final String FIELD_BEFORE_LABORREL_TYPE = "beforelaborreltype";
    private static final String FIELD_LABORREL_STATUS = "laborrelstatus";
    private static final String FIELD_BEFORE_LABORREL_STATUS = "beforelaborrelstatus";
    private static final String FIELD_POS_TYPE = "postype";
    private static final String FIELD_BEFORE_POS_TYPE = "beforepostype";
    private static final String FIELD_POS_STATUS = "posstatus";
    private static final String FIELD_BEFORE_POS_STATUS = "beforeposstatus";
    private static final String ENTRY_B_PERSON_ENTRY = "entry_b_person";
    private static final Set<String> SHOW_NEW_PATE_SET = Sets.newHashSet((Object[])new String[]{"ide_formdesigner"});
    private final Set<String> f7SelectSet = new HashSet<String>();

    public PerChgBillTplEdit() {
        this.f7SelectSet.add(FIELD_LABORREL_TYPE);
        this.f7SelectSet.add(FIELD_BEFORE_LABORREL_TYPE);
        this.f7SelectSet.add(FIELD_LABORREL_STATUS);
        this.f7SelectSet.add(FIELD_BEFORE_LABORREL_STATUS);
        this.f7SelectSet.add(FIELD_POS_TYPE);
        this.f7SelectSet.add(FIELD_BEFORE_POS_TYPE);
        this.f7SelectSet.add(FIELD_POS_STATUS);
        this.f7SelectSet.add(FIELD_BEFORE_POS_STATUS);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (String number : this.f7SelectSet) {
            BasedataEdit laborrelType = (BasedataEdit)this.getControl(number);
            if (Objects.isNull(laborrelType)) continue;
            laborrelType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit chgAction = (BasedataEdit)this.getControl("affaction");
        if (chgAction != null) {
            chgAction.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String billIsnewchgaction;
        Control control = (Control)beforeF7SelectEvent.getSource();
        String key = control.getKey();
        if (this.f7SelectSet.contains(key)) {
            QFilter varRange;
            if ((HRStringUtils.equals((String)FIELD_LABORREL_TYPE, (String)key) || HRStringUtils.equals((String)FIELD_LABORREL_STATUS, (String)key)) && !HRStringUtils.equals((String)(billIsnewchgaction = this.getBusinessValue()), (String)"0")) {
                String entityId = this.getView().getEntityId();
                LOGGER.info("{} use new isnewchgaction.", (Object)entityId);
                return;
            }
            BasedataEdit focusF7 = (BasedataEdit)beforeF7SelectEvent.getSource();
            Long actionId = (Long)this.getModel().getValue("affaction_id");
            if (Objects.isNull(actionId) || actionId == 0L) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d8\u52a8\u64cd\u4f5c\u3002", (String)"PerChgBillTplEdit_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            }
            if ((varRange = ChgStrategyService.getInstance().queryRuleVarRangeByAction(actionId, focusF7.getKey())) != null) {
                beforeF7SelectEvent.addCustomQFilter(varRange);
            }
        }
        if (HRStringUtils.equals((String)control.getKey(), (String)"affaction")) {
            billIsnewchgaction = this.getBusinessValue();
            if (!HRStringUtils.equals((String)billIsnewchgaction, (String)"0")) {
                String entityId = this.getView().getEntityId();
                LOGGER.info("{} use new isnewchgaction.", (Object)entityId);
                return;
            }
            String entityName = this.getView().getFormShowParameter().getFormId();
            List actionIds = ChgActionService.getInstance().getActionIdByBill(entityName);
            QFilter actionFilter = new QFilter("id", "in", (Object)actionIds);
            actionFilter.and(new QFilter("enable", "=", (Object)"1"));
            beforeF7SelectEvent.addCustomQFilter(actionFilter);
        }
    }

    private String getBusinessValue() {
        IFormView view;
        String billIsnewchgaction = this.getPageCache().get(BUSINESS_VALUE);
        if (HRStringUtils.isEmpty((String)billIsnewchgaction) && (view = this.getView()) != null) {
            if (SHOW_NEW_PATE_SET.contains(view.getEntityId())) {
                LOGGER.info("PerChgBillTplEdit#setFilter parentView getEntityId:{}", (Object)view.getEntityId());
                billIsnewchgaction = "1";
            } else {
                billIsnewchgaction = view.getControl(ENTRY_B_PERSON_ENTRY) != null ? "1" : "0";
            }
        }
        return billIsnewchgaction;
    }
}

