/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin.blacklist;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hpfs.business.utils.BlacklistUtils;
import kd.hr.hpfs.business.validator.BlackListImportValidatorHelper;
import kd.hr.impt.common.enu.ValidatorEnum;
import kd.hr.impt.common.plugin.AfterCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeInitValidatorEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.hr.impt.core.validate.AbstractValidateHandler;

public class BlackListOutSideImportPlugin
extends HRDataBaseList
implements HRImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(BlackListOutSideImportPlugin.class);

    public void beforeInitValidator(BeforeInitValidatorEventArgs args) {
        args.setValidator(ValidatorEnum.CUSTOM_VALIDATOR, (AbstractValidateHandler)new BlackListImportValidatorHelper());
    }

    public void beforeCallOperation(BeforeCallOperationEventArgs args) {
        DynamicObject[] dynamicObjects = (DynamicObject[])args.getDynamicObjects();
        Arrays.stream(dynamicObjects).forEach(dy -> {
            DynamicObject mainCardObject;
            dy.set("issysperson", (Object)Boolean.FALSE);
            dy.set("datasource", (Object)"1");
            dy.set("phone", (Object)(dy.getString("locationcode").startsWith("+") ? dy.getString("locationcode") + "-" + dy.getString("phonecode") : "+" + dy.getString("locationcode") + "-" + dy.getString("phonecode")));
            DynamicObjectCollection entryentity = dy.getDynamicObjectCollection("entryentity");
            if (dy.get("maincardtype") instanceof DynamicObject && !HRObjectUtils.isEmpty((Object)dy.getDynamicObject("maincardtype"))) {
                mainCardObject = entryentity.addNew();
                mainCardObject.set("cardtype", (Object)dy.getDynamicObject("maincardtype"));
                mainCardObject.set("cardnumber", (Object)dy.getString("maincardnumber"));
                mainCardObject.set("ismaincard", (Object)Boolean.TRUE);
            }
            if (dy.get("cardtypeimport") instanceof DynamicObject && !HRObjectUtils.isEmpty((Object)dy.getDynamicObject("cardtypeimport"))) {
                mainCardObject = entryentity.addNew();
                mainCardObject.set("cardtype", (Object)dy.getDynamicObject("cardtypeimport"));
                mainCardObject.set("cardnumber", (Object)dy.getString("cardnumberimport"));
                mainCardObject.set("ismaincard", (Object)Boolean.FALSE);
            }
        });
    }

    public void afterCallOperation(AfterCallOperationEventArgs args) {
        try {
            DynamicObject[] dynamicObjects = args.getDynamicObjects();
            Arrays.stream(dynamicObjects).forEach(dynamicObject -> BlacklistUtils.saveBlacklistOperationLog((String)"1", (DynamicObject)dynamicObject, null));
        }
        catch (Exception ex) {
            LOGGER.error("blacklist.BlackListOutSideImportPlugin.afterCallOperation:", (Throwable)ex);
        }
    }
}

