/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin.blacklist;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class PersonCardInfoFormPlugin
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(PersonCardInfoFormPlugin.class);
    private static final String MORE_DETAIL_FLEX = "moredetailflex";
    private static final String MORE_DETAIL_LABEL = "moredetaillabel";
    private static final String MORE_DETAIL_VECTOR = "moredetailvector";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{MORE_DETAIL_LABEL});
        this.addClickListeners(new String[]{MORE_DETAIL_VECTOR});
    }

    public void afterBindData(EventObject e) {
        Label nationlabel;
        Label genderlabel;
        Label issyslabel;
        Label numberlabel;
        Label namelabel;
        super.afterBindData(e);
        IFormView view = this.getView();
        Map customParams = view.getFormShowParameter().getCustomParams();
        Boolean issysperson = (Boolean)customParams.get("issysperson");
        String emppicture = (String)customParams.get("emppicture");
        Image pictureControl = (Image)view.getControl("emppicture");
        String imageFullUrl = HRImageUrlUtil.getImageFullUrl((String)emppicture);
        if (!HRStringUtils.isEmpty((String)imageFullUrl)) {
            pictureControl.setUrl(imageFullUrl);
        }
        if (!HRObjectUtils.isEmpty((Object)(namelabel = (Label)view.getControl("namelabel")))) {
            namelabel.setText(String.valueOf(customParams.get("name")));
        }
        if (!HRObjectUtils.isEmpty((Object)(numberlabel = (Label)view.getControl("numberlabel")))) {
            numberlabel.setText(String.valueOf(customParams.get("empnumber")));
        }
        if (!HRObjectUtils.isEmpty((Object)(issyslabel = (Label)view.getControl("issyslabel")))) {
            issyslabel.setText(issysperson != false ? ResManager.loadKDString((String)"\u4f01\u4e1a\u5185\u4eba\u5458", (String)"PersonCardInfoFormPlugin_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5916\u90e8\u4eba\u5458", (String)"PersonCardInfoFormPlugin_1", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        }
        if (!HRObjectUtils.isEmpty((Object)(genderlabel = (Label)view.getControl("genderlabel")))) {
            if (HRObjectUtils.isEmpty(customParams.get("gender")) || ResManager.loadKDString((String)"\u672a\u77e5", (String)"PersonCardInfoFormPlugin_2", (String)"hr-hpfs-formplugin", (Object[])new Object[0]).equals(String.valueOf(customParams.get("gender")))) {
                view.setVisible(Boolean.FALSE, new String[]{"genderlabel"});
            }
            genderlabel.setText(String.valueOf(customParams.get("gender")));
        }
        if (!HRObjectUtils.isEmpty((Object)(nationlabel = (Label)view.getControl("nationlabel")))) {
            if (HRObjectUtils.isEmpty(customParams.get("nation"))) {
                view.setVisible(Boolean.FALSE, new String[]{"nationlabel"});
            }
            nationlabel.setText(String.valueOf(customParams.get("nation")));
        }
        if (!issysperson.booleanValue()) {
            view.setVisible(Boolean.FALSE, new String[]{"numberlabel"});
            view.setVisible(Boolean.FALSE, new String[]{"employeelabel"});
            view.setVisible(Boolean.FALSE, new String[]{MORE_DETAIL_FLEX});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (MORE_DETAIL_LABEL.equals(key) || MORE_DETAIL_VECTOR.equals(key)) {
            DynamicObject dataEntity = this.getView().getParentView().getModel().getDataEntity();
            long employeeId = dataEntity.getLong("employee.id");
            Long ermanfileId = PersonCardInfoFormPlugin.getErmanfileId(employeeId);
            if (0L == ermanfileId) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848ID\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7cfb\u7edf\u4e2d\u662f\u5426\u5b58\u5728\u8be5\u4eba\u5458\u3002", (String)"PersonCardInfoFormPlugin_5", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                Map retMap = (Map)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"jumpErManFileDetail", (Object[])new Object[]{ermanfileId, "htm_erfilelist"});
                if (((Boolean)retMap.get("success")).booleanValue()) {
                    FormShowParameter formShowParameter = (FormShowParameter)retMap.get("data");
                    formShowParameter.setCustomParam("checkRightAppId", (Object)"hspm");
                    this.getView().showForm(formShowParameter);
                } else {
                    this.getView().showErrorNotification((String)retMap.get("errormsg"));
                }
            }
            catch (Exception var9) {
                LOGGER.error("jumpDetailFail", (Throwable)var9);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0b\u5e8f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PersonCardInfoFormPlugin_4", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public static Long getErmanfileId(Long employId) {
        if (employId == null || employId <= 0L) {
            return 0L;
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hspm_ermanfile");
        QFilter qFilter = new QFilter("employee", "=", (Object)employId);
        qFilter.and(new QFilter("filetype", "=", (Object)1050L));
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        DynamicObject[] query = hrBaseServiceHelper.query(qFilter.toArray());
        if (query.length > 0) {
            LOGGER.error("employee.to.multi.ermanId={}", (Object)query.toString());
            return query[0].getLong("id");
        }
        return 0L;
    }
}

