/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin.cross;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hpfs.business.domain.repository.perchg.ChgCrossValidRepository;
import kd.hr.hpfs.common.constants.ChgCrossValidConstants;

public class CrossValidationEditPlugin
extends HRDataBaseEdit
implements ChgCrossValidConstants,
BeforeF7SelectListener {
    static final String[] allFieldArr = new String[]{"condition", "orgrelvalidtype", "crossstatus", "crossresult", "crossnoti", "description"};
    static final String[] partFieldArr = new String[]{"condition", "orgrelvalidtype", "crossstatus", "crossresult", "crossnoti"};
    protected static final String BUSINESS_VALUE = "businessvalue";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit unMul = (MulBasedataEdit)this.getControl("muluncommitted");
        unMul.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mul = (MulBasedataEdit)this.getControl("mulcommitted");
        mul.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (operationStatus.getValue() == OperationStatus.ADDNEW.getValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"uncommittedtrans", "committedtrans"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"muluncommitted", "mulcommitted"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "muluncommitted": 
            case "mulcommitted": {
                this.validTransCross();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "save": {
                this.save(args);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("muluncommitted".equals(name) || "mulcommitted".equals(name)) {
            FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setCustomParam(BUSINESS_VALUE, (Object)"2");
        }
    }

    private void save(BeforeDoOperationEventArgs args) {
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (operationStatus.getValue() == OperationStatus.ADDNEW.getValue()) {
            this.saveBatch();
            args.setCancel(true);
        } else {
            String errorMsg = this.validateSingle();
            if (HRStringUtils.isNotEmpty((String)errorMsg)) {
                this.getView().showErrorNotification(errorMsg);
                args.setCancel(true);
            }
        }
    }

    private void saveBatch() {
        String errorMsg;
        boolean res = this.validTransCross();
        if (!res) {
            return;
        }
        DynamicObjectCollection uncommittedCollection = (DynamicObjectCollection)this.getModel().getValue("muluncommitted");
        DynamicObjectCollection committedCollection = (DynamicObjectCollection)this.getModel().getValue("mulcommitted");
        List<Long> uncommittedIds = uncommittedCollection.stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList());
        List<Long> committedIds = committedCollection.stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList());
        DynamicObject[] dynArr = this.queryDyn(uncommittedIds, committedIds);
        HashSet<String> set = new HashSet<String>();
        if (dynArr.length != 0 && HRStringUtils.isNotEmpty((String)(errorMsg = this.validConflict(dynArr, set)))) {
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        List<DynamicObject> dynList = this.formatDynList(uncommittedCollection, committedCollection, set);
        ChgCrossValidRepository.save((DynamicObject[])dynList.toArray(new DynamicObject[0]));
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"CrossValidationEditPlugin_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        this.getView().sendFormAction(this.getView().getParentView());
        this.getModel().setDataChanged(false);
        this.getView().close();
    }

    private List<DynamicObject> formatDynList(DynamicObjectCollection uncommittedCollection, DynamicObjectCollection committedCollection, Set<String> set) {
        ArrayList<DynamicObject> dynList = new ArrayList<DynamicObject>(uncommittedCollection.size() * committedCollection.size());
        for (DynamicObject unCommit : uncommittedCollection) {
            for (DynamicObject commit : committedCollection) {
                DynamicObject dyn = ChgCrossValidRepository.generateEmptyDynamicObject();
                dyn.set("uncommittedtrans", (Object)unCommit.getLong("fbasedataid.id"));
                dyn.set("committedtrans", (Object)commit.getLong("fbasedataid.id"));
                for (String field : allFieldArr) {
                    dyn.set(field, this.getModel().getValue(field));
                }
                dyn.set("enable", (Object)"1");
                dyn.set("status", (Object)"C");
                dyn.set("creator", (Object)RequestContext.get().getCurrUserId());
                String number = CodeRuleServiceHelper.getNumber((String)"hpfs_chgcrossvalid", (DynamicObject)dyn, null);
                dyn.set("number", (Object)number);
                String str = this.formatStr(dyn);
                if (set.contains(str)) continue;
                dynList.add(dyn);
            }
        }
        return dynList;
    }

    private DynamicObject[] queryDyn(List<Long> uncommittedIds, List<Long> committedIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("uncommittedtrans", "in", uncommittedIds), new QFilter("committedtrans", "in", committedIds), new QFilter("condition", "=", this.getModel().getValue("condition")), new QFilter("orgrelvalidtype", "=", this.getModel().getValue("orgrelvalidtype")), new QFilter("enable", "=", (Object)"1")};
        String selectField = "id,uncommittedtrans,committedtrans,condition,orgrelvalidtype,crossstatus,crossresult,crossnoti";
        return ChgCrossValidRepository.queryOriginalArray((String)selectField, (QFilter[])qFilters);
    }

    private String formatStr(DynamicObject dyn) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(dyn.getLong("uncommittedtrans")).append("-").append(dyn.getLong("committedtrans"));
        for (String field : partFieldArr) {
            stringBuilder.append("-").append(dyn.getString(field));
        }
        return stringBuilder.toString();
    }

    private String validateSingle() {
        long unCommitId = ((DynamicObject)this.getModel().getValue("uncommittedtrans")).getLong("id");
        long commitId = ((DynamicObject)this.getModel().getValue("committedtrans")).getLong("id");
        DynamicObject[] dyns = this.queryDyn(Collections.singletonList(unCommitId), Collections.singletonList(commitId));
        if (dyns.length == 0) {
            return "";
        }
        String errorMsg = this.validConflict(dyns, false);
        if (HRStringUtils.isNotEmpty((String)errorMsg)) {
            return errorMsg;
        }
        if (dyns[0].getLong("id") != ((Long)this.getModel().getValue("id")).longValue()) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u548c\u5df2\u6709\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CrossValidationEditPlugin_1", (String)"hr-hpfs-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private String validConflict(DynamicObject[] dyns, Set<String> set) {
        for (DynamicObject dyn : dyns) {
            String errorMsg = this.validConflict(dyns, true);
            if (HRStringUtils.isNotEmpty((String)errorMsg)) {
                return errorMsg;
            }
            String crossStatus = dyn.getString("crossstatus");
            String crossResult = dyn.getString("crossresult");
            String crossNotification = dyn.getString("crossnoti");
            String str = dyn.getLong("uncommittedtrans") + "-" + dyn.getLong("committedtrans") + "-" + crossStatus + "-" + crossResult + "-" + crossNotification;
            set.add(str);
        }
        return "";
    }

    private String validConflict(DynamicObject[] dyns, boolean isAdd) {
        for (DynamicObject dyn : dyns) {
            boolean conflictStatus = isAdd || dyn.getLong("id") != ((Long)this.getModel().getValue("id")).longValue();
            String crossStatus = dyn.getString("crossstatus");
            String status = (String)this.getModel().getValue("crossstatus");
            if (conflictStatus && !HRStringUtils.equals((String)crossStatus, (String)status)) {
                return ResManager.loadKDString((String)"\u6821\u9a8c\u72b6\u6001\u4e0d\u4e00\u81f4\u3002", (String)"CrossValidationEditPlugin_2", (String)"hr-hpfs-formplugin", (Object[])new Object[0]);
            }
            String crossResult = dyn.getString("crossresult");
            String result = (String)this.getModel().getValue("crossresult");
            if (conflictStatus && !HRStringUtils.equals((String)crossResult, (String)result)) {
                return ResManager.loadKDString((String)"\u6821\u9a8c\u7ed3\u679c\u4e0d\u4e00\u81f4\u3002", (String)"CrossValidationEditPlugin_3", (String)"hr-hpfs-formplugin", (Object[])new Object[0]);
            }
            String crossNotification = dyn.getString("crossnoti");
            String notification = (String)this.getModel().getValue("crossnoti");
            if (!conflictStatus || HRStringUtils.equals((String)crossNotification, (String)notification)) continue;
            return ResManager.loadKDString((String)"\u6821\u9a8c\u5f3a\u5ea6\u4e0d\u4e00\u81f4\u3002", (String)"CrossValidationEditPlugin_4", (String)"hr-hpfs-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private boolean validTransCross() {
        DynamicObjectCollection uncommittedCollection = (DynamicObjectCollection)this.getModel().getValue("muluncommitted");
        if (uncommittedCollection.isEmpty()) {
            return true;
        }
        DynamicObjectCollection committedCollection = (DynamicObjectCollection)this.getModel().getValue("mulcommitted");
        if (committedCollection.isEmpty()) {
            return true;
        }
        List uncommittedIds = uncommittedCollection.stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList());
        List committedIds = committedCollection.stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList());
        uncommittedIds.retainAll(committedIds);
        if (uncommittedIds.isEmpty()) {
            return true;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6709\u53d1\u8d77\u7684\u4eba\u4e8b\u4e8b\u52a1\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CrossValidationEditPlugin_5", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        return false;
    }
}

