/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin.fieldmap;

import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hpfs.business.service.fileMap.FileMapManagerService;
import kd.hr.hpfs.business.service.fileMap.IFileMapManagerService;
import kd.sdk.hr.common.constants.FileMapManagerConstants;
import kd.sdk.hr.hspm.business.helper.InfoGroupHelper;

public class FieldRelationCEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
FileMapManagerConstants {
    private static final Log LOGGER = LogFactory.getLog(FieldRelationCEdit.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit targetField = (BasedataEdit)this.getView().getControl("targetfieldnew_c");
        targetField.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String entryData = (String)this.getView().getFormShowParameter().getCustomParam("selectrowentitydy");
        String entryEntityData = (String)this.getView().getFormShowParameter().getCustomParam("entryentitydata");
        if (StringUtils.isBlank((CharSequence)entryEntityData)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)entryData)) {
            return;
        }
        DynamicObjectCollection parentEntryEntityDys = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)entryEntityData);
        DynamicObject selectRowEntityDy = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)entryData);
        if (Objects.isNull(parentEntryEntityDys)) {
            return;
        }
        if (Objects.isNull(selectRowEntityDy)) {
            return;
        }
        DynamicObject sourceEntityDy = selectRowEntityDy.getDynamicObject("sourceentity_c");
        if (Objects.isNull(sourceEntityDy)) {
            return;
        }
        DynamicObject targetEntityDy = selectRowEntityDy.getDynamicObject("targetentity_c");
        if (Objects.isNull(targetEntityDy)) {
            return;
        }
        DynamicObjectCollection subEntryEntityDys = this.getModel().getEntryEntity("subentryentity_c");
        Optional<String> writePersonInfoValid = this.writePersonInfoValidC(parentEntryEntityDys, sourceEntityDy, targetEntityDy, subEntryEntityDys);
        if (writePersonInfoValid.isPresent()) {
            this.getView().showErrorNotification(writePersonInfoValid.get());
            args.setCancel(true);
            return;
        }
        Optional<String> otherWritePersonInfoValid = this.otherWritePersonInfoValidC(targetEntityDy, subEntryEntityDys);
        if (otherWritePersonInfoValid.isPresent()) {
            this.getView().showErrorNotification(otherWritePersonInfoValid.get());
            args.setCancel(true);
            return;
        }
        Optional<String> wrapWritePersonInfoValid = this.wrapWritePersonInfoValidC(targetEntityDy, subEntryEntityDys);
        if (wrapWritePersonInfoValid.isPresent()) {
            this.getView().showErrorNotification(wrapWritePersonInfoValid.get());
            args.setCancel(true);
        }
    }

    private Optional<String> wrapWritePersonInfoValidC(DynamicObject targetEntityDy, DynamicObjectCollection subEntryEntityDys) {
        String pageNumber = targetEntityDy.getString("number");
        if (InfoGroupHelper.isSingleRowTpl((String)pageNumber)) {
            return Optional.empty();
        }
        List writePersonInfos = subEntryEntityDys.stream().filter(data -> Objects.nonNull(data.getDynamicObject("targetfieldnew_c")) && data.getBoolean("writepersoninfo_c")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(writePersonInfos)) {
            return Optional.empty();
        }
        String entryEntityData = (String)this.getView().getFormShowParameter().getCustomParam("otherentryentitydata");
        if (StringUtils.isBlank((CharSequence)entryEntityData)) {
            return Optional.empty();
        }
        DynamicObjectCollection billEntryEntityDys = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)entryEntityData);
        for (DynamicObject billEntryEntityDy : billEntryEntityDys) {
            DynamicObjectCollection billSubEntryEntityDys;
            List billWritePersonInfos;
            if (!targetEntityDy.getString("id").equals(billEntryEntityDy.getString("targetentity.id")) || CollectionUtils.isEmpty(billWritePersonInfos = (billSubEntryEntityDys = billEntryEntityDy.getDynamicObjectCollection("subentryentity")).stream().filter(data -> Objects.nonNull(data.getDynamicObject("targetfieldnew")) && data.getBoolean("writepersoninfo")).collect(Collectors.toList()))) continue;
            return Optional.of(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4eba\u5458\u4fe1\u606f\u7ec4\u201c%s\u201d\u4e0d\u80fd\u540c\u65f6\u4e0e\u5355\u636e\u548c\u5019\u9009\u4eba\u5efa\u7acb\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u8bd5\u3002", (String)"FieldRelationEdit_3", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), targetEntityDy.getString("name")));
        }
        return Optional.empty();
    }

    private Optional<String> writePersonInfoValidC(DynamicObjectCollection parentEntryEntityDys, DynamicObject sourceEntityDy, DynamicObject targetEntityDy, DynamicObjectCollection subEntryEntityDys) {
        Optional<List> first = subEntryEntityDys.stream().filter(data -> Objects.nonNull(data.getDynamicObject("targetfieldnew_c")) && data.getBoolean("writepersoninfo_c")).collect(Collectors.groupingBy(data -> data.getLong("targetfieldnew_c.id"))).values().stream().filter(data -> data.size() > 1).findFirst();
        if (first.isPresent()) {
            List dynamicObjects = first.get();
            String sourceField = ((DynamicObject)dynamicObjects.get(0)).getString("targetfieldnew_c.name");
            return Optional.of(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4eba\u5458\u4fe1\u606f\u5b57\u6bb5\u201c%1$s\u201d\u5df2\u5728\u5019\u9009\u4eba\u4fe1\u606f\u7ec4\u201c%2$s\u201d\u4e2d\u542f\u7528\u4e86\u201c\u56de\u5199\u4eba\u5458\u4fe1\u606f\u201d\uff0c\u65e0\u6cd5\u540c\u65f6\u7531\u4e24\u4e2a\u4e0d\u540c\u7684\u5b57\u6bb5\u56de\u5199\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (String)"FieldRelationEdit_2", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), sourceField, sourceEntityDy.getString("name")));
        }
        Map<Long, DynamicObject> selfTargetFieldNewAndDy = subEntryEntityDys.stream().filter(data -> Objects.nonNull(data.getDynamicObject("targetfieldnew_c")) && data.getBoolean("writepersoninfo_c")).collect(Collectors.toMap(data -> data.getLong("targetfieldnew_c.id"), data -> data, (o1, o2) -> o1));
        if (CollectionUtils.isEmpty(selfTargetFieldNewAndDy)) {
            return Optional.empty();
        }
        for (DynamicObject entryEntityDy : parentEntryEntityDys) {
            if (sourceEntityDy.getString("id").equals(entryEntityDy.getDynamicObject("sourceentity_c").getString("id")) && targetEntityDy.getString("id").equals(entryEntityDy.getString("targetentity_c.id")) || !targetEntityDy.getString("id").equals(entryEntityDy.getString("targetentity_c.id"))) continue;
            DynamicObjectCollection parentSubEntryEntityDys = entryEntityDy.getDynamicObjectCollection("subentryentity_c");
            Map<Long, DynamicObject> targetFieldNewAndSourceFieldMap = parentSubEntryEntityDys.stream().filter(data -> Objects.nonNull(data.getDynamicObject("targetfieldnew_c")) && data.getBoolean("writepersoninfo_c")).collect(Collectors.toMap(data -> data.getLong("targetfieldnew_c.id"), data -> data, (o1, o2) -> o1));
            for (Map.Entry<Long, DynamicObject> selfTargetFieldNewAndSourceFieldTag : selfTargetFieldNewAndDy.entrySet()) {
                Long selfTargetFieldNew = selfTargetFieldNewAndSourceFieldTag.getKey();
                if (!targetFieldNewAndSourceFieldMap.containsKey(selfTargetFieldNew)) continue;
                String targetFieldNewName = selfTargetFieldNewAndSourceFieldTag.getValue().getString("targetfieldnew_c.name");
                return Optional.of(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4eba\u5458\u4fe1\u606f\u5b57\u6bb5\u201c%1$s\u201d\u5df2\u5728\u5019\u9009\u4eba\u4fe1\u606f\u7ec4\u201c%2$s\u201d\u4e2d\u542f\u7528\u4e86\u201c\u56de\u5199\u4eba\u5458\u4fe1\u606f\u201d\uff0c\u65e0\u6cd5\u540c\u65f6\u7531\u4e24\u4e2a\u4e0d\u540c\u7684\u5b57\u6bb5\u56de\u5199\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (String)"FieldRelationEdit_2", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), targetFieldNewName, entryEntityDy.getDynamicObject("sourceentity_c").getString("name")));
            }
        }
        return Optional.empty();
    }

    private Optional<String> otherWritePersonInfoValidC(DynamicObject targetEntityDy, DynamicObjectCollection subEntryEntityDys) {
        String entryEntityData = (String)this.getView().getFormShowParameter().getCustomParam("otherentryentitydata");
        if (StringUtils.isBlank((CharSequence)entryEntityData)) {
            return Optional.empty();
        }
        DynamicObjectCollection parentEntryEntityDys = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)entryEntityData);
        Map<Long, DynamicObject> selfTargetFieldNewAndDy = subEntryEntityDys.stream().filter(data -> Objects.nonNull(data.getDynamicObject("targetfieldnew_c")) && data.getBoolean("writepersoninfo_c")).collect(Collectors.toMap(data -> data.getLong("targetfieldnew_c.id"), data -> data, (o1, o2) -> o1));
        if (CollectionUtils.isEmpty(selfTargetFieldNewAndDy)) {
            return Optional.empty();
        }
        for (DynamicObject entryEntityDy : parentEntryEntityDys) {
            if (!targetEntityDy.getString("id").equals(entryEntityDy.getString("targetentity.id"))) continue;
            DynamicObjectCollection parentSubEntryEntityDys = entryEntityDy.getDynamicObjectCollection("subentryentity");
            Map<Long, DynamicObject> targetFieldNewAndDy = parentSubEntryEntityDys.stream().filter(data -> Objects.nonNull(data.getDynamicObject("targetfieldnew")) && data.getBoolean("writepersoninfo")).collect(Collectors.toMap(data -> data.getLong("targetfieldnew.id"), data -> data, (o1, o2) -> o1));
            for (Map.Entry<Long, DynamicObject> entry : selfTargetFieldNewAndDy.entrySet()) {
                if (!targetFieldNewAndDy.containsKey(entry.getKey())) continue;
                String targetFieldNewName = entry.getValue().getString("targetfieldnew_c.name");
                return Optional.of(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4eba\u5458\u4fe1\u606f\u5b57\u6bb5\u201c%1$s\u201d\u5df2\u5728\u5355\u636e\u4fe1\u606f\u7ec4\u201c%2$s\u201d\u4e2d\u542f\u7528\u4e86\u201c\u56de\u5199\u4eba\u5458\u4fe1\u606f\u201d\uff0c\u65e0\u6cd5\u540c\u65f6\u7531\u4e24\u4e2a\u4e0d\u540c\u7684\u5355\u636e\u5b57\u6bb5\u56de\u5199\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (String)"FieldRelationEdit_1", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), targetFieldNewName, entryEntityDy.getString("billinfogroup")));
            }
        }
        return Optional.empty();
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String entryData = (String)this.getView().getFormShowParameter().getCustomParam("selectrowentitydy");
        String personnelBusinessBillNumber = (String)this.getView().getFormShowParameter().getCustomParam("personnelbusinessbillnumber");
        if (StringUtils.isBlank((CharSequence)personnelBusinessBillNumber)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)entryData)) {
            DynamicObject selectRowEntityDy = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)entryData);
            if (Objects.isNull(selectRowEntityDy)) {
                return;
            }
            Object sourceEntityDy = selectRowEntityDy.get("sourceentity_c");
            if (Objects.isNull(sourceEntityDy)) {
                return;
            }
            String sourceEntity = selectRowEntityDy.getString("sourceentity_c.number");
            DynamicObjectCollection scrSubEntryEntityDys = selectRowEntityDy.getDynamicObjectCollection("subentryentity_c");
            IFileMapManagerService.getInstance().setSubEntryEntityC(scrSubEntryEntityDys, this.getView());
            new FileMapManagerService().insertOrUpdatePersonfields(selectRowEntityDy);
            MainEntityType dataEntityType = IFileMapManagerService.getInstance().getEntityNameByExtEntityName(sourceEntity);
            this.dealCFieldsInfo(dataEntity, dataEntityType);
        }
    }

    private void dealCFieldsInfo(DynamicObject dataEntity, MainEntityType dataEntityType) {
        Map<String, String> allFieldMaps = dataEntityType.getProperties().stream().filter(data -> !data.getName().endsWith("_id")).collect(Collectors.toMap(IMetadata::getName, data -> Objects.isNull(data.getDisplayName()) ? data.getName() : data.getDisplayName().getLocaleValue()));
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("subentryentity_c");
        Map<String, DynamicObject> pageFieldMaps = entryEntity.stream().collect(Collectors.toMap(data -> data.getString("sourcefieldtag_c"), data -> data));
        for (Map.Entry<String, String> entry : allFieldMaps.entrySet()) {
            String key = entry.getKey();
            DynamicObject dynamicObject = pageFieldMaps.get(key);
            if (Objects.isNull(dynamicObject)) {
                dynamicObject = entryEntity.addNew();
                dynamicObject.set("ispkid_c", (Object)"0");
            }
            dynamicObject.set("sourcefield_c", (Object)allFieldMaps.getOrDefault(key, key));
            dynamicObject.set("sourcefieldtag_c", (Object)key);
        }
        this.getModel().updateEntryCache(entryEntity);
        this.getView().updateView("subentryentity_c");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult() == null || !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("donothing_save".equals(operateKey)) {
            DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity("subentryentity_c");
            this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64((Object)subEntryEntity));
            this.getPageCache().put("isdirectClose", "1");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        List customQFilters = beforeF7SelectEvent.getCustomQFilters();
        String entryData = (String)this.getView().getFormShowParameter().getCustomParam("selectrowentitydy");
        if (StringUtils.isBlank((CharSequence)entryData)) {
            return;
        }
        DynamicObject entity = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)entryData);
        if (Objects.isNull(entity)) {
            return;
        }
        String targetEntity = entity.getString("targetentity_c.id");
        if (StringUtils.isBlank((CharSequence)targetEntity)) {
            return;
        }
        switch (name) {
            case "targetfieldnew_c": {
                QFilter qFilter = new QFilter("targetentity.id", "=", (Object)targetEntity);
                customQFilters.add(qFilter);
                break;
            }
        }
    }
}

