/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin.fieldmap;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hpfs.business.service.fileMap.IFileMapManagerService;
import kd.hr.hpfs.common.utils.MetaUtils;
import kd.hr.hpfs.formplugin.fieldmap.FieldMapConfDrawPageUtil;
import kd.sdk.hr.common.constants.FileMapManagerConstants;
import kd.sdk.hr.common.helper.HpfsMetaDataServiceHelper;
import kd.sdk.hr.hpfs.common.constants.PerChgNewBillTplConstants;
import kd.sdk.hr.hpfs.utils.RepositoryUtils;

public class FileMapManagerEdit
extends HRDataBaseEdit
implements TreeNodeClickListener,
CellClickListener,
SearchEnterListener,
BeforeF7SelectListener,
RowClickEventListener,
FileMapManagerConstants {
    private static final String TREE_ID_ROOT = "root";
    private static final String STATUS_SELECTED = "selected";
    private static final String STATUS_UNSELECTED = "unselected";
    private static final String ISMAPPED_TRUE = String.valueOf(true);
    private static final String ISMAPPED_FALSE = String.valueOf(false);
    private static final String CONTROL_KEY_FLEX_SOURCEFIELDS = "flex_sourcefields";
    private static final String CONTROL_KEY_FLEX_TARGETFIELDS = "flex_targetfields";
    private static final String CONTROL_KEY_PAIRTREE = "pairtree";
    private static final String CONTROL_KEY_BTN_MAP = "btn_map";
    private static final String CONTROL_KEY_BTN_UNMAP = "btn_unmap";
    private static final String CONTROL_KEY_FLEX_MAPPEDFIELDS = "flex_mappedfields";
    private static final String CONTROL_KEY_SEARCH_SOURCE = "search_source";
    private static final String CONTROL_KEY_SEARCH_TARGET = "search_target";
    private static final String CONTROL_KEY_SEARCH_MAPPED = "search_mapped";
    private static final String CONTROL_KEY_LBL_SOUCEHEAD = "lbl_soucehead";
    private static final String CONTROL_KEY_LBL_TARGETHEAD = "lbl_targethead";
    private static final String CONTROL_KEY_ENEITYCONF = "entityconf";
    private static final String CHILDVIEWID = "childviewid";
    private static final String CHANGE_PERSONNEL_BUSINESS_BILL = "changePersonnelBusinessBill";
    private static final String ADV_SHEETMATCH_C = "adv_sheetmatch_c";
    private static final String BIZAPPID_ID = "bizappid.id";
    private HRPageCache hrPageCache;
    private static final String CACHE_KEY_CURRENT_FIELD_UNMAPPED_SOURCE = "current_field_unmapped_source";
    private static final String CACHE_KEY_CURRENT_FIELD_UNMAPPED_TARGET = "current_field_unmapped_target";
    private static final String CACHE_KEY_SELECTED_MAPPED_FIELDS = "selected_mapped_fields";
    private static final String CACHE_KEY_LAST_INITED_COMBO = "last_inited_combo";
    private static final String MAP_KEY_ENTITY_NUMBER = "entity_number";
    private static final String MAP_KEY_ENTRY_NUMBER = "entry_number";
    private static final String MAP_KEY_FIELD_NUMBER = "field_number";
    private static final String MAP_KEY_FIELD_NAME = "field_name";
    private static final String MAP_KEY_FIELD_TYPE = "field_type";
    private static final String MAP_KEY_POSITION = "position";
    private static final String MAP_KEY_ISMAPPED = "ismapped";
    private static final String MAP_KEY_SOURCE_PROP = "source_prop";
    private static final String MAP_KEY_SOURCE_ENTITY = "source_entity";
    private static final String MAP_KEY_TARGET_PROP = "target_prop";
    private static final String MAP_KEY_TARGET_ENTITY = "target_entity";
    private static final String UNMAP = "unmap";
    private static final Map<String, List<String>> PERSON3KEY = new HashMap<String, List<String>>(16);
    private static final Log LOGGER = LogFactory.getLog(FileMapManagerEdit.class);

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.initHRPageCache();
        this.setHomVisible();
    }

    private void initHRPageCache() {
        HRPageCache pageCache = this.getHRPageCache();
        LinkedList selectedFields = new LinkedList();
        pageCache.put(CACHE_KEY_SELECTED_MAPPED_FIELDS, selectedFields);
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        TreeView treeView = (TreeView)this.getView().getControl(CONTROL_KEY_PAIRTREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Button btnMap = (Button)this.getView().getControl(CONTROL_KEY_BTN_MAP);
        btnMap.addClickListener((ClickListener)this);
        Button btnUnmap = (Button)this.getView().getControl(CONTROL_KEY_BTN_UNMAP);
        btnUnmap.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addCellClickListener((CellClickListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid entryCGrid = (EntryGrid)this.getView().getControl("entryentity_c");
        entryCGrid.addCellClickListener((CellClickListener)this);
        entryCGrid.addRowClickListener((RowClickEventListener)this);
        Search searchSource = (Search)this.getView().getControl(CONTROL_KEY_SEARCH_SOURCE);
        searchSource.addEnterListener((SearchEnterListener)this);
        Search searchTarget = (Search)this.getView().getControl(CONTROL_KEY_SEARCH_TARGET);
        searchTarget.addEnterListener((SearchEnterListener)this);
        Search searchMapped = (Search)this.getView().getControl(CONTROL_KEY_SEARCH_MAPPED);
        searchMapped.addEnterListener((SearchEnterListener)this);
        BasedataEdit sourceEntityF7 = (BasedataEdit)this.getView().getControl("sourceentity");
        sourceEntityF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit targetEntityF7 = (BasedataEdit)this.getView().getControl("targetentity");
        targetEntityF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void cellClick(CellClickEvent evt) {
        String fieldKey;
        switch (fieldKey = evt.getFieldKey()) {
            case "sourceprikey": {
                this.setMapKeyComboProp("sourceentity", "sourceprikey", evt.getRow());
                break;
            }
            case "targetprikey": {
                this.setMapKeyComboProp("targetentity", "targetprikey", evt.getRow());
                break;
            }
            case "selectsrcentry": {
                this.showSelectEntryF7(evt);
                break;
            }
            case "srcentryfieldrelation": {
                this.showSrcEntryFieldRelationF7(evt);
                break;
            }
            case "srcentryfieldrelation_c": {
                this.showSrcEntryFieldRelationF7C(evt);
                break;
            }
        }
    }

    private void showSrcEntryFieldRelationF7C(CellClickEvent evt) {
        if (this.getChildView(false)) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hpfs_fieldrelationc");
        showParameter.getOpenStyle().setShowType(ShowType.PageDrawer);
        showParameter.getOpenStyle().setPlaceholder(false);
        showParameter.setStatus(OperationStatus.EDIT);
        String entryKey = ((EntryGrid)evt.getSource()).getEntryKey();
        DynamicObject selectRowEntityDy = this.getModel().getEntryRowEntity(entryKey, evt.getRow());
        if (Objects.isNull(selectRowEntityDy)) {
            return;
        }
        DynamicObject targetEntityDy = selectRowEntityDy.getDynamicObject("targetentity_c");
        if (Objects.isNull(targetEntityDy)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5173\u8054\u7684\u4eba\u5458\u4fe1\u606f\u7ec4", (String)"FileMapManagerEdit_8", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            return;
        }
        long id = selectRowEntityDy.getLong("id");
        if (id == 0L) {
            ORM.create().genLongId(selectRowEntityDy.getDataEntityType());
            selectRowEntityDy.set("id", (Object)id);
        }
        String caption = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u4e0e%2$s\u5b57\u6bb5\u5173\u7cfb", (String)"FileMapManagerEdit_12", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), selectRowEntityDy.getString("sourceentity_c.name"), targetEntityDy.getString("name"));
        showParameter.setCaption(caption);
        showParameter.setCustomParam("selectrowentitydy", (Object)SerializationUtils.serializeToBase64((Object)selectRowEntityDy));
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection entryEntityDys = this.getModel().getEntryEntity("entryentity_c");
        DynamicObjectCollection otherEntryEntityDys = this.getModel().getEntryEntity("entryentity");
        showParameter.setCustomParam("entryentitydata", (Object)SerializationUtils.serializeToBase64((Object)entryEntityDys));
        showParameter.setCustomParam("otherentryentitydata", (Object)SerializationUtils.serializeToBase64((Object)otherEntryEntityDys));
        DynamicObject personnelBusinessBill = dataEntity.getDynamicObject("personnelbusinessbill");
        if (Objects.isNull(personnelBusinessBill)) {
            return;
        }
        showParameter.setCustomParam("personnelbusinessbillnumber", (Object)personnelBusinessBill.getString("number"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "srcentryfieldrelation_c"));
        String pageId = showParameter.getPageId();
        this.getPageCache().put(CHILDVIEWID, pageId);
        this.getView().showForm(showParameter);
    }

    private boolean getChildView(boolean isClose) {
        try {
            String childWiewId = this.getPageCache().get(CHILDVIEWID);
            if (childWiewId != null) {
                IFormView view = this.getView().getView(childWiewId);
                if (isClose) {
                    view.getPageCache().put("isdirectClose", "1");
                    view.close();
                    this.getView().sendFormAction(view);
                    return false;
                }
                if (view.getModel().getDataChanged() && StringUtils.isNotBlank((CharSequence)view.getModel().getChangeDesc())) {
                    view.close();
                    this.getView().sendFormAction(view);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("childview is null");
        }
        return false;
    }

    private void showSrcEntryFieldRelationF7(CellClickEvent evt) {
        if (this.getChildView(false)) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hpfs_fieldrelation");
        showParameter.getOpenStyle().setShowType(ShowType.PageDrawer);
        showParameter.getOpenStyle().setPlaceholder(false);
        showParameter.setStatus(OperationStatus.EDIT);
        String entryKey = ((EntryGrid)evt.getSource()).getEntryKey();
        DynamicObject selectRowEntityDy = this.getModel().getEntryRowEntity(entryKey, evt.getRow());
        if (Objects.isNull(selectRowEntityDy)) {
            return;
        }
        DynamicObject targetEntityDy = selectRowEntityDy.getDynamicObject("targetentity");
        if (Objects.isNull(targetEntityDy)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5173\u8054\u7684\u4eba\u5458\u4fe1\u606f\u7ec4", (String)"FileMapManagerEdit_8", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            return;
        }
        long id = selectRowEntityDy.getLong("id");
        if (id == 0L) {
            ORM.create().genLongId(selectRowEntityDy.getDataEntityType());
            selectRowEntityDy.set("id", (Object)id);
        }
        String caption = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u4e0e%2$s\u5b57\u6bb5\u5173\u7cfb", (String)"FileMapManagerEdit_12", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), selectRowEntityDy.getString("billinfogroup"), targetEntityDy.getString("name"));
        showParameter.setCaption(caption);
        showParameter.setCustomParam("selectrowentitydy", (Object)SerializationUtils.serializeToBase64((Object)selectRowEntityDy));
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection entryEntityDys = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection otherEntryEntityDys = this.getModel().getEntryEntity("entryentity_c");
        showParameter.setCustomParam("entryentitydata", (Object)SerializationUtils.serializeToBase64((Object)entryEntityDys));
        showParameter.setCustomParam("otherentryentitydata", (Object)SerializationUtils.serializeToBase64((Object)otherEntryEntityDys));
        DynamicObject personnelBusinessBill = dataEntity.getDynamicObject("personnelbusinessbill");
        if (Objects.isNull(personnelBusinessBill)) {
            return;
        }
        showParameter.setCustomParam("personnelbusinessbillnumber", (Object)personnelBusinessBill.getString("number"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "srcentryfieldrelation"));
        String pageId = showParameter.getPageId();
        this.getPageCache().put(CHILDVIEWID, pageId);
        this.getView().showForm(showParameter);
    }

    public void afterLoadData(EventObject evt) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.setGroupInfo(dataEntity);
        this.getModel().setDataChanged(false);
    }

    private Map<String, String> getEntityKeyAndNameMap(DynamicObject dataEntity, List<String> extEntryList) {
        String number = dataEntity.getString("personnelbusinessbill.number");
        DataEntityPropertyCollection properties = IFileMapManagerService.getInstance().getEntityNameByExtEntityName(number).getProperties();
        List collect = properties.stream().filter(data -> extEntryList.contains(data.getName())).collect(Collectors.toList());
        return collect.stream().collect(Collectors.toMap(IMetadata::getName, data -> StringUtils.isNotBlank((CharSequence)data.getDisplayName().getLocaleValue()) ? data.getDisplayName().getLocaleValue() : data.getName()));
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (this.isUnmappedFieldFlex(key)) {
            this.changeUnmappedFieldSelectStatus(key);
        }
        if (this.isMappedMainFieldFlex(key)) {
            this.changeMappedFieldSelectStatus(key);
        }
        switch (key) {
            case "btn_map": {
                this.mapSelectedFields();
                this.updateTreeView();
                break;
            }
            case "btn_unmap": {
                this.showUnmapConfirm();
                break;
            }
        }
    }

    private void showUnmapConfirm() {
        HRPageCache pageCache = this.getHRPageCache();
        List<String> selectField = this.getSelectedMappedFields(pageCache);
        if (this.isTreeNoData() || CollectionUtils.isEmpty(selectField)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u89e3\u9664\u5173\u8054\u7684\u5b57\u6bb5\u3002", (String)"FileMapManagerEdit_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u89e3\u9664\u5173\u8054\uff1f", (String)"FileMapManagerEdit_1", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(UNMAP, (IFormPlugin)this));
    }

    public boolean isTreeNoData() {
        HRPageCache pageCache = this.getHRPageCache();
        TreeView tree = (TreeView)this.getControl(CONTROL_KEY_PAIRTREE);
        String nodeId = this.getSelectedTreeNode(tree);
        Map<String, Object> treeNodeInfo = this.getSelectedNodeInfo(pageCache);
        return HRStringUtils.isEmpty((String)nodeId) || HRStringUtils.equals((String)nodeId, (String)TREE_ID_ROOT) || null == treeNodeInfo || treeNodeInfo.isEmpty();
    }

    private void unmapSelectedFields() {
        HRPageCache pageCache = this.getHRPageCache();
        List<String> selectedFields = this.getSelectedMappedFields(pageCache);
        TreeView tree = (TreeView)this.getControl(CONTROL_KEY_PAIRTREE);
        String nodeId = this.getSelectedTreeNode(tree);
        this.selectTableEntityRow(nodeId);
        for (String fieldFlexKey : selectedFields) {
            Map<String, Object> treeNodeInfo = this.getSelectedNodeInfo(pageCache);
            Map mappedFieldsInfo = (Map)treeNodeInfo.get(fieldFlexKey);
            String sourceProp = (String)mappedFieldsInfo.get(MAP_KEY_SOURCE_PROP);
            String targetProp = (String)mappedFieldsInfo.get(MAP_KEY_TARGET_PROP);
            String sourceFieldKey = FieldMapConfDrawPageUtil.getUnmappedFlexKey(FieldMapConfDrawPageUtil.getUnmappedCommonKey("source", sourceProp));
            String targetFieldKey = FieldMapConfDrawPageUtil.getUnmappedFlexKey(FieldMapConfDrawPageUtil.getUnmappedCommonKey("target", targetProp));
            Map sourceFieldInfo = (Map)treeNodeInfo.get(sourceFieldKey);
            Map targetFieldInfo = (Map)treeNodeInfo.get(targetFieldKey);
            sourceFieldInfo.put(MAP_KEY_ISMAPPED, ISMAPPED_FALSE);
            targetFieldInfo.put(MAP_KEY_ISMAPPED, ISMAPPED_FALSE);
            treeNodeInfo.put(sourceFieldKey, sourceFieldInfo);
            treeNodeInfo.put(targetFieldKey, targetFieldInfo);
            treeNodeInfo.remove(fieldFlexKey);
            this.deleteMappedField(sourceProp, targetProp);
            pageCache.put(this.getSelectedTreeNodeId(), treeNodeInfo);
        }
        selectedFields.clear();
        pageCache.put(CACHE_KEY_SELECTED_MAPPED_FIELDS, selectedFields);
        this.drawAllFieldContainers(nodeId);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        int result;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals(UNMAP) && "Yes".equals(messageBoxClosedEvent.getResultValue())) {
            this.unmapSelectedFields();
            this.updateTreeView();
        }
        if (HRStringUtils.equals((String)callBackId, (String)CHANGE_PERSONNEL_BUSINESS_BILL) && (result = messageBoxClosedEvent.getResult().getValue()) == MessageBoxResult.Yes.getValue()) {
            this.changePersonnelBusinessBill();
        }
    }

    private void changePersonnelBusinessBill() {
        this.setHomVisible();
        this.getModel().deleteEntryData("entryentity");
        this.getModel().deleteEntryData("entryentity_c");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.setGroupInfo(dataEntity);
        this.getChildView(true);
    }

    private void deleteMappedField(String sourcePropKey, String targetPropKey) {
        DynamicObjectCollection mappedFields = this.getModel().getEntryEntity("subentryentity");
        ArrayList<Integer> indexToDelete = new ArrayList<Integer>();
        for (int i = 0; i < mappedFields.size(); ++i) {
            DynamicObject mappedField = (DynamicObject)mappedFields.get(i);
            if (!HRStringUtils.equals((String)sourcePropKey, (String)mappedField.getString("sourcefield")) || !HRStringUtils.equals((String)targetPropKey, (String)mappedField.getString("targetfield"))) continue;
            indexToDelete.add(i);
        }
        int size = indexToDelete.size();
        int[] indexToDeleteArray = new int[size];
        for (int index = 0; index < size; ++index) {
            indexToDeleteArray[index] = (Integer)indexToDelete.get(index);
        }
        this.getModel().deleteEntryRows("subentryentity", indexToDeleteArray);
    }

    private void mapSelectedFields() {
        HRPageCache cache = this.getHRPageCache();
        Map<String, Object> treeNodeInfo = this.getSelectedNodeInfo(cache);
        String sourceFieldKey = (String)cache.get(CACHE_KEY_CURRENT_FIELD_UNMAPPED_SOURCE, String.class);
        String targetFieldKey = (String)cache.get(CACHE_KEY_CURRENT_FIELD_UNMAPPED_TARGET, String.class);
        if (null == treeNodeInfo || treeNodeInfo.isEmpty() || HRStringUtils.isEmpty((String)sourceFieldKey) || HRStringUtils.isEmpty((String)targetFieldKey)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5173\u8054\u7684\u5b57\u6bb5\u3002", (String)"FileMapManagerEdit_2", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.selectTableEntityRow(this.getSelectedTreeNodeId());
        Map sourceFieldInfo = (Map)treeNodeInfo.get(sourceFieldKey);
        Map targetFieldInfo = (Map)treeNodeInfo.get(targetFieldKey);
        String sourceField = (String)sourceFieldInfo.get(MAP_KEY_FIELD_NUMBER);
        String targetField = (String)targetFieldInfo.get(MAP_KEY_FIELD_NUMBER);
        sourceFieldInfo.put(MAP_KEY_ISMAPPED, ISMAPPED_TRUE);
        targetFieldInfo.put(MAP_KEY_ISMAPPED, ISMAPPED_TRUE);
        treeNodeInfo.put(sourceFieldKey, sourceFieldInfo);
        treeNodeInfo.put(targetFieldKey, targetFieldInfo);
        TreeView tree = (TreeView)this.getControl(CONTROL_KEY_PAIRTREE);
        String nodeId = this.getSelectedTreeNode(tree);
        this.addMappedFieldsToEntry(sourceField, targetField);
        cache.put(this.getSelectedTreeNodeId(), treeNodeInfo);
        cache.remove(CACHE_KEY_CURRENT_FIELD_UNMAPPED_TARGET);
        this.drawAllFieldContainers(nodeId);
    }

    public void addMappedFieldsToEntry(String sourceField, String targetField) {
        int fieldRowIndex = this.getModel().createNewEntryRow("subentryentity");
        this.getModel().setValue("sourcefield", (Object)sourceField, fieldRowIndex);
        this.getModel().setValue("targetfield", (Object)targetField, fieldRowIndex);
    }

    public void drawAllFieldContainers(String nodeId) {
        this.clearFieldsCache();
        String[] tableNumbers = nodeId.split("\\|");
        String sourceTable = tableNumbers[0];
        String targetTable = tableNumbers[1];
        this.drawUnmappedFieldContainer(sourceTable, CONTROL_KEY_FLEX_SOURCEFIELDS, "source", "");
        this.drawUnmappedFieldContainer(targetTable, CONTROL_KEY_FLEX_TARGETFIELDS, "target", "");
        this.drawMappedFieldContainer(sourceTable, targetTable, "");
    }

    private void clearFieldsCache() {
        HRPageCache cache = this.getHRPageCache();
        cache.remove(CACHE_KEY_CURRENT_FIELD_UNMAPPED_SOURCE);
        cache.remove(CACHE_KEY_CURRENT_FIELD_UNMAPPED_TARGET);
        cache.remove(CACHE_KEY_SELECTED_MAPPED_FIELDS);
    }

    private boolean isUnmappedFieldFlex(String key) {
        return key.contains("flex_fieldum");
    }

    private boolean isMappedMainFieldFlex(String key) {
        return key.contains("flex_fieldmm");
    }

    private void changeMappedFieldSelectStatus(String key) {
        HRPageCache pageCache = this.getHRPageCache();
        Map<String, Object> treeNodeInfo = this.getSelectedNodeInfo(pageCache);
        Map mappedFieldsInfo = (Map)treeNodeInfo.get(key);
        List<String> selectedFields = this.getSelectedMappedFields(pageCache);
        boolean isSelected = selectedFields.contains(key);
        if (isSelected) {
            selectedFields.remove(key);
        } else {
            selectedFields.add(key);
        }
        isSelected = !isSelected;
        this.changeMappedFieldBorderLineColor(key, isSelected, mappedFieldsInfo);
        pageCache.put(CACHE_KEY_SELECTED_MAPPED_FIELDS, selectedFields);
        pageCache.put(this.getSelectedTreeNodeId(), treeNodeInfo);
    }

    private List<String> getSelectedMappedFields(HRPageCache pageCache) {
        ArrayList selectedFields = (ArrayList)pageCache.get(CACHE_KEY_SELECTED_MAPPED_FIELDS, List.class);
        if (null == selectedFields) {
            selectedFields = new ArrayList();
        }
        return selectedFields;
    }

    private void changeMappedFieldBorderLineColor(String fieldFlexKey, boolean isSelected, Map<String, String> mappedFieldsInfo) {
        if (mappedFieldsInfo == null) {
            return;
        }
        String sourceProp = mappedFieldsInfo.get(MAP_KEY_SOURCE_PROP);
        String sourceEntity = mappedFieldsInfo.get(MAP_KEY_SOURCE_ENTITY);
        String targetProp = mappedFieldsInfo.get(MAP_KEY_TARGET_PROP);
        String targetEntity = mappedFieldsInfo.get(MAP_KEY_TARGET_ENTITY);
        String entryNum = mappedFieldsInfo.get(MAP_KEY_ENTRY_NUMBER);
        sourceEntity = MetaUtils.getSourceEntityNum((String)sourceEntity);
        MainEntityType sourceEntityType = EntityMetadataCache.getDataEntityType((String)sourceEntity);
        DataEntityPropertyCollection sourceProps = sourceEntityType.getProperties();
        DynamicProperty sourceProperty = null;
        if (HRStringUtils.isNotEmpty((String)entryNum) && !HRStringUtils.equals((String)entryNum, (String)sourceEntity)) {
            DataEntityPropertyCollection entityProperties = ((EntryProp)sourceProps.get((Object)entryNum)).getDynamicCollectionItemPropertyType().getProperties();
            sourceProperty = (DynamicProperty)entityProperties.get((Object)sourceProp);
        } else {
            sourceProperty = (DynamicProperty)sourceProps.get((Object)sourceProp);
        }
        MainEntityType targetEntityType = EntityMetadataCache.getDataEntityType((String)targetEntity);
        DataEntityPropertyCollection targetProps = targetEntityType.getProperties();
        DynamicProperty targetProperty = (DynamicProperty)targetProps.get((Object)targetProp);
        FlexPanelAp mappedFieldAp = null;
        mappedFieldAp = isSelected ? FieldMapConfDrawPageUtil.combineSelectedMappedFieldAp(sourceProperty, sourceEntityType.getDisplayName().getLocaleValue(), true, targetProperty, targetEntityType.getDisplayName().getLocaleValue(), true) : FieldMapConfDrawPageUtil.combineUnselectedMappedFieldAp(sourceProperty, sourceEntityType.getDisplayName().getLocaleValue(), true, targetProperty, targetEntityType.getDisplayName().getLocaleValue(), true);
        this.getView().updateControlMetadata(fieldFlexKey, mappedFieldAp.createControl());
    }

    public void onGetControl(OnGetControlArgs evt) {
        super.onGetControl(evt);
        String key = evt.getKey();
        if (this.isClickableFieldFlex(key)) {
            this.bindFieldFlexClick(key, evt);
        }
    }

    public boolean isClickableFieldFlex(String key) {
        return key.contains("flex_fieldum") || key.contains("flex_fieldmm");
    }

    private void bindFieldFlexClick(String key, OnGetControlArgs evt) {
        Container container = new Container();
        container.setKey(key);
        container.setView(this.getView());
        container.addClickListener((ClickListener)this);
        evt.setControl((Control)container);
    }

    public void changeUnmappedFieldSelectStatus(String newKey) {
        HRPageCache pageCache = this.getHRPageCache();
        Map<String, String> newFieldInfo = this.getUnmappedFieldInfo(newKey, pageCache);
        if (newFieldInfo == null) {
            return;
        }
        String position = newFieldInfo.get(MAP_KEY_POSITION);
        String currentSelectedFileKeyPosition = "";
        currentSelectedFileKeyPosition = HRStringUtils.equals((String)position, (String)"source") ? CACHE_KEY_CURRENT_FIELD_UNMAPPED_SOURCE : CACHE_KEY_CURRENT_FIELD_UNMAPPED_TARGET;
        String currentSelectedFlexKey = (String)pageCache.get(currentSelectedFileKeyPosition, String.class);
        if (!HRStringUtils.isEmpty((String)currentSelectedFlexKey)) {
            this.changeUnmappedFieldBorderLineColor(currentSelectedFlexKey, STATUS_UNSELECTED);
        }
        this.changeUnmappedFieldBorderLineColor(newKey, STATUS_SELECTED);
        pageCache.put(currentSelectedFileKeyPosition, (Object)newKey);
    }

    private void changeUnmappedFieldBorderLineColor(String fieldFlexKey, String selectedStatus) {
        HRPageCache pageCache = this.getHRPageCache();
        Map<String, String> fieldInfo = this.getUnmappedFieldInfo(fieldFlexKey, pageCache);
        String entityNumber = fieldInfo.get(MAP_KEY_ENTITY_NUMBER);
        String fieldNumber = fieldInfo.get(MAP_KEY_FIELD_NUMBER);
        String position = fieldInfo.get(MAP_KEY_POSITION);
        String entryNum = fieldInfo.get(MAP_KEY_ENTRY_NUMBER);
        entityNumber = MetaUtils.getSourceEntityNum((String)entityNumber);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = entityType.getProperties();
        DynamicProperty property = null;
        if (HRStringUtils.isNotEmpty((String)entryNum) && !HRStringUtils.equals((String)entryNum, (String)entityNumber)) {
            DataEntityPropertyCollection entityProperties = ((EntryProp)properties.get((Object)entryNum)).getDynamicCollectionItemPropertyType().getProperties();
            property = (DynamicProperty)entityProperties.get((Object)fieldNumber);
        } else {
            property = (DynamicProperty)properties.get((Object)fieldNumber);
        }
        FlexPanelAp selectedUnmappedFieldAp = null;
        if (STATUS_SELECTED.equals(selectedStatus)) {
            selectedUnmappedFieldAp = FieldMapConfDrawPageUtil.combineSelectedUnmappedFieldAp(property, entityType.getDisplayName().getLocaleValue(), position, true);
        }
        if (STATUS_UNSELECTED.equals(selectedStatus)) {
            selectedUnmappedFieldAp = FieldMapConfDrawPageUtil.combineUnselectedUnmappedFieldAp(property, entityType.getDisplayName().getLocaleValue(), position, true);
        }
        if (null != selectedUnmappedFieldAp) {
            this.getView().updateControlMetadata(fieldFlexKey, selectedUnmappedFieldAp.createControl());
        }
    }

    public void showFields(String nodeId) {
        this.drawAllFieldContainers(nodeId);
    }

    public void cleanFields() {
        this.drawEmptyUnmappedFiledContainer(CONTROL_KEY_FLEX_SOURCEFIELDS, "source");
        this.drawEmptyUnmappedFiledContainer(CONTROL_KEY_FLEX_TARGETFIELDS, "target");
        this.drawEmptyMappedFiledContainer(CONTROL_KEY_FLEX_MAPPEDFIELDS);
    }

    public void drawEmptyUnmappedFiledContainer(String containerKey, String position) {
        FlexPanelAp fieldsContainerFlexAp = FieldMapConfDrawPageUtil.createUnmappedFieldsContainerFlex(containerKey);
        Container fieldsContainerFlex = (Container)this.getControl(containerKey);
        List items = ((Container)fieldsContainerFlexAp.buildRuntimeControl()).getItems();
        fieldsContainerFlex.getItems().addAll(items);
        this.getView().createControlIndex(fieldsContainerFlex.getItems());
        this.getView().updateControlMetadata(containerKey, fieldsContainerFlexAp.createControl());
    }

    public void drawUnmappedFieldContainer(String entityName, String containerKey, String position, String searchText) {
        String[] entityNames = entityName.split("\\.");
        String entryName = "";
        entityName = entityNames[0];
        if (entityNames.length == 2) {
            entryName = entityNames[1];
        }
        entityName = MetaUtils.getSourceEntityNum((String)entityName);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DataEntityPropertyCollection properties = entityType.getProperties();
        FlexPanelAp fieldsContainerFlexAp = FieldMapConfDrawPageUtil.createUnmappedFieldsContainerFlex(containerKey);
        Container fieldsContainerFlex = (Container)this.getControl(containerKey);
        HRPageCache pageCache = this.getHRPageCache();
        Map<String, Object> tableInfo = this.getSelectedNodeInfo(pageCache);
        for (IDataEntityProperty property : properties) {
            this.appendUnmappedField(entityType, fieldsContainerFlexAp, fieldsContainerFlex, property, position, searchText, tableInfo, entryName, entityName);
        }
        pageCache.put(this.getSelectedTreeNodeId(), tableInfo);
        List items = ((Container)fieldsContainerFlexAp.buildRuntimeControl()).getItems();
        fieldsContainerFlex.getItems().addAll(items);
        this.getView().createControlIndex(fieldsContainerFlex.getItems());
        this.getView().updateControlMetadata(containerKey, fieldsContainerFlexAp.createControl());
        int fieldAmount = items.size();
        if ("source".equals(position)) {
            Label lblHead = (Label)this.getView().getControl(CONTROL_KEY_LBL_SOUCEHEAD);
            lblHead.setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6e90\u5b57\u6bb5(%s)", (String)"FileMapManagerEdit_3", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), fieldAmount));
        } else {
            Label lblHead = (Label)this.getView().getControl(CONTROL_KEY_LBL_TARGETHEAD);
            lblHead.setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u76ee\u6807\u5b57\u6bb5(%s)", (String)"FileMapManagerEdit_4", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), fieldAmount));
        }
    }

    public void appendUnmappedField(MainEntityType sourceEntityType, FlexPanelAp fieldsContainerFlexAp, Container fieldsContainerFlex, IDataEntityProperty property, String position, String searchText, Map<String, Object> tableInfo, String entryName, String entityName) {
        if (!this.isFieldShouldShow(property)) {
            return;
        }
        List<String> valList = PERSON3KEY.get(entityName);
        if (!CollectionUtils.isEmpty(valList) && valList.contains(property.getName())) {
            return;
        }
        if (!HRStringUtils.isEmpty((String)entryName) && !HRStringUtils.equals((String)entryName, (String)entityName) && property.getName().equals(entryName)) {
            if (property instanceof EntryProp) {
                DataEntityPropertyCollection properties = ((EntryProp)property).getDynamicCollectionItemPropertyType().getProperties();
                for (IDataEntityProperty entryProper : properties) {
                    if (this.filterBaseDataId(entryProper) || this.filterId(entryProper)) continue;
                    this.createFlexAndSaveCache(sourceEntityType, fieldsContainerFlexAp, entryProper, position, searchText, tableInfo, entryName);
                }
            }
        } else if (HRStringUtils.equals((String)entryName, (String)entityName) || HRStringUtils.isEmpty((String)entryName)) {
            this.createFlexAndSaveCache(sourceEntityType, fieldsContainerFlexAp, property, position, searchText, tableInfo, entryName);
        }
    }

    private void createFlexAndSaveCache(MainEntityType sourceEntityType, FlexPanelAp fieldsContainerFlexAp, IDataEntityProperty property, String position, String searchText, Map<String, Object> tableInfo, String entryName) {
        FlexPanelAp unmappedFieldFlexAp = FieldMapConfDrawPageUtil.combineUnselectedUnmappedFieldAp((DynamicProperty)property, sourceEntityType.getDisplayName().getLocaleValue(), position, true);
        String fieldFlexKey = unmappedFieldFlexAp.getKey();
        this.cacheUnmappedFieldInfo(fieldFlexKey, entryName, sourceEntityType, property, position, false, tableInfo);
        if (!this.isFieldMapped(fieldFlexKey, property.getName()) && this.matchSearch(property, searchText)) {
            fieldsContainerFlexAp.getItems().add(unmappedFieldFlexAp);
        }
    }

    private boolean matchSearch(IDataEntityProperty property, String searchText) {
        if (HRStringUtils.isEmpty((String)searchText)) {
            return true;
        }
        LocaleString displayName = property.getDisplayName();
        return property.getName().contains(searchText) || null != displayName && null != displayName.getLocaleValue() && displayName.getLocaleValue().contains(searchText);
    }

    private void cacheUnmappedFieldInfo(String fieldFlexKey, String entryName, MainEntityType sourceEntityType, IDataEntityProperty property, String position, boolean isMapped, Map<String, Object> tableInfo) {
        HashMap<String, String> fieldFlexInfo = (HashMap<String, String>)tableInfo.get(fieldFlexKey);
        if (null != fieldFlexInfo) {
            return;
        }
        fieldFlexInfo = new HashMap<String, String>();
        fieldFlexInfo.put(MAP_KEY_ENTITY_NUMBER, sourceEntityType.getName());
        fieldFlexInfo.put(MAP_KEY_ENTRY_NUMBER, entryName);
        fieldFlexInfo.put(MAP_KEY_FIELD_NUMBER, property.getName());
        LocaleString displayName = property.getDisplayName();
        if (null == displayName) {
            fieldFlexInfo.put(MAP_KEY_FIELD_NAME, property.getName());
        } else {
            fieldFlexInfo.put(MAP_KEY_FIELD_NAME, property.getDisplayName().getLocaleValue());
        }
        fieldFlexInfo.put(MAP_KEY_FIELD_TYPE, property.getClass().getName());
        fieldFlexInfo.put(MAP_KEY_POSITION, position);
        if (isMapped) {
            fieldFlexInfo.put(MAP_KEY_ISMAPPED, ISMAPPED_TRUE);
        } else {
            fieldFlexInfo.put(MAP_KEY_ISMAPPED, ISMAPPED_FALSE);
        }
        tableInfo.put(fieldFlexKey, fieldFlexInfo);
    }

    public Map<String, String> getUnmappedFieldInfo(String fieldFlexKey, HRPageCache pageCache) {
        Map<String, Object> tableInfo = this.getSelectedNodeInfo(pageCache);
        Map fieldInfo = (Map)tableInfo.get(fieldFlexKey);
        return fieldInfo;
    }

    public Map<String, Object> getNodeInfo(String sourceEntityId, String targetEntityId, String hisStatus) {
        HRPageCache cache = this.getHRPageCache();
        HashMap tableInfo = (HashMap)cache.get(this.getNodeId(sourceEntityId, targetEntityId, hisStatus), Map.class);
        if (null == tableInfo) {
            tableInfo = new HashMap();
        }
        return tableInfo;
    }

    public Map<String, Object> getNodeInfo(String sourceEntityId, String targetEntityId) {
        HRPageCache cache = this.getHRPageCache();
        HashMap tableInfo = (HashMap)cache.get(this.getNodeId(sourceEntityId, targetEntityId), Map.class);
        if (null == tableInfo) {
            tableInfo = new HashMap();
        }
        return tableInfo;
    }

    public String getNodeId(String sourceEntityId, String targetEntityId, String hisStatus) {
        return sourceEntityId + "|" + targetEntityId + "|" + hisStatus;
    }

    public String getNodeId(String sourceEntityId, String targetEntityId) {
        return sourceEntityId + "|" + targetEntityId;
    }

    public Map<String, Object> getSelectedNodeInfo() {
        HRPageCache cache = this.getHRPageCache();
        return this.getSelectedNodeInfo(cache);
    }

    public Map<String, Object> getSelectedNodeInfo(HRPageCache pageCache) {
        HashMap tableInfo = (HashMap)pageCache.get(this.getSelectedTreeNodeId(), Map.class);
        if (null == tableInfo) {
            tableInfo = new HashMap();
        }
        return tableInfo;
    }

    public void drawMappedFieldContainer(String sourceTable, String targetTable, String searchText) {
        String[] entityNames = sourceTable.split("\\.");
        String entryNum = "";
        sourceTable = entityNames[0];
        if (entityNames.length == 2) {
            entryNum = entityNames[1];
        }
        DynamicObjectCollection mappedFields = this.getModel().getEntryEntity("subentryentity");
        sourceTable = MetaUtils.getSourceEntityNum((String)sourceTable);
        MainEntityType sourceEntityType = EntityMetadataCache.getDataEntityType((String)sourceTable);
        MainEntityType targetEntityType = EntityMetadataCache.getDataEntityType((String)targetTable);
        DataEntityPropertyCollection sourceProperties = sourceEntityType.getProperties();
        DataEntityPropertyCollection targetProperties = targetEntityType.getProperties();
        FlexPanelAp fieldsContainerFlexAp = FieldMapConfDrawPageUtil.createMappedFieldsContainerFlex(CONTROL_KEY_FLEX_MAPPEDFIELDS);
        Container fieldsContainerFlex = (Container)this.getControl(CONTROL_KEY_FLEX_MAPPEDFIELDS);
        for (DynamicObject mappedField : mappedFields) {
            String sourceField = mappedField.getString("sourcefield");
            String targetField = mappedField.getString("targetfield");
            if (HRStringUtils.isEmpty((String)sourceField) || HRStringUtils.isEmpty((String)targetField)) continue;
            DynamicProperty sourceFieldProp = null;
            if (HRStringUtils.isNotEmpty((String)entryNum) && !HRStringUtils.equals((String)entryNum, (String)sourceTable)) {
                DataEntityPropertyCollection entityProperties = ((EntryProp)sourceProperties.get((Object)entryNum)).getDynamicCollectionItemPropertyType().getProperties();
                sourceFieldProp = (DynamicProperty)entityProperties.get((Object)sourceField);
            } else {
                sourceFieldProp = (DynamicProperty)sourceProperties.get((Object)sourceField);
            }
            DynamicProperty targetFieldProp = (DynamicProperty)targetProperties.get((Object)targetField);
            this.appendMappedField(sourceFieldProp, sourceEntityType, targetFieldProp, targetEntityType, fieldsContainerFlexAp, searchText, entryNum);
        }
        List items = ((Container)fieldsContainerFlexAp.buildRuntimeControl()).getItems();
        fieldsContainerFlex.getItems().addAll(items);
        this.getView().createControlIndex(fieldsContainerFlex.getItems());
        this.getView().updateControlMetadata(CONTROL_KEY_FLEX_MAPPEDFIELDS, fieldsContainerFlexAp.createControl());
    }

    public void drawEmptyMappedFiledContainer(String containerKey) {
        FlexPanelAp fieldsContainerFlexAp = FieldMapConfDrawPageUtil.createMappedFieldsContainerFlex(containerKey);
        Container fieldsContainerFlex = (Container)this.getControl(containerKey);
        List items = ((Container)fieldsContainerFlexAp.buildRuntimeControl()).getItems();
        fieldsContainerFlex.getItems().addAll(items);
        this.getView().createControlIndex(fieldsContainerFlex.getItems());
        this.getView().updateControlMetadata(containerKey, fieldsContainerFlexAp.createControl());
    }

    private void appendMappedField(DynamicProperty sourceFieldProp, MainEntityType sourceEntityType, DynamicProperty targetFieldProp, MainEntityType targetEntityType, FlexPanelAp fieldsContainerFlexAp, String searchText, String entryNum) {
        if (sourceFieldProp == null || targetFieldProp == null) {
            return;
        }
        FlexPanelAp fieldFlexAp = FieldMapConfDrawPageUtil.combineUnselectedMappedFieldAp(sourceFieldProp, sourceEntityType.getDisplayName().getLocaleValue(), true, targetFieldProp, targetEntityType.getDisplayName().getLocaleValue(), false);
        this.cacheMappedFieldInfo(fieldFlexAp.getKey(), sourceEntityType.getName(), (IDataEntityProperty)sourceFieldProp, targetEntityType.getName(), (IDataEntityProperty)targetFieldProp, entryNum);
        if (this.matchSearch(sourceFieldProp, targetFieldProp, searchText)) {
            fieldsContainerFlexAp.getItems().add(fieldFlexAp);
        }
    }

    private boolean matchSearch(DynamicProperty sourceFieldProp, DynamicProperty targetFieldProp, String searchText) {
        return this.matchSearch((IDataEntityProperty)sourceFieldProp, searchText) || this.matchSearch((IDataEntityProperty)targetFieldProp, searchText);
    }

    private void cacheMappedFieldInfo(String fieldFlexKey, String sourceEntityType, IDataEntityProperty sourceProperty, String targetEntityType, IDataEntityProperty targetProperty, String entryNum) {
        HRPageCache pageCache = this.getHRPageCache();
        Map<String, Object> treeNodeInfo = this.getSelectedNodeInfo(pageCache);
        HashMap<String, String> fieldFlexInfo = (HashMap<String, String>)treeNodeInfo.get(fieldFlexKey);
        if (null != fieldFlexInfo) {
            return;
        }
        fieldFlexInfo = new HashMap<String, String>();
        fieldFlexInfo.put(MAP_KEY_SOURCE_ENTITY, sourceEntityType);
        fieldFlexInfo.put(MAP_KEY_SOURCE_PROP, sourceProperty.getName());
        fieldFlexInfo.put(MAP_KEY_TARGET_ENTITY, targetEntityType);
        fieldFlexInfo.put(MAP_KEY_TARGET_PROP, targetProperty.getName());
        fieldFlexInfo.put(MAP_KEY_ENTRY_NUMBER, entryNum);
        treeNodeInfo.put(fieldFlexKey, fieldFlexInfo);
        pageCache.put(this.getSelectedTreeNodeId(), treeNodeInfo);
    }

    private boolean isFieldShouldShow(IDataEntityProperty property) {
        LocaleString chineseName = property.getDisplayName();
        String dbName = property.getAlias();
        String name = property.getName();
        return null != chineseName || "id".equals(name);
    }

    private boolean filterId(IDataEntityProperty property) {
        LocaleString chineseName = property.getDisplayName();
        String name = property.getName();
        return "id".equals(name);
    }

    private boolean filterBaseDataId(IDataEntityProperty property) {
        LocaleString chineseName = property.getDisplayName();
        String name = property.getName();
        return chineseName == null && name.contains("_id");
    }

    private boolean isFieldMapped(String fieldKey, String propertyNumber) {
        Map<String, Object> treeNodeInfo = this.getSelectedNodeInfo();
        Map fieldInfo = (Map)treeNodeInfo.get(fieldKey);
        if (null == fieldInfo) {
            DynamicObjectCollection mappedFields = this.getModel().getEntryEntity("subentryentity");
            for (DynamicObject mappedField : mappedFields) {
                if (!HRStringUtils.equals((String)mappedField.getString("sourcefield"), (String)propertyNumber)) continue;
                return true;
            }
            return false;
        }
        String isMapped = (String)fieldInfo.get(MAP_KEY_ISMAPPED);
        return ISMAPPED_TRUE.equals(isMapped);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        TreeView treeView = (TreeView)evt.getSource();
        String nodeId = (String)evt.getNodeId();
        if (HRStringUtils.equals((String)CONTROL_KEY_PAIRTREE, (String)treeView.getKey())) {
            if (TREE_ID_ROOT.equals(nodeId)) {
                evt.setCancel(true);
                return;
            }
            this.clearSearchText();
            this.selectTableEntityRow(nodeId);
            this.showFields(nodeId);
        }
    }

    private void clearSearchText() {
        Search searchSource = (Search)this.getView().getControl(CONTROL_KEY_SEARCH_SOURCE);
        searchSource.setSearchKey("");
        Search searchTarget = (Search)this.getView().getControl(CONTROL_KEY_SEARCH_TARGET);
        searchTarget.setSearchKey("");
        Search searchMapped = (Search)this.getView().getControl(CONTROL_KEY_SEARCH_MAPPED);
        searchMapped.setSearchKey("");
    }

    private void selectTableEntityRow(String nodeId) {
        DynamicObjectCollection mappedTables = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < mappedTables.size(); ++i) {
            EntryGrid tableEntityGrid;
            DynamicObject mappedTable = (DynamicObject)mappedTables.get(i);
            String[] tableNumbers = nodeId.split("\\|");
            String sourceAndEntryNum = "";
            String sourceNum = "";
            String targetNum = "";
            String entryNum = "";
            if (tableNumbers.length >= 2) {
                targetNum = tableNumbers[1];
                sourceAndEntryNum = tableNumbers[0];
                String[] soureNumAndEntry = sourceAndEntryNum.split("\\.");
                sourceNum = soureNumAndEntry[0];
                if (soureNumAndEntry.length >= 2) {
                    entryNum = soureNumAndEntry[1];
                }
            }
            DynamicObject sourceEntity = mappedTable.getDynamicObject("sourceentity");
            DynamicObject targetEntity = mappedTable.getDynamicObject("targetentity");
            String sourceentryNum = mappedTable.getString("sourceentry");
            if (null == sourceEntity || null == targetEntity || !HRStringUtils.equals((String)sourceEntity.getString("number"), (String)sourceNum) || !HRStringUtils.equals((String)targetEntity.getString("number"), (String)targetNum)) continue;
            if (HRStringUtils.isEmpty((String)entryNum)) {
                tableEntityGrid = (EntryGrid)this.getControl("entryentity");
                tableEntityGrid.selectRows(i);
                continue;
            }
            if (!HRStringUtils.equals((String)sourceentryNum, (String)entryNum)) continue;
            tableEntityGrid = (EntryGrid)this.getControl("entryentity");
            tableEntityGrid.selectRows(i);
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.initPairTreeView();
        this.updateTreeView();
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String propertyName;
        block7 : switch (propertyName = evt.getProperty().getName()) {
            case "sourceentity": {
                this.updateTreeView();
                break;
            }
            case "targetentity": {
                this.updateTreeView();
                ChangeData[] changeSet = evt.getChangeSet();
                if (changeSet == null || changeSet.length == 0) {
                    return;
                }
                if (Objects.nonNull(changeSet[0].getOldValue()) && !changeSet[0].getOldValue().equals(changeSet[0].getNewValue())) {
                    this.getModel().deleteEntryData("subentryentity");
                    this.getView().updateView("subentryentity");
                }
                if (!Objects.nonNull(changeSet[0].getNewValue())) break;
                DynamicObjectCollection entryEntityDys = this.getModel().getEntryEntity("entryentity");
                Map<String, List<DynamicObject>> targetEntityAndDysMap = entryEntityDys.stream().filter(data -> "n_extinfo_fields".equals(data.getString("sourceentry"))).filter(data -> Objects.nonNull(data.getDynamicObject("targetentity"))).collect(Collectors.groupingBy(data -> data.getString("targetentity.id")));
                for (Map.Entry<String, List<DynamicObject>> entry : targetEntityAndDysMap.entrySet()) {
                    if (entry.getValue().size() <= 1) continue;
                    String billInfoGroup = entry.getValue().get(0).getString("billinfogroup");
                    String targetEntityName = entry.getValue().get(0).getString("targetentity.name");
                    String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5355\u636e\u4fe1\u606f\u5206\u7ec4\u201c%1$s\u201d\uff0c\u4eba\u5458\u4fe1\u606f\u7ec4\u201c%2$s\u201d\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (String)"FileMapManagerEdit_9", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), billInfoGroup, targetEntityName);
                    this.getView().showErrorNotification(msg);
                    break block7;
                }
                break;
            }
            case "targetentity_c": {
                this.changeTargetEntityC(evt);
                break;
            }
            case "sourceentry": {
                this.updateTreeView();
                break;
            }
            case "personnelbusinessbill": {
                this.changePersonnelBusinessBill(evt);
                break;
            }
        }
    }

    private void setHomVisible() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject personnelbusinessbill = dataEntity.getDynamicObject("personnelbusinessbill");
        if (Objects.nonNull(personnelbusinessbill)) {
            this.getView().setVisible(Boolean.valueOf("1WXB5G9/BL46".equals(personnelbusinessbill.getString(BIZAPPID_ID))), new String[]{ADV_SHEETMATCH_C});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ADV_SHEETMATCH_C});
        }
    }

    private void changeTargetEntityC(PropertyChangedArgs evt) {
        ChangeData[] changeSet = evt.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        if (Objects.nonNull(changeSet[0].getOldValue()) && !changeSet[0].getOldValue().equals(changeSet[0].getNewValue())) {
            this.getModel().deleteEntryData("subentryentity_c");
            this.getView().updateView("subentryentity_c");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("save".equals(operateKey) && this.getChildView(false)) {
            args.setCancel(true);
            return;
        }
    }

    private void changePersonnelBusinessBill(PropertyChangedArgs args) {
        ChangeData[] changeSet = args.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        if (Objects.nonNull(changeSet[0].getNewValue()) && changeSet[0].getNewValue().equals(changeSet[0].getOldValue())) {
            return;
        }
        if (Objects.isNull(changeSet[0].getOldValue())) {
            this.changePersonnelBusinessBill();
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6362\u4eba\u4e8b\u4e1a\u52a1\u5355\u636e\u540e\u5c06\u6e05\u7a7a\u5355\u636e\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\uff1f", (String)"FileMapManagerEdit_11", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CHANGE_PERSONNEL_BUSINESS_BILL, (IFormPlugin)this));
        }
    }

    private void setGroupInfo(DynamicObject dataEntity) {
        DynamicObject personnelBusinessBill = dataEntity.getDynamicObject("personnelbusinessbill");
        if (Objects.isNull(personnelBusinessBill)) {
            return;
        }
        String number = personnelBusinessBill.getString("number");
        MainEntityType dataEntityType = IFileMapManagerService.getInstance().getEntityNameByExtEntityName(number);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection entryEntityC = this.getModel().getEntryEntity("entryentity_c");
        this.dealSysPresetEntryInfo(number, entryEntity);
        this.dealExtEntryInfo(dataEntity, properties, entryEntity);
        this.dealExtFieldsInfo(dataEntity, properties, entryEntity);
        this.sortEntryEntity(entryEntity, "srcentryissyspreset", "billinfogroup", "targetentity.id");
        this.getModel().updateEntryCache(entryEntity);
        this.getView().updateView("entryentity");
        this.dealHcfInfo(dataEntity, entryEntityC);
        this.sortEntryEntity(entryEntityC, "srcentryissyspreset_c", "sourceentity_c.name", "targetentity_c.id");
        this.getModel().updateEntryCache(entryEntityC);
        this.getView().updateView("entryentity_c");
    }

    private void dealSysPresetEntryInfo(String number, DynamicObjectCollection entryEntity) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.ADDNEW.equals((Object)status)) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hpfs_filemapmanager");
        QFilter qFilter = new QFilter("personnelbusinessbill", "=", (Object)number);
        DynamicObject dynamicObject = helper.loadDynamicObject(new QFilter[]{qFilter, RepositoryUtils.isSysPreset()});
        if (dynamicObject == null) {
            LOGGER.info("preset data is empty");
            return;
        }
        DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : collection) {
            if (!"1".equals(entry.getString("srcentryissyspreset"))) continue;
            DynamicObject addNew = entryEntity.addNew();
            HashSet<String> hashSet = new HashSet<String>(16);
            hashSet.add("id");
            HRDynamicObjectUtils.copy((DynamicObject)entry, (DynamicObject)addNew, hashSet);
        }
    }

    private void sortEntryEntity(DynamicObjectCollection entryEntityC, String srcEntryIsSysPreset, String sourceEntityCName, String targetEntityCId) {
        Collator instance = Collator.getInstance(RequestContext.get().getLang().getLocale());
        entryEntityC.sort((o1, o2) -> {
            String index2;
            String srcEntryIsSysPresetIndex1 = o1.getString(srcEntryIsSysPreset);
            String srcEntryIsSysPresetIndex2 = o2.getString(srcEntryIsSysPreset);
            int srcEntryIsSysPresetIndex = srcEntryIsSysPresetIndex2.compareTo(srcEntryIsSysPresetIndex1);
            if (srcEntryIsSysPresetIndex != 0) {
                return srcEntryIsSysPresetIndex;
            }
            String index1 = o1.getString(sourceEntityCName) == null ? "" : o1.getString(sourceEntityCName);
            int index = instance.compare(index1, index2 = o2.getString(sourceEntityCName) == null ? "" : o2.getString(sourceEntityCName));
            if (index != 0) {
                return index;
            }
            String index3 = o1.getString(targetEntityCId) == null ? "" : o1.getString(targetEntityCId);
            String index4 = o2.getString(targetEntityCId) == null ? "" : o2.getString(targetEntityCId);
            return instance.compare(index3, index4);
        });
    }

    private void dealHcfInfo(DynamicObject dataEntity, DynamicObjectCollection entryEntity) {
        String appId = dataEntity.getDynamicObject("personnelbusinessbill").getString(BIZAPPID_ID);
        if (!"1WXB5G9/BL46".equals(appId)) {
            return;
        }
        DynamicObject[] childDys = HpfsMetaDataServiceHelper.getChildDys();
        List sourceEntityCs = entryEntity.stream().map(data -> data.getString("sourceentity_c.number")).collect(Collectors.toList());
        for (DynamicObject childDy : childDys) {
            if (sourceEntityCs.contains(childDy.getString("number"))) continue;
            DynamicObject dynamicObject = entryEntity.addNew();
            dynamicObject.set("sourceentity_c", (Object)childDy);
            dynamicObject.set("srcentryissyspreset_c", (Object)"0");
        }
    }

    private void dealExtFieldsInfo(DynamicObject dataEntity, DataEntityPropertyCollection properties, DynamicObjectCollection entryEntity) {
        List extBillList = properties.stream().filter(data -> data.getName().contains("_a_") || data.getName().contains("_b_")).filter(data -> !(data instanceof EntryProp)).map(IMetadata::getName).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(extBillList)) {
            return;
        }
        List extInfoFields = entryEntity.stream().filter(data -> "n_extinfo_fields".equals(data.getString("sourceentry"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(extInfoFields)) {
            DynamicObject dynamicObject = entryEntity.addNew();
            dynamicObject.set("sourceentity", (Object)dataEntity.getDynamicObject("personnelbusinessbill"));
            dynamicObject.set("billinfogroup", (Object)ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5b57\u6bb5\u5206\u7ec4", (String)"FileMapManagerEdit_7", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            dynamicObject.set("sourceentry", (Object)"n_extinfo_fields");
            dynamicObject.set("srcentryissyspreset", (Object)"0");
        }
    }

    private void dealExtEntryInfo(DynamicObject dataEntity, DataEntityPropertyCollection properties, DynamicObjectCollection entryEntity) {
        List<String> extEntryList = properties.stream().filter(data -> data.getName().contains("_a_") || data.getName().contains("_b_")).filter(EntryProp.class::isInstance).filter(data -> !PerChgNewBillTplConstants.THREE_PERSON_ORDERS.contains(data.getName())).map(IMetadata::getName).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(extEntryList)) {
            return;
        }
        Map<String, String> entityKeyAndNameMap = this.getEntityKeyAndNameMap(dataEntity, extEntryList);
        Map<String, List<DynamicObject>> pageGroupMaps = entryEntity.stream().collect(Collectors.groupingBy(data -> data.getString("sourceentry")));
        for (String extEntry : extEntryList) {
            List<DynamicObject> dynamicObjects = pageGroupMaps.get(extEntry);
            if (CollectionUtils.isEmpty(dynamicObjects)) {
                DynamicObject dynamicObject = entryEntity.addNew();
                dynamicObject.set("sourceentity", (Object)dataEntity.getDynamicObject("personnelbusinessbill"));
                dynamicObject.set("billinfogroup", (Object)entityKeyAndNameMap.getOrDefault(extEntry, extEntry));
                dynamicObject.set("sourceentry", (Object)extEntry);
                dynamicObject.set("srcentryissyspreset", (Object)"0");
                continue;
            }
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set("sourceentity", (Object)dataEntity.getDynamicObject("personnelbusinessbill"));
                dynamicObject.set("billinfogroup", (Object)entityKeyAndNameMap.getOrDefault(extEntry, extEntry));
                dynamicObject.set("sourceentry", (Object)extEntry);
                dynamicObject.set("srcentryissyspreset", (Object)"0");
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs evt) {
        if (HRStringUtils.equals((String)"entryentity", (String)evt.getEntryProp().getName())) {
            this.updateTreeView();
        }
    }

    private void setMapKeyComboProp(String entityKey, String comboKey, int rowIndex) {
        HRPageCache cache;
        MulComboEdit fieldEditor = (MulComboEdit)this.getView().getControl(comboKey);
        DynamicObject entity = (DynamicObject)this.getModel().getValue(entityKey, rowIndex);
        if (null == entity) {
            return;
        }
        String entityNumber = entity.getString("number");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String initedComboName = entityNumber + comboKey;
        if (HRStringUtils.equals((String)initedComboName, (String)((String)(cache = this.getHRPageCache()).get(CACHE_KEY_LAST_INITED_COMBO, String.class)))) {
            return;
        }
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        ArrayList<ComboItem> fieldCombos = new ArrayList<ComboItem>();
        for (IDataEntityProperty property : properties) {
            if (!this.isFieldShouldShow(property)) continue;
            ComboItem item = new ComboItem();
            String name = property.getName();
            LocaleString chineseNameLS = property.getDisplayName();
            String chineseName = null == chineseNameLS ? name : chineseNameLS.getLocaleValue();
            item.setValue(name);
            item.setCaption(new LocaleString(name + "(" + chineseName + ")"));
            fieldCombos.add(item);
        }
        fieldEditor.setComboItems(fieldCombos);
        EntryGrid tableEntry = (EntryGrid)this.getControl("entryentity");
        cache.put(CACHE_KEY_LAST_INITED_COMBO, (Object)initedComboName);
        tableEntry.focusCell(rowIndex, comboKey);
    }

    private void updateTreeView() {
        HRPageCache pageCache = this.getHRPageCache();
        TreeNode root = (TreeNode)pageCache.get(TREE_ID_ROOT, TreeNode.class);
        TreeView pairTree = (TreeView)this.getView().getControl(CONTROL_KEY_PAIRTREE);
        String selectedTreeNodeId = this.getSelectedTreeNode(pairTree);
        boolean isSelectedTreeNodeAlive = false;
        root.setChildren(new ArrayList());
        DynamicObjectCollection entityPairEntry = this.getModel().getEntryEntity("entryentity");
        int mappedFieldAmmount = 0;
        for (DynamicObject entityPair : entityPairEntry) {
            DynamicObject sourceEntity = entityPair.getDynamicObject("sourceentity");
            DynamicObject targetEntity = entityPair.getDynamicObject("targetentity");
            String sourceentry = entityPair.getString("sourceentry");
            if (null == sourceEntity || null == targetEntity) continue;
            String sourceEntityNumber = sourceEntity.getString("number");
            String targetEntityNumber = targetEntity.getString("number");
            String targetEntityName = targetEntity.getString("name");
            sourceEntityNumber = String.join((CharSequence)".", sourceEntityNumber, sourceentry);
            this.selectTableEntityRow(this.getNodeId(sourceEntityNumber, targetEntityNumber));
            int rowAmount = this.getModel().getEntryRowCount("subentryentity");
            mappedFieldAmmount += rowAmount;
            sourceEntityNumber = String.join((CharSequence)".", sourceEntityNumber);
            String nodeId = this.getNodeId(sourceEntityNumber, targetEntityNumber);
            TreeNode treeNode = new TreeNode(TREE_ID_ROOT, nodeId, targetEntityName + "(" + rowAmount + ")");
            root.addChild(treeNode);
            if (!HRStringUtils.equals((String)selectedTreeNodeId, (String)nodeId)) continue;
            isSelectedTreeNodeAlive = true;
        }
        root.setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5168\u90e8(%s)", (String)"FileMapManagerEdit_5", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), mappedFieldAmmount));
        pairTree.updateNode(root);
        pairTree.expand(TREE_ID_ROOT);
        if (isSelectedTreeNodeAlive) {
            pairTree.treeNodeClick(TREE_ID_ROOT, selectedTreeNodeId);
            TreeNode treeNode = root.getTreeNode(selectedTreeNodeId, 2);
            pairTree.focusNode(treeNode);
            this.selectTableEntityRow(treeNode.getId());
        } else {
            this.cleanFields();
        }
        this.saveRootNode(root);
    }

    private String getSelectedTreeNodeId() {
        TreeView pairTree = (TreeView)this.getView().getControl(CONTROL_KEY_PAIRTREE);
        return this.getSelectedTreeNode(pairTree);
    }

    public String getSelectedTreeNode(TreeView pairTree) {
        List selectedNodeIds = pairTree.getTreeState().getSelectedNodeId();
        if (null == selectedNodeIds || selectedNodeIds.isEmpty()) {
            return "";
        }
        return (String)selectedNodeIds.get(0);
    }

    public HRPageCache getHRPageCache() {
        if (null == this.hrPageCache) {
            this.hrPageCache = new HRPageCache(this.getPageCache());
        }
        return this.hrPageCache;
    }

    public void initPairTreeView() {
        TreeView pairTree = (TreeView)this.getView().getControl(CONTROL_KEY_PAIRTREE);
        TreeNode root = new TreeNode("", TREE_ID_ROOT, ResManager.loadKDString((String)"\u5168\u90e8", (String)"FileMapManagerEdit_6", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        root.setCheckable(false);
        this.saveRootNode(root);
        pairTree.addNode(root);
    }

    public void saveRootNode(TreeNode root) {
        HRPageCache pageCache = this.getHRPageCache();
        pageCache.put(TREE_ID_ROOT, (Object)root);
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        String key = search.getKey();
        String searchText = evt.getText();
        String nodeId = this.getSelectedTreeNodeId();
        if (this.isTreeNoData()) {
            return;
        }
        String[] tableNumbers = nodeId.split("\\|");
        String sourceTable = tableNumbers[0];
        String targetTable = tableNumbers[1];
        switch (key) {
            case "search_source": {
                this.drawUnmappedFieldContainer(sourceTable, CONTROL_KEY_FLEX_SOURCEFIELDS, "source", searchText);
                break;
            }
            case "search_target": {
                this.drawUnmappedFieldContainer(targetTable, CONTROL_KEY_FLEX_TARGETFIELDS, "target", searchText);
                break;
            }
            case "search_mapped": {
                this.drawMappedFieldContainer(sourceTable, targetTable, searchText);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject entityConf = (DynamicObject)this.getModel().getValue(CONTROL_KEY_ENEITYCONF);
        if ("sourceentity".equals(fieldKey)) {
            showParameter.getListFilterParameter().getQFilters().add(this.getSourceEntityFilter(entityConf));
        }
        if ("targetentity".equals(fieldKey)) {
            showParameter.getListFilterParameter().getQFilters().add(this.getTargetEntityFilter(entityConf));
            showParameter.setCustomParam("pagetype", (Object)"extend");
            showParameter.setCustomParam("refappid", (Object)"0QO140ANVBBZ");
        }
    }

    private QFilter getSourceEntityFilter(DynamicObject entityConf) {
        if (null == entityConf) {
            return this.getDefaultEntityFilter();
        }
        DynamicObjectCollection sourceEntities = entityConf.getDynamicObjectCollection("sourceentryentity");
        ArrayList sourceEntityIds = new ArrayList(sourceEntities.size());
        sourceEntities.forEach(sourceEntity -> sourceEntityIds.add(sourceEntity.getString("sourceentity.id")));
        QFilter entityFilter = new QFilter("id", "in", sourceEntityIds);
        return entityFilter;
    }

    public QFilter getDefaultEntityFilter() {
        return new QFilter("modeltype", "=", (Object)"BaseFormModel").or(new QFilter("modeltype", "=", (Object)"BillFormModel"));
    }

    private QFilter getTargetEntityFilter(DynamicObject entityConf) {
        if (null == entityConf) {
            return this.getDefaultEntityFilter();
        }
        DynamicObjectCollection sourceEntities = entityConf.getDynamicObjectCollection("targetentryentity");
        ArrayList sourceEntityIds = new ArrayList(sourceEntities.size());
        sourceEntities.forEach(sourceEntity -> sourceEntityIds.add(sourceEntity.getString("targetentity.id")));
        QFilter entityFilter = new QFilter("id", "in", sourceEntityIds);
        return entityFilter;
    }

    private void showSelectEntryF7(CellClickEvent evt) {
        DynamicObject mainEntity = (DynamicObject)this.getModel().getValue("sourceentity", evt.getRow());
        if (null == mainEntity) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u6e90\u5b9e\u4f53", (String)"FileMapManagerEdit_10", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            return;
        }
        String entityId = mainEntity.getString("id");
        entityId = MetaUtils.getSourceEntityNum((String)entityId);
        QFilter entityFilter = new QFilter("fid", "=", (Object)entityId).and("isdeleted", "=", (Object)"0");
        this.showEntryF7(evt, entityFilter);
    }

    public void showEntryF7(CellClickEvent evt, QFilter entityFilter) {
        String cellKey = evt.getFieldKey();
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("hpfs_entityinfo");
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setMultiSelect(false);
        listShowParameter.setShowApproved(false);
        listShowParameter.setLookUp(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, cellKey));
        listShowParameter.setHasRight(true);
        listShowParameter.setCustomParam("rowIndex", (Object)String.valueOf(evt.getRow()));
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        filters.add(entityFilter);
        OpenStyle style = this.getOpenStyle();
        listShowParameter.setOpenStyle(style);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private OpenStyle getOpenStyle() {
        OpenStyle style = new OpenStyle();
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("880px");
        cssValue.setHeight("600px");
        style.setInlineStyleCss(cssValue);
        style.setShowType(ShowType.Modal);
        return style;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObjectCollection subEntryEntityDys;
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("selectsrcentry".equals(actionId)) {
            Map pkMap;
            Map entityNameMap;
            HRPageCache pageCache = new HRPageCache(this.getView());
            List pageList = (List)pageCache.get("entityList", List.class);
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (HRObjectUtils.isEmpty((Object)selectedRows)) {
                return;
            }
            ListSelectedRow row = selectedRows.get(0);
            Optional<Map> any = pageList.stream().filter(entry -> entry.containsKey(row.getPrimaryKeyValue())).findAny();
            if (any.isPresent() && !CollectionUtils.isEmpty((Map)(entityNameMap = (Map)(pkMap = any.get()).get(row.getPrimaryKeyValue())))) {
                String entitykey = (String)entityNameMap.get("entitykey");
                String name = (String)entityNameMap.get("name");
                int rowIndex = Integer.parseInt((String)entityNameMap.get("rowIndex"));
                DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
                this.getModel().setValue("sourceentry", (Object)entitykey, rowIndex);
                this.getModel().setValue("sourceentryname", (Object)name, rowIndex);
            }
        }
        if (actionId.equals("srcentryfieldrelation") && Objects.nonNull(returnData = closedCallBackEvent.getReturnData())) {
            subEntryEntityDys = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)String.valueOf(returnData));
            this.getModel().deleteEntryData("subentryentity");
            IFileMapManagerService.getInstance().setSubEntryEntity(subEntryEntityDys, this.getView());
            this.getView().updateView("subentryentity");
        }
        if (actionId.equals("srcentryfieldrelation_c") && Objects.nonNull(returnData = closedCallBackEvent.getReturnData())) {
            subEntryEntityDys = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)String.valueOf(returnData));
            this.getModel().deleteEntryData("subentryentity_c");
            IFileMapManagerService.getInstance().setSubEntryEntityC(subEntryEntityDys, this.getView());
            this.getView().updateView("subentryentity_c");
        }
    }

    public void afterAddRow(AfterAddRowEventArgs rowEventArgs) {
        super.afterAddRow(rowEventArgs);
        String entryName = rowEventArgs.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = rowEventArgs.getRowDataEntities();
        if ("entryentity".equals(entryName)) {
            this.setNewRowInfoGroup(rowEventArgs, rowDataEntities, entryName, "billinfogroup");
        } else if ("entryentity_c".equals(entryName)) {
            this.setNewRowInfoGroup(rowEventArgs, rowDataEntities, entryName, "sourceentity_c");
        }
    }

    private void setNewRowInfoGroup(AfterAddRowEventArgs rowEventArgs, RowDataEntity[] rowDataEntities, String entryName, String field) {
        if (Objects.nonNull(rowDataEntities) && rowDataEntities.length > 0) {
            int insertRow = rowEventArgs.getInsertRow();
            DynamicObjectCollection entryDys = this.getModel().getEntryEntity(entryName);
            DynamicObject dynamicObject = (DynamicObject)entryDys.get(insertRow - 1);
            for (RowDataEntity rowData : rowDataEntities) {
                int rowIndex = rowData.getRowIndex();
                if (dynamicObject == null) continue;
                this.getModel().setValue(field, dynamicObject.get(field), rowIndex);
                if ("entryentity".equals(entryName)) {
                    this.getModel().setValue("sourceentity", dynamicObject.get("sourceentity"), rowIndex);
                    this.getModel().setValue("sourceprikey", dynamicObject.get("sourceprikey"), rowIndex);
                    this.getModel().setValue("sourceentry", dynamicObject.get("sourceentry"), rowIndex);
                    this.getModel().setValue("targetprikey", dynamicObject.get("targetprikey"), rowIndex);
                    this.getModel().setValue("srcentryissyspreset", dynamicObject.get("srcentryissyspreset"), rowIndex);
                    continue;
                }
                if (!"entryentity_c".equals(entryName)) continue;
                this.getModel().setValue("sourceprikey_c", dynamicObject.get("sourceprikey_c"), rowIndex);
                this.getModel().setValue("sourceentry_c", dynamicObject.get("sourceentry_c"), rowIndex);
                this.getModel().setValue("billinfogroup_c", dynamicObject.get("billinfogroup_c"), rowIndex);
                this.getModel().setValue("targetprikey_c", dynamicObject.get("targetprikey_c"), rowIndex);
                this.getModel().setValue("srcentryissyspreset_c", dynamicObject.get("srcentryissyspreset_c"), rowIndex);
            }
        }
    }

    static {
        List<String> empValList = Arrays.asList("enterprise", "laborreltype", "laborrelstatus", "empnumber", "startdate", "enddate", "bsed", "bsled", "sysenddate");
        List<String> depValList = Arrays.asList("adminorg", MAP_KEY_POSITION, "job", "stdposition", "postype", "posstatus", "startdate", "enddate", "bsed", "bsled", "sysenddate", "businessstatus", "org", "affiliateadminorg", "empgroup", "positionvid", "jobvid", "stdpositionvid");
        PERSON3KEY.put("hrpi_employee", empValList);
        PERSON3KEY.put("hrpi_empentrel", empValList);
        PERSON3KEY.put("hrpi_depemp", depValList);
        PERSON3KEY.put("hrpi_empposorgrel", depValList);
        PERSON3KEY.put("hrpi_emporgrelall", depValList);
        PERSON3KEY.put("hspm_ermanfile", depValList);
    }
}

