/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin.fieldmap;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;

public class HpfsEntityInfoList
extends AbstractListPlugin {
    private static final Log LOG = LogFactory.getLog(HpfsEntityInfoList.class);

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                if (HpfsEntityInfoList.this.getView() != null && HpfsEntityInfoList.this.getView().getParentView() != null) {
                    DynamicObjectCollection rows = super.getData(start, limit);
                    if (rows.isEmpty()) {
                        return rows;
                    }
                    String rowIndex = (String)HpfsEntityInfoList.this.getView().getFormShowParameter().getCustomParam("rowIndex");
                    HRPageCache pageCache = new HRPageCache(HpfsEntityInfoList.this.getView().getParentView());
                    pageCache.remove("entityList");
                    TextProp nameProp = new TextProp();
                    nameProp.setName("name");
                    DataEntityPropertyCollection properties = ((DynamicObject)rows.get(0)).getDataEntityType().getProperties();
                    properties.add((Object)nameProp);
                    ArrayList entityList = new ArrayList(16);
                    rows.forEach(row -> {
                        IDataEntityProperty entryProp;
                        HashMap<String, String> entityNameMap = new HashMap<String, String>(16);
                        HashMap<String, HashMap<String, String>> pkIdMap = new HashMap<String, HashMap<String, String>>(16);
                        String mainEntityNmuber = row.getString("fid");
                        String entryNumber = row.getString("entitykey");
                        IDataEntityType entityType = null;
                        try {
                            entityType = new HRBaseServiceHelper(mainEntityNmuber).generateEmptyDynamicObject().getDataEntityType();
                        }
                        catch (Exception e) {
                            LOG.info("==meta form not is exsit==", (Object)e);
                            return;
                        }
                        String localeValue = "";
                        localeValue = HRStringUtils.equals((String)entryNumber, (String)mainEntityNmuber) ? entityType.getDisplayName().getLocaleValue() : (null != (entryProp = (IDataEntityProperty)entityType.getProperties().get((Object)entryNumber)) ? entryProp.getDisplayName().getLocaleValue() : this.findEntryDisplayName(entryNumber, entityType));
                        row.set("name", (Object)localeValue);
                        entityNameMap.put("entitykey", row.getString("entitykey"));
                        entityNameMap.put("rowIndex", rowIndex);
                        entityNameMap.put("name", localeValue);
                        pkIdMap.put(String.valueOf(row.getPkValue()), entityNameMap);
                        entityList.add(pkIdMap);
                    });
                    pageCache.put("entityList", entityList);
                    return rows;
                }
                HpfsEntityInfoList.this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7236\u754c\u9762\u4e0d\u5b58\u5728\uff0c\u8bf7\u5173\u95ed\u5b50\u9875\u9762\u540e\u5237\u65b0\u91cd\u8bd5\u3002", (String)"HpfsEntityInfoList_1", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
                return null;
            }

            private String findEntryDisplayName(String entryNumber, IDataEntityType entityType) {
                for (IDataEntityProperty prop : entityType.getProperties()) {
                    if (!(prop instanceof EntryProp)) continue;
                    IDataEntityType entryType = ((EntryProp)prop).getItemType();
                    IDataEntityProperty subEntryProperty = (IDataEntityProperty)entryType.getProperties().get((Object)entryNumber);
                    if (null != subEntryProperty) {
                        return subEntryProperty.getDisplayName().getLocaleValue();
                    }
                    return this.findEntryDisplayName(entryNumber, entryType);
                }
                return "";
            }
        });
    }
}

