/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin.file;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListColumnConfig;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.query.QueryListPlugin;
import kd.hr.hpfs.common.utils.ObjectUtils;

public class ERManFileCommonListPlugin
extends QueryListPlugin
implements ItemClickListener {
    private static final Log logger = LogFactory.getLog(ERManFileCommonListPlugin.class);
    private static final String MERGE_INITBATCH_TAG = "hric$subTaskInitBatchMap";
    private static final String INITBATCH_TAG = "initbatch";
    private static final String INIT_ENTITYNUMBER_DEPEMP = "hrpi_onboardempexp_init";
    private static final String INIT_ENTITYNUMBER_QUITDEPEMP = "hrpi_quitempexp_init";

    public void filterContainerInit(FilterContainerInitArgs args) {
        String isFirst = this.getPageCache().get("first");
        if (isFirst != null && HRStringUtils.equals((String)isFirst, (String)"false")) {
            return;
        }
        List columnList = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : columnList) {
            String fieldName = filterColumn.getFieldName();
            if (!HRStringUtils.equals((String)fieldName, (String)"org.name")) continue;
            filterColumn.setDefaultValue("");
            this.getPageCache().put("first", "false");
            return;
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        List<QFilter> filter = this.getCustomFilter(this.getView());
        setFilterEvent.getQFilters().addAll(filter);
    }

    private List<QFilter> getCustomFilter(IFormView formView) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter dFilter = new QFilter("datastatus", "=", (Object)"1");
        Map mergeInitBatchMap = (Map)formView.getFormShowParameter().getCustomParam(MERGE_INITBATCH_TAG);
        logger.info("ERManFileCommonListPlugin==>getCustomFilter the mergeInitBarchMap is {}", (Object)mergeInitBatchMap);
        if (HRObjectUtils.isEmpty((Object)mergeInitBatchMap)) {
            qFilterList.add(new QFilter("initstatus", "=", (Object)"2"));
        } else {
            Object depempInitBatch = mergeInitBatchMap.get(INIT_ENTITYNUMBER_DEPEMP);
            Object quitdepempInitBatch = mergeInitBatchMap.get(INIT_ENTITYNUMBER_QUITDEPEMP);
            Object initbatch = ObjectUtils.isEmpty(depempInitBatch) ? quitdepempInitBatch : depempInitBatch;
            qFilterList.add(new QFilter(INITBATCH_TAG, "=", initbatch));
        }
        qFilterList.add(qFilter);
        qFilterList.add(dFilter);
        return qFilterList;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (HRStringUtils.equals((String)"person_name", (String)fieldName) || HRStringUtils.equals((String)"name", (String)fieldName)) {
            args.setCancel(true);
            IListView listView = (IListView)this.getView();
            long erFileId = (Long)listView.getFocusRowPkId();
            String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
            try {
                Map retMap = (Map)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"jumpErManFileDetail", (Object[])new Object[]{erFileId, billFormId});
                if (((Boolean)retMap.get("success")).booleanValue()) {
                    FormShowParameter formShowParameter = (FormShowParameter)retMap.get("data");
                    this.getView().showForm(formShowParameter);
                } else {
                    this.getView().showErrorNotification((String)retMap.get("errormsg"));
                }
            }
            catch (Exception esc) {
                logger.error("jumpDetailFail", (Throwable)esc);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0b\u5e8f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ERManFileCommonListPlugin_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        ArrayList<String> fixedColumnList = new ArrayList<String>();
        fixedColumnList.add("person.headsculpture");
        fixedColumnList.add("name");
        fixedColumnList.add("person.name");
        List listColumns = args.getListColumns();
        List collect = listColumns.stream().map(IListColumnConfig::getListFieldKey).collect(Collectors.toList());
        fixedColumnList.stream().filter(collect::contains).forEach(column -> args.getListColumn(column).setFixed(true));
    }

    public void packageData(PackageDataEvent dataEvent) {
        Date endDate;
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)dataEvent.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if ("enddate".equals(fieldKey) && (endDate = dataEvent.getRowData().getDate("enddate")) != null) {
            try {
                boolean endDayBefore;
                Date startDate = dataEvent.getRowData().getDate("startdate");
                if (ERManFileCommonListPlugin.getMaxDate(endDate)) {
                    dataEvent.setFormatValue((Object)" ");
                } else if (startDate != null && (endDayBefore = HRDateTimeUtils.dayBefore((Date)endDate, (Date)startDate))) {
                    dataEvent.setFormatValue((Object)HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"));
                }
            }
            catch (Exception ec) {
                logger.error("packageEndDataException", (Throwable)ec);
            }
        }
    }

    public static boolean getMaxDate(Date endDate) {
        if (endDate == null) {
            return false;
        }
        try {
            endDate = HRDateTimeUtils.parseDate((String)HRDateTimeUtils.format((Date)endDate));
            return HRDateTimeUtils.dayAfter((Date)endDate, (Date)HRDateTimeUtils.getSysMaxDate()) || HRDateTimeUtils.dayAfter((Date)endDate, (Date)HRDateTimeUtils.addDay((Date)HRDateTimeUtils.getSysMaxDate(), (long)-1L)) || HRDateTimeUtils.dayEquals((Date)endDate, (Date)HRDateTimeUtils.getSysMaxDate()) || HRDateTimeUtils.dayEquals((Date)endDate, (Date)HRDateTimeUtils.addDay((Date)HRDateTimeUtils.getSysMaxDate(), (long)-1L));
        }
        catch (Exception esc) {
            logger.error("listGetMaxDateError", (Throwable)esc);
            return false;
        }
    }
}

