/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin.guide;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hpfs.business.domain.repository.perchg.ChgRuleConfigRepository;
import kd.hr.hpfs.common.constants.ChgConstants;
import kd.hr.hpfs.common.constants.ChgGuideConstants;
import kd.hr.hpfs.common.constants.ChgRuleConstants;
import kd.hr.hpfs.common.constants.ChgStrategyConstants;
import kd.hr.hpfs.common.enums.ChgCarrierEnum;
import kd.hr.hpfs.common.enums.ChgTacticApplicableStageEnum;
import kd.hr.hpfs.formplugin.model.DrawFormFieldDto;
import kd.hr.hpfs.formplugin.service.ChgNameValidateService;
import kd.hr.hpfs.formplugin.util.ChgCommonUtils;
import kd.hr.hpfs.formplugin.util.PageDrawerUtils;
import kd.hr.hpfs.formplugin.util.TemplateEditUtils;

public class ChgGuideLeftTreeEditPlugin
extends HRDataBaseEdit
implements ChgConstants,
ChgStrategyConstants,
ChgRuleConstants,
ChgGuideConstants {
    private static final Log LOGGER = LogFactory.getLog(ChgGuideLeftTreeEditPlugin.class);
    static final String[] basciFieldArr = new String[]{"ispreset", "isinterrupted", "seq", "id"};

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        String firstInitLeft;
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        Map map = (Map)formShowParameter.getCustomParam("params");
        Map tacticMaps = (Map)map.get("tacticMaps");
        ArrayList<Map<String, Object>> tabListBefore = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> tabListAfter = new ArrayList<Map<String, Object>>();
        tacticMaps.forEach((k, v) -> {
            String applicableStage = (String)v.get("applicablestage");
            if (HRStringUtils.equals((String)applicableStage, (String)ChgTacticApplicableStageEnum.APPLICABLE_STAGE_BEFORE.getCode())) {
                tabListBefore.add((Map<String, Object>)v);
            } else {
                tabListAfter.add((Map<String, Object>)v);
            }
        });
        tabListBefore.sort(Comparator.comparingInt(row -> Integer.parseInt(row.get("index") + "")));
        tabListAfter.sort(Comparator.comparingInt(row -> Integer.parseInt(row.get("index") + "")));
        HashMap<String, DrawFormFieldDto> allFields = new HashMap<String, DrawFormFieldDto>(16);
        HashSet<String> set = new HashSet<String>();
        if (!CollectionUtils.isEmpty(tabListBefore)) {
            e.getItems().add(this.formatLeftOldTabMap(tabListBefore, allFields));
            set.add("before");
            firstInitLeft = ("left_tactic_" + ((Map)tabListBefore.get(0)).get("number")).toLowerCase(Locale.ROOT);
            formShowParameter.getCustomParams().put("firstInitLeft", firstInitLeft);
        }
        if (!CollectionUtils.isEmpty(tabListAfter)) {
            e.getItems().add(this.formatLeftNewTabMap(tabListAfter, allFields));
            set.add("after");
            if (formShowParameter.getCustomParam("firstInitLeft") == null) {
                firstInitLeft = ("left_tactic_" + ((Map)tabListAfter.get(0)).get("number")).toLowerCase(Locale.ROOT);
                formShowParameter.getCustomParams().put("firstInitLeft", firstInitLeft);
            }
        }
        formShowParameter.getCustomParams().put("fieldsStatus", set);
        formShowParameter.getCustomParams().put("allFields", SerializationUtils.toJsonString(allFields.values()));
    }

    private Map<String, Object> formatLeftOldTabMap(List<Map<String, Object>> tabList, Map<String, DrawFormFieldDto> allFields) {
        return PageDrawerUtils.formatLoadMap("oldtacticflex", this.drawLeftTree(tabList, allFields));
    }

    private Map<String, Object> formatLeftNewTabMap(List<Map<String, Object>> tabList, Map<String, DrawFormFieldDto> allFields) {
        return PageDrawerUtils.formatLoadMap("newtacticflex", this.drawLeftTree(tabList, allFields));
    }

    private FlexPanelAp drawLeftTree(List<Map<String, Object>> tabList, Map<String, DrawFormFieldDto> allFields) {
        FlexPanelAp tacticGroupAp = new HRFlexPanelAp.Builder("strategytacticap").setAlignItems("stretch").setJustifyContent("flex-start").setDirection("column").setWrap(false).setName("strategytacticap").build();
        for (Map<String, Object> manMap : tabList) {
            String tacticNumber = (String)manMap.get("number");
            String tacticName = PageDrawerUtils.getNameLocalValue((Map)manMap.get("name"));
            FlexPanelAp tacticAp = this.drawLeftUnselectedSingle(tacticNumber, tacticName, allFields);
            tacticGroupAp.getItems().add(tacticAp);
        }
        return tacticGroupAp;
    }

    private FlexPanelAp drawLeftUnselectedSingle(String tacticNumber, String tacticName, Map<String, DrawFormFieldDto> allFields) {
        String number = ("left_tactic_" + tacticNumber).toLowerCase(Locale.ROOT);
        if (allFields.get(number) == null) {
            DrawFormFieldDto label = new DrawFormFieldDto().setField(number).setName(tacticName).setClassSimpleName(Label.class.getSimpleName());
            allFields.put(number, label);
        }
        return this.drawLeftSingle(tacticNumber, tacticName, "white", "#333333", "");
    }

    private FlexPanelAp drawLeftUnselectedSingle(String tacticNumber, String tacticName) {
        return this.drawLeftSingle(tacticNumber, tacticName, "white", "#333333", "");
    }

    private FlexPanelAp drawLeftSelectedSingle(String tacticNumber, String tacticName) {
        return this.drawLeftSingle(tacticNumber, tacticName, "themeColor|10", "themeColor", "2px_solid_themeColor");
    }

    private FlexPanelAp drawLeftSingle(String tacticNumber, String tacticName, String backColor, String fontColor, String leftBorder) {
        String number = ("left_tactic_" + tacticNumber).toLowerCase(Locale.ROOT);
        FlexPanelAp tacticAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(number).setName(tacticName).setBackColor(backColor).setBorderLeft(leftBorder)).setShrink(0).setGrow(0).setAlignItems("stretch").setJustifyContent("flex-start").setDirection("column").setWrap(false).build();
        LabelAp lblRelatePageAp = ((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)new HRLabelAp.Builder(number).setId(number).setName(tacticName).setFontSize(14).setClickable(true).setForeColor(fontColor).setMarginLeft("32px")).setMarginTop("14px")).setMarginBottom("13px")).build();
        tacticAp.getItems().add(lblRelatePageAp);
        return tacticAp;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.startsWith("left_tactic_")) {
            DrawFormFieldDto drawFormFieldDto = this.getAllFields().get(key);
            if (drawFormFieldDto == null) {
                return;
            }
            String currLabelLeftTree = this.getPageCache().get("currLabelLeftTree");
            if (HRStringUtils.isNotEmpty((String)currLabelLeftTree)) {
                if (HRStringUtils.equals((String)currLabelLeftTree, (String)drawFormFieldDto.getField())) {
                    return;
                }
                try {
                    OperationResult result = this.getView().getView(this.getPageCache().get("childPageId")).invokeOperation("cacherecall");
                    if (!result.isSuccess()) {
                        this.getPageCache().remove("save");
                        return;
                    }
                }
                catch (Exception e) {
                    String warnInfo = ResManager.loadKDString((String)"\u9875\u9762\u70b9\u51fb\u9891\u7387\u8fc7\u5feb\uff0c\u8bf7\u7b49\u5f85\u9875\u9762\u52a0\u8f7d\u5b8c\u6210\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ChgGuideLeftTreeEditPlugin_1", (String)"hr-hpfs-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(warnInfo);
                }
                DrawFormFieldDto currBefore = this.getAllFields().get(currLabelLeftTree);
                FlexPanelAp tacticUnselectedAp = this.drawLeftUnselectedSingle(currBefore.getField().replace("left_tactic_", ""), currBefore.getName());
                this.getView().updateControlMetadata(tacticUnselectedAp.getKey(), tacticUnselectedAp.createControl());
            }
            this.getPageCache().put("currLabelLeftTree", drawFormFieldDto.getField());
            FlexPanelAp tacticAp = this.drawLeftSelectedSingle(drawFormFieldDto.getField().replace("left_tactic_", ""), drawFormFieldDto.getName());
            this.getView().updateControlMetadata(tacticAp.getKey(), tacticAp.createControl());
            Map tacticMaps = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("tacticMaps"), Map.class);
            this.showFieldFlex((Map)tacticMaps.get(drawFormFieldDto.getField()));
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.cacheTacticConfigs();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.cacheTacticConfigs();
    }

    private void cacheTacticConfigs() {
        List fieldsStatus = (List)this.getView().getFormShowParameter().getCustomParam("fieldsStatus");
        if (!fieldsStatus.contains("before")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelapold"});
        }
        if (!fieldsStatus.contains("after")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelapnew"});
        }
        Map params = (Map)this.getView().getFormShowParameter().getCustomParam("params");
        List strategyTactics = (List)params.get("strategyTactics");
        this.getPageCache().put("tacticMaps", SerializationUtils.toJsonString(params.get("tacticMaps")));
        Map<String, List> tacticConfigMap = strategyTactics.stream().collect(Collectors.toMap(tactic -> ("left_tactic_" + ((Map)((Map)tactic.get(0)).get("chgtactic")).get("number")).toLowerCase(Locale.ROOT), tactic -> tactic));
        this.getPageCache().put("allTacticConfig", SerializationUtils.toJsonString(tacticConfigMap));
        List ruleConfigList = (List)params.get("ruleConfigs");
        if (ruleConfigList == null) {
            Label label = (Label)this.getControl((String)this.getView().getFormShowParameter().getCustomParam("firstInitLeft"));
            label.click();
            return;
        }
        Map<String, List<Map>> ruleConfigMap = ruleConfigList.stream().filter(tactic -> tactic.get("chgtactic") != null).collect(Collectors.groupingBy(tactic -> ("left_tactic_" + ((Map)tactic.get("chgtactic")).get("number")).toLowerCase(Locale.ROOT)));
        Map extraTacticMapping = (Map)params.get("extraTacticMapping");
        this.getPageCache().put("fileTacticValueMap", SerializationUtils.toJsonString((Object)extraTacticMapping));
        this.getPageCache().put("ruleConfigMap", SerializationUtils.toJsonString(ruleConfigMap));
        Label label = (Label)this.getControl((String)this.getView().getFormShowParameter().getCustomParam("firstInitLeft"));
        label.click();
    }

    private Map<String, List<Map<String, Object>>> formatMapping(List<DynamicObject> dynList) {
        HashMap<String, List<Map<String, Object>>> dynMap = new HashMap<String, List<Map<String, Object>>>(16);
        for (DynamicObject dyn : dynList) {
            DynamicObjectCollection tableMapping = dyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject mappedTable : tableMapping) {
                String targetTable = mappedTable.getString("targetentity.number");
                String sourceTable = mappedTable.getString("sourceentity.number");
                DynamicObjectCollection fieldMapping = mappedTable.getDynamicObjectCollection("subentryentity");
                for (DynamicObject mappedField : fieldMapping) {
                    String targetField = mappedField.getString("targetfield");
                    String sourceField = mappedField.getString("sourcefield");
                    HashMap<String, String> field = new HashMap<String, String>();
                    field.put("chgfile", targetField);
                    field.put("limittype", "");
                    field.put("entitysource", sourceTable);
                    field.put("fieldsource", sourceField);
                    dynMap.computeIfAbsent(targetTable, list -> new ArrayList()).add(field);
                }
            }
        }
        return dynMap;
    }

    private void showFieldFlex(Map<String, Object> tacticMap) {
        Map fieldsMap;
        Map tacticFieldsMap;
        String fieldsValueCache;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setTargetKey("fieldflex");
        formShowParameter.setFormId("hpfs_chgguidefield");
        formShowParameter.setSendToClient(true);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "config"));
        formShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        Map allTacticConfig = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("allTacticConfig"), Map.class);
        String currLabelLeftTree = this.getPageCache().get("currLabelLeftTree");
        List tacticConfig = (List)allTacticConfig.get(currLabelLeftTree);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("tacticConfig", tacticConfig == null ? Collections.emptyList() : tacticConfig);
        paramMap.put("tacticMap", tacticMap);
        String chgRuleId = this.getView().getParentView().getPageCache().get("chgRuleId");
        this.getPageCache().put("chgRuleId", chgRuleId);
        this.getPageCache().put("carrier", this.getView().getParentView().getPageCache().get("carrier"));
        paramMap.put("carrier", this.getPageCache().get("carrier"));
        String mustInputError = this.validateMustInput();
        paramMap.put("mustInputError", mustInputError);
        if (!this.isAddStatus() || HRStringUtils.isNotEmpty((String)chgRuleId)) {
            Map ruleConfigMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("ruleConfigMap"), Map.class);
            List tacticConfigValue = (List)ruleConfigMap.get(currLabelLeftTree);
            paramMap.put("tacticConfigValue", tacticConfigValue);
            Map fileTacticValueMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("fileTacticValueMap"), Map.class);
            Map fileTacticValue = (Map)fileTacticValueMap.get(currLabelLeftTree);
            paramMap.put("fileTacticValue", fileTacticValue == null ? Collections.emptyMap() : fileTacticValue);
        }
        if ((fieldsValueCache = this.getPageCache().get("fieldsMap")) != null && (tacticFieldsMap = (Map)(fieldsMap = (Map)SerializationUtils.fromJsonString((String)fieldsValueCache, Map.class)).get(currLabelLeftTree)) != null) {
            paramMap.put("fieldsValueCache", tacticFieldsMap);
        }
        formShowParameter.setCustomParam("params", paramMap);
        this.getView().showForm(formShowParameter);
        this.getPageCache().put("childPageId", formShowParameter.getPageId());
    }

    public void onGetControl(OnGetControlArgs onGetControlArgs) {
        super.onGetControl(onGetControlArgs);
        String key = onGetControlArgs.getKey();
        if (this.getAllFields().get(key) != null) {
            TemplateEditUtils.addGetControl(this.getAllFields().get(key), onGetControlArgs, this);
        }
    }

    private Map<String, DrawFormFieldDto> getAllFields() {
        String fieldList;
        if (this.getPageCache().get("allFields") == null) {
            fieldList = (String)this.getView().getFormShowParameter().getCustomParam("allFields");
            this.getPageCache().put("allFields", fieldList);
        } else {
            fieldList = this.getPageCache().get("allFields");
        }
        return ChgCommonUtils.formatAllFields(fieldList).stream().collect(Collectors.toMap(DrawFormFieldDto::getField, row -> row));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)key, (String)"save")) {
            OperationResult result;
            LOGGER.info("ChgGuideLeftTreeEditPlugin#afterDoOperation begin save");
            this.getPageCache().put("save", "1");
            if (this.getPageCache().get("currLabelLeftTree") == null) {
                LOGGER.info("ChgGuideLeftTreeEditPlugin#afterDoOperation currLabelLeftTree cacge isEmpty");
                boolean success = this.saveData();
                afterDoOperationEventArgs.getOperationResult().setSuccess(success);
                this.getPageCache().remove("save");
                return;
            }
            try {
                LOGGER.info("ChgGuideLeftTreeEditPlugin#afterDoOperation invoker cacherecall");
                result = this.getView().getView(this.getPageCache().get("childPageId")).invokeOperation("cacherecall");
            }
            catch (Exception ex) {
                LOGGER.warn("ChgGuideLeftTreeEditPlugin#afterDoOperation save error", (Throwable)ex);
                String warnInfo = ResManager.loadKDString((String)"\u9875\u9762\u70b9\u51fb\u9891\u7387\u8fc7\u5feb\uff0c\u8bf7\u7b49\u5f85\u9875\u9762\u52a0\u8f7d\u5b8c\u6210\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ChgGuideLeftTreeEditPlugin_1", (String)"hr-hpfs-formplugin", (Object[])new Object[0]);
                afterDoOperationEventArgs.getOperationResult().setSuccess(false);
                afterDoOperationEventArgs.getOperationResult().setMessage(warnInfo);
                return;
            }
            if (!result.isSuccess()) {
                LOGGER.info("ChgGuideLeftTreeEditPlugin#afterDoOperation invoker cacherecall fail");
                afterDoOperationEventArgs.getOperationResult().setSuccess(result.isSuccess());
                this.getPageCache().remove("save");
                if (HRStringUtils.isNotEmpty((String)result.getValidateResult().getMessage())) {
                    this.getView().showOperationResult(result);
                }
                this.getView().getParentView().sendFormAction(this.getView());
                return;
            }
            LOGGER.info("ChgGuideLeftTreeEditPlugin#afterDoOperation invoker cacherecall success");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        LOGGER.info("ChgGuideLeftTreeEditPlugin#closedCallBack");
        super.closedCallBack(closedCallBackEvent);
        Object dataReturned = closedCallBackEvent.getReturnData();
        String key = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)key, (String)"config")) {
            LOGGER.info("ChgGuideLeftTreeEditPlugin#closedCallBack");
            Map fieldMap = (Map)SerializationUtils.fromJsonString((String)((String)dataReturned), Map.class);
            String currLabelLeftTree = this.getPageCache().get("currLabelLeftTree");
            Map fieldsMap = this.getPageCache().get("fieldsMap") == null ? new HashMap<String, Map>(16) : (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("fieldsMap"), Map.class);
            fieldsMap.put(currLabelLeftTree, fieldMap);
            this.getPageCache().put("fieldsMap", SerializationUtils.toJsonString(fieldsMap));
            if (this.getPageCache().get("save") != null) {
                LOGGER.info("ChgGuideLeftTreeEditPlugin#afterDoOperation closedCallBack saveData");
                this.saveData();
            }
        }
    }

    private boolean saveData() {
        LOGGER.info("ChgGuideLeftTreeEditPlugin#afterDoOperation saveData");
        String chgCategory = this.getView().getParentView().getPageCache().get("chgcategory");
        Long chgCategoryId = Long.parseLong(chgCategory);
        String chgStrategy = this.getView().getParentView().getPageCache().get("chgstrategy");
        Long chgStrategyId = Long.parseLong(chgStrategy);
        Map nameOrmValue = (Map)this.getView().getFormShowParameter().getCustomParam("nameOrmValue");
        String name = this.getView().getParentView().getPageCache().get("name");
        String billSource = this.getView().getParentView().getPageCache().get("billsource");
        Map idsMap = (Map)this.getView().getFormShowParameter().getCustomParam("ids");
        DynamicObject dyn = this.getChgGuideBase(idsMap);
        String number = this.getNumber(dyn);
        String actionType = this.getView().getParentView().getPageCache().get("actiontype");
        String carrier = this.getView().getParentView().getPageCache().get("carrier");
        Long actionTypeId = Long.parseLong(actionType);
        Long hbssActionId = ChgNameValidateService.getInstance().getHBSSActionId(name, actionTypeId, number);
        LOGGER.info("ChgGuideLeftTreeEditPlugin#saveData hbssActionId is {}", (Object)hbssActionId);
        if (hbssActionId == -1L) {
            this.getView().showErrorNotification("name exists hbss action");
            return false;
        }
        String backNum = number + "_BACK";
        String backMsg = ResManager.loadKDString((String)"\u64a4\u56de", (String)"ChgActionEditPlugin_4", (String)"hr-hpfs-formplugin", (Object[])new Object[0]);
        String backName = name + "_" + backMsg;
        Long backActionId = ChgNameValidateService.getInstance().getHBSSActionId(backName, actionTypeId, backNum);
        LOGGER.info("ChgGuideLeftTreeEditPlugin#saveData backActionId is {}", (Object)backActionId);
        if (backActionId == -1L) {
            this.getView().showErrorNotification("name exists hbss action");
            return false;
        }
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("params");
        List strategyConfigList = (List)map.get("strategyTactics");
        String fieldsMapString = this.getPageCache().get("fieldsMap");
        Map fieldsMap = HRStringUtils.isEmpty((String)fieldsMapString) ? Collections.emptyMap() : (Map)SerializationUtils.fromJsonString((String)fieldsMapString, Map.class);
        Map ruleConfigMaps = (Map)map.get("ruleConfigMaps");
        HashSet strategyTacticMustInput = new HashSet();
        strategyConfigList.forEach(row -> {
            String tacticNumber = (String)((Map)((Map)row.get(0)).get("chgtactic")).get("number");
            String leftTreeNumber = ("left_tactic_" + tacticNumber).toLowerCase(Locale.ROOT);
            for (Map config : row) {
                boolean isMust = (Boolean)config.get("required");
                if (!isMust) continue;
                strategyTacticMustInput.add(leftTreeNumber);
                break;
            }
        });
        if (this.isAddStatus()) {
            LOGGER.info("ChgGuideLeftTreeEditPlugin#isAddStatus");
            strategyTacticMustInput.removeAll(fieldsMap.keySet());
            strategyTacticMustInput.removeAll(ruleConfigMaps.keySet());
            if (!strategyTacticMustInput.isEmpty()) {
                LOGGER.info("ChgGuideLeftTreeEditPlugin#strategyTacticMustInput is not empty");
                Map tacticMaps = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("tacticMaps"), Map.class);
                StringBuilder stringBuilder = new StringBuilder(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4ee5\u4e0b\u4fe1\u606f\u7ec4\u7684\u5fc5\u586b\u5b57\u6bb5\uff1a", (String)"ChgGuideLeftTreeEditPlugin_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
                strategyTacticMustInput.forEach(row -> {
                    if (tacticMaps.get(row) != null) {
                        stringBuilder.append(this.getNameLocalValue((Map)((Map)tacticMaps.get(row)).get("name"))).append(' ');
                    }
                });
                this.getView().getParentView().showErrorNotification(stringBuilder.toString());
                this.getView().returnDataToParent((Object)"2");
                return false;
            }
        }
        DynamicObject hbssAction = this.formatHBSSAction(number, nameOrmValue, hbssActionId);
        DynamicObject backAction = this.formatHBSSAction(backNum, backName, backActionId);
        LOGGER.info("ChgGuideLeftTreeEditPlugin#saveData begin transfer");
        try (TXHandle h = TX.requiresNew();){
            try {
                HashMap<String, Long> params = new HashMap<String, Long>(2);
                params.put("action", hbssAction.getLong("id"));
                params.put("backaction", backAction.getLong("id"));
                this.saveGuideBase(chgCategoryId, chgStrategyId, nameOrmValue, billSource, dyn, params, idsMap, carrier);
            }
            catch (RuntimeException e) {
                LOGGER.error("*****PerChg Found Error***** : ", (Throwable)e);
                h.markRollback();
                throw new KDException((Throwable)e, new ErrorCode("ChgGuideRuleConfigEditPlugin", ExceptionUtils.getExceptionStackTraceMessage((Exception)e)), new Object[0]);
            }
        }
        this.syncHBSSAction(hbssAction);
        this.syncHBSSAction(backAction);
        return true;
    }

    private String validateMustInput() {
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("params");
        List strategyConfigList = (List)map.get("strategyTactics");
        String fieldsMapString = this.getPageCache().get("fieldsMap");
        Map fieldsMap = HRStringUtils.isEmpty((String)fieldsMapString) ? Collections.emptyMap() : (Map)SerializationUtils.fromJsonString((String)fieldsMapString, Map.class);
        Map ruleConfigMaps = (Map)map.get("ruleConfigMaps");
        HashSet strategyTacticMustInput = new HashSet();
        strategyConfigList.forEach(row -> {
            String tacticNumber = (String)((Map)((Map)row.get(0)).get("chgtactic")).get("number");
            String leftTreeNumber = ("left_tactic_" + tacticNumber).toLowerCase(Locale.ROOT);
            for (Map config : row) {
                boolean isMust = (Boolean)config.get("required");
                if (!isMust) continue;
                strategyTacticMustInput.add(leftTreeNumber);
                break;
            }
        });
        strategyTacticMustInput.removeAll(fieldsMap.keySet());
        strategyTacticMustInput.removeAll(ruleConfigMaps.keySet());
        String currLabelLeftTree = this.getPageCache().get("currLabelLeftTree");
        if (HRStringUtils.isNotEmpty((String)currLabelLeftTree)) {
            strategyTacticMustInput.remove(currLabelLeftTree);
        }
        if (!strategyTacticMustInput.isEmpty()) {
            Map tacticMaps = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("tacticMaps"), Map.class);
            StringBuilder stringBuilder = new StringBuilder(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4ee5\u4e0b\u4fe1\u606f\u7ec4\u7684\u5fc5\u586b\u5b57\u6bb5\uff1a", (String)"ChgGuideLeftTreeEditPlugin_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            strategyTacticMustInput.forEach(row -> {
                if (tacticMaps.get(row) != null) {
                    stringBuilder.append(this.getNameLocalValue((Map)((Map)tacticMaps.get(row)).get("name"))).append(' ');
                }
            });
            return stringBuilder.toString();
        }
        return "";
    }

    private String getNameLocalValue(Map<String, String> name) {
        return name.get(RequestContext.get().getLang().getLangTag().replace("-", "_"));
    }

    private DynamicObject getChgGuideBase(Map<String, Object> idsMap) {
        HRBaseServiceHelper baseHelper = new HRBaseServiceHelper("hpfs_chgguidebase");
        if (this.isAddStatus()) {
            DynamicObject dyn = baseHelper.generateEmptyDynamicObject();
            Long newId = ORM.create().genLongId("hpfs_chgguidebase");
            dyn.set("id", (Object)newId);
            dyn.set("masterid", (Object)newId);
            dyn.set("status", (Object)"C");
            dyn.set("enable", (Object)"10");
            dyn.set("creator", (Object)RequestContext.get().getCurrUserId());
            return dyn;
        }
        Long id = Long.parseLong(idsMap.get("chgGuideBaseId") + "");
        return baseHelper.loadSingle((Object)id);
    }

    private String getNumber(DynamicObject dyn) {
        if (this.isAddStatus()) {
            String number = CodeRuleServiceHelper.getNumber((String)"hpfs_chgguidebase", (DynamicObject)dyn, null);
            dyn.set("number", (Object)number);
            return number;
        }
        return dyn.getString("number");
    }

    private DynamicObject saveChgAction(Long chgCategoryId, Map<String, Object> name, String number, Map<String, Long> params, Map<String, Object> idsMap) {
        DynamicObject dyn;
        LOGGER.info("ChgGuideLeftTreeEditPlugin#saveChgAction begin");
        HRBaseServiceHelper actionHelper = new HRBaseServiceHelper("hpfs_chgaction");
        if (this.isAddStatus()) {
            dyn = actionHelper.generateEmptyDynamicObject();
            dyn.set("id", (Object)ORM.create().genLongId("hpfs_chgaction"));
            dyn.set("masterid", dyn.get("id"));
            dyn.set("status", (Object)"C");
            dyn.set("enable", (Object)"10");
            dyn.set("creator", (Object)RequestContext.get().getCurrUserId());
        } else {
            Long chgActionId = Long.parseLong(idsMap.get("chgActionId") + "");
            dyn = actionHelper.loadSingle((Object)chgActionId);
        }
        dyn.set("number", (Object)number);
        dyn.set("name", name);
        dyn.set("chgcategory", (Object)chgCategoryId);
        dyn.set("action", (Object)params.get("action"));
        dyn.set("backaction", (Object)params.get("backaction"));
        actionHelper.saveOne(dyn);
        return dyn;
    }

    private DynamicObject formatHBSSAction(String number, Map<String, Object> name, Long id) {
        DynamicObject newDy;
        String actionType = this.getView().getParentView().getPageCache().get("actiontype");
        Long actionTypeId = Long.parseLong(actionType);
        HRBaseServiceHelper actionHelper = new HRBaseServiceHelper("hbss_action");
        if (id != 0L) {
            newDy = actionHelper.loadSingle((Object)id);
        } else {
            newDy = actionHelper.generateEmptyDynamicObject();
            Long newId = ORM.create().genLongId("hbss_action");
            newDy.set("id", (Object)newId);
            newDy.set("masterid", (Object)newId);
        }
        newDy.set("name", name);
        newDy.set("number", (Object)number);
        newDy.set("actiontype", (Object)actionTypeId);
        newDy.set("status", (Object)"C");
        newDy.set("enable", (Object)"1");
        return newDy;
    }

    private DynamicObject formatHBSSAction(String number, String name, Long id) {
        DynamicObject newDy;
        String actionType = this.getView().getParentView().getPageCache().get("actiontype");
        Long actionTypeId = Long.parseLong(actionType);
        HRBaseServiceHelper actionHelper = new HRBaseServiceHelper("hbss_action");
        if (id != 0L) {
            newDy = actionHelper.loadSingle((Object)id);
        } else {
            newDy = actionHelper.generateEmptyDynamicObject();
            Long newId = ORM.create().genLongId("hbss_action");
            newDy.set("id", (Object)newId);
            newDy.set("masterid", (Object)newId);
        }
        newDy.set("name", (Object)name);
        newDy.set("number", (Object)number);
        newDy.set("actiontype", (Object)actionTypeId);
        newDy.set("status", (Object)"C");
        newDy.set("enable", (Object)"1");
        return newDy;
    }

    private void syncHBSSAction(DynamicObject action) {
        HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSMsgService", (String)"saveActionDy", (Object[])new Object[]{action});
    }

    private boolean isAddStatus() {
        int operateStatus = this.getView().getFormShowParameter().getStatus().getValue();
        return operateStatus == OperationStatus.ADDNEW.getValue();
    }

    private DynamicObject saveChgRule(Long actionId, Long chgStrategyId, Map<String, Object> name, String number, Map<String, Object> idsMap) {
        DynamicObject dyn;
        LOGGER.info("ChgGuideLeftTreeEditPlugin#saveChgRule begin");
        HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("hpfs_chgrule");
        if (this.isAddStatus()) {
            Long newId = ORM.create().genLongId("hpfs_chgrule");
            dyn = ruleHelper.generateEmptyDynamicObject();
            dyn.set("id", (Object)newId);
            dyn.set("masterid", (Object)newId);
            dyn.set("status", (Object)"C");
            dyn.set("enable", (Object)"10");
            dyn.set("creator", (Object)RequestContext.get().getCurrUserId());
        } else {
            Long ruleId = Long.parseLong(idsMap.get("chgRuleId") + "");
            dyn = ruleHelper.loadSingle((Object)ruleId);
        }
        dyn.set("number", (Object)number);
        dyn.set("name", name);
        dyn.set("chgaction", (Object)actionId);
        dyn.set("chgstrategy", (Object)chgStrategyId);
        this.saveRuleConfig(dyn.getLong("id"));
        ruleHelper.saveOne(dyn);
        return dyn;
    }

    private void saveRuleConfig(Long ruleId) {
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("params");
        List ruleConfigList = (List)map.get("ruleConfigs");
        Map ruleConfigMaps = (Map)map.get("ruleConfigMaps");
        Map tacticMaps = (Map)map.get("tacticMaps");
        Map extraTacticMapping = (Map)map.get("extraTacticMapping");
        String fieldsMapString = this.getPageCache().get("fieldsMap");
        Map fieldsMap = HRStringUtils.isEmpty((String)fieldsMapString) ? Collections.emptyMap() : (Map)SerializationUtils.fromJsonString((String)fieldsMapString, Map.class);
        QFilter[] qFilters = new QFilter[]{new QFilter("chgrule", "=", (Object)ruleId)};
        Map<Long, Map<String, Long>> idMap = this.getIdMap(qFilters);
        ArrayList<DynamicObject> dyn2add = new ArrayList<DynamicObject>(16);
        tacticMaps.forEach((prefix, tactic) -> {
            Object tacticId = tactic.get("id");
            String tacticNumber = (String)tactic.get("number");
            long tacticIdLong = Long.parseLong(tacticId + "");
            Map chgObject = (Map)tactic.get("chgobject");
            if (chgObject == null) {
                return;
            }
            String tableName = (String)((Map)tactic.get("chgobject")).get("number");
            Map fieldsValueMap = (Map)fieldsMap.get(prefix);
            if (!CollectionUtils.isEmpty((Map)fieldsValueMap)) {
                fieldsValueMap.values().forEach(value -> {
                    DynamicObject dyn = ChgRuleConfigRepository.getInstance().generateEmptyDynamicObject();
                    dyn.set("chgrule", (Object)ruleId);
                    this.formatStrategyDyn2Add(dyn, (Map<String, Object>)value, tacticId, tableName, tacticNumber);
                    this.setRuleConfigId(dyn, idMap, tacticIdLong);
                    dyn2add.add(dyn);
                });
                return;
            }
            Map ruleValueMap = ruleConfigMaps.getOrDefault(prefix, new HashMap());
            Map fileTacticValueMap = extraTacticMapping.getOrDefault(prefix, new HashMap());
            fileTacticValueMap.forEach(ruleValueMap::putIfAbsent);
            if (CollectionUtils.isEmpty((Map)ruleValueMap)) {
                DynamicObject dyn = ChgRuleConfigRepository.getInstance().generateEmptyDynamicObject();
                dyn.set("chgrule", (Object)ruleId);
                dyn.set("chgtactic", tacticId);
                this.setRuleConfigId(dyn, idMap, tacticIdLong);
                dyn2add.add(dyn);
                return;
            }
            ruleValueMap.values().forEach(value -> {
                DynamicObject dyn = ChgRuleConfigRepository.getInstance().generateEmptyDynamicObject();
                dyn.set("chgrule", (Object)ruleId);
                this.formatStrategyDyn2Add(dyn, (Map<String, Object>)value, tacticId, tableName, tacticNumber);
                this.setRuleConfigId(dyn, idMap, tacticIdLong);
                dyn2add.add(dyn);
            });
        });
        dyn2add.removeIf(row -> row.get("chgtactic") == null);
        ChgRuleConfigRepository.getInstance().deleteByFilter(qFilters);
        ChgRuleConfigRepository.getInstance().save(dyn2add.toArray(new DynamicObject[0]));
    }

    private Map<Long, Map<String, Long>> getIdMap(QFilter[] qFilters) {
        DynamicObjectCollection collection = ChgRuleConfigRepository.getInstance().queryOriginalCollection("id, chgtactic, chgfile", qFilters);
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Long, List<DynamicObject>> map = collection.stream().collect(Collectors.groupingBy(row -> row.getLong("chgtactic")));
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, row -> ((List)row.getValue()).stream().collect(Collectors.toMap(dyn -> dyn.getString("chgfile"), dyn -> dyn.getLong("id")))));
    }

    private void setRuleConfigId(DynamicObject dyn, Map<Long, Map<String, Long>> idMap, long tacticId) {
        String chgFile = dyn.getString("chgfile");
        if (idMap.get(tacticId) == null) {
            return;
        }
        Long id = idMap.get(tacticId).get(chgFile);
        if (id != null) {
            dyn.set("id", (Object)id);
        }
    }

    private void formatAddDyn2Add(DynamicObject ruleConfig, Map<String, Object> field) {
        String tacticNumber = ((String)field.get("number")).toLowerCase(Locale.ROOT);
        Object tacticId = field.get("fid") == null ? field.get("id") : field.get("fid");
        ruleConfig.set("chgtactic", tacticId);
        String mappingName = "mappingbase-tactic-" + tacticNumber + "-mapping";
        ruleConfig.set("filemapping", this.getModel().getValue(mappingName));
    }

    private void formatStrategyDyn2Add(DynamicObject ruleConfig, Map<String, Object> field, Object tacticId, String tableName, String tacticNumber) {
        String limitType;
        ruleConfig.set("chgtactic", tacticId);
        String fieldNumber = (String)field.get("chgfile");
        if (HRStringUtils.isEmpty((String)fieldNumber)) {
            return;
        }
        String name = fieldNumber;
        ruleConfig.set("chgfile", field.get("chgfile"));
        switch (limitType = (String)field.get("limittype")) {
            case "": {
                this.setValueCustom(ruleConfig, name, field, tableName, tacticNumber);
                break;
            }
            case "0": {
                this.setValueFixed(ruleConfig, name, field, tableName, tacticNumber);
                break;
            }
            case "1": {
                this.setValueChgType(ruleConfig, name, field);
                break;
            }
        }
        ruleConfig.set("limittype", (Object)limitType);
    }

    private void setValueCustom(DynamicObject ruleConfig, String name, Map<String, Object> field, String tableName, String tacticNumber) {
        Object object = field.get("entitysource");
        if (object != null && !"".equals(object)) {
            String entitySource = object instanceof String ? (String)object : (String)((Map)object).get("number");
            ruleConfig.set("entitysource", (Object)entitySource);
            ruleConfig.set("fieldsource", field.get("fieldsource"));
            return;
        }
        Object valuefixed = field.get("valuefixed");
        if (valuefixed != null && !"".equals(valuefixed)) {
            if (valuefixed instanceof DynamicObject) {
                ruleConfig.set("valuefixed", (Object)((DynamicObject)valuefixed).getLong("id"));
            } else {
                ruleConfig.set("valuefixed", valuefixed);
            }
            return;
        }
        String carrier = this.getView().getParentView().getPageCache().get("carrier");
        if (HRStringUtils.equals((String)carrier, (String)ChgCarrierEnum.CARRIER_ACTION.getCode())) {
            String tableNameSub = tableName.split("_")[1];
            String rpcParam = tacticNumber + "_" + tableNameSub.substring(0, Math.min(50, tableNameSub.length())) + "_" + name;
            if (rpcParam.length() > 100) {
                rpcParam = rpcParam.substring(0, 100);
            }
            ruleConfig.set("rpcparam", (Object)rpcParam);
            return;
        }
    }

    private void setValueFixed(DynamicObject ruleConfig, String name, Map<String, Object> field, String tableName, String tacticNumber) {
        String sourceTypeName = "sourcecombo-" + name;
        String val = (String)field.get("val");
        String valRange = (String)field.get("valrange_tag");
        this.setValueCustom(ruleConfig, name, field, tableName, tacticNumber);
        String valName = "val-" + name;
        if (HRStringUtils.isNotEmpty((String)val)) {
            ruleConfig.set("val", (Object)val);
        }
        if (HRStringUtils.isNotEmpty((String)valRange)) {
            ruleConfig.set("valrange_tag", (Object)valRange);
        }
        ruleConfig.set("val", field.get("val"));
        ruleConfig.set("valrange_tag", field.get("valrange_tag"));
        this.setValueCustom(ruleConfig, name, field, tableName, tacticNumber);
    }

    private void setValueChgType(DynamicObject ruleConfig, String name, Map<String, Object> field) {
        String chgTypeName = "chgcombo" + name;
        ruleConfig.set("chgtype", field.get("chgtype"));
        ruleConfig.set("valuefixed", field.get("valuefixed"));
    }

    private void saveGuideBase(Long chgCategoryId, Long chgStrategyId, Map<String, Object> name, String billSource, DynamicObject dyn, Map<String, Long> params, Map<String, Object> idsMap, String carrier) {
        LOGGER.info("ChgGuideLeftTreeEditPlugin#saveGuideBase begin");
        HRBaseServiceHelper baseHelper = new HRBaseServiceHelper("hpfs_chgguidebase");
        DynamicObject chgAction = this.saveChgAction(chgCategoryId, name, dyn.getString("number"), params, idsMap);
        DynamicObject chgRule = this.saveChgRule(chgAction.getLong("id"), chgStrategyId, name, dyn.getString("number"), idsMap);
        String chgEvent = this.getView().getParentView().getPageCache().get("chgevent");
        Long chgEventId = Long.parseLong(chgEvent);
        dyn.set("chgaction", (Object)chgAction.getLong("id"));
        dyn.set("chgrule", (Object)chgRule.getLong("id"));
        dyn.set("chgcategory", (Object)chgCategoryId);
        dyn.set("chgevent", (Object)chgEventId);
        dyn.set("name", name);
        dyn.set("billsource", (Object)billSource);
        dyn.set("carrier", (Object)carrier);
        DynamicObjectCollection pluginCollection = dyn.getDynamicObjectCollection("entryentity");
        this.formatPluginCollection(pluginCollection);
        dyn.set("entryentity", (Object)pluginCollection);
        baseHelper.saveOne(dyn);
    }

    private void formatPluginCollection(DynamicObjectCollection pluginCollection) {
        Map params = (Map)this.getView().getFormShowParameter().getCustomParam("params");
        List collection = (List)params.get("pluginCollection");
        String pluginParam = (String)params.get("pluginParam");
        Map pluginMap = HRStringUtils.isEmpty((String)pluginParam) ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)pluginParam, Map.class);
        pluginCollection.clear();
        collection.forEach(plugin -> {
            String number;
            List maps;
            Map pluginValueMap = (Map)plugin.get("plugin");
            if (CollectionUtils.isEmpty((Map)pluginValueMap)) {
                return;
            }
            DynamicObject dyn = pluginCollection.addNew();
            Arrays.stream(basciFieldArr).forEach(field -> dyn.set(field, plugin.get(field)));
            dyn.set("plugin", pluginValueMap.get("id"));
            if (this.isAddStatus()) {
                dyn.set("id", null);
            }
            if (CollectionUtils.isEmpty((Collection)(maps = (List)pluginMap.get(number = (String)pluginValueMap.get("number"))))) {
                return;
            }
            DynamicObjectCollection paramsCollection = dyn.getDynamicObjectCollection("subentryentity");
            maps.forEach(row -> {
                DynamicObject paramDyn = paramsCollection.addNew();
                paramDyn.set("param", row.get("paramnumber"));
                paramDyn.set("value", row.get("paramvalue"));
            });
        });
    }

    private String getChgObjectFieldName(String field, String chgObject) {
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)chgObject)).getDataEntityType().getProperties().get((Object)field);
        if (dataEntityProperty == null) {
            return "";
        }
        return dataEntityProperty.getDisplayName().getLocaleValue();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().returnDataToParent((Object)"1");
    }
}

