/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.TextProp;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.control.HRFieldAp;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.common.constants.ChgRuleConstants;
import kd.hr.hpfs.common.constants.ChgStyleConstants;
import kd.hr.hpfs.formplugin.model.DrawFormFieldDto;
import kd.hr.hpfs.formplugin.service.ApControlService;
import kd.hr.hpfs.formplugin.service.ChgLocalValueService;
import kd.hr.hpfs.formplugin.util.ChgCommonUtils;
import kd.hr.hpfs.formplugin.util.ChgStyleUtils;

public class ChgGuideBaseDrawControlService
implements ChgStyleConstants {
    private static final ChgGuideBaseDrawControlService CHG_GUIDE_BASE_DRAW_CONTROL_SERVICE = new ChgGuideBaseDrawControlService();

    public static ChgGuideBaseDrawControlService getInstance() {
        return CHG_GUIDE_BASE_DRAW_CONTROL_SERVICE;
    }

    public List<ControlAp<?>> formatCustomSource(String name, boolean isMust, List<DrawFormFieldDto> allFields, String displayName) {
        ArrayList controlApList = new ArrayList();
        this.formatCustomSourceEntityBase(name, isMust, allFields, displayName, controlApList);
        this.formatCustomSourceLabel(name, controlApList);
        this.formatCustomSourceComboField(name, isMust, allFields, displayName, controlApList);
        return controlApList;
    }

    private void formatCustomSourceEntityBase(String name, boolean isMust, List<DrawFormFieldDto> allFields, String displayName, List<ControlAp<?>> controlApList) {
        FieldAp entityBaseAp = new HRFieldAp.Builder("baseentityap-" + name).setFontSize(14).setName("").setWidth("230px").setShowTitle(false).build();
        String fieldName = displayName + ChgLocalValueService.getInstance().getAppointedEntity();
        DrawFormFieldDto baseEntityField = new DrawFormFieldDto().setField("baseentityap-" + name).setName(fieldName).setClassSimpleName(BasedataProp.class.getSimpleName()).setBaseEntityId("bos_objecttype").setBackEndMustInput(isMust).setDisplayStyle(2);
        entityBaseAp.setField(new ApControlService().createField(baseEntityField));
        entityBaseAp.setFireUpdEvt(true);
        entityBaseAp.setTextAlign("right");
        entityBaseAp.setLabelDirection("h");
        entityBaseAp.setFieldStyle(2);
        entityBaseAp.setLabelWidth(new LocaleString("5px"));
        entityBaseAp.setWidth(new LocaleString("230px"));
        entityBaseAp.setStyle(ChgStyleUtils.setBottomStyle());
        allFields.add(baseEntityField);
        controlApList.add((ControlAp<?>)entityBaseAp);
    }

    private void formatCustomSourceLabel(String name, List<ControlAp<?>> controlApList) {
        LabelAp labelAp = ((HRLabelAp.Builder)new HRLabelAp.Builder("label-" + name).setFontSize(14).setMarginTop("18px")).setForeColor("#666666").setShrink(0).setName(ResManager.loadKDString((String)"\u7684", (String)"ChgGuideBaseDrawControlService_4", (String)"hr-hpfs-formplugin", (Object[])new Object[0])).build();
        FlexPanelAp labelFlexAp = new HRFlexPanelAp.Builder("fieldflex" + name + "label").setName(ChgRuleConstants.CHINESE_FIELD_FLEX + name + "label").build();
        labelFlexAp.getItems().add(labelAp);
        controlApList.add((ControlAp<?>)labelAp);
    }

    private void formatCustomSourceComboField(String name, boolean isMust, List<DrawFormFieldDto> allFields, String displayName, List<ControlAp<?>> controlApList) {
        FieldAp comboAp = new HRFieldAp.Builder("combo-" + name).setName("").setWidth("230px").setShowTitle(false).build();
        String fieldDisplayName = displayName + ChgLocalValueService.CHG_LOCAL_VALUE_SERVICE.getAppointedField();
        DrawFormFieldDto comboField = new DrawFormFieldDto().setField("combo-" + name).setName(fieldDisplayName).setClassSimpleName(ComboProp.class.getSimpleName()).setBackEndMustInput(isMust).setComboItemList(new ArrayList<ComboItem>());
        comboAp.setField(new ApControlService().createField(comboField));
        comboAp.setWidth(new LocaleString("230px"));
        comboAp.setTextAlign("right");
        comboAp.setLabelDirection("h");
        comboAp.setFieldStyle(2);
        comboAp.setLabelWidth(new LocaleString("5px"));
        comboAp.setStyle(ChgStyleUtils.setBottomStyle());
        allFields.add(comboField);
        controlApList.add((ControlAp<?>)comboAp);
    }

    public List<ControlAp<?>> formatFixedVal(String name, Map<String, Object> fieldMap, List<DrawFormFieldDto> allFields, List<Map<String, Object>> originFields, Map<String, String> baseFields, String displayName, String carrier) {
        String val;
        boolean isMust = (Boolean)fieldMap.get("required");
        ArrayList controlApList = new ArrayList();
        controlApList.addAll(ChgGuideBaseDrawControlService.getInstance().formatCustomSource(name, isMust, allFields, displayName));
        StringBuilder sb = new StringBuilder().append('\uff0c');
        String labelApname = sb.append(ResManager.loadKDString((String)"\u6570\u636e\u8303\u56f4\u8bbe\u7f6e\u4e3a", (String)"ChgGuideBaseDrawControlService_5", (String)"hr-hpfs-formplugin", (Object[])new Object[0])).toString();
        LabelAp labelAp = ((HRLabelAp.Builder)((HRLabelAp.Builder)new HRLabelAp.Builder("labelrange-" + name).setFontSize(14).setMarginTop("18px")).setForeColor("#666666").setShrink(0).setName(labelApname).setMarginRight("10px")).build();
        FlexPanelAp labelFlexAp = new HRFlexPanelAp.Builder("fieldflex" + name + "label").setName(ChgRuleConstants.CHINESE_FIELD_FLEX + name + "label").build();
        labelFlexAp.getItems().add(labelAp);
        controlApList.add((ControlAp<?>)labelAp);
        String fieldNumber = (String)fieldMap.get("chgfile");
        String limitType = (String)fieldMap.get("limittype");
        boolean editable = (Boolean)fieldMap.get("editable");
        HashMap<String, Object> originField = new HashMap<String, Object>();
        originField.put("field", fieldNumber);
        originField.put("limitType", limitType);
        originField.put("editable", editable);
        String valRange = (String)fieldMap.get("valrange_tag");
        if (HRStringUtils.isNotEmpty((String)valRange)) {
            controlApList.addAll(this.formatFixedValBaseData(name, fieldMap, allFields, originField, baseFields, displayName));
        }
        if (HRStringUtils.isNotEmpty((String)(val = (String)fieldMap.get("val")))) {
            controlApList.addAll(this.formatFixedValCombo(name, fieldMap, allFields, originField, displayName));
        }
        originFields.add(originField);
        return controlApList;
    }

    public List<ControlAp<?>> formatFixedValV1(String name, Map<String, Object> fieldMap, List<DrawFormFieldDto> allFields, List<Map<String, Object>> originFields, Map<String, String> baseFields, String displayName) {
        boolean isMust = (Boolean)fieldMap.get("required");
        ArrayList controlApList = new ArrayList();
        String fieldNumber = (String)fieldMap.get("chgfile");
        String limitType = (String)fieldMap.get("limittype");
        boolean editable = (Boolean)fieldMap.get("editable");
        HashMap<String, Object> originField = new HashMap<String, Object>();
        originField.put("field", fieldNumber);
        originField.put("limitType", limitType);
        originField.put("editable", editable);
        String field = (String)fieldMap.get("chgfile");
        String chgObject = (String)((Map)((Map)fieldMap.get("chgtactic")).get("chgobject")).get("id");
        IDataEntityProperty property = (IDataEntityProperty)new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)chgObject)).getDataEntityType().getProperties().get((Object)field);
        if (property instanceof BasedataProp) {
            fieldMap.put("valrange_tag", null);
            String fixedDisplayName = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u56fa\u5b9a\u503c", (String)"ChgGuideBaseDrawControlService_13", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), displayName);
            controlApList.add(this.formatBaseDataFixedVal("fixedval", name, fieldMap, allFields, originField, baseFields, BasedataProp.class.getSimpleName(), fixedDisplayName));
        } else if (property instanceof ComboProp) {
            List comboItems = ((ComboProp)property).getComboItems();
            StringBuilder val = new StringBuilder();
            for (ValueMapItem valueMapItem : comboItems) {
                String value = valueMapItem.getValue();
                val.append(value);
                val.append(",");
            }
            String valStr = val.substring(0, val.lastIndexOf(","));
            fieldMap.put("val", valStr);
            String fixedDisplayName = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u56fa\u5b9a\u503c", (String)"ChgGuideBaseDrawControlService_13", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), displayName);
            controlApList.add(this.formatComboFixedVal("fixedval", name, fieldMap, allFields, originField, ComboProp.class.getSimpleName(), fixedDisplayName));
        } else if (property instanceof BooleanProp) {
            fieldMap.put("val", "");
            String fixedDisplayName = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u56fa\u5b9a\u503c", (String)"ChgGuideBaseDrawControlService_13", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), displayName);
            controlApList.add(this.formatComboFixedVal("fixedval", name, fieldMap, allFields, originField, ComboProp.class.getSimpleName(), fixedDisplayName));
        }
        originFields.add(originField);
        return controlApList;
    }

    private ControlAp<?> formatBaseDataFixedVal(String prefix, String name, Map<String, Object> fieldMap, List<DrawFormFieldDto> allFields, Map<String, Object> originField, Map<String, String> baseFields, String classSimpleName, String displayName) {
        String fieldNumber = (String)fieldMap.get("chgfile");
        String chgObject = (String)((Map)((Map)fieldMap.get("chgtactic")).get("chgobject")).get("id");
        boolean isMust = (Boolean)fieldMap.get("required");
        boolean editable = (Boolean)fieldMap.get("editable");
        String valueRange = (String)fieldMap.get("valrange_tag");
        FieldAp entityBaseAp = new HRFieldAp.Builder(prefix + "-" + name).setWidth("230px").setName("").setShowTitle(false).build();
        DrawFormFieldDto baseDataField = new DrawFormFieldDto().setField(prefix + "-" + name).setName(displayName).setClassSimpleName(classSimpleName).setBaseEntityId(this.getChgObjectBaseEntityId(fieldNumber, chgObject)).setBackEndMustInput(isMust).setLock(editable).setHidden(!editable);
        this.setFieldApStyle(entityBaseAp, baseDataField);
        allFields.add(baseDataField);
        originField.put("class", BasedataProp.class.getSimpleName());
        baseFields.put(prefix + "-" + name, valueRange);
        return entityBaseAp;
    }

    private List<ControlAp<?>> formatFixedValBaseData(String name, Map<String, Object> fieldMap, List<DrawFormFieldDto> allFields, Map<String, Object> originField, Map<String, String> baseFields, String displayName) {
        ArrayList controlApList = new ArrayList(2);
        String fixedDisplayName = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u56fa\u5b9a\u503c", (String)"ChgGuideBaseDrawControlService_13", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), displayName);
        controlApList.add(this.formatBaseDataFixedVal("fixedval", name, fieldMap, allFields, originField, baseFields, BasedataProp.class.getSimpleName(), fixedDisplayName));
        String rangeDisplayName = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u6570\u636e\u8303\u56f4", (String)"ChgGuideBaseDrawControlService_14", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), displayName);
        controlApList.add(this.formatBaseDataFixedVal("val", name, fieldMap, allFields, originField, baseFields, MulBasedataProp.class.getSimpleName(), rangeDisplayName));
        return controlApList;
    }

    private List<ControlAp<?>> formatFixedValCombo(String name, Map<String, Object> fieldMap, List<DrawFormFieldDto> allFields, Map<String, Object> originField, String displayName) {
        ArrayList controlApList = new ArrayList(2);
        String fixedDisplayName = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u56fa\u5b9a\u503c", (String)"ChgGuideBaseDrawControlService_13", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), displayName);
        controlApList.add(this.formatComboFixedVal("fixedval", name, fieldMap, allFields, originField, ComboProp.class.getSimpleName(), fixedDisplayName));
        String rangeDisplayName = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u6570\u636e\u8303\u56f4", (String)"ChgGuideBaseDrawControlService_14", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), displayName);
        controlApList.add(this.formatComboFixedVal("val", name, fieldMap, allFields, originField, MulComboProp.class.getSimpleName(), rangeDisplayName));
        return controlApList;
    }

    private ControlAp<?> formatComboFixedVal(String prefix, String name, Map<String, Object> fieldMap, List<DrawFormFieldDto> allFields, Map<String, Object> originField, String className, String displayName) {
        String fieldNumber = (String)fieldMap.get("chgfile");
        String chgObject = (String)((Map)((Map)fieldMap.get("chgtactic")).get("chgobject")).get("id");
        boolean isMust = (Boolean)fieldMap.get("required");
        boolean editable = (Boolean)fieldMap.get("editable");
        String val = (String)fieldMap.get("val");
        List<ComboItem> comboItemList = this.getChgObjectComboList(fieldNumber, chgObject, val);
        FieldAp comboAp = new HRFieldAp.Builder(prefix + "-" + name).setShowTitle(false).setName("").setWidth("230px").build();
        DrawFormFieldDto comboField = new DrawFormFieldDto().setField(prefix + "-" + name).setName(displayName).setClassSimpleName(className).setComboItemList(comboItemList).setBackEndMustInput(isMust).setLock(editable).setHidden(!editable);
        this.setFieldApStyle(comboAp, comboField);
        allFields.add(comboField);
        originField.put("class", ComboProp.class.getSimpleName());
        return comboAp;
    }

    public void setFieldApStyle(FieldAp fieldAp, DrawFormFieldDto drawFormField) {
        fieldAp.setField(new ApControlService().createField(drawFormField));
        fieldAp.setLock(drawFormField.getLock());
        fieldAp.setTextAlign("right");
        fieldAp.setLabelDirection("h");
        fieldAp.setFieldStyle(2);
        fieldAp.setLabelWidth(new LocaleString("5px"));
        fieldAp.setStyle(ChgStyleUtils.setBottomStyle());
    }

    public String getChgObjectBaseEntityId(String field, String chgObject) {
        return ((BasedataProp)new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)chgObject)).getDataEntityType().getProperties().get((Object)field)).getBaseEntityId();
    }

    private List<ComboItem> getChgObjectComboList(String field, String chgObject, String val) {
        List<String> values = Arrays.asList(val.split(","));
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)chgObject)).getDataEntityType().getProperties().get((Object)field);
        if (dataEntityProperty instanceof ComboProp) {
            return this.formatComboItemList(dataEntityProperty, values);
        }
        return ChgCommonUtils.formatComboListFromBoolean();
    }

    public List<ComboItem> formatComboItemList(IDataEntityProperty dataEntityProperty, List<String> values) {
        List originItems = ((ComboProp)dataEntityProperty).getComboItems();
        return originItems.stream().filter(row -> values.contains(row.getValue())).map(row -> {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(row.getName());
            comboItem.setValue(row.getValue());
            return comboItem;
        }).distinct().collect(Collectors.toList());
    }

    public void formatFieldText(FlexPanelAp flexPanelAp, String field, String displayName, List<DrawFormFieldDto> allFields) {
        FieldAp entityBaseAp = new HRFieldAp.Builder("text_" + field).setShowTitle(false).setWidth("230px").setName("").build();
        DrawFormFieldDto drawFormField = new DrawFormFieldDto().setField("text_" + field).setName(displayName).setClassSimpleName(TextProp.class.getSimpleName()).setLock(false);
        entityBaseAp.setField(new ApControlService().createField(drawFormField));
        entityBaseAp.setFireUpdEvt(true);
        entityBaseAp.setLabelDirection("h");
        entityBaseAp.setFieldStyle(2);
        entityBaseAp.setStyle(ChgStyleUtils.setBottomStyle());
        allFields.add(drawFormField);
        flexPanelAp.getItems().add(entityBaseAp);
        String nameOne = ResManager.loadKDString((String)"\u7684", (String)"ChgGuideBaseDrawControlService_4", (String)"hr-hpfs-formplugin", (Object[])new Object[0]);
        String nameTwo = ResManager.loadKDString((String)"\u503c", (String)"ChgGuideBaseDrawControlService_6", (String)"hr-hpfs-formplugin", (Object[])new Object[0]);
        nameTwo = nameOne + nameTwo;
        LabelAp labelAp = ((HRLabelAp.Builder)((HRLabelAp.Builder)new HRLabelAp.Builder("label0-" + field).setFontSize(14).setMarginTop("4px")).setForeColor("#666666").setShrink(0).setMarginRight("10px")).setName(nameTwo).build();
        flexPanelAp.getItems().add(labelAp);
    }

    public ControlAp<?> formatFieldCombo(String name, Map<String, Object> fieldMap, List<DrawFormFieldDto> allFields, String limitType, String displayName, boolean editable, String carrier) {
        FieldAp comboAp = new HRFieldAp.Builder("sourcecombo-" + name).setFontSize(14).setName("").setWidth("130px").build();
        String fieldName = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u6570\u636e\u6765\u6e90", (String)"ChgGuideBaseDrawControlService_12", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), displayName);
        DrawFormFieldDto comboField = new DrawFormFieldDto().setField("sourcecombo-" + name).setName(fieldName).setClassSimpleName(ComboProp.class.getSimpleName()).setComboItemList(ChgCommonUtils.formatComboByLimitType(fieldMap, limitType, carrier)).setMustInput(editable);
        this.setFieldApStyle(comboAp, comboField);
        comboAp.setFireUpdEvt(true);
        allFields.add(comboField);
        return comboAp;
    }

    public List<ControlAp<?>> formatChgType(String name, boolean isMust, boolean editable, List<DrawFormFieldDto> allFields, Map<String, Object> fieldMap, List<Map<String, Object>> originFields, Map<String, String> baseFields, String displayName) {
        ArrayList controlApList = new ArrayList();
        FieldAp comboAp = new HRFieldAp.Builder("chgcombo" + name).setName("").build();
        FlexPanelAp flexPanelAp = new HRFlexPanelAp.Builder("fieldflex" + name + "chgtype").setName(ChgRuleConstants.CHINESE_FIELD_FLEX + name + "chgtype").build();
        DrawFormFieldDto comboField = new DrawFormFieldDto().setField("chgcombo" + name).setName("chgtype" + name).setClassSimpleName(ComboProp.class.getSimpleName()).setComboItemList(ChgCommonUtils.formatChgTypeComboItems()).setMustInput(isMust).setLock(editable);
        this.setFieldApStyle(comboAp, comboField);
        comboAp.setFireUpdEvt(editable);
        allFields.add(comboField);
        flexPanelAp.getItems().add(comboAp);
        if (editable) {
            flexPanelAp.getItems().addAll(this.formatFixedValV1(name, fieldMap, allFields, originFields, baseFields, displayName));
        }
        controlApList.add((ControlAp<?>)flexPanelAp);
        return controlApList;
    }
}

