/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class MulSelectConfirmPlugin
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(MulSelectConfirmPlugin.class);
    private static final String NUMBER_SUMLABEL = "sumlabel";
    private static final String NUMBER_COINCIDENTLABEL = "coincidentlabel";
    private static final String NUMBER_INCONGRUENTLABEL = "incongruentlabel";
    private static final String FILENAME = "filename";
    private static final String EXPORTDATALIST = "exportDataList";
    private static final String HEADDATALIST = "headDataList";
    private static final String OP_DONOTHING_EXPORT = "donothing_export";
    private static final String PAGE_WIDTH_MORPHEME = "420px";
    private static final String PAGE_WIDTH_SYLLABARY = "500px";
    private static final String PAGE_WIDTH_ALPHABETIC = "600px";
    private static final LocaleString WIDTH = new LocaleString("420px");

    public void preOpenForm(PreOpenFormEventArgs evt) {
        this.adjustFormWidth(evt);
    }

    private void adjustFormWidth(PreOpenFormEventArgs evt) {
        FormShowParameter formShowParam = evt.getFormShowParameter();
        LOGGER.info("Current-lang:{}", (Object)RequestContext.get().getLang().toString());
        LOGGER.info("Confirm-Page-Width:{}", (Object)WIDTH.toString());
        formShowParam.getFormConfig().setWidth(WIDTH);
    }

    public void afterCreateNewData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Label sumlabel = (Label)this.getView().getControl(NUMBER_SUMLABEL);
        Label coincidentlabel = (Label)this.getView().getControl(NUMBER_COINCIDENTLABEL);
        Label incongruentlabel = (Label)this.getView().getControl(NUMBER_INCONGRUENTLABEL);
        sumlabel.setText(String.valueOf(Optional.ofNullable(formShowParameter.getCustomParam(NUMBER_SUMLABEL)).orElseGet(() -> 0)));
        coincidentlabel.setText(String.valueOf(Optional.ofNullable(formShowParameter.getCustomParam(NUMBER_COINCIDENTLABEL)).orElseGet(() -> 0)));
        incongruentlabel.setText(String.valueOf(Optional.ofNullable(formShowParameter.getCustomParam(NUMBER_INCONGRUENTLABEL)).orElseGet(() -> 0)));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (OP_DONOTHING_EXPORT.equals(operate.getOperateKey())) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String fileName = (String)formShowParameter.getCustomParam(FILENAME);
            List exportDataObjectList = (List)formShowParameter.getCustomParam(EXPORTDATALIST);
            ArrayList exportDataList = new ArrayList();
            exportDataObjectList.stream().forEach(exportData -> exportDataList.add(exportData.getInnerMap()));
            List headObjectList = (List)formShowParameter.getCustomParam(HEADDATALIST);
            ArrayList headDataList = new ArrayList();
            headObjectList.stream().forEach(headObject -> headDataList.add(new HRExportHeadObject(headObject.getString("columnId"), headObject.getString("columnAlias"))));
            String exportExcelUrl = null;
            try {
                exportExcelUrl = HRExportDataHelper.getExportExcelUrl((String)fileName, exportDataList, headDataList);
            }
            catch (IOException exception) {
                LOGGER.error((Throwable)exception);
                this.getView().showErrorNotification("getExportExcelUrl exception");
                return;
            }
            if (exportExcelUrl != null) {
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.addAction("download", (Object)exportExcelUrl);
            }
        }
    }

    static {
        WIDTH.setLocaleValue_zh_CN(PAGE_WIDTH_MORPHEME);
        WIDTH.setLocaleValue_zh_TW(PAGE_WIDTH_MORPHEME);
        WIDTH.setLocaleValue_en(PAGE_WIDTH_ALPHABETIC);
        WIDTH.put(Lang.RU.toString(), (Object)PAGE_WIDTH_ALPHABETIC);
        WIDTH.put(Lang.KO.toString(), (Object)PAGE_WIDTH_SYLLABARY);
        WIDTH.put(Lang.JA.toString(), (Object)PAGE_WIDTH_SYLLABARY);
    }
}

