/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.opplugin.validators;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.common.constants.FileMapManagerConstants;
import kd.sdk.hr.hspm.business.helper.InfoGroupHelper;

public class FileMapManagerSaveValidator
extends AbstractValidator
implements FileMapManagerConstants {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (Objects.isNull(dataEntities) || dataEntities.length == 0) {
            return;
        }
        this.validExtGroup(dataEntities);
        this.validLoadPersonField(dataEntities);
        this.validWritePersonField(dataEntities);
        this.wrapWritePersonInfoValid(dataEntities);
    }

    private void wrapWritePersonInfoValid(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Object wrapEntryEntityDy2;
            DynamicObjectCollection entryEntityDys = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            DynamicObjectCollection hcfEntryEntityDys = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity_c");
            List wrapEntryEntityDys = entryEntityDys.stream().filter(data -> !InfoGroupHelper.isSingleRowTpl((String)data.getString("targetentity.number"))).collect(Collectors.toList());
            List wrapHcfEntryEntityDys = hcfEntryEntityDys.stream().filter(data -> !InfoGroupHelper.isSingleRowTpl((String)data.getString("targetentity_c.number"))).collect(Collectors.toList());
            HashSet<String> infoGroups = new HashSet<String>(10);
            for (Object wrapEntryEntityDy2 : wrapEntryEntityDys) {
                DynamicObjectCollection dynamicObjectCollection = wrapEntryEntityDy2.getDynamicObjectCollection("subentryentity");
                List writePersonInfos = dynamicObjectCollection.stream().filter(data -> Objects.nonNull(data.getDynamicObject("targetfieldnew")) && data.getBoolean("writepersoninfo")).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(writePersonInfos)) continue;
                infoGroups.add(wrapEntryEntityDy2.getString("targetentity.name"));
            }
            HashSet<String> hcfInfoGroups = new HashSet<String>(10);
            wrapEntryEntityDy2 = wrapHcfEntryEntityDys.iterator();
            while (wrapEntryEntityDy2.hasNext()) {
                DynamicObject wrapEntryEntityDy3 = (DynamicObject)wrapEntryEntityDy2.next();
                DynamicObjectCollection dynamicObjectCollection = wrapEntryEntityDy3.getDynamicObjectCollection("subentryentity_c");
                List writePersonInfos = dynamicObjectCollection.stream().filter(data -> Objects.nonNull(data.getDynamicObject("targetfieldnew_c")) && data.getBoolean("writepersoninfo_c")).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(writePersonInfos)) continue;
                hcfInfoGroups.add(wrapEntryEntityDy3.getString("targetentity_c.name"));
            }
            ArrayList allInfoGroups = Lists.newArrayListWithCapacity((int)10);
            allInfoGroups.addAll(infoGroups);
            allInfoGroups.addAll(hcfInfoGroups);
            List results = allInfoGroups.stream().filter(HRStringUtils::isNotEmpty).collect(Collectors.groupingBy(data -> data)).entrySet().stream().filter(row -> ((List)row.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
            for (String result : results) {
                String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4eba\u5458\u4fe1\u606f\u7ec4\u201c%s\u201d\u4e0d\u80fd\u540c\u65f6\u4e0e\u5355\u636e\u548c\u5019\u9009\u4eba\u5efa\u7acb\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u8bd5\u3002", (String)"FieldRelationEdit_3", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), result);
                this.addFatalErrorMessage(dataEntity, msg);
            }
        }
    }

    private void validWritePersonField(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            List orDefault;
            Map<Long, String> targetFieldNewAndDy;
            DynamicObjectCollection subEntryEntityDys;
            DynamicObjectCollection entryEntityDys = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            DynamicObjectCollection hcfEntryEntityDys = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity_c");
            HashMap allTargetFieldNewAndDy = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject entryEntityDy : entryEntityDys) {
                subEntryEntityDys = entryEntityDy.getDynamicObjectCollection("subentryentity");
                targetFieldNewAndDy = subEntryEntityDys.stream().filter(data -> Objects.nonNull(data.getDynamicObject("targetfieldnew")) && data.getBoolean("writepersoninfo")).collect(Collectors.toMap(data -> data.getLong("targetfieldnew.id"), data -> data.getString("targetfieldnew.name"), (o1, o2) -> o1));
                for (Map.Entry<Long, String> entry : targetFieldNewAndDy.entrySet()) {
                    orDefault = allTargetFieldNewAndDy.getOrDefault(entry.getKey(), new ArrayList());
                    orDefault.add(entry.getValue());
                    allTargetFieldNewAndDy.put(entry.getKey(), orDefault);
                }
            }
            for (DynamicObject entryEntityDy : hcfEntryEntityDys) {
                subEntryEntityDys = entryEntityDy.getDynamicObjectCollection("subentryentity_c");
                targetFieldNewAndDy = subEntryEntityDys.stream().filter(data -> Objects.nonNull(data.getDynamicObject("targetfieldnew_c")) && data.getBoolean("writepersoninfo_c")).collect(Collectors.toMap(data -> data.getLong("targetfieldnew_c.id"), data -> data.getString("targetfieldnew_c.name"), (o1, o2) -> o1));
                for (Map.Entry<Long, String> entry : targetFieldNewAndDy.entrySet()) {
                    orDefault = allTargetFieldNewAndDy.getOrDefault(entry.getKey(), new ArrayList());
                    orDefault.add(entry.getValue());
                    allTargetFieldNewAndDy.put(entry.getKey(), orDefault);
                }
            }
            Map<String, List> billEntityAndPersonField = entryEntityDys.stream().collect(Collectors.toMap(data -> data.getString("billinfogroup"), data -> {
                DynamicObjectCollection dynamicObjectCollection = data.getDynamicObjectCollection("subentryentity");
                return dynamicObjectCollection.stream().map(row -> row.getLong("targetfieldnew.id")).collect(Collectors.toList());
            }, (o1, o2) -> o1));
            Map<String, List> hcfEntityAndPersonField = hcfEntryEntityDys.stream().collect(Collectors.toMap(data -> data.getString("sourceentity_c.name"), data -> {
                DynamicObjectCollection dynamicObjectCollection = data.getDynamicObjectCollection("subentryentity_c");
                return dynamicObjectCollection.stream().map(row -> row.getLong("targetfieldnew_c.id")).collect(Collectors.toList());
            }, (o1, o2) -> o1));
            for (Map.Entry longListEntry : allTargetFieldNewAndDy.entrySet()) {
                if (((List)longListEntry.getValue()).size() <= 1) continue;
                String infoGroup = "";
                for (Map.Entry<String, List> stringListEntry : billEntityAndPersonField.entrySet()) {
                    if (!stringListEntry.getValue().contains(longListEntry.getKey())) continue;
                    infoGroup = stringListEntry.getKey();
                    break;
                }
                for (Map.Entry<String, List> stringListEntry : hcfEntityAndPersonField.entrySet()) {
                    if (!stringListEntry.getValue().contains(longListEntry.getKey())) continue;
                    infoGroup = stringListEntry.getKey();
                    break;
                }
                String string = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4eba\u5458\u4fe1\u606f\u5b57\u6bb5\u201c%1$s\u201d\u5df2\u5728\u5355\u636e\u4fe1\u606f\u7ec4/\u5019\u9009\u4eba\u4fe1\u606f\u7ec4\u201c%2$s\u201d\u4e2d\u542f\u7528\u4e86\u201c\u56de\u5199\u4eba\u5458\u4fe1\u606f\u201d\uff0c\u65e0\u6cd5\u540c\u65f6\u7531\u4e24\u4e2a\u4e0d\u540c\u7684\u5355\u636e\u5b57\u6bb5\u56de\u5199\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (String)"FieldRelationEdit_4", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), ((List)longListEntry.getValue()).get(0), infoGroup);
                this.addFatalErrorMessage(dataEntity, string);
            }
        }
    }

    private void validLoadPersonField(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObjectCollection entryEntityDys = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            List nExtInfoFieldsDys = entryEntityDys.stream().filter(data -> "n_extinfo_fields".equals(data.getString("sourceentry"))).filter(data -> Objects.nonNull(data.getDynamicObject("targetentity"))).collect(Collectors.toList());
            HashMap allSourceFieldTagAndDy = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject nExtInfoFieldsDy : nExtInfoFieldsDys) {
                DynamicObjectCollection subEntryEntityDys = nExtInfoFieldsDy.getDynamicObjectCollection("subentryentity");
                Map<String, DynamicObject> sourceFieldTagAndDy = subEntryEntityDys.stream().filter(data -> Objects.nonNull(data.getDynamicObject("targetfieldnew")) && data.getBoolean("loadpersoninfo")).collect(Collectors.toMap(data -> data.getString("sourcefieldtag"), data -> data, (o1, o2) -> o1));
                for (Map.Entry<String, DynamicObject> entry : sourceFieldTagAndDy.entrySet()) {
                    List orDefault = allSourceFieldTagAndDy.getOrDefault(entry.getKey(), new ArrayList());
                    orDefault.add(entry.getValue());
                    allSourceFieldTagAndDy.put(entry.getKey(), orDefault);
                }
            }
            Map<String, List> targetEntityAndPersonField = nExtInfoFieldsDys.stream().collect(Collectors.toMap(data -> data.getString("targetentity.name"), data -> {
                DynamicObjectCollection dynamicObjectCollection = data.getDynamicObjectCollection("subentryentity");
                return dynamicObjectCollection.stream().map(row -> row.getString("sourcefieldtag")).collect(Collectors.toList());
            }, (o1, o2) -> o1));
            for (Map.Entry entry : allSourceFieldTagAndDy.entrySet()) {
                if (((List)entry.getValue()).size() <= 1) continue;
                String targetEntityName = "";
                for (Map.Entry<String, Object> entry2 : targetEntityAndPersonField.entrySet()) {
                    if (!((List)entry2.getValue()).contains(entry.getKey())) continue;
                    targetEntityName = entry2.getKey();
                    break;
                }
                String sourceField = ((DynamicObject)((List)entry.getValue()).get(0)).getString("sourcefield");
                String string = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u201c%1$s\u201d\u4e0d\u80fd\u540c\u65f6\u52a0\u8f7d\u4e24\u4e2a\u4eba\u5458\u4fe1\u606f\u5b57\u6bb5\uff0c\u8be5\u5b57\u6bb5\u5df2\u5728\u4eba\u5458\u4fe1\u606f\u7ec4\u201c%2$s\u201d\u4e2d\u542f\u7528\u4e86\u201c\u52a0\u8f7d\u4eba\u5458\u4fe1\u606f\u201d\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (String)"FieldRelationEdit_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), sourceField + "(" + (String)entry.getKey() + ")", targetEntityName);
                this.addFatalErrorMessage(dataEntity, string);
            }
        }
    }

    private void validExtGroup(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObjectCollection entryEntityDys = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            Map<String, List<DynamicObject>> targetEntityAndDysMap = entryEntityDys.stream().filter(data -> "n_extinfo_fields".equals(data.getString("sourceentry"))).filter(data -> Objects.nonNull(data.getDynamicObject("targetentity"))).collect(Collectors.groupingBy(data -> data.getString("targetentity.id")));
            for (Map.Entry<String, List<DynamicObject>> entry : targetEntityAndDysMap.entrySet()) {
                if (entry.getValue().size() <= 1) continue;
                String billInfoGroup = entry.getValue().get(0).getString("billinfogroup");
                String targetEntityName = entry.getValue().get(0).getString("targetentity.name");
                String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5355\u636e\u4fe1\u606f\u5206\u7ec4\u201c%1$s\u201d\uff0c\u4eba\u5458\u4fe1\u606f\u7ec4\u201c%2$s\u201d\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (String)"FileMapManagerEdit_9", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), billInfoGroup, targetEntityName);
                this.addFatalErrorMessage(dataEntity, msg);
            }
        }
    }
}

