/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.approval;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.ProgressBarAp;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.repository.ErmanFileRepository;
import kd.hr.hspm.business.multiview.AttacheHandlerService;
import kd.hr.hspm.business.util.InfoGroupApprovalUtil;
import kd.hr.hspm.business.util.ParamAnalysisUtil;
import kd.hr.hspm.common.constants.FieldTypeEnum;
import kd.hr.hspm.common.constants.utils.CommonUtil;

@Deprecated
public class ApprovalHelper {
    private static final Log LOGGER = LogFactory.getLog(ApprovalHelper.class);
    private static final HRBaseServiceHelper INFOAPPROVAL_HELPER = new HRBaseServiceHelper("hspm_infoapproval");
    public static final String KEY_APPROVAL_SUMBIT_CALLBACK = "ApprovalSubmitCallBack";
    public static final String KEY_HOMEPAGE_CLOSE_CALLBACK = "HomePageCloseCallBack";

    public static void viewChangeRecord(IFormView view) {
        MobileFormShowParameter showParameter;
        LOGGER.info("viewAuditRecord");
        if (!ApprovalHelper.isMobile(view) && !CommonUtil.hasPerm((String)"hspm_changerecord", (String)"47150e89000000ac", (String)"hssc")) {
            view.showErrorNotification(HRBaseUtils.getNoPermMsg());
            return;
        }
        if (ApprovalHelper.isMobile(view)) {
            showParameter = new MobileFormShowParameter();
            showParameter.setFormId("hspm_changerecordmob");
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
        } else {
            showParameter = new FormShowParameter();
            showParameter.setFormId("hspm_changerecord");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            Long personId = Long.valueOf(view.getPageCache().get("personId"));
            showParameter.setPageId(view.getPageId() + "hspm_changerecord" + personId);
        }
        view.showForm((FormShowParameter)showParameter);
    }

    public static void viewAuditRecord(IFormView view) {
        MobileListShowParameter showParameter;
        LOGGER.info("viewAuditRecord");
        if (!ApprovalHelper.isMobile(view) && !CommonUtil.hasPerm((String)"hspm_infoapproval", (String)"47150e89000000ac", (String)"hssc")) {
            view.showErrorNotification(HRBaseUtils.getNoPermMsg());
            return;
        }
        Long personId = Long.valueOf(view.getPageCache().get("personId"));
        if (ApprovalHelper.isMobile(view)) {
            showParameter = new MobileListShowParameter();
            showParameter.setFormId("bos_moblist");
            showParameter.setBillFormId("hspm_infoapproval");
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setHasRight(true);
        } else {
            showParameter = new ListShowParameter();
            showParameter.setFormId("bos_list");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setPageId(view.getPageId() + "viewAuditRecord" + personId);
        }
        showParameter.setBillFormId("hspm_infoapproval");
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        listFilterParameter.getQFilters().add(new QFilter("person", "=", (Object)personId));
        showParameter.setListFilterParameter(listFilterParameter);
        view.showForm((FormShowParameter)showParameter);
    }

    private static boolean isMobile(IFormView view) {
        return view instanceof MobileFormView;
    }

    public static Map<String, List<Map<String, Object>>> getAuditFieldMap(IFormView view) {
        HashMap<String, List<Map<String, Object>>> updateFieldMap = new HashMap<String, List<Map<String, Object>>>();
        Map allCache = view.getPageCache().getAll();
        for (Map.Entry entry : allCache.entrySet()) {
            String key = (String)entry.getKey();
            if (HRStringUtils.isEmpty((String)key) || !key.endsWith("-entrycache")) continue;
            String cacheValue = (String)entry.getValue();
            List groupFields = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
            updateFieldMap.put(key.replace("-entrycache", ""), groupFields);
        }
        return updateFieldMap;
    }

    public static boolean existAuditInfo(IFormView view) {
        Map<String, List<Map<String, Object>>> auditMap = ApprovalHelper.getAuditFieldMap(view);
        if (auditMap.size() == 0) {
            return false;
        }
        String personIdStr = view.getPageCache().get("personId");
        DynamicObject bill = ApprovalHelper.getInProcessWorkFlowBill(Long.parseLong(personIdStr));
        if (bill == null) {
            return !ApprovalHelper.removeOldVersonData(view);
        }
        if (!"G".equals(bill.getString("billstatus"))) {
            return false;
        }
        return ApprovalHelper.isChange(bill, auditMap);
    }

    private static boolean isChange(DynamicObject bill, Map<String, List<Map<String, Object>>> auditMap) {
        DynamicObjectCollection dynamicObjects = bill.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            LOGGER.info(MessageFormat.format("compare_auditMap:{0}", auditMap));
            HashMap<String, List> auditDbMap = new HashMap<String, List>(dynamicObjects.size());
            for (DynamicObject dynamicObject : dynamicObjects) {
                String firstGroup = "0000".equals(dynamicObject.getString("firstgroupnum")) ? "0000" : dynamicObject.getString("firstgroup");
                List list = auditDbMap.computeIfAbsent(firstGroup, val -> new ArrayList());
                list.add(dynamicObject);
            }
            if (auditMap.size() != auditDbMap.size()) {
                return true;
            }
            for (Map.Entry entry : auditDbMap.entrySet()) {
                List<Map<String, Object>> mapList = auditMap.get(entry.getKey());
                if (mapList == null) {
                    return true;
                }
                List dbList = (List)entry.getValue();
                LOGGER.info(MessageFormat.format("mapList:{0}, dbList:{1}", mapList, dbList));
                if (mapList.size() != dbList.size()) {
                    return true;
                }
                Set set = dbList.stream().map(val -> {
                    StringBuilder sb = new StringBuilder();
                    sb.append(val.getString("entityname"));
                    sb.append(val.getString("fieldname"));
                    sb.append(val.getLong("dataid"));
                    sb.append(val.getString("newvalue"));
                    return sb.toString();
                }).collect(Collectors.toSet());
                for (Map<String, Object> map : mapList) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(map.get("entityName"));
                    sb.append(map.get("fieldname"));
                    sb.append(map.get("dataid"));
                    Object newValue = map.get("newvalue");
                    if (newValue != null) {
                        sb.append(newValue.toString());
                    }
                    if (set.contains(sb.toString())) continue;
                    LOGGER.info(MessageFormat.format("change--set:{0}, sb:{1}", set, sb));
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean removeOldVersonData(IFormView view) {
        DynamicObject bill;
        String billId = view.getPageCache().get("submitVerson");
        if (HRStringUtils.isNotEmpty((String)billId) && !HRObjectUtils.isEmpty((Object)(bill = INFOAPPROVAL_HELPER.queryOne("billstatus", (Object)Long.parseLong(billId)))) && "C".equals(bill.getString("billstatus"))) {
            ApprovalHelper.removeFieldCache(view);
            return true;
        }
        return false;
    }

    public static void submitConfirm(IFormView view, IFormPlugin formPlugin) {
        if (!ApprovalHelper.isMobile(view) && !CommonUtil.hasPerm((String)view.getEntityId(), (String)"3+IV9XQ9HIYA", (String)"hssc")) {
            view.showErrorNotification(HRBaseUtils.getNoPermMsg());
            return;
        }
        Map<String, List<Map<String, Object>>> updateFieldMap = ApprovalHelper.getAuditFieldMap(view);
        if (updateFieldMap.size() == 0) {
            view.showConfirm(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u5ba1\u6838\u7684\u4fe1\u606f\u3002", (String)"ApprovalHelper_1", (String)"hr-hspm-business", (Object[])new Object[0]), MessageBoxOptions.None);
            return;
        }
        String configJson = view.getPageCache().get("cnfjson");
        Map infoGroupConfig = (Map)SerializationUtils.fromJsonString((String)configJson, Map.class);
        List mainentry = (List)infoGroupConfig.get("mainentry");
        String personIdStr = view.getPageCache().get("personId");
        Long personId = Long.parseLong(personIdStr);
        DynamicObject bill = ApprovalHelper.getInProcessWorkFlowBill(personId);
        if (bill != null) {
            if ("B".equals(bill.getString("billstatus")) || "D".equals(bill.getString("billstatus"))) {
                view.showConfirm(ResManager.loadKDString((String)"\u8be5\u5ba1\u6279\u5355\u636e\u5df2\u5728\u5ba1\u6279\u6d41\u7a0b\u4e2d\uff0c\u6682\u65f6\u65e0\u6cd5\u63d0\u4ea4\u8be5\u5ba1\u6279\u5355\u3002", (String)"ApprovalHelper_5", (String)"hr-hspm-business", (Object[])new Object[0]), MessageBoxOptions.None);
                return;
            }
            DynamicObjectCollection entity = bill.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection backUpEntity = ApprovalHelper.backUpEntity(entity);
            entity.clear();
            ApprovalHelper.handleHeadAudit(entity, updateFieldMap, infoGroupConfig);
            for (Map entry : mainentry) {
                String gName = (String)entry.get("groupname");
                List<Map<String, Object>> groupFields = updateFieldMap.get(gName);
                if (CollectionUtils.isEmpty(groupFields)) continue;
                List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(entry);
                ApprovalHelper.addDataToEntity(gName, Boolean.FALSE, groups, groupFields, entity);
                ApprovalHelper.addDataToEntity(gName, Boolean.TRUE, groups, groupFields, entity);
            }
            if (entity.size() == 0) {
                LOGGER.error("entity is null");
                view.showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u6682\u65e0\u9700\u8981\u5ba1\u6838\u7684\u5b57\u6bb5\u3002", (String)"ApprovalHelper_0", (String)"hr-hspm-business", (Object[])new Object[0]), MessageBoxOptions.None);
                return;
            }
            if (backUpEntity != null && !ApprovalHelper.check(view, entity, backUpEntity)) {
                return;
            }
        } else if (ApprovalHelper.existConflict(view)) {
            return;
        }
        ApprovalHelper.handleTip(view, formPlugin, updateFieldMap, infoGroupConfig);
    }

    private static void handleTip(IFormView view, IFormPlugin formPlugin, Map<String, List<Map<String, Object>>> updateFieldMap, Map<String, Object> infoGroupConfig) {
        ConfirmCallBackListener confirm = new ConfirmCallBackListener(KEY_APPROVAL_SUMBIT_CALLBACK, formPlugin);
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u9700\u5ba1\u6838\u4fe1\u606f\u7ec4\uff1a", (String)"ApprovalHelper_8", (String)"hr-hspm-business", (Object[])new Object[0]));
        boolean firstGroup = false;
        List<Map<String, Object>> headFields = updateFieldMap.get("0000");
        if (!CollectionUtils.isEmpty(headFields)) {
            firstGroup = true;
            sb.append(ResManager.loadKDString((String)"\u6863\u6848\u5934\u90e8", (String)"ApprovalHelper_9", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        List mainentry = (List)infoGroupConfig.get("mainentry");
        for (Map entry : mainentry) {
            String gName = (String)entry.get("groupname");
            List<Map<String, Object>> groupFields = updateFieldMap.get(gName);
            if (CollectionUtils.isEmpty(groupFields)) continue;
            if (!firstGroup) {
                firstGroup = true;
                sb.append(gName);
                continue;
            }
            sb.append("\u3001").append(gName);
        }
        view.showConfirm(sb.toString(), MessageBoxOptions.OKCancel, confirm);
    }

    public static void submit(IFormView view) {
        DynamicObjectCollection entity;
        if (!ApprovalHelper.isMobile(view) && !CommonUtil.hasPerm((String)view.getEntityId(), (String)"3+IV9XQ9HIYA", (String)"hssc")) {
            view.showErrorNotification(HRBaseUtils.getNoPermMsg());
            return;
        }
        String personIdStr = view.getPageCache().get("personId");
        Long personId = Long.parseLong(personIdStr);
        LOGGER.info(MessageFormat.format("ApprovalHelper#submit:{0}", personId));
        DynamicObject erFileDy = ErmanFileRepository.getPrimaryErmanFile(personId);
        String configJson = view.getPageCache().get("cnfjson");
        if (HRObjectUtils.isEmpty((Object)erFileDy) || HRStringUtils.isEmpty((String)configJson)) {
            LOGGER.error("data_exception_person:{0},configJson:{1}", (Object)personId, (Object)configJson);
            view.showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38", (String)"ApprovalHelper_2", (String)"hr-hspm-business", (Object[])new Object[0]), MessageBoxOptions.None);
            return;
        }
        Map allCache = view.getPageCache().getAll();
        HashMap<String, List<Map<String, Object>>> updateFieldMap = new HashMap<String, List<Map<String, Object>>>(allCache.size());
        for (Map.Entry entry : allCache.entrySet()) {
            String key = (String)entry.getKey();
            if (HRStringUtils.isEmpty((String)key) || !key.endsWith("-entrycache")) continue;
            String cacheValue = (String)entry.getValue();
            LOGGER.info(MessageFormat.format("grougCache:{0}", SerializationUtils.toJsonString(entry)));
            List groupFields = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
            updateFieldMap.put(key.replace("-entrycache", ""), groupFields);
        }
        if (updateFieldMap.size() == 0) {
            view.showConfirm(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u5ba1\u6838\u7684\u4fe1\u606f\u3002", (String)"ApprovalHelper_1", (String)"hr-hspm-business", (Object[])new Object[0]), MessageBoxOptions.None);
            return;
        }
        Map infoGroupConfig = (Map)SerializationUtils.fromJsonString((String)configJson, Map.class);
        OperationServiceImpl operationService = new OperationServiceImpl();
        DynamicObjectCollection backUpEntity = null;
        DynamicObject bill = ApprovalHelper.getInProcessWorkFlowBill(personId);
        LOGGER.info(MessageFormat.format("personid:{0}, bill:{1} ", personId, bill == null ? null : bill.get("billno")));
        if (bill == null) {
            if (ApprovalHelper.existConflict(view)) {
                return;
            }
            bill = INFOAPPROVAL_HELPER.generateEmptyDynamicObject();
            bill.set("person", (Object)personId);
            bill.set("employee", (Object)erFileDy.getLong("employee.id"));
            bill.set("cmpemp", (Object)erFileDy.getLong("cmpemp.id"));
            bill.set("billstatus", (Object)"B");
            bill.set("auditstatus", (Object)"B");
            bill.set("creator", (Object)RequestContext.get().getCurrUserId());
            bill.set("modifier", (Object)RequestContext.get().getCurrUserId());
            entity = bill.getDynamicObjectCollection("entryentity");
        } else {
            if ("B".equals(bill.getString("billstatus")) || "D".equals(bill.getString("billstatus"))) {
                view.showConfirm(ResManager.loadKDString((String)"\u8be5\u5ba1\u6279\u5355\u636e\u5df2\u5728\u5ba1\u6279\u6d41\u7a0b\u4e2d\uff0c\u6682\u65f6\u65e0\u6cd5\u63d0\u4ea4\u8be5\u5ba1\u6279\u5355\u3002", (String)"ApprovalHelper_5", (String)"hr-hspm-business", (Object[])new Object[0]), MessageBoxOptions.None);
                return;
            }
            entity = bill.getDynamicObjectCollection("entryentity");
            backUpEntity = ApprovalHelper.backUpEntity(entity);
            entity.clear();
        }
        ApprovalHelper.handleHeadAudit(entity, updateFieldMap, infoGroupConfig);
        List mainentry = (List)infoGroupConfig.get("mainentry");
        for (Map entry : mainentry) {
            String gName = (String)entry.get("groupname");
            List groupFields = (List)updateFieldMap.get(gName);
            if (CollectionUtils.isEmpty((Collection)groupFields)) continue;
            List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(entry);
            ApprovalHelper.addDataToEntity(gName, Boolean.FALSE, groups, groupFields, entity);
            ApprovalHelper.addDataToEntity(gName, Boolean.TRUE, groups, groupFields, entity);
        }
        if (entity.size() == 0) {
            LOGGER.error("entity is null");
            view.showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u6682\u65e0\u9700\u8981\u5ba1\u6838\u7684\u5b57\u6bb5\u3002", (String)"ApprovalHelper_0", (String)"hr-hspm-business", (Object[])new Object[0]), MessageBoxOptions.None);
            return;
        }
        if (backUpEntity != null && !ApprovalHelper.check(view, entity, backUpEntity)) {
            return;
        }
        OperationResult result = operationService.localInvokeOperation("submit", new DynamicObject[]{bill}, OperateOption.create());
        if (ApprovalHelper.handleSubmitResult(view, result)) {
            if (ApprovalHelper.isMobile(view)) {
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("hspm_approvalsuccess");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                showParameter.setCustomParam("person", (Object)personId);
                view.showForm((FormShowParameter)showParameter);
                view.getPageCache().put("submitVerson", bill.getString("id"));
            } else {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"ApprovalHelper_4", (String)"hr-hspm-business", (Object[])new Object[0]));
                view.updateView();
            }
        }
    }

    private static void handleHeadAudit(DynamicObjectCollection entity, Map<String, List<Map<String, Object>>> updateFieldMap, Map<String, Object> infoGroupConfig) {
        Optional<Map> headOpt;
        List<Map<String, Object>> headFields = updateFieldMap.get("0000");
        List headConfig = (List)infoGroupConfig.get("headentity");
        if (!CollectionUtils.isEmpty(headFields) && !CollectionUtils.isEmpty((Collection)headConfig) && (headOpt = headConfig.stream().filter(val -> "headsculpture".equals(val.get("number"))).findAny()).isPresent()) {
            Map<String, Object> updateField = headFields.get(0);
            DynamicObject newDy = entity.addNew();
            newDy.set("entityname", updateField.get("entityName"));
            newDy.set("fieldname", updateField.get("fieldname"));
            newDy.set("displayname", headOpt.get().get("name"));
            newDy.set("fieldtype", (Object)FieldTypeEnum.PICTURE.getType());
            newDy.set("isnew", updateField.get("isnew"));
            newDy.set("oldvalue", updateField.get("oldvalue"));
            newDy.set("newvalue", updateField.get("newvalue"));
            newDy.set("dataid", updateField.get("dataid"));
            newDy.set("reason", updateField.get("reason"));
            newDy.set("firstgroupnum", updateField.get("groupnumber"));
            newDy.set("firstgroup", (Object)ResManager.loadKDString((String)"\u6863\u6848\u5934\u90e8", (String)"ApprovalHelper_7", (String)"hr-hspm-business", (Object[])new Object[0]));
            newDy.set("secondgroup", (Object)" ");
        }
    }

    private static boolean check(IFormView view, DynamicObjectCollection newEntity, DynamicObjectCollection backUpEntity) {
        Map<String, DynamicObject> entityMap = backUpEntity.stream().collect(Collectors.toMap(val -> ApprovalHelper.getFullKey(val), val -> val));
        LinkedHashSet<String> notAgreeGroup = new LinkedHashSet<String>(newEntity.size());
        LinkedHashSet<String> newTypeAgreeGroup = new LinkedHashSet<String>(newEntity.size());
        for (DynamicObject dynamicObject : newEntity) {
            String newValue;
            String key = ApprovalHelper.getFullKey(dynamicObject);
            DynamicObject oldDy = entityMap.get(key);
            if (oldDy == null) {
                dynamicObject.set("change", (Object)Boolean.TRUE);
                dynamicObject.set("status", (Object)Boolean.FALSE);
                continue;
            }
            if (oldDy.getBoolean("status")) {
                dynamicObject.set("change", (Object)Boolean.TRUE);
                dynamicObject.set("status", (Object)Boolean.TRUE);
                dynamicObject.set("reason", (Object)oldDy.getString("reason"));
                newValue = oldDy.getString("newvalue");
                if (!HRStringUtils.isNotEmpty((String)newValue)) continue;
                String gName = dynamicObject.getString("firstgroup");
                Long dataId = dynamicObject.getLong("dataid");
                String group = "" + dataId + InfoGroupApprovalUtil.isText(dynamicObject) + ":" + gName;
                if (dynamicObject.getBoolean("isnew") && !newValue.equals(dynamicObject.getString("newvalue"))) {
                    newTypeAgreeGroup.add(group);
                    continue;
                }
                if (!newValue.equals(dynamicObject.getString("newvalue"))) continue;
                notAgreeGroup.add(group);
                continue;
            }
            newValue = oldDy.getString("newvalue");
            if (HRStringUtils.isNotEmpty((String)newValue) && !newValue.equals(dynamicObject.getString("newvalue"))) {
                dynamicObject.set("change", (Object)Boolean.TRUE);
            }
            dynamicObject.set("reason", (Object)oldDy.getString("reason"));
        }
        notAgreeGroup.removeAll(newTypeAgreeGroup);
        if (notAgreeGroup.size() > 0) {
            StringBuilder tip = new StringBuilder(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u5b8c\u5168\u90e8\u88ab\u9a73\u56de\u7684\u4fe1\u606f\u540e\u518d\u63d0\u4ea4\r\n\u672a\u4fee\u6539\u7684\u9a73\u56de\u4fe1\u606f\u7ec4\u5b57\u6bb5\uff1a", (String)"ApprovalHelper_6", (String)"hr-hspm-business", (Object[])new Object[0]));
            boolean first = true;
            HashSet<String> groupNameSet = new HashSet<String>(notAgreeGroup.size());
            for (String gName : notAgreeGroup) {
                if (!groupNameSet.add(gName = gName.substring(gName.indexOf(":") + 1))) continue;
                if (first) {
                    first = false;
                } else {
                    tip.append("\u3001");
                }
                tip.append(gName);
            }
            view.showConfirm(tip.toString(), MessageBoxOptions.None);
            return false;
        }
        return true;
    }

    public static String getFullKey(DynamicObject dynamicObject) {
        StringBuilder sb = new StringBuilder();
        sb.append(dynamicObject.getString("firstgroupnum")).append(dynamicObject.getString("entityname")).append(dynamicObject.getString("fieldname")).append(dynamicObject.getString("dataid"));
        return sb.toString();
    }

    private static DynamicObjectCollection backUpEntity(DynamicObjectCollection entity) {
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection(entity.getDynamicObjectType(), null);
        for (DynamicObject dynamicObject : entity) {
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)dynamicObjects.addNew());
        }
        return dynamicObjects;
    }

    private static boolean existConflict(IFormView view) {
        String billId = view.getPageCache().get("submitVerson");
        if (HRStringUtils.isNotEmpty((String)billId)) {
            LOGGER.error("existConflict");
            ApprovalHelper.removeFieldCache(view);
            view.showConfirm(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u5ba1\u6838\u7684\u4fe1\u606f\u3002", (String)"ApprovalHelper_1", (String)"hr-hspm-business", (Object[])new Object[0]), MessageBoxOptions.None);
            return true;
        }
        return false;
    }

    private static void removeFieldCache(IFormView view) {
        Map allCache = view.getPageCache().getAll();
        ArrayList<String> delList = new ArrayList<String>();
        delList.add("submitVerson");
        for (String key : allCache.keySet()) {
            if (HRStringUtils.isEmpty((String)key) || !key.endsWith("-entrycache")) continue;
            delList.add(key);
        }
        view.getPageCache().batchRemove(delList);
    }

    private static boolean handleSubmitResult(IFormView view, OperationResult result) {
        LOGGER.info(MessageFormat.format("sumbit_result:{0}", SerializationUtils.toJsonString((Object)result)));
        List successPkIds = result.getSuccessPkIds();
        if (CollectionUtils.isEmpty((Collection)successPkIds)) {
            StringBuilder tip = new StringBuilder(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25", (String)"ApprovalHelper_3", (String)"hr-hspm-business", (Object[])new Object[0]));
            List errors = result.getAllErrorOrValidateInfo();
            if (!CollectionUtils.isEmpty((Collection)errors) && errors.get(0) != null) {
                tip.append("\r\n").append(((IOperateInfo)errors.get(0)).toString());
            }
            view.showConfirm(tip.toString(), MessageBoxOptions.None);
            return false;
        }
        return true;
    }

    private static void addDataToEntity(String gName, Boolean isNew, List<Map<String, Object>> groups, List<Map<String, Object>> groupFields, DynamicObjectCollection entity) {
        boolean hasChildGroup = groups.size() > 1;
        for (Map<String, Object> group : groups) {
            String SecondGroupName = hasChildGroup ? (String)group.get("gname") : " ";
            List<Map<String, Object>> fields = ParamAnalysisUtil.getFields(group);
            Set pageFields = fields.stream().map(val -> String.valueOf(val.get("pnumber")) + val.get("number")).collect(Collectors.toSet());
            Map<Long, List<Map>> updateMap = groupFields.stream().filter(val -> pageFields.contains(String.valueOf(val.get("entityName")) + val.get("fieldname"))).filter(val -> isNew.equals(val.get("isnew"))).collect(Collectors.groupingBy(val -> (Long)val.get("dataid")));
            if (updateMap.size() <= 0) continue;
            for (List<Map> updateFieldList : updateMap.values()) {
                Map<String, Map> fieldMap = updateFieldList.stream().collect(Collectors.toMap(val -> String.valueOf(val.get("entityName")) + val.get("fieldname"), val -> val));
                for (Map<String, Object> field : fields) {
                    String pnumber = (String)field.get("pnumber");
                    String number = (String)field.get("number");
                    Map updateField = fieldMap.get(pnumber + number);
                    if (updateField == null) continue;
                    DynamicObject newDy = entity.addNew();
                    newDy.set("entityname", (Object)pnumber);
                    newDy.set("fieldname", (Object)number);
                    newDy.set("displayname", field.get("displayname"));
                    newDy.set("fieldtype", field.get("type"));
                    newDy.set("isnew", updateField.get("isnew"));
                    newDy.set("oldvalue", updateField.get("oldvalue"));
                    newDy.set("newvalue", updateField.get("newvalue"));
                    newDy.set("dataid", updateField.get("dataid"));
                    newDy.set("reason", updateField.get("reason"));
                    newDy.set("firstgroupnum", updateField.get("groupnumber"));
                    newDy.set("firstgroup", (Object)gName);
                    newDy.set("secondgroup", (Object)SecondGroupName);
                    newDy.set("extrainfo", field.get("refkey"));
                }
            }
        }
    }

    public static DynamicObject getInProcessWorkFlowBill(Long personId) {
        if (personId == null || personId == 0L) {
            LOGGER.warn("personId is null");
            return null;
        }
        QFilter personFilter = new QFilter("person", "=", (Object)personId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"B").or("billstatus", "=", (Object)"G").or("billstatus", "=", (Object)"D");
        return INFOAPPROVAL_HELPER.queryOne("billno,auditstatus,billstatus,isexistsworkflow,entryentity.entityname,entryentity.fieldname,entryentity.displayname,entryentity.fieldtype,entryentity.isnew,entryentity.oldvalue,entryentity.newvalue,entryentity.change,entryentity.status,entryentity.reason,entryentity.firstgroupnum,entryentity.firstgroup,entryentity.secondgroup,entryentity.dataid,entryentity.extrainfo", new QFilter[]{personFilter, statusFilter});
    }

    public static void delCacheData(IFormView view) {
        LOGGER.info("delCacheData");
        Map<String, List<Map<String, Object>>> updateFieldMap = ApprovalHelper.getAuditFieldMap(view);
        if (!CollectionUtils.isEmpty(updateFieldMap)) {
            HashMap<Object, HashSet<Long>> delMap = new HashMap<Object, HashSet<Long>>(updateFieldMap.size());
            for (Map.Entry<String, List<Map<String, Object>>> entry : updateFieldMap.entrySet()) {
                for (Map<String, Object> field : entry.getValue()) {
                    if (!Boolean.TRUE.equals(field.get("isnew"))) continue;
                    String entityName = (String)field.get("entityName");
                    HashSet<Long> set = (HashSet<Long>)delMap.get(entityName);
                    if (CollectionUtils.isEmpty((Collection)set)) {
                        set = new HashSet<Long>();
                        delMap.put(entityName, set);
                    }
                    set.add((Long)field.get("dataid"));
                }
            }
            if (!CollectionUtils.isEmpty(delMap)) {
                String personIdStr = view.getPageCache().get("personId");
                Long personId = Long.parseLong(personIdStr);
                DynamicObject bill = ApprovalHelper.getInProcessWorkFlowBill(personId);
                if (bill != null) {
                    DynamicObjectCollection entity = bill.getDynamicObjectCollection("entryentity");
                    for (DynamicObject dy : entity) {
                        if (!dy.getBoolean("isnew")) continue;
                        String entityName = dy.getString("entityName");
                        Set set = (Set)delMap.get(entityName);
                        set.remove(dy.getLong("dataid"));
                    }
                }
                if (!CollectionUtils.isEmpty(delMap)) {
                    for (Map.Entry entry : delMap.entrySet()) {
                        AttacheHandlerService attacheHandlerService = AttacheHandlerService.getInstance();
                        Map<String, Object> resultMap = attacheHandlerService.invokeDel(new ArrayList<Long>((Collection)entry.getValue()), (String)entry.getKey(), Boolean.TRUE);
                        LOGGER.info(MessageFormat.format("del_result:{0}", SerializationUtils.toJsonString(resultMap)));
                    }
                }
            }
        }
    }

    public static void handleSubmitButtonVisible(IFormView view) {
        Map<String, List<Map<String, Object>>> auditMap = ApprovalHelper.getAuditFieldMap(view);
        if (auditMap.size() == 0 || ApprovalHelper.removeOldVersonData(view)) {
            ApprovalHelper.setSubmitButtonVisible(view, Boolean.FALSE);
            return;
        }
        String personIdStr = view.getPageCache().get("personId");
        DynamicObject bill = ApprovalHelper.getInProcessWorkFlowBill(Long.parseLong(personIdStr));
        if (bill != null) {
            if (!"G".equals(bill.getString("billstatus")) || !ApprovalHelper.isChange(bill, auditMap) && !ApprovalHelper.allFieldsAuditPass(bill)) {
                ApprovalHelper.setSubmitButtonVisible(view, Boolean.FALSE);
                return;
            }
        } else if (HRStringUtils.isNotEmpty((String)view.getPageCache().get("submitVerson"))) {
            ApprovalHelper.removeFieldCache(view);
            ApprovalHelper.setSubmitButtonVisible(view, Boolean.FALSE);
            return;
        }
        ApprovalHelper.setSubmitButtonVisible(view, Boolean.TRUE);
    }

    private static void setSubmitButtonVisible(IFormView view, Boolean visible) {
        if (ApprovalHelper.isMobile(view)) {
            view.setVisible(visible, new String[]{"toolbar", "blankflex"});
        } else {
            view.setVisible(visible, new String[]{"submit"});
        }
    }

    private static boolean allFieldsAuditPass(DynamicObject bill) {
        DynamicObjectCollection dynamicObjects = bill.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!dynamicObject.getBoolean("status")) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotPasss(IFormView view, String regNumber) {
        if (view == null || HRStringUtils.isEmpty((String)regNumber)) {
            return false;
        }
        String billId = view.getPageCache().get("submitVerson");
        if (HRStringUtils.isNotEmpty((String)billId)) {
            DynamicObject bill = INFOAPPROVAL_HELPER.queryOne("billstatus,entryentity.firstgroupnum,entryentity.status", (Object)Long.parseLong(billId));
            if (bill == null) {
                return false;
            }
            if (!"G".equals(bill.getString("billstatus"))) {
                return false;
            }
            DynamicObjectCollection entity = bill.getDynamicObjectCollection("entryentity");
            if (entity != null) {
                for (DynamicObject dynamicObject : entity) {
                    if (!regNumber.equals(dynamicObject.getString("firstgroupnum")) || !dynamicObject.getBoolean("status")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void setSubmitButtonVisibleListener(IFormView view, ProgresssListener listener) {
        ProgressBar bar = (ProgressBar)view.getControl("progressbar");
        if (bar != null) {
            bar.addProgressListener(listener);
            bar.start();
            ProgressBarAp progressBarAp = new ProgressBarAp();
            progressBarAp.setKey("progressbar");
            progressBarAp.setIntervalTime(3000);
            view.updateControlMetadata(progressBarAp.getKey(), progressBarAp.createControl());
        }
    }

    public static HashMap<Integer, String> getChangeBtnNameMaps() {
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"ApprovalHelper_10", (String)"hr-hspm-business", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"ApprovalHelper_11", (String)"hr-hspm-business", (Object[])new Object[0]));
        return btnNameMaps;
    }

    public static Tuple<Boolean, String> widthDraw(DynamicObject bill) {
        if (bill == null || bill.getPkValue() == null) {
            return Tuple.create((Object)Boolean.FALSE, (Object)"bill is null");
        }
        try {
            WorkflowServiceHelper.withdraw((DynamicObject)bill);
        }
        catch (Exception exception) {
            LOGGER.error("withdraw ex:", (Throwable)exception);
        }
        OperationResult result = new OperationServiceImpl().localInvokeOperation("delete", new DynamicObject[]{bill}, OperateOption.create());
        LOGGER.info(MessageFormat.format("deletebill_result:{0}", SerializationUtils.toJsonString((Object)result)));
        List successPkIds = result.getSuccessPkIds();
        if (CollectionUtils.isEmpty((Collection)successPkIds)) {
            StringBuilder tip = new StringBuilder(ResManager.loadKDString((String)"\u64a4\u9500\u5931\u8d25", (String)"ApprovalHelper_12", (String)"hr-hspm-business", (Object[])new Object[0]));
            List errors = result.getAllErrorOrValidateInfo();
            if (!CollectionUtils.isEmpty((Collection)errors) && errors.get(0) != null) {
                tip.append("\r\n").append(((IOperateInfo)errors.get(0)).toString());
            }
            return Tuple.create((Object)Boolean.FALSE, (Object)tip.toString());
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f", (String)"ApprovalHelper_13", (String)"hr-hspm-business", (Object[])new Object[0]));
    }

    public static boolean isCanWithDraw(DynamicObject bill) {
        return bill != null && !bill.getBoolean("rejectrecord") && ("B".equals(bill.getString("billstatus")) || "D".equals(bill.getString("billstatus")));
    }
}

